/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile.wmts;

import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemType;
import com.geoway.adf.gis.basic.util.XmlUtil;
import com.geoway.adf.gis.tile.ITileDataSource;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileMeta;
import com.geoway.adf.gis.tile.TileType;
import com.geoway.adf.gis.tile.a.m;
import com.geoway.adf.gis.tile.meta.LODInfo;
import com.geoway.adf.gis.tile.meta.SpatialReference;
import com.geoway.adf.gis.tile.meta.TileSchema;
import com.geoway.adf.gis.tile.wmts.HttpUtil;
import com.geoway.adf.gis.tile.wmts.WMTSTileMeta;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WMTSTileDataSource
implements ITileDataSource {
    private static final Logger a = LoggerFactory.getLogger(WMTSTileDataSource.class);
    private final String aQ;

    public WMTSTileDataSource(String string) {
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.endsWith("&")) {
            string = string.substring(0, string.length() - 1);
        }
        if (!string.contains("?")) {
            string = string + "?";
        }
        this.aQ = string;
    }

    @Override
    public String getConnectionString() {
        return this.aQ;
    }

    @Override
    public boolean connect() {
        HttpUtil.doGet(this.getCapabilitiesUrl(), 10000);
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public List<ITileDataset> getDatasets() {
        String string = this.getCapabilitiesUrl();
        String string2 = HttpUtil.doGet(string, 10000);
        try {
            ArrayList<ITileDataset> arrayList = new ArrayList<ITileDataset>();
            Document document = XmlUtil.readDocumentFromStr((String)string2);
            Element element = (Element)document.getElementsByTagName("Contents").item(0);
            NodeList nodeList = element.getElementsByTagName("Layer");
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Element element2 = (Element)nodeList.item(i2);
                m m2 = this.a(document, element2);
                if (m2 == null) continue;
                arrayList.add(m2);
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new RuntimeException(this.aQ + "\u5143\u6570\u636e\u89e3\u6790\u5931\u8d25", exception);
        }
    }

    @Override
    public List<ITileDataset> getDatasets(TileType ... tileTypeArray) {
        return this.getDatasets();
    }

    @Override
    public ITileDataset getDataset(String string) {
        String string2 = this.aQ + "SERVICE=WMTS&REQUEST=GetCapabilities";
        String string3 = HttpUtil.doGet(string2, 10000);
        try {
            Document document = XmlUtil.readDocumentFromStr((String)string3);
            Element element = (Element)document.getElementsByTagName("Contents").item(0);
            NodeList nodeList = element.getElementsByTagName("Layer");
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Element element2 = (Element)nodeList.item(i2);
                m m2 = this.a(document, element2);
                if (m2 == null || !m2.getName().equalsIgnoreCase(string)) continue;
                return m2;
            }
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException(this.aQ + "\u5143\u6570\u636e\u89e3\u6790\u5931\u8d25", exception);
        }
    }

    @Override
    public ITileDataset createDataset(TileMeta tileMeta) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u521b\u5efa\u74e6\u7247\u6570\u636e\u96c6");
    }

    @Override
    public void deleteDataset(String string) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5220\u9664\u74e6\u7247\u6570\u636e\u96c6");
    }

    private String getCapabilitiesUrl() {
        if (this.aQ.endsWith("?")) {
            return this.aQ + "SERVICE=WMTS&REQUEST=GetCapabilities";
        }
        return this.aQ + "&SERVICE=WMTS&REQUEST=GetCapabilities";
    }

    private m a(Document document, Element element) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        Object object5;
        WMTSTileMeta wMTSTileMeta = new WMTSTileMeta();
        NodeList nodeList = XmlUtil.findNodeList((Node)document, (String)"/Capabilities/OperationsMetadata/Operation");
        if (nodeList != null) {
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                object5 = (Element)nodeList.item(i2);
                string = object5.getAttribute("name");
                object4 = XmlUtil.findfirstNode((Node)object5, (String)"DCP/HTTP/Get");
                if (object4 == null) continue;
                object3 = ((Element)object4).getAttribute("xlink:href");
                if (string.equals("GetCapabilities")) {
                    wMTSTileMeta.setGetCapabilitiesUrl((String)object3);
                    continue;
                }
                if (!string.equals("GetTile")) continue;
                wMTSTileMeta.setGetTileUrl((String)object3);
            }
        }
        String string2 = XmlUtil.findfirstNodeStringValue((Node)element, (String)"Title");
        object5 = XmlUtil.findfirstNodeStringValue((Node)element, (String)"Identifier");
        string = XmlUtil.findfirstNodeStringValue((Node)element, (String)"Style/Identifier");
        object4 = XmlUtil.findfirstNodeStringValue((Node)element, (String)"Format");
        object3 = null;
        Double d2 = null;
        Double d3 = null;
        Double d4 = null;
        Node node = XmlUtil.findfirstNode((Node)element, (String)"WGS84BoundingBox");
        if (node == null) {
            node = XmlUtil.findfirstNode((Node)element, (String)"BoundingBox");
        }
        if (node != null) {
            try {
                object2 = XmlUtil.findfirstNodeStringValue((Node)node, (String)"LowerCorner");
                object = XmlUtil.findfirstNodeStringValue((Node)node, (String)"UpperCorner");
                object3 = Double.valueOf(((String)object2).split(" ")[0]);
                d2 = Double.valueOf(((String)object2).split(" ")[1]);
                d3 = Double.valueOf(((String)object).split(" ")[0]);
                d4 = Double.valueOf(((String)object).split(" ")[1]);
            }
            catch (Exception exception) {
                a.error(this.aQ + "\u56fe\u5c42\u8303\u56f4\u8bfb\u53d6\u5f02\u5e38", (Throwable)exception);
            }
        }
        object2 = new ArrayList();
        object = XmlUtil.findNodeList((Node)element, (String)"TileMatrixSetLink/TileMatrixSet");
        for (n = 0; n < object.getLength(); ++n) {
            object2.add(object.item(n).getTextContent());
        }
        n = 1;
        LinkedHashMap<String, TileSchema> linkedHashMap = new LinkedHashMap<String, TileSchema>();
        NodeList nodeList2 = XmlUtil.findNodeList((Node)document, (String)"Capabilities/Contents/TileMatrixSet");
        for (int i3 = 0; i3 < nodeList2.getLength(); ++i3) {
            Object object6;
            Element element2 = (Element)nodeList2.item(i3);
            String string3 = XmlUtil.findfirstNodeStringValue((Node)element2, (String)"Identifier");
            String string4 = XmlUtil.findfirstNodeStringValue((Node)element2, (String)"SupportedCRS");
            if (!object2.contains(string3)) continue;
            SpatialReference spatialReference = null;
            try {
                int n2 = Integer.valueOf(string4.split("::")[1]);
                spatialReference = SpatialReference.fromSrid(n2);
                if (spatialReference == null) {
                    object6 = SpatialReferenceSystemFunc.createSpatialReference((int)n2);
                    if (object6 != null) {
                        spatialReference = new SpatialReference(n2, object6.getWkt());
                        n = object6.getType() == SpatialReferenceSystemType.Geographic ? 1 : 0;
                    } else {
                        n = 1;
                    }
                } else {
                    n = spatialReference == SpatialReference.WGS84WebMercator ? 0 : 1;
                }
            }
            catch (Exception exception) {
                a.error(this.aQ + "\n" + string4 + "\u89e3\u6790\u7a7a\u95f4\u53c2\u8003\u5f02\u5e38");
                n = 0;
            }
            Integer n3 = 256;
            object6 = 256;
            String string5 = "90.0 -180.0";
            double d5 = -180.0;
            double d6 = 90.0;
            NodeList nodeList3 = element2.getElementsByTagName("TileMatrix");
            ArrayList<LODInfo> arrayList = new ArrayList<LODInfo>();
            for (int i4 = 0; i4 < nodeList3.getLength(); ++i4) {
                String[] stringArray;
                Element element3 = (Element)nodeList3.item(i4);
                Integer n4 = XmlUtil.findfirstNodeIntValue((Node)element3, (String)"Identifier");
                Double d7 = XmlUtil.findfirstNodeDoubleValue((Node)element3, (String)"ScaleDenominator");
                string5 = XmlUtil.findfirstNodeStringValue((Node)element3, (String)"TopLeftCorner");
                n3 = XmlUtil.findfirstNodeIntValue((Node)element3, (String)"TileWidth");
                object6 = XmlUtil.findfirstNodeIntValue((Node)element3, (String)"TileHeight");
                Integer n5 = XmlUtil.findfirstNodeIntValue((Node)element3, (String)"MatrixHeight");
                if (n4 == null) {
                    n4 = i4 + 1;
                }
                if (string5 == null || string5.isEmpty()) {
                    string5 = "90.0 -180.0";
                }
                if (n3 == null || n3 == 0) {
                    n3 = 256;
                }
                if (object6 == null || (Integer)object6 == 0) {
                    object6 = 256;
                }
                if (n5 == null || n5 == 0) {
                    n5 = (int)Math.pow(2.0, n4.intValue());
                }
                if ((stringArray = string5.trim().split(" ")).length >= 2) {
                    d6 = Double.parseDouble(stringArray[0]);
                    d5 = Double.parseDouble(stringArray[1]);
                }
                double d8 = 2.0 * Math.abs(d6) / (double)((Integer)object6).intValue() / (double)n5.intValue();
                LODInfo lODInfo = new LODInfo();
                lODInfo.setLevelID(n4);
                lODInfo.setScale(d7);
                lODInfo.setResolution(d8);
                arrayList.add(lODInfo);
            }
            TileSchema tileSchema = new TileSchema();
            tileSchema.setLodInfos(arrayList);
            tileSchema.setWidth(n3);
            tileSchema.setHeight((Integer)object6);
            tileSchema.setSpatialReference(spatialReference);
            if (n != 0) {
                tileSchema.setOriginX(d5);
                tileSchema.setOriginY(d6);
            } else {
                tileSchema.setOriginX(d6);
                tileSchema.setOriginY(d5);
            }
            linkedHashMap.put(string3, tileSchema);
        }
        wMTSTileMeta.setName((String)object5);
        wMTSTileMeta.setAliasName(string2);
        wMTSTileMeta.setStyle(string);
        wMTSTileMeta.setDataFormat((String)object4);
        wMTSTileMeta.setTileType(TileType.RasterTile);
        wMTSTileMeta.setXmin((Double)object3);
        wMTSTileMeta.setYmin(d2);
        wMTSTileMeta.setXmax(d3);
        wMTSTileMeta.setYmax(d4);
        wMTSTileMeta.setTileMatrixSets(linkedHashMap);
        wMTSTileMeta.setTileSchema((TileSchema)linkedHashMap.get(this.getDefaultTileMatrixSet(linkedHashMap)));
        if (wMTSTileMeta.getTileSchema().getLodInfos().size() > 0) {
            List<Integer> list = wMTSTileMeta.getTileSchema().getLodInfos().stream().map(LODInfo::getLevelID).collect(Collectors.toList());
            wMTSTileMeta.setStartLevel((Integer)list.get(0));
            wMTSTileMeta.setEndLevel((Integer)list.get(list.size() - 1));
            wMTSTileMeta.setLevels(list);
        }
        m m2 = new m(this, wMTSTileMeta);
        return m2;
    }

    public String getDefaultTileMatrixSet(Map<String, TileSchema> map) {
        String string = null;
        for (Map.Entry<String, TileSchema> entry : map.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase("guobiao")) continue;
            string = entry.getKey();
            break;
        }
        if (string == null) {
            string = (String)map.keySet().stream().findFirst().get();
        }
        return string;
    }
}

