/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile.a;

import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.tile.IModel3dTileDataset;
import com.geoway.adf.gis.tile.ITileDataSource;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileData;
import com.geoway.adf.gis.tile.TileMeta;
import com.geoway.adf.gis.tile.TileType;
import com.geoway.adf.gis.tile.meta.MapExtent;
import com.geoway.adf.gis.tile.mongo.MongoTileDataSource;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class k
implements IModel3dTileDataset,
ITileDataset {
    private static final Logger a = LoggerFactory.getLogger(k.class);
    private String name;
    private String aliasName;
    private TileType ba;
    private TileMeta u;
    private MongoTileDataSource bb;
    private MongoCollection<Document> bc;
    private static final SimpleDateFormat bd = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private boolean be = false;
    private List<WriteModel<Document>> bf = null;

    public k(MongoTileDataSource mongoTileDataSource, TileMeta tileMeta) {
        this.bc = mongoTileDataSource.getMongoDatabase().getCollection(tileMeta.getName());
        this.bb = mongoTileDataSource;
        this.u = tileMeta;
        this.name = tileMeta.getName();
        this.aliasName = tileMeta.getAliasName();
        this.ba = tileMeta.getTileType();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TileType getType() {
        return this.ba;
    }

    @Override
    public ITileDataSource getDataSource() {
        return this.bb;
    }

    @Override
    public TileMeta getTileMeta() {
        return this.u;
    }

    @Override
    public String getAliasName() {
        return this.aliasName;
    }

    @Override
    public boolean updateTileMeta(TileMeta tileMeta) {
        TileMeta tileMeta2 = new TileMeta();
        tileMeta2.copyFrom(tileMeta);
        tileMeta2.setUpdateTime(new Date());
        if (this.bb.updateTileMeta(tileMeta2)) {
            this.u = tileMeta2;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> getAllLevels() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try (MongoCursor mongoCursor = this.bc.distinct("level", Integer.class).iterator();){
            while (mongoCursor.hasNext()) {
                arrayList.add((Integer)mongoCursor.next());
            }
            ArrayList<Integer> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public Long getDataCount() {
        long l2 = this.bc.estimatedDocumentCount();
        return l2;
    }

    @Override
    public Long getDataSize() {
        try {
            Document document = this.bb.getMongoDatabase().runCommand((Bson)new Document("collStats", (Object)this.bc.getNamespace().getCollectionName()));
            Object object = document.get((Object)"size");
            Object object2 = document.get((Object)"storageSize");
            Object object3 = document.get((Object)"totalSize");
            return object3 instanceof Number ? ((Number)object3).longValue() : 0L;
        }
        catch (Exception exception) {
            a.error(this.getName() + " \u83b7\u53d6\u5b58\u50a8\u5927\u5c0f\u5f02\u5e38", (Throwable)exception);
            return null;
        }
    }

    @Override
    public boolean existTile(int n, int n2, int n3) {
        Document document = (Document)this.bc.find(Filters.eq((String)"key", (Object)String.format("%d_%d_%d", n2, n3, n))).first();
        return document != null;
    }

    @Override
    public TileData getTile(int n, int n2, int n3) {
        byte[] byArray;
        Binary binary;
        String string = String.format("%d_%d_%d", n2, n3, n);
        Bson bson = Filters.eq((String)"key", (Object)string);
        Document document = (Document)this.bc.find(bson).first();
        if (document != null && (binary = (Binary)document.get((Object)"data", Binary.class)) != null && (byArray = binary.getData()) != null) {
            TileData tileData = new TileData();
            tileData.setKey(string);
            tileData.setLevel(n);
            tileData.setRow(n2);
            tileData.setCol(n3);
            tileData.setFormat((String)document.get((Object)"type", String.class));
            tileData.setData(byArray);
            if (this.u.getTileType() == TileType.Model3DTile && tileData.getFormat() == null) {
                tileData.setFormat("3dtiles");
            }
            return tileData;
        }
        return null;
    }

    @Override
    public TileData getTile(String string) {
        byte[] byArray;
        Binary binary;
        Bson bson = Filters.eq((String)"key", (Object)string);
        Document document = (Document)this.bc.find(bson).first();
        if (document != null && (binary = (Binary)document.get((Object)"data", Binary.class)) != null && (byArray = binary.getData()) != null) {
            TileData tileData = new TileData();
            tileData.setKey(string);
            tileData.setLevel(document.getInteger((Object)"level", 0));
            tileData.setRow(document.getInteger((Object)"row", 0));
            tileData.setCol(document.getInteger((Object)"col", 0));
            tileData.setFormat((String)document.get((Object)"type", String.class));
            tileData.setData(byArray);
            return tileData;
        }
        return null;
    }

    @Override
    public boolean deleteTile(int n, int n2, int n3) {
        Bson bson = Filters.eq((String)"key", (Object)String.format("%d_%d_%d", n2, n3, n));
        if (this.be) {
            DeleteOneModel deleteOneModel = new DeleteOneModel(bson);
            this.bf.add((WriteModel<Document>)deleteOneModel);
            if (this.bf.size() >= 1000) {
                this.bc.bulkWrite(this.bf);
                this.bf.clear();
            }
        } else {
            DeleteResult deleteResult = this.bc.deleteOne(bson);
        }
        return true;
    }

    @Override
    public boolean writeTile(TileData tileData, boolean bl) {
        Document document;
        int n = tileData.getLevel();
        int n2 = tileData.getRow();
        int n3 = tileData.getCol();
        if (bl) {
            this.deleteTile(n, n2, n3);
        }
        if ("3dtiles".equals(tileData.getFormat())) {
            document = new Document();
            document.put("key", (Object)tileData.getKey());
            document.put("data", (Object)tileData.getData());
        } else {
            document = new Document();
            if (tileData.getKey() != null && !tileData.getKey().isEmpty()) {
                document.put("key", (Object)tileData.getKey());
            } else {
                document.put("key", (Object)(n2 + "_" + n3 + "_" + n));
            }
            document.put("name", (Object)(n2 + "_" + n3 + "_" + n + "_TDT"));
            document.put("row", (Object)n2);
            document.put("col", (Object)n3);
            document.put("level", (Object)n);
            document.put("time", (Object)bd.format(new Date()));
            document.put("type", (Object)tileData.getFormat());
            document.put("data", (Object)tileData.getData());
        }
        if (this.be) {
            InsertOneModel insertOneModel = new InsertOneModel((Object)document);
            this.bf.add((WriteModel<Document>)insertOneModel);
            if (this.bf.size() >= 1000) {
                this.bc.bulkWrite(this.bf);
                this.bf.clear();
            }
        } else {
            this.bc.insertOne((Object)document);
        }
        return true;
    }

    @Override
    public void startWrite() {
        this.be = true;
        this.bf = new ArrayList<WriteModel<Document>>();
        this.bc.createIndex((Bson)new Document("key", (Object)1));
    }

    @Override
    public void commitWrite(boolean bl) {
        this.be = false;
        if (this.bf.size() > 0) {
            this.bc.bulkWrite(this.bf);
            this.bf.clear();
        }
    }

    @Override
    public void setExtentFilter(MapExtent mapExtent) {
    }

    @Override
    public void setGeometryFilter(IGeometry iGeometry) {
    }

    @Override
    public void resetReading() {
    }

    @Override
    public TileData nextTileData() {
        return null;
    }
}

