/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile.model3d;

import com.geoway.adf.gis.tile.ITileDataSource;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileMeta;
import com.geoway.adf.gis.tile.TileType;
import com.geoway.adf.gis.tile.a.h;
import com.geoway.adf.gis.tile.meta.SpatialReference;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Model3dTileDataSource
implements ITileDataSource {
    private final File tilePath;
    private final SpatialReference s;

    public Model3dTileDataSource(String string) {
        this.tilePath = new File(string);
        this.s = SpatialReference.CGCS2000;
    }

    @Override
    public String getConnectionString() {
        return this.tilePath.toString();
    }

    @Override
    public boolean connect() {
        File file = new File(this.tilePath, "tileset.json");
        return file.exists();
    }

    @Override
    public void close() {
    }

    @Override
    public List<ITileDataset> getDatasets() {
        ITileDataset iTileDataset = this.getDataset(null);
        ArrayList<ITileDataset> arrayList = new ArrayList<ITileDataset>();
        arrayList.add(iTileDataset);
        return arrayList;
    }

    @Override
    public List<ITileDataset> getDatasets(TileType ... tileTypeArray) {
        return this.getDatasets();
    }

    @Override
    public ITileDataset getDataset(String string) {
        TileMeta tileMeta = this.i();
        h h2 = new h(this, tileMeta);
        return h2;
    }

    @Override
    public ITileDataset createDataset(TileMeta tileMeta) {
        if (!this.tilePath.isDirectory() || !this.tilePath.exists()) {
            this.tilePath.mkdirs();
        }
        TileMeta tileMeta2 = new TileMeta();
        tileMeta2.copyFrom(tileMeta);
        tileMeta2.setTileType(TileType.Model3DTile);
        h h2 = new h(this, tileMeta2);
        return h2;
    }

    @Override
    public void deleteDataset(String string) {
        if (this.tilePath.exists()) {
            this.tilePath.delete();
        }
    }

    private TileMeta i() {
        TileMeta tileMeta = new TileMeta();
        tileMeta.setName(this.tilePath.getName());
        tileMeta.setAliasName(this.tilePath.getName());
        tileMeta.setTileType(TileType.Model3DTile);
        return tileMeta;
    }
}

