/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.base.controller;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RestResult<T>
implements Serializable {
    private Integer code;
    private T data;
    private String msg;
    protected String status;
    protected String message;
    protected Long total;

    public void markFailure(String message) {
        this.code = 1000;
        this.msg = message;
    }

    public static <T> RestResult<T> error(RestResult<?> result) {
        return RestResult.error(result.getCode(), result.getMsg());
    }

    public static <T> RestResult<T> error(Integer code, String message) {
        Assert.isTrue((200 != code ? 1 : 0) != 0, (String)"code \u5fc5\u987b\u662f\u9519\u8bef\u7684\uff01");
        RestResult<T> result = new RestResult<T>();
        result.code = code;
        result.msg = message;
        return result;
    }

    public static <T> RestResult<T> error(ResultCodeEnum resultCodeEnum) {
        return RestResult.error(resultCodeEnum.getCode(), resultCodeEnum.getMessage());
    }

    public static <T> RestResult<T> error(String msg) {
        return RestResult.error(ResultCodeEnum.UNKNOWN_ERROR.getCode(), msg);
    }

    public static <T> RestResult<T> success(T data) {
        RestResult<T> result = new RestResult<T>();
        result.code = ResultCodeEnum.SUCCESS.getCode();
        result.data = data;
        result.msg = "\u64cd\u4f5c\u6210\u529f\uff01";
        return result;
    }

    public static <T> RestResult<T> success(T data, String msg) {
        RestResult<T> result = new RestResult<T>();
        result.code = ResultCodeEnum.SUCCESS.getCode();
        result.data = data;
        result.msg = msg;
        return result;
    }

    public static boolean isSuccess(Integer code) {
        return Objects.equals(code, ResultCodeEnum.SUCCESS.getCode());
    }

    @JsonIgnore
    public boolean isSuccess() {
        return RestResult.isSuccess(this.code);
    }

    @JsonIgnore
    public boolean isError() {
        return !this.isSuccess();
    }

    public Integer getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public Long getTotal() {
        return this.total;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestResult)) {
            return false;
        }
        RestResult other = (RestResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "RestResult(code=" + this.getCode() + ", data=" + this.getData() + ", msg=" + this.getMsg() + ", status=" + this.getStatus() + ", message=" + this.getMessage() + ", total=" + this.getTotal() + ")";
    }

    public static enum ResultCodeEnum {
        SUCCESS(true, 200, "\u6210\u529f"),
        UNKNOWN_ERROR(false, 500, "\u672a\u77e5\u9519\u8bef"),
        INSERT_ERROR(false, 1000, "\u63d2\u5165\u6570\u636e\u5f02\u5e38"),
        SELECT_ERROR(false, 1001, "\u67e5\u8be2\u6570\u636e\u5f02\u5e38"),
        UPDATE_ERROR(false, 1002, "\u66f4\u65b0\u6570\u636e\u5f02\u5e38"),
        DELETE_ERROR(false, 1003, "\u5220\u9664\u6570\u636e\u5f02\u5e38"),
        NULL_POINT(false, 1004, "\u7a7a\u6307\u9488\u5f02\u5e38"),
        INDEX_OUT_OF_BOUNDS(false, 1005, "\u4e0b\u6807\u8d8a\u754c\u5f02\u5e38"),
        REQUEST_TIMEOUT(false, 1006, "\u8bf7\u6c42\u8d85\u65f6"),
        PARAM_ERROR(false, 1007, "\u53c2\u6570\u9519\u8bef"),
        NOT_INIT_DATA(false, 1008, "\u6570\u636e\u672a\u521d\u59cb\u5316"),
        SQL_ERROR(false, 1009, "\u6570\u636e\u5e93SQL\u9519\u8bef"),
        REPEAT_SUBMIT(false, 1010, "\u91cd\u590d\u63d0\u4ea4"),
        CUSTOM_ERROR(false, 2000, "\u81ea\u5b9a\u4e49\u9519\u8bef"),
        USER_FORBIDDEN(false, 2001, "\u7528\u6237\u88ab\u7981\u7528"),
        NOT_LOGIN_ERROR(false, 2002, "\u672a\u767b\u5f55");

        private final Boolean success;
        private final Integer code;
        private final String message;

        private ResultCodeEnum(boolean success, Integer code, String message) {
            this.success = success;
            this.code = code;
            this.message = message;
        }

        public Boolean getSuccess() {
            return this.success;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class StatusConstants {
        public static final int SUCCESS = 200;
        public static final int FAILURE = 1000;
        public static final int NOLOGIN = 1001;
        public static final int NOPERMISSON = 1002;
    }
}

