/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.base.controller;

import com.geoway.ns.ai.base.chat.message.AiMessage;
import com.geoway.ns.ai.base.controller.RestResult;
import com.geoway.ns.ai.base.tool.http.AiHttpToolCallRequest;
import com.geoway.ns.ai.base.tool.http.AiHttpToolCallResult;
import com.geoway.ns.ai.base.tool.http.AiHttpToolDefinitionResponse;
import com.geoway.ns.ai.base.tool.http.AiHttpToolExcuteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
@CrossOrigin
@RequestMapping(value={"/ai/tool"})
public class AiToolController {
    @Autowired
    private AiHttpToolExcuteService aiHttpToolExcuteService;

    @GetMapping(value={"metadata"})
    public RestResult<AiHttpToolDefinitionResponse> definition(String classname) throws Exception {
        return RestResult.success(this.aiHttpToolExcuteService.getDefinition(classname));
    }

    @RequestMapping(value={"call"}, method={RequestMethod.POST})
    public RestResult<AiHttpToolCallResult> call(@RequestBody AiHttpToolCallRequest aiHttpToolCallRequest) throws Exception {
        return RestResult.success(this.aiHttpToolExcuteService.call(aiHttpToolCallRequest));
    }

    @RequestMapping(value={"/call/stream"}, method={RequestMethod.POST}, produces={"text/event-stream"})
    public Flux<ServerSentEvent<AiMessage>> stream(@RequestBody AiHttpToolCallRequest aiHttpToolCallRequest) throws Exception {
        return this.aiHttpToolExcuteService.callStream(aiHttpToolCallRequest);
    }
}

