/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.base.tool;

import cn.hutool.json.JSONUtil;
import com.geoway.ns.ai.base.chat.client.AiChatClient;
import com.geoway.ns.ai.base.chat.message.AiMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AiToolContext {
    private AiChatClient chatClient;
    private Map<String, String> context;
    public static final String TOOL_CALL_HISTORY = "TOOL_CALL_HISTORY";
    public static final String TOOL_CALL_CHAT_CLIENT = "TOOL_CALL_CHAT_CLIENT";
    public static final String TOOL_CALL_CHAT_DTO = "TOOL_CALL_CHAT_DTO";
    public static final String TOOL_CALL_CHAT_SESSIONID = "TOOL_CALL_CHAT_SESSIONID";

    public Map<String, String> getContext() {
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public boolean containsKey(String key) {
        return this.context.containsKey(key);
    }

    public void putAll(Map<String, Object> map) {
        for (Map.Entry<String, Object> obj : map.entrySet()) {
            this.put(obj.getKey(), obj.getValue());
        }
    }

    public void put(String key, Object value) {
        if (value == null) {
            return;
        }
        String string = JSONUtil.toJsonStr((Object)value);
        this.context.put(key, string);
    }

    public <T> T get(String key, Class<T> clazz) {
        if (this.context.containsKey(key)) {
            Object object = JSONUtil.toBean((String)this.context.get(key), clazz);
            return (T)object;
        }
        return null;
    }

    public <T> T getOrDefault(String key, Class<T> clazz, Object defaultObject) {
        if (this.context.containsKey(key)) {
            Object object = JSONUtil.toBean((String)this.context.get(key), clazz);
            return (T)object;
        }
        return (T)defaultObject;
    }

    public <T> List<T> getList(String key, Class<T> clazz) {
        if (this.context.containsKey(key)) {
            List object = JSONUtil.toList((String)this.context.get(key), clazz);
            return object;
        }
        return null;
    }

    public <T> List<T> getListOrDefault(String key, Class<T> clazz, Object defaultObject) {
        if (this.context.containsKey(key)) {
            List object = JSONUtil.toList((String)this.context.get(key), clazz);
            return object;
        }
        return (List)defaultObject;
    }

    public String toJsonString() {
        return JSONUtil.toJsonStr(this.context);
    }

    public AiToolContext() {
        this.context = new HashMap<String, String>();
    }

    public AiToolContext(Map<String, String> map) {
        this.context = map;
    }

    public List<AiMessage> getToolCallHistory() {
        return this.getList(TOOL_CALL_HISTORY, AiMessage.class);
    }

    public String getUserInput() {
        List<AiMessage> messages = this.getToolCallHistory();
        ArrayList<AiMessage> copyMessage = new ArrayList<AiMessage>(messages);
        Collections.reverse(copyMessage);
        AiMessage userMessage = copyMessage.stream().filter(f -> f.getRole().equals("user")).findFirst().orElse(null);
        if (userMessage == null) {
            return "";
        }
        return userMessage.getContent().toString();
    }

    public AiChatClient getChatClient() {
        return this.chatClient;
    }

    public void setChatClient(AiChatClient chatClient) {
        this.chatClient = chatClient;
    }
}

