/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.base.tool.http;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson2.JSONObject;
import com.geoway.ns.ai.base.RefObject;
import com.geoway.ns.ai.base.chat.message.AIMessageType;
import com.geoway.ns.ai.base.chat.message.AiMessage;
import com.geoway.ns.ai.base.tool.AiTool;
import com.geoway.ns.ai.base.tool.AiToolContext;
import com.geoway.ns.ai.base.tool.AiToolDefinition;
import com.geoway.ns.ai.base.tool.AiToolResult;
import com.geoway.ns.ai.base.tool.Void.AiVoidToolParam;
import com.geoway.ns.ai.base.tool.http.AiHttpToolCallRequest;
import com.geoway.ns.ai.base.tool.http.AiHttpToolCallResult;
import com.geoway.ns.ai.base.tool.http.AiHttpToolDefinitionRequest;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;

public class AiHttpTool
implements AiTool {
    private String host;
    private String classname;
    private Map<String, String> headerMap;

    public AiHttpTool(String host, String classname, Map<String, String> headerMap) {
        this.host = host;
        this.classname = classname;
        this.headerMap = headerMap;
    }

    @Override
    public AiToolDefinition getToolDefinition() {
        return new AiHttpToolDefinitionRequest(this.host, this.classname, this.headerMap);
    }

    @Override
    public AiToolResult call(String toolInput, AiToolContext aiToolContext, Consumer<AiMessage> aiMessageConsumer) {
        String url = this.host + "/ai/tool/call/stream";
        AiHttpToolCallRequest toolCallRequest = new AiHttpToolCallRequest();
        toolCallRequest.setToolContext(aiToolContext.getContext());
        toolCallRequest.setClassName(this.classname);
        toolCallRequest.setToolInput(toolInput);
        String json = JSONUtil.toJsonStr((Object)toolCallRequest);
        WebClient.Builder builder = WebClient.builder();
        if (this.headerMap != null) {
            for (Map.Entry<String, String> kv : this.headerMap.entrySet()) {
                builder.defaultHeader(kv.getKey(), new String[]{kv.getValue()});
            }
        }
        RefObject refObject = new RefObject();
        WebClient webClient = builder.build();
        ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)webClient.post().uri(url, new Object[0])).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM})).bodyValue((Object)json).retrieve().bodyToFlux(AiMessage.class).map(aiMessage -> {
            try {
                if (aiMessage.getRole().equalsIgnoreCase(AIMessageType.Http.getDesc())) {
                    refObject.set(aiMessage.getHttpCallResult());
                } else if (aiMessageConsumer != null) {
                    aiMessageConsumer.accept((AiMessage)aiMessage);
                }
                return aiMessage;
            }
            catch (Exception E) {
                throw new RuntimeException(E);
            }
        }).blockLast();
        AiHttpToolCallResult restResult = (AiHttpToolCallResult)refObject.get();
        if (restResult == null) {
            return null;
        }
        String modelResult = restResult.getModelResult();
        JSONObject callResult = JSONObject.parseObject((String)restResult.getToolCallResult());
        AiVoidToolParam voidToolParam = (AiVoidToolParam)JSONObject.parseObject((String)restResult.getParam(), AiVoidToolParam.class);
        AiToolResult aiToolResult = new AiToolResult(modelResult, callResult, voidToolParam);
        aiToolResult.setReturn(restResult.getIsReturn());
        aiToolContext.setContext(restResult.getToolContext());
        return aiToolResult;
    }

    public String getHost() {
        return this.host;
    }

    public String getClassname() {
        return this.classname;
    }

    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.headerMap = headerMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AiHttpTool)) {
            return false;
        }
        AiHttpTool other = (AiHttpTool)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$classname = this.getClassname();
        String other$classname = other.getClassname();
        if (this$classname == null ? other$classname != null : !this$classname.equals(other$classname)) {
            return false;
        }
        Map<String, String> this$headerMap = this.getHeaderMap();
        Map<String, String> other$headerMap = other.getHeaderMap();
        return !(this$headerMap == null ? other$headerMap != null : !((Object)this$headerMap).equals(other$headerMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AiHttpTool;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $classname = this.getClassname();
        result = result * 59 + ($classname == null ? 43 : $classname.hashCode());
        Map<String, String> $headerMap = this.getHeaderMap();
        result = result * 59 + ($headerMap == null ? 43 : ((Object)$headerMap).hashCode());
        return result;
    }

    public String toString() {
        return "AiHttpTool(host=" + this.getHost() + ", classname=" + this.getClassname() + ", headerMap=" + this.getHeaderMap() + ")";
    }
}

