/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.chat.util.query;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.geoway.ns.ai.chat.util.query.OperationModel;
import com.geoway.ns.ai.chat.util.query.QueryFilterParam;
import com.geoway.ns.ai.chat.util.query.QueryParamUtil;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;

public class MyQueryMapperUtil<T> {
    private static final Logger log = LoggerFactory.getLogger(MyQueryMapperUtil.class);
    private Class clazz;

    public MyQueryMapperUtil() {
    }

    public MyQueryMapperUtil(T t) {
        this.clazz = t.getClass();
    }

    public QueryWrapper<T> queryMapper(String filterParams, String sortParams, Class entityClass) throws Exception {
        QueryWrapper<T> queryWrapper = this.queryMapper(filterParams, entityClass);
        if (StrUtil.isNotEmpty((CharSequence)sortParams)) {
            String[] sortParamArr;
            for (String sortParam : sortParamArr = sortParams.split(";")) {
                String[] sortCondition = sortParam.split("_");
                String sortFieldName = sortCondition[1];
                String sortType = sortCondition[2];
                Field field = this.getField(entityClass, sortFieldName);
                if (field == null) continue;
                String column = this.findTableFiled(field);
                if ("desc".equalsIgnoreCase(sortType)) {
                    queryWrapper.orderByDesc((Object)column);
                    continue;
                }
                queryWrapper.orderByAsc((Object)column);
            }
        }
        return queryWrapper;
    }

    public QueryWrapper queryMapper(String filterParams, String sortParams) throws Exception {
        return this.queryMapper(filterParams, sortParams, this.clazz);
    }

    public QueryWrapper queryMapper(String filterParams) throws Exception {
        return this.queryMapper(filterParams, this.clazz);
    }

    public QueryWrapper<T> queryMapper(String filterParams, Class entityClass) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StrUtil.isEmpty((CharSequence)filterParams)) {
            return queryWrapper;
        }
        try {
            boolean isOldFilter;
            filterParams = this.nestingManage(filterParams, queryWrapper, entityClass);
            boolean bl = isOldFilter = filterParams.startsWith("Q_") || filterParams.startsWith("QOR_");
            if (isOldFilter) {
                this.bulidQueryWrapper2(filterParams, queryWrapper, entityClass);
            } else {
                this.bulidQueryWrapper(filterParams, queryWrapper, entityClass);
            }
            return queryWrapper;
        }
        catch (Exception e) {
            log.error("\u6784\u5efa\u67e5\u8be2\u8868\u8fbe\u5f0f\u51fa\u9519:", (Throwable)e);
            return queryWrapper;
        }
    }

    public QueryWrapper<T> queryMapperSort(String sortParams) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)sortParams)) {
            String[] sortParamArr;
            for (String sortParam : sortParamArr = sortParams.split(";")) {
                String[] sortCondition = sortParam.split("_");
                String sortFieldName = sortCondition[1];
                String sortType = sortCondition[2];
                Field field = this.getField(this.clazz, sortFieldName);
                if (field == null) continue;
                String column = this.findTableFiled(field);
                if ("desc".equalsIgnoreCase(sortType)) {
                    queryWrapper.orderByDesc((Object)column);
                    continue;
                }
                queryWrapper.orderByAsc((Object)column);
            }
        }
        return queryWrapper;
    }

    private Field getField(Class clazz, String fieldName) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            Field[] fields;
            for (Field f : fields = clazz.getFields()) {
                if (!f.getName().equalsIgnoreCase(fieldName)) continue;
                field = f;
                break;
            }
        }
        return field;
    }

    private void bulidQueryWrapper(String filterParams, QueryWrapper<T> queryWrapper, Class entityClass) throws Exception {
        String[] filtersSplit;
        for (String filterParam : filtersSplit = filterParams.split(";")) {
            this.buildMybatisQuery(filterParam, queryWrapper, entityClass);
        }
    }

    private void bulidQueryWrapper2(String filterParams, QueryWrapper<T> queryWrapper, Class entityClass) throws Exception {
        List<QueryFilterParam> queryFilterParams = QueryParamUtil.parseQueryFilterParams(filterParams);
        for (QueryFilterParam queryFilterParam : queryFilterParams) {
            this.bulidQueryWrapper(queryFilterParam, queryWrapper, entityClass);
        }
    }

    private void bulidQueryWrapper(QueryFilterParam queryFilterParam, QueryWrapper<T> queryWrapper, Class entityClass) {
        if (!queryFilterParam.isNest()) {
            Field field = this.getField(entityClass, queryFilterParam.getParamName());
            if (field == null) {
                return;
            }
            String column = this.findTableFiled(field);
            String value1 = queryFilterParam.getParamValue();
            String value2 = null;
            if (queryFilterParam.getOperationMode() == OperationModel.BETWEEN || queryFilterParam.getOperationMode() == OperationModel.BTW || queryFilterParam.getOperationMode() == OperationModel.NOTBETWEEN || queryFilterParam.getOperationMode() == OperationModel.NOTBTW) {
                String[] values = queryFilterParam.getParamValue().split(",");
                if (values.length >= 1) {
                    value1 = values[0];
                }
                if (values.length >= 2) {
                    value2 = values[1];
                }
            }
            Object result1 = this.valueOfType(field, value1);
            Object result2 = this.valueOfType(field, value2);
            String type = queryFilterParam.getOperation();
            this.buildQueryWrapper(queryWrapper, column, type, result1, result2);
            if (queryFilterParam.getJoinModel() == QueryFilterParam.JoinModel.OR) {
                queryWrapper.or();
            }
        } else {
            List<QueryFilterParam> subQueryFilterParams = queryFilterParam.getChildrens();
            if (subQueryFilterParams == null || subQueryFilterParams.size() == 0) {
                return;
            }
            if (queryFilterParam.getJoinModel() == QueryFilterParam.JoinModel.OR) {
                queryWrapper.or(subQueryWrapper -> {
                    for (QueryFilterParam subFilterParam : subQueryFilterParams) {
                        this.bulidQueryWrapper(subFilterParam, (QueryWrapper<T>)subQueryWrapper, entityClass);
                    }
                });
            } else {
                queryWrapper.and(subQueryWrapper -> {
                    for (QueryFilterParam subFilterParam : subQueryFilterParams) {
                        this.bulidQueryWrapper(subFilterParam, (QueryWrapper<T>)subQueryWrapper, entityClass);
                    }
                });
            }
        }
    }

    private void buildMybatisQuery(String filterParam, QueryWrapper<T> queryWrapper, Class entityClass) throws Exception {
        if ("OR".equalsIgnoreCase(filterParam)) {
            queryWrapper.or();
            return;
        }
        String[] filters = filterParam.split("_");
        if (filters.length < 3) {
            return;
        }
        Field field = this.getField(entityClass, filters[0]);
        String column = this.findTableFiled(field);
        String type = filters[1];
        String value1 = null;
        String value2 = null;
        if (filters.length >= 3) {
            value1 = filters[2];
        }
        if (filters.length >= 4) {
            value2 = filters[3];
        }
        Object result1 = this.valueOfType(field, value1);
        Object result2 = this.valueOfType(field, value2);
        this.buildQueryWrapper(queryWrapper, column, type, result1, result2);
    }

    private void buildMybatisQuery2(String filterParam, QueryWrapper<T> queryWrapper, Class entityClass) throws Exception {
        if ("OR".equalsIgnoreCase(filterParam)) {
            queryWrapper.or();
            return;
        }
        String[] paramValPair = filterParam.split("=");
        if (paramValPair.length < 2) {
            return;
        }
        String parseParam = paramValPair[0];
        String parseValue = paramValPair[1];
        String[] filters = parseParam.split("_");
        if (filters.length < 4) {
            return;
        }
        Field field = this.getField(entityClass, filters[1]);
        String column = this.findTableFiled(field);
        String type = filters[3];
        String value1 = parseValue;
        String value2 = null;
        if (type.toUpperCase().indexOf("BETWEEN") > -1) {
            String[] values = parseValue.split("_");
            if (values.length >= 1) {
                value1 = values[0];
            }
            if (values.length >= 2) {
                value2 = values[1];
            }
        }
        Object result1 = this.valueOfType(field, value1);
        Object result2 = this.valueOfType(field, value2);
        this.buildQueryWrapper(queryWrapper, column, type, result1, result2);
        if ("QOR".equalsIgnoreCase(filters[0])) {
            queryWrapper.or();
        }
    }

    private QueryWrapper<T> buildQueryWrapper(QueryWrapper<T> queryWrapper, String column, String type, Object result1, Object result2) {
        switch (type) {
            case "EQ": {
                queryWrapper.eq((Object)column, result1);
                break;
            }
            case "NE": {
                queryWrapper.ne((Object)column, result1);
                break;
            }
            case "GT": {
                queryWrapper.gt((Object)column, result1);
                break;
            }
            case "GE": {
                queryWrapper.ge((Object)column, result1);
                break;
            }
            case "LT": {
                queryWrapper.lt((Object)column, result1);
                break;
            }
            case "LE": {
                queryWrapper.le((Object)column, result1);
                break;
            }
            case "BTW": 
            case "BETWEEN": {
                queryWrapper.between((Object)column, result1, result2);
                break;
            }
            case "NOTBETWEEN": {
                queryWrapper.notBetween((Object)column, result1, result2);
                break;
            }
            case "LK": 
            case "LIKE": {
                queryWrapper.like((Object)column, result1);
                break;
            }
            case "NLK": 
            case "NOTLIKE": {
                queryWrapper.notLike((Object)column, result1);
                break;
            }
            case "LFK": 
            case "LIKELEFT": {
                queryWrapper.likeLeft((Object)column, result1);
                break;
            }
            case "RHK": 
            case "LIKERIGHT": {
                queryWrapper.likeRight((Object)column, result1);
                break;
            }
            case "ISNULL": {
                queryWrapper.isNull((Object)column);
                break;
            }
            case "ISNOTNULL": {
                queryWrapper.isNotNull((Object)column);
                break;
            }
            case "IN": {
                queryWrapper.in((Object)column, Arrays.asList(result1.toString().split(",")));
                break;
            }
            case "NOTIN": {
                queryWrapper.notIn((Object)column, Arrays.asList(result1.toString().split(",")));
                break;
            }
        }
        return queryWrapper;
    }

    private Object valueOfType(Field field, String value) {
        try {
            String valueType = field.getType().getName();
            Object result = value;
            if (value != null) {
                block19 : switch (valueType) {
                    case "java.lang.String": {
                        return result;
                    }
                    case "java.lang.int": 
                    case "java.lang.Integer": {
                        result = Integer.parseInt(value);
                        break;
                    }
                    case "java.lang.long": 
                    case "java.lang.Long": {
                        result = Long.parseLong(value);
                        break;
                    }
                    case "java.lang.short": 
                    case "java.lang.Short": {
                        result = Short.parseShort(value);
                        break;
                    }
                    case "java.lang.double": 
                    case "java.lang.Double": {
                        result = Double.parseDouble(value);
                        break;
                    }
                    case "java.lang.float": 
                    case "java.lang.Float": {
                        result = Float.valueOf(Float.parseFloat(value));
                        break;
                    }
                    case "java.lang.byte": 
                    case "java.lang.Byte": {
                        result = Byte.parseByte(value);
                        break;
                    }
                    case "java.lang.Boolean": 
                    case "java.lang.boolean": {
                        result = Boolean.parseBoolean(value);
                        break;
                    }
                    case "java.util.Date": {
                        String dateType = "yyyy-MM-dd HH:mm:ss";
                        boolean isTableField = field.isAnnotationPresent(DateTimeFormat.class);
                        if (isTableField) {
                            DateTimeFormat tableField = field.getAnnotation(DateTimeFormat.class);
                            dateType = tableField.pattern();
                        }
                        switch (dateType) {
                            case "yyyy-MM-dd HH:mm:ss": {
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                result = sdf.parse(value);
                                break block19;
                            }
                            case "yyyy-MM-dd": {
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                                result = sdf.parse(value);
                                break block19;
                            }
                            case "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2": {
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2");
                                result = sdf.parse(value);
                                break block19;
                            }
                            case "yyyy\u5e74MM\u6708dd\u65e5": {
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
                                result = sdf.parse(value);
                                break block19;
                            }
                        }
                        break;
                    }
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String findTableFiled(Field field) {
        String fieldValue = null;
        boolean isTableField = field.isAnnotationPresent(TableField.class);
        boolean isTableId = field.isAnnotationPresent(TableId.class);
        if (isTableField) {
            TableField tableField = field.getAnnotation(TableField.class);
            fieldValue = tableField.value();
        }
        if (isTableId) {
            TableId tableId = field.getAnnotation(TableId.class);
            fieldValue = tableId.value();
        }
        return fieldValue;
    }

    private String nestingManage(String filterParams, QueryWrapper<T> queryWrapper, Class entityClass) {
        int count = (filterParams.length() - filterParams.replace(";(", "").length()) / 2;
        for (int i = 0; i < count; ++i) {
            int start = filterParams.indexOf(";(");
            int end = filterParams.indexOf(");");
            String deleteStr = filterParams.substring(start, end + 1);
            String subFilter = filterParams.substring(start + 2, end);
            queryWrapper.and(a -> {
                try {
                    boolean isOldFilter;
                    boolean bl = isOldFilter = subFilter.startsWith("Q_") || subFilter.startsWith("QOR_");
                    if (isOldFilter) {
                        this.bulidQueryWrapper2(subFilter, (QueryWrapper<T>)a, entityClass);
                    } else {
                        this.bulidQueryWrapper(subFilter, (QueryWrapper<T>)a, entityClass);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            filterParams = filterParams.replace(deleteStr, "");
        }
        return filterParams;
    }

    public static boolean isComplexExpession(String matchParam) {
        String regex = "\\([^\\(\\)]+\\)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(matchParam);
        return matcher.find();
    }
}

