/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.chat.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.ns.ai.base.controller.RestResult;
import com.geoway.ns.ai.chat.service.AiUserService;
import com.geoway.ns.ai.chat.util.query.MyQueryMapperUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public class BaseController<T, S extends IService<T>> {
    protected final S service;
    protected final MyQueryMapperUtil<T> qmu;
    @Autowired
    protected AiUserService aiUserService;

    public BaseController(S s, T t) {
        this.service = s;
        this.qmu = new MyQueryMapperUtil<T>(t);
    }

    @GetMapping(value={"/{id}"})
    public RestResult<T> queryById(@PathVariable String id) throws Exception {
        return RestResult.success((Object)this.service.getById((Serializable)((Object)id)));
    }

    @GetMapping(value={"/filter"})
    public RestResult<T> queryByFilter(String filterParam) throws Exception {
        QueryWrapper<T> wrapper = this.getWrapper(filterParam);
        wrapper.last("limit 1");
        return RestResult.success((Object)this.service.getOne(wrapper));
    }

    @GetMapping(value={"/list"})
    public RestResult<List<T>> queryList(String filterParam, String sortParam) throws Exception {
        QueryWrapper<T> wrapper = this.getWrapper(filterParam, sortParam);
        return RestResult.success((Object)this.service.list(wrapper));
    }

    @GetMapping(value={"/page"})
    public RestResult<IPage<T>> queryList(String filterParam, String sortParam, Integer page, Integer size) throws Exception {
        QueryWrapper<T> wrapper = this.getWrapper(filterParam, sortParam);
        Page pages = new Page((long)page.intValue(), (long)size.intValue());
        return RestResult.success((Object)this.service.page((IPage)pages, wrapper));
    }

    @PostMapping(value={"/saveOrUpdate"})
    @Transactional(rollbackFor={Exception.class})
    public RestResult<String> saveOrUpdate(@RequestBody T t) throws Exception {
        this.service.saveOrUpdate(t);
        Map map = BeanUtil.beanToMap(t, (String[])new String[0]);
        return RestResult.success((Object)map.get("id").toString());
    }

    @PostMapping(value={"/saveOrUpdateBatch"})
    public RestResult<String> saveOrUpdateBatch(@RequestParam(name="keepUp", defaultValue="true") Boolean keepUp, @RequestBody List<T> ts) throws Exception {
        StringBuilder sbr = new StringBuilder();
        for (T t : ts) {
            try {
                this.service.saveOrUpdate(t);
            }
            catch (Exception e) {
                if (!keepUp.booleanValue()) {
                    throw e;
                }
                sbr.append(e.getMessage() + "; ");
            }
        }
        return sbr.length() > 1 ? RestResult.error((String)sbr.toString()) : RestResult.success((Object)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE, RequestMethod.POST})
    @Transactional(rollbackFor={Exception.class})
    public RestResult<String> delete(@PathVariable String id) throws Exception {
        this.service.removeById((Serializable)((Object)id));
        return RestResult.success((Object)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/deleteByIds"}, method={RequestMethod.DELETE, RequestMethod.POST})
    @Transactional(rollbackFor={Exception.class})
    public RestResult<String> deleteBatch(@RequestParam String ids) throws Exception {
        this.service.removeBatchByIds(Arrays.asList(ids.split(",")));
        return RestResult.success((Object)"\u5220\u9664\u6210\u529f\uff01");
    }

    private QueryWrapper<T> getWrapper(String filterParam, String sortParam) throws Exception {
        if (StrUtil.isNotBlank((CharSequence)filterParam) && StrUtil.isNotBlank((CharSequence)sortParam)) {
            return this.qmu.queryMapper(filterParam, sortParam);
        }
        if (StrUtil.isNotBlank((CharSequence)filterParam)) {
            return this.qmu.queryMapper(filterParam);
        }
        if (StrUtil.isNotBlank((CharSequence)sortParam)) {
            return this.qmu.queryMapperSort(sortParam);
        }
        return new QueryWrapper();
    }

    private QueryWrapper<T> getWrapper(String filterParam) throws Exception {
        return this.qmu.queryMapper(filterParam);
    }

    protected String getUserId() throws Exception {
        String userId = this.aiUserService.getUserId();
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        return userId;
    }
}

