CREATE TABLE IF NOT EXISTS  tb_ai_chat_log (
	f_id varchar(64) NOT NULL, -- 主键
	f_pid varchar(64) NULL, -- 会话id
	f_sessionid varchar(64) NULL, -- 会话id
	f_name text NULL, -- 名称
	f_create_time timestamp NULL, -- 创建时间
	f_question text NULL, -- 问题
	f_answer text NULL, -- 答案
	f_chatcost int4 NULL, -- 问答耗时
	f_toolcost int4 NULL, -- 工具执行耗时
	f_toolname text NULL, -- 工具名称
	f_toolparams text NULL, -- 工具执行参数
	f_toolresult text NULL, -- 工具执行结果
	f_errormsg text NULL,--异常信息
	CONSTRAINT tb_ai_chat_log_pk PRIMARY KEY (f_id)
);
CREATE INDEX IF NOT EXISTS tb_ai_chat_log_f_sessionid_idx ON tb_ai_chat_log USING btree (f_sessionid);
CREATE INDEX IF NOT EXISTS tb_ai_chat_log_f_pid_idx ON tb_ai_chat_log USING btree (f_pid);
COMMENT ON TABLE tb_ai_chat_log IS 'AI对话详情表';

-- Column comments

COMMENT ON COLUMN tb_ai_chat_log.f_id IS '主键';
COMMENT ON COLUMN tb_ai_chat_log.f_pid IS '会话id';
COMMENT ON COLUMN tb_ai_chat_log.f_sessionid IS '对话id';
COMMENT ON COLUMN tb_ai_chat_log.f_name IS '名称';
COMMENT ON COLUMN tb_ai_chat_log.f_create_time IS '创建时间';
COMMENT ON COLUMN tb_ai_chat_log.f_question IS '问题';
COMMENT ON COLUMN tb_ai_chat_log.f_answer IS '答案';
COMMENT ON COLUMN tb_ai_chat_log.f_chatcost IS '问答耗时';
COMMENT ON COLUMN tb_ai_chat_log.f_toolcost IS '工具执行耗时';
COMMENT ON COLUMN tb_ai_chat_log.f_toolname IS '工具名称';
COMMENT ON COLUMN tb_ai_chat_log.f_toolparams IS '工具执行参数';
COMMENT ON COLUMN tb_ai_chat_log.f_toolresult IS '工具执行结果';
COMMENT ON COLUMN tb_ai_chat_log.f_errormsg IS '异常信息';


-- tb_ai_chat_history definition

-- Drop table

-- DROP TABLE tb_ai_chat_history;

CREATE TABLE IF NOT EXISTS tb_ai_chat_history (
	f_id varchar(64) NOT NULL, -- 主键
	f_pid varchar(64) NULL, -- 会话id
	f_create_time timestamp NULL, -- 创建时间
	f_type int2 NULL, -- 1.用户   2. ai
	f_thinks text NULL, -- 思考内容
	f_status int2 NULL, -- 状态 0.进行中  1.完成  -1.失败
	f_cost int4 NULL, -- 耗时
	f_relation varchar(64) NULL, -- ai消息id
	f_voice text NULL, -- 文字语音内容
	f_msgs text NULL, -- AI消息
	CONSTRAINT tb_ai_chat_history_pk PRIMARY KEY (f_id)
);
CREATE INDEX IF NOT EXISTS  tb_ai_chat_history_f_pid_idx ON tb_ai_chat_history USING btree (f_pid);
COMMENT ON TABLE tb_ai_chat_history IS 'AI对话详情表';

-- Column comments

COMMENT ON COLUMN tb_ai_chat_history.f_id IS '主键';
COMMENT ON COLUMN tb_ai_chat_history.f_pid IS '会话id';
COMMENT ON COLUMN tb_ai_chat_history.f_create_time IS '创建时间';
COMMENT ON COLUMN tb_ai_chat_history.f_type IS '1.用户   2. ai';
COMMENT ON COLUMN tb_ai_chat_history.f_thinks IS '思考内容';
COMMENT ON COLUMN tb_ai_chat_history.f_status IS '状态 0.进行中  1.完成  -1.失败';
COMMENT ON COLUMN tb_ai_chat_history.f_cost IS '耗时';
COMMENT ON COLUMN tb_ai_chat_history.f_relation IS 'ai消息id';
COMMENT ON COLUMN tb_ai_chat_history.f_voice IS '文字语音内容';
COMMENT ON COLUMN tb_ai_chat_history.f_msgs IS 'AI消息';


-- tb_ai_chat definition

-- Drop table

-- DROP TABLE tb_ai_chat;

CREATE TABLE IF NOT EXISTS tb_ai_chat (
	f_user_id varchar(128) NULL, -- 用户id
	f_create_time timestamp NULL, -- 创建时间
	f_name text NULL, -- 对话窗名称
	f_id varchar(64) NOT NULL, -- 主键
	f_collect int2 NULL, -- 收藏  1.是  0.否
	f_type varchar(16) NULL, -- chat、znfx、znjs、znwd
	CONSTRAINT tb_ai_chat_pk PRIMARY KEY (f_id)
);
CREATE INDEX IF NOT EXISTS tb_ai_chat_f_user_id_idx ON tb_ai_chat USING btree (f_user_id);
COMMENT ON TABLE tb_ai_chat IS 'AI对话表';

-- Column comments

COMMENT ON COLUMN tb_ai_chat.f_user_id IS '用户id';
COMMENT ON COLUMN tb_ai_chat.f_create_time IS '创建时间';
COMMENT ON COLUMN tb_ai_chat.f_name IS '对话窗名称';
COMMENT ON COLUMN tb_ai_chat.f_id IS '主键';
COMMENT ON COLUMN tb_ai_chat.f_collect IS '收藏  1.是  0.否';
COMMENT ON COLUMN tb_ai_chat.f_type IS 'chat、znfx、znjs、znwd';

