/*
 * Decompiled with CFR 0.152.
 */
package squants.market;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Try;
import scala.util.matching.Regex;
import squants.Dimension;
import squants.QuantityParseException;
import squants.UnitOfMeasure;
import squants.market.Currency;
import squants.market.Currency$;
import squants.market.Money;
import squants.market.MoneyContext;

public final class Money$
implements Dimension<Money>,
scala.Serializable {
    public static Money$ MODULE$;
    private Regex squants$Dimension$$QuantityString;
    private final Dimension<Money> dimensionImplicit;
    private volatile boolean bitmap$0;

    static {
        new Money$();
    }

    @Override
    public Option<UnitOfMeasure<Money>> symbolToUnit(String symbol) {
        return Dimension.symbolToUnit$(this, symbol);
    }

    @Override
    public Try<Money> parse(Object value) {
        return Dimension.parse$(this, value);
    }

    @Override
    public Try<Money> parseString(String s) {
        return Dimension.parseString$(this, s);
    }

    @Override
    public <N> Try<Money> parseTuple(Tuple2<N, String> t, Numeric<N> num) {
        return Dimension.parseTuple$(this, t, num);
    }

    @Override
    public boolean equals(Object that) {
        return Dimension.equals$(this, that);
    }

    @Override
    public int hashCode() {
        return Dimension.hashCode$(this);
    }

    private Regex squants$Dimension$$QuantityString$lzycompute() {
        Money$ money$ = this;
        synchronized (money$) {
            if (!this.bitmap$0) {
                this.squants$Dimension$$QuantityString = Dimension.squants$Dimension$$QuantityString$(this);
                this.bitmap$0 = true;
            }
        }
        return this.squants$Dimension$$QuantityString;
    }

    @Override
    public Regex squants$Dimension$$QuantityString() {
        return !this.bitmap$0 ? this.squants$Dimension$$QuantityString$lzycompute() : this.squants$Dimension$$QuantityString;
    }

    @Override
    public Dimension<Money> dimensionImplicit() {
        return this.dimensionImplicit;
    }

    @Override
    public void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension<Money> x$1) {
        this.dimensionImplicit = x$1;
    }

    public Money apply(double value, MoneyContext fxContext) {
        return new Money(package$.MODULE$.BigDecimal().apply(value), fxContext.defaultCurrency());
    }

    public Money apply(BigDecimal value, MoneyContext fxContext) {
        return new Money(value, fxContext.defaultCurrency());
    }

    public Money apply(BigDecimal value, Currency currency) {
        return new Money(value, currency);
    }

    public Try<Money> apply(BigDecimal value, String currency, MoneyContext fxContext) {
        return Currency$.MODULE$.apply(currency, fxContext).map((Function1 & Serializable & scala.Serializable)x$1 -> new Money(value, (Currency)x$1));
    }

    public <A> Money apply(A n, Currency currency, Numeric<A> num) {
        return new Money(package$.MODULE$.BigDecimal().apply(num.toDouble(n)), currency);
    }

    public <A> Try<Money> apply(A n, String currency, Numeric<A> num, MoneyContext fxContext) {
        return Currency$.MODULE$.apply(currency, fxContext).map((Function1 & Serializable & scala.Serializable)x$2 -> new Money(package$.MODULE$.BigDecimal().apply(num.toDouble(n)), (Currency)x$2));
    }

    public Try<Money> apply(String s, MoneyContext fxContext) {
        Failure failure;
        String string2;
        Regex regex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(26).append("([-+]?[0-9]*\\.?[0-9]+) *(").append(((TraversableOnce)fxContext.currencies().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.code(), Set$.MODULE$.canBuildFrom())).reduceLeft((Function2 & Serializable & scala.Serializable)(x$4, x$5) -> new StringBuilder(1).append((String)x$4).append("|").append((String)x$5).toString())).append(")").toString())).r();
        Option option2 = regex.unapplySeq((CharSequence)(string2 = s));
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
            String value = (String)((LinearSeqOptimized)option2.get()).apply(0);
            String currency = (String)((LinearSeqOptimized)option2.get()).apply(1);
            failure = Currency$.MODULE$.apply(currency, fxContext).map((Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(value)).toDouble()), (Currency)x$6, (Numeric)Numeric.DoubleIsFractional$.MODULE$));
        } else {
            failure = new Failure((Throwable)new QuantityParseException("Unable to parse Money", s));
        }
        return failure;
    }

    @Override
    public String name() {
        return "Money";
    }

    public Nothing$ primaryUnit() {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Nothing$ siUnit() {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Nothing$ units() {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Money$() {
        MODULE$ = this;
        Dimension.$init$(this);
    }
}

