/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.raster.CompositeTile;
import geotrellis.raster.GeoAttrsError;
import geotrellis.raster.Tile;
import geotrellis.raster.TileLayout;
import geotrellis.raster.package$;
import geotrellis.raster.split.Split;
import geotrellis.raster.split.Split$Options$;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;

public final class CompositeTile$
implements Serializable {
    public static CompositeTile$ MODULE$;

    static {
        new CompositeTile$();
    }

    public CompositeTile apply(Tile tile, TileLayout tileLayout) {
        CompositeTile compositeTile;
        Tile tile2 = tile;
        if (tile2 instanceof CompositeTile) {
            CompositeTile compositeTile2 = (CompositeTile)tile2;
            TileLayout tileLayout2 = tileLayout;
            TileLayout tileLayout3 = compositeTile2.tileLayout();
            if (tileLayout2 == null ? tileLayout3 != null : !((Object)tileLayout2).equals(tileLayout3)) {
                throw new GeoAttrsError(new StringBuilder(101).append("This tile is a composite tile with a different layout than the argument tile layout.").append(" ").append(tileLayout).append(" does not match ").append(compositeTile2.tileLayout()).toString());
            }
            compositeTile = compositeTile2;
        } else {
            compositeTile = this.wrap(tile, tileLayout);
        }
        return compositeTile;
    }

    public CompositeTile wrap(Tile tile, int tileCols, int tileRows) {
        TileLayout tileLayout = new TileLayout(tileCols, tileRows, (tile.cols$mcI$sp() - 1) / tileCols + 1, (tile.rows$mcI$sp() - 1) / tileRows + 1);
        return this.wrap(tile, tileLayout, true);
    }

    public CompositeTile wrap(Tile tile, int tileCols, int tileRows, boolean cropped) {
        TileLayout tileLayout = new TileLayout(tileCols, tileRows, (tile.cols$mcI$sp() - 1) / tileCols + 1, (tile.rows$mcI$sp() - 1) / tileRows + 1);
        return this.wrap(tile, tileLayout, cropped);
    }

    public CompositeTile wrap(Tile tile, TileLayout tileLayout) {
        return new CompositeTile(package$.MODULE$.withSinglebandTileSplitMethods(tile).split(tileLayout, new Split.Options(true, Split$Options$.MODULE$.apply$default$2())), tileLayout);
    }

    public CompositeTile wrap(Tile tile, TileLayout tileLayout, boolean cropped) {
        return new CompositeTile(package$.MODULE$.withSinglebandTileSplitMethods(tile).split(tileLayout, new Split.Options(cropped, Split$Options$.MODULE$.apply$default$2())), tileLayout);
    }

    public CompositeTile apply(Seq<Tile> tiles, TileLayout tileLayout) {
        return new CompositeTile(tiles, tileLayout);
    }

    public Option<Tuple2<Seq<Tile>, TileLayout>> unapply(CompositeTile x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.tiles(), (Object)x$0.tileLayout()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CompositeTile$() {
        MODULE$ = this;
    }
}

