/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.proj4.CRS;
import geotrellis.proj4.Transform$;
import geotrellis.raster.CellSize;
import geotrellis.raster.GeoAttrsError;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridExtent$;
import geotrellis.raster.GridIntegral;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.TileLayout;
import geotrellis.raster.reproject.Reproject;
import geotrellis.raster.reproject.Reproject$Options$;
import geotrellis.raster.reproject.ReprojectRasterExtent$;
import geotrellis.util.Constants$;
import geotrellis.vector.Extent;
import java.io.Serializable;
import org.locationtech.jts.geom.Point;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import spire.math.Integral;
import spire.math.Integral$;

@ScalaSignature(bytes="\u0006\u0001\rUe\u0001\u0002!B\u0001\u0019C\u0001\"\u001c\u0001\u0003\u0006\u0004%\tA\u001c\u0005\tk\u0002\u0011\t\u0011)A\u0005_\"Aa\u000f\u0001BC\u0002\u0013\u0005q\u000f\u0003\u0005|\u0001\t\u0005\t\u0015!\u0003y\u0011!a\bA!b\u0001\n\u00039\b\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011\u0002=\t\u0011y\u0004!Q1A\u0005\u0002}D\u0011\"!\u0001\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0013\u0005\r\u0001A!b\u0001\n\u0003y\b\"CA\u0003\u0001\t\u0005\t\u0015!\u0003M\u0011)\t9\u0001\u0001B\u0002B\u0003-\u0011\u0011\u0002\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\tI\u0002\u0001C\u0001\u0003[Aq!!\u0007\u0001\t\u0003\tY\u0004C\u0004\u0002H\u0001!\t!a\u0014\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T!9\u0011\u0011\f\u0001\u0005\u0006\u0005m\u0003bBA1\u0001\u0011\u0015\u00111\r\u0005\b\u0003S\u0002AQAA6\u0011\u001d\ty\u0007\u0001C\u0003\u0003cBq!!\u001e\u0001\t\u000b\t9\bC\u0004\u0002v\u0001!)!a!\t\u000f\u0005U\u0004\u0001\"\u0002\u0002\f\"9\u0011q\u0015\u0001\u0005\u0006\u0005%\u0006bBAZ\u0001\u0011\u0015\u0011Q\u0017\u0005\b\u0003s\u0003AQAA^\u0011\u001d\ty\f\u0001C\u0001\u0003\u0003Dq!a0\u0001\t\u0003\tY\rC\u0004\u0002P\u0002!\t!!5\t\u000f\u0005m\u0007\u0001\"\u0001\u0002^\"I\u00111\u001f\u0001\u0012\u0002\u0013\u0005\u0011Q\u001f\u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u0011\u001d\u0011)\u0002\u0001C\u0001\u0005/AqA!\u0006\u0001\t\u0003\u0011i\u0002C\u0004\u0003&\u0001!\tAa\n\t\u000f\t%\u0002\u0001\"\u0001\u0003,!9!q\u0006\u0001\u0005\u0002\tE\u0002b\u0002B\u001a\u0001\u0011\u0005!Q\u0007\u0005\n\u0005{\u0001\u0011\u0013!C\u0001\u0003kDqAa\u0010\u0001\t\u0003\u0011\t\u0005C\u0004\u0003N\u0001!\tAa\u0014\t\u000f\tU\u0003\u0001\"\u0011\u0003X!9!1\f\u0001\u0005B\tu\u0003b\u0002B3\u0001\u0011\u0005!q\r\u0005\b\u0005s\u0002A\u0011\tB>\u000f\u001d\u0011i)\u0011E\u0001\u0005\u001f3a\u0001Q!\t\u0002\tE\u0005bBA\r_\u0011\u0005!q\u0014\u0005\n\u0005C{#\u0019!C\u0003\u0005GC\u0001B!+0A\u00035!Q\u0015\u0005\b\u0005W{C\u0011\u0001BW\u0011\u001d\u0011Yk\fC\u0001\u0005\u0007DqAa+0\t\u0003\u0011Y\u000eC\u0004\u0003z>\"\u0019Aa?\t\u000f\r-q\u0006\"\u0001\u0004\u000e\u0019111C\u0018\u0002\u0007+A!b!\u00079\u0005\u0003\u0005\u000b\u0011BB\u000e\u0011)\u0019\t\u0003\u000fB\u0002B\u0003-11\u0005\u0005\b\u00033AD\u0011AB\u0013\u0011\u001d\u0019\t\u0004\u000fC\u0001\u0007gAqa!\r9\t\u0003\u0019)\u0007C\u0005\u0004l=\n\t\u0011b\u0001\u0004n!I1\u0011Q\u0018\u0002\u0002\u0013%11\u0011\u0002\u000b\u000fJLG-\u0012=uK:$(B\u0001\"D\u0003\u0019\u0011\u0018m\u001d;fe*\tA)\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001!\u0006\u0002H\u001dN\u0011\u0001\u0001\u0013\t\u0004\u0013*cU\"A!\n\u0005-\u000b%\u0001D$sS\u0012Le\u000e^3he\u0006d\u0007CA'O\u0019\u0001!\u0011b\u0014\u0001!\u0002\u0003\u0005)\u0019\u0001)\u0003\u00039\u000b\"!U,\u0011\u0005I+V\"A*\u000b\u0003Q\u000bQa]2bY\u0006L!AV*\u0003\u000f9{G\u000f[5oOB\u0011!\u000bW\u0005\u00033N\u00131!\u00118zQ\u0011q5L\u00185\u0011\u0005Ic\u0016BA/T\u0005-\u0019\b/Z2jC2L'0\u001a32\u000b\rz\u0006MY1\u000f\u0005I\u0003\u0017BA1T\u0003\rIe\u000e^\u0019\u0005I\r<GK\u0004\u0002eO6\tQM\u0003\u0002g\u000b\u00061AH]8pizJ\u0011\u0001V\u0019\u0006G%TGn\u001b\b\u0003%*L!a[*\u0002\t1{gnZ\u0019\u0005I\r<G+\u0001\u0004fqR,g\u000e^\u000b\u0002_B\u0011\u0001o]\u0007\u0002c*\u0011!oQ\u0001\u0007m\u0016\u001cGo\u001c:\n\u0005Q\f(AB#yi\u0016tG/A\u0004fqR,g\u000e\u001e\u0011\u0002\u0013\r,G\u000e\\<jIRDW#\u0001=\u0011\u0005IK\u0018B\u0001>T\u0005\u0019!u.\u001e2mK\u0006Q1-\u001a7mo&$G\u000f\u001b\u0011\u0002\u0015\r,G\u000e\u001c5fS\u001eDG/A\u0006dK2d\u0007.Z5hQR\u0004\u0013\u0001B2pYN,\u0012\u0001T\u0001\u0006G>d7\u000fI\u0001\u0005e><8/A\u0003s_^\u001c\b%\u0001\u0006fm&$WM\\2fIE\u0002R!a\u0003\u0002\u00161k!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\u0005[\u0006$\bN\u0003\u0002\u0002\u0014\u0005)1\u000f]5sK&!\u0011qCA\u0007\u0005!Ie\u000e^3he\u0006d\u0017A\u0002\u001fj]&$h\b\u0006\u0007\u0002\u001e\u0005\r\u0012QEA\u0014\u0003S\tY\u0003\u0006\u0003\u0002 \u0005\u0005\u0002cA%\u0001\u0019\"9\u0011q\u0001\u0007A\u0004\u0005%\u0001\"B7\r\u0001\u0004y\u0007\"\u0002<\r\u0001\u0004A\b\"\u0002?\r\u0001\u0004A\b\"\u0002@\r\u0001\u0004a\u0005BBA\u0002\u0019\u0001\u0007A\n\u0006\u0005\u00020\u0005U\u0012qGA\u001d)\u0011\ty\"!\r\t\u0013\u0005MR\"!AA\u0004\u0005%\u0011AC3wS\u0012,gnY3%e!)Q.\u0004a\u0001_\")a0\u0004a\u0001\u0019\"1\u00111A\u0007A\u00021#b!!\u0010\u0002D\u0005\u0015C\u0003BA\u0010\u0003\u007fA\u0011\"!\u0011\u000f\u0003\u0003\u0005\u001d!!\u0003\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007C\u0003n\u001d\u0001\u0007q\u000eC\u0004\u0002H9\u0001\r!!\u0013\u0002\u0011\r,G\u000e\\*ju\u0016\u00042!SA&\u0013\r\ti%\u0011\u0002\t\u0007\u0016dGnU5{KV\u0011\u0011\u0011J\u0001\bG>l'-\u001b8f)\u0011\ty\"!\u0016\t\u000f\u0005]\u0003\u00031\u0001\u0002 \u0005!A\u000f[1u\u0003Ai\u0017\r\u001d-U_\u001e\u0013\u0018\u000e\u001a#pk\ndW\rF\u0002y\u0003;Ba!a\u0018\u0012\u0001\u0004A\u0018!\u0001=\u0002!5\f\u0007/\u0017+p\u000fJLG\rR8vE2,Gc\u0001=\u0002f!1\u0011q\r\nA\u0002a\f\u0011!_\u0001\u000b[\u0006\u0004\b\fV8He&$Gc\u0001'\u0002n!1\u0011qL\nA\u0002a\f!\"\\1q3R{wI]5e)\ra\u00151\u000f\u0005\u0007\u0003O\"\u0002\u0019\u0001=\u0002\u00135\f\u0007\u000fV8He&$GCBA=\u0003\u007f\n\t\tE\u0003S\u0003wbE*C\u0002\u0002~M\u0013a\u0001V;qY\u0016\u0014\u0004BBA0+\u0001\u0007\u0001\u0010\u0003\u0004\u0002hU\u0001\r\u0001\u001f\u000b\u0005\u0003s\n)\tC\u0004\u0002\bZ\u0001\r!!#\u0002\u00115\f\u0007oQ8pe\u0012\u0004RAUA>qb$B!!\u001f\u0002\u000e\"9\u0011qR\fA\u0002\u0005E\u0015!\u00019\u0011\t\u0005M\u0015\u0011\u0015\b\u0005\u0003+\u000biJ\u0004\u0003\u0002\u0018\u0006meb\u00013\u0002\u001a&\tA)\u0003\u0002s\u0007&\u0019\u0011qT9\u0002\u000fA\f7m[1hK&!\u00111UAS\u0005\u0015\u0001v.\u001b8u\u0015\r\ty*]\u0001\nOJLG\rV8NCB$b!!#\u0002,\u0006=\u0006BBAW1\u0001\u0007A*A\u0002d_2Da!!-\u0019\u0001\u0004a\u0015a\u0001:po\u0006aqM]5e\u0007>dGk\\'baR\u0019\u00010a.\t\r\u00055\u0016\u00041\u0001M\u000319'/\u001b3S_^$v.T1q)\rA\u0018Q\u0018\u0005\u0007\u0003cS\u0002\u0019\u0001'\u0002\u001d]LG\u000f\u001b*fg>dW\u000f^5p]R1\u0011qDAb\u0003\u000fDa!!2\u001c\u0001\u0004A\u0018a\u0004;be\u001e,GoQ3mY^KG\r\u001e5\t\r\u0005%7\u00041\u0001y\u0003A!\u0018M]4fi\u000e+G\u000e\u001c%fS\u001eDG\u000f\u0006\u0003\u0002 \u00055\u0007bBA$9\u0001\u0007\u0011\u0011J\u0001\u000fo&$\b\u000eR5nK:\u001c\u0018n\u001c8t)\u0019\ty\"a5\u0002X\"1\u0011Q[\u000fA\u00021\u000b!\u0002^1sO\u0016$8i\u001c7t\u0011\u0019\tI.\ba\u0001\u0019\u0006QA/\u0019:hKR\u0014vn^:\u0002\u001b\u001d\u0014\u0018\u000e\u001a\"pk:$7OR8s)\u0019\ty.!:\u0002jB!\u0011*!9M\u0013\r\t\u0019/\u0011\u0002\u000b\u000fJLGMQ8v]\u0012\u001c\bBBAt=\u0001\u0007q.A\u0005tk\n,\u0005\u0010^3oi\"I\u00111\u001e\u0010\u0011\u0002\u0003\u0007\u0011Q^\u0001\u0006G2\fW\u000e\u001d\t\u0004%\u0006=\u0018bAAy'\n9!i\\8mK\u0006t\u0017aF4sS\u0012\u0014u.\u001e8eg\u001a{'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t9P\u000b\u0003\u0002n\u0006e8FAA~!\u0011\tiPa\u0002\u000e\u0005\u0005}(\u0002\u0002B\u0001\u0005\u0007\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u00151+\u0001\u0006b]:|G/\u0019;j_:LAA!\u0003\u0002\u0000\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001dQ|'+Y:uKJ,\u0005\u0010^3oiR\u0011!q\u0002\t\u0004\u0013\nE\u0011b\u0001B\n\u0003\na!+Y:uKJ,\u0005\u0010^3oi\u000692M]3bi\u0016\fE.[4oK\u0012<%/\u001b3FqR,g\u000e\u001e\u000b\u0005\u0003?\u0011I\u0002\u0003\u0004\u0003\u001c\u0005\u0002\ra\\\u0001\ri\u0006\u0014x-\u001a;FqR,g\u000e\u001e\u000b\u0007\u0003?\u0011yB!\t\t\r\tm!\u00051\u0001p\u0011\u001d\u0011\u0019C\ta\u0001\u0003#\u000ba\"\u00197jO:lWM\u001c;Q_&tG/A\njg\u001e\u0013\u0018\u000eZ#yi\u0016tG/\u00117jO:,G-\u0006\u0002\u0002n\u0006I2M]3bi\u0016\fE.[4oK\u0012\u0014\u0016m\u001d;fe\u0016CH/\u001a8u)\u0011\u0011yA!\f\t\r\tmA\u00051\u0001p\u0003E\tG.[4o)\u0006\u0014x-\u001a;QSb,Gn]\u000b\u0003\u0003?\t\u0011\"\u001a=uK:$hi\u001c:\u0015\u000b=\u00149Da\u000f\t\u000f\teb\u00051\u0001\u0002`\u0006Q1-\u001a7m\u0005>,h\u000eZ:\t\u0013\u0005-h\u0005%AA\u0002\u00055\u0018aE3yi\u0016tGOR8sI\u0011,g-Y;mi\u0012\u0012\u0014\u0001C1eUV\u001cH\u000fV8\u0015\t\u0005}!1\t\u0005\b\u0005\u000bB\u0003\u0019\u0001B$\u0003)!\u0018\u000e\\3MCf|W\u000f\u001e\t\u0004\u0013\n%\u0013b\u0001B&\u0003\nQA+\u001b7f\u0019\u0006Lx.\u001e;\u0002\u0011\r\fg.R9vC2$B!!<\u0003R!1!1K\u0015A\u0002]\u000b\u0011!Y\u0001\u0007KF,\u0018\r\\:\u0015\t\u00055(\u0011\f\u0005\u0007\u0003/R\u0003\u0019A,\u0002\u0011!\f7\u000f[\"pI\u0016$\"Aa\u0018\u0011\u0007I\u0013\t'C\u0002\u0003dM\u00131!\u00138u\u0003)!xn\u0012:jIRK\b/Z\u000b\u0005\u0005S\u0012y\u0007\u0006\u0003\u0003l\tM\u0004\u0003B%\u0001\u0005[\u00022!\u0014B8\t\u0019\u0011\t\b\fb\u0001!\n\tQ\nC\u0005\u0003v1\n\t\u0011q\u0001\u0003x\u0005QQM^5eK:\u001cW\r\n\u001b\u0011\r\u0005-\u0011Q\u0003B7\u0003!!xn\u0015;sS:<GC\u0001B?!\u0011\u0011yHa\"\u000f\t\t\u0005%1\u0011\t\u0003INK1A!\"T\u0003\u0019\u0001&/\u001a3fM&!!\u0011\u0012BF\u0005\u0019\u0019FO]5oO*\u0019!QQ*\u0002\u0015\u001d\u0013\u0018\u000eZ#yi\u0016tG\u000f\u0005\u0002J_M)qFa%\u0003\u001aB\u0019!K!&\n\u0007\t]5K\u0001\u0004B]f\u0014VM\u001a\t\u0004%\nm\u0015b\u0001BO'\na1+\u001a:jC2L'0\u00192mKR\u0011!qR\u0001\bKB\u001c\u0018\u000e\\8o+\t\u0011)k\u0004\u0002\u0003(\u0002BaH_ls6s~\u000b*\u0001\u0005faNLGn\u001c8!\u0003\u0015\t\u0007\u000f\u001d7z+\u0011\u0011yKa.\u0015\r\tE&q\u0018Ba)\u0011\u0011\u0019L!/\u0011\t%\u0003!Q\u0017\t\u0004\u001b\n]F!B(4\u0005\u0004\u0001\u0006\"\u0003B^g\u0005\u0005\t9\u0001B_\u0003))g/\u001b3f]\u000e,G%\u000e\t\u0007\u0003\u0017\t)B!.\t\u000b5\u001c\u0004\u0019A8\t\u000f\u0005\u001d3\u00071\u0001\u0002JU!!Q\u0019Bg)!\u00119M!6\u0003X\neG\u0003\u0002Be\u0005\u001f\u0004B!\u0013\u0001\u0003LB\u0019QJ!4\u0005\u000b=#$\u0019\u0001)\t\u0013\tEG'!AA\u0004\tM\u0017AC3wS\u0012,gnY3%mA1\u00111BA\u000b\u0005\u0017DQ!\u001c\u001bA\u0002=DaA \u001bA\u0002\t-\u0007bBA\u0002i\u0001\u0007!1Z\u000b\u0005\u0005;\u0014)\u000f\u0006\u0004\u0003`\n5(q\u001e\u000b\u0005\u0005C\u00149\u000f\u0005\u0003J\u0001\t\r\bcA'\u0003f\u0012)q*\u000eb\u0001!\"I!\u0011^\u001b\u0002\u0002\u0003\u000f!1^\u0001\u000bKZLG-\u001a8dK\u0012:\u0004CBA\u0006\u0003+\u0011\u0019\u000fC\u0003nk\u0001\u0007q\u000eC\u0004\u0003rV\u0002\rAa=\u0002\t\u001d\u0014\u0018\u000e\u001a\t\u0006\u0013\nU(1]\u0005\u0004\u0005o\f%\u0001B$sS\u0012\f1c\u001a:jI\n{WO\u001c3t\u0013:$Hk\u001c'p]\u001e$BA!@\u0004\u0006A)\u0011*!9\u0003\u0000B\u0019!k!\u0001\n\u0007\r\r1K\u0001\u0003M_:<\u0007bBB\u0004m\u0001\u00071\u0011B\u0001\u0007E>,h\u000eZ:\u0011\u000b%\u000b\tOa\u0018\u0002%\u0019dwn\u001c:XSRDGk\u001c7fe\u0006t7-\u001a\u000b\u0004q\u000e=\u0001BBB\to\u0001\u0007\u00010A\u0003wC2,XMA\the&$W\t\u001f;f]RlU\r\u001e5pIN,Baa\u0006\u0004 M\u0019\u0001Ha%\u0002\tM,GN\u001a\t\u0005\u0013\u0002\u0019i\u0002E\u0002N\u0007?!Qa\u0014\u001dC\u0002A\u000b!\"\u001a<jI\u0016t7-\u001a\u00139!\u0019\tY!!\u0006\u0004\u001eQ!1qEB\u0018)\u0011\u0019Ic!\f\u0011\u000b\r-\u0002h!\b\u000e\u0003=Bqa!\t<\u0001\b\u0019\u0019\u0003C\u0004\u0004\u001am\u0002\raa\u0007\u0002\u0013I,\u0007O]8kK\u000e$H\u0003CB\u000e\u0007k\u0019)e!\u0013\t\u000f\r]B\b1\u0001\u0004:\u0005\u00191O]2\u0011\t\rm2\u0011I\u0007\u0003\u0007{Q1aa\u0010D\u0003\u0015\u0001(o\u001c65\u0013\u0011\u0019\u0019e!\u0010\u0003\u0007\r\u00136\u000bC\u0004\u0004Hq\u0002\ra!\u000f\u0002\t\u0011,7\u000f\u001e\u0005\b\u0007\u0017b\u0004\u0019AB'\u0003\u001dy\u0007\u000f^5p]N\u0004Baa\u0014\u0004`9!1\u0011KB-\u001d\u0011\u0019\u0019fa\u0016\u000f\t\u0005]5QK\u0005\u0003\u0005\u000eK1a!\rB\u0013\u0011\u0019Yf!\u0018\u0002\u0013I+\u0007O]8kK\u000e$(bAB\u0019\u0003&!1\u0011MB2\u0005\u001dy\u0005\u000f^5p]NTAaa\u0017\u0004^Q111DB4\u0007SBqaa\u000e>\u0001\u0004\u0019I\u0004C\u0004\u0004Hu\u0002\ra!\u000f\u0002#\u001d\u0014\u0018\u000eZ#yi\u0016tG/T3uQ>$7/\u0006\u0003\u0004p\r]D\u0003BB9\u0007{\"Baa\u001d\u0004zA)11\u0006\u001d\u0004vA\u0019Qja\u001e\u0005\u000b=s$\u0019\u0001)\t\u000f\r\u0005b\bq\u0001\u0004|A1\u00111BA\u000b\u0007kBqa!\u0007?\u0001\u0004\u0019y\b\u0005\u0003J\u0001\rU\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"a!\"\u0011\t\r\u001d5\u0011S\u0007\u0003\u0007\u0013SAaa#\u0004\u000e\u0006!A.\u00198h\u0015\t\u0019y)\u0001\u0003kCZ\f\u0017\u0002BBJ\u0007\u0013\u0013aa\u00142kK\u000e$\b")
public class GridExtent<N>
extends GridIntegral<N> {
    private final Extent extent;
    private final double cellwidth;
    private final double cellheight;
    public final N cols;
    public final N rows;
    public final Integral<N> evidence$1;

    public static <N> gridExtentMethods<N> gridExtentMethods(GridExtent<N> gridExtent, Integral<N> integral) {
        return GridExtent$.MODULE$.gridExtentMethods(gridExtent, integral);
    }

    public static double floorWithTolerance(double d) {
        return GridExtent$.MODULE$.floorWithTolerance(d);
    }

    public static GridBounds<Object> gridBoundsIntToLong(GridBounds<Object> gridBounds) {
        return GridExtent$.MODULE$.gridBoundsIntToLong(gridBounds);
    }

    public static <N> GridExtent<N> apply(Extent extent, Grid<N> grid, Integral<N> integral) {
        return GridExtent$.MODULE$.apply(extent, grid, integral);
    }

    public static <N> GridExtent<N> apply(Extent extent, N n, N n2, Integral<N> integral) {
        return GridExtent$.MODULE$.apply(extent, n, n2, integral);
    }

    public static <N> GridExtent<N> apply(Extent extent, CellSize cellSize, Integral<N> integral) {
        return GridExtent$.MODULE$.apply(extent, cellSize, integral);
    }

    public static double epsilon() {
        return GridExtent$.MODULE$.epsilon();
    }

    public Extent extent() {
        return this.extent;
    }

    public double cellwidth() {
        return this.cellwidth;
    }

    public double cellheight() {
        return this.cellheight;
    }

    @Override
    public N cols() {
        return this.cols;
    }

    @Override
    public N rows() {
        return this.rows;
    }

    public CellSize cellSize() {
        return new CellSize(this.cellwidth(), this.cellheight());
    }

    public GridExtent<N> combine(GridExtent<N> that) {
        if (this.cellwidth() != that.cellwidth()) {
            throw new GeoAttrsError(new StringBuilder(25).append("illegal cellwidths: ").append(this.cellwidth()).append(" and ").append(that.cellwidth()).toString());
        }
        if (this.cellheight() != that.cellheight()) {
            throw new GeoAttrsError(new StringBuilder(26).append("illegal cellheights: ").append(this.cellheight()).append(" and ").append(that.cellheight()).toString());
        }
        Extent newExtent = this.extent().combine(that.extent());
        return GridExtent$.MODULE$.apply(newExtent, new CellSize(this.cellwidth(), this.cellheight()), this.evidence$1);
    }

    public final double mapXToGridDouble(double x) {
        return (x - this.extent().xmin()) / this.cellwidth();
    }

    public final double mapYToGridDouble(double y) {
        return (this.extent().ymax() - y) / this.cellheight();
    }

    public N mapXToGrid(double x) {
        return (N)Integral$.MODULE$.apply(this.evidence$1).fromDouble(GridExtent$.MODULE$.floorWithTolerance(this.mapXToGridDouble(x)));
    }

    public N mapYToGrid(double y) {
        return (N)Integral$.MODULE$.apply(this.evidence$1).fromDouble(GridExtent$.MODULE$.floorWithTolerance(this.mapYToGridDouble(y)));
    }

    public Tuple2<N, N> mapToGrid(double x, double y) {
        Object col = Integral$.MODULE$.apply(this.evidence$1).fromDouble(GridExtent$.MODULE$.floorWithTolerance((x - this.extent().xmin()) / this.cellwidth()));
        Object row = Integral$.MODULE$.apply(this.evidence$1).fromDouble(GridExtent$.MODULE$.floorWithTolerance((this.extent().ymax() - y) / this.cellheight()));
        return new Tuple2(col, row);
    }

    public Tuple2<N, N> mapToGrid(Tuple2<Object, Object> mapCoord) {
        return this.mapToGrid(mapCoord._1$mcD$sp(), mapCoord._2$mcD$sp());
    }

    public Tuple2<N, N> mapToGrid(Point p) {
        return this.mapToGrid(geotrellis.vector.package$.MODULE$.withExtraPointMethods(p).x(), geotrellis.vector.package$.MODULE$.withExtraPointMethods(p).y());
    }

    public Tuple2<Object, Object> gridToMap(N col, N row) {
        return new Tuple2.mcDD.sp(this.gridColToMap(col), this.gridRowToMap(row));
    }

    public double gridColToMap(N col) {
        return this.evidence$1.toDouble(col) * this.cellwidth() + this.extent().xmin() + this.cellwidth() / (double)2;
    }

    public double gridRowToMap(N row) {
        return this.extent().ymax() - this.evidence$1.toDouble(row) * this.cellheight() - this.cellheight() / (double)2;
    }

    public GridExtent<N> withResolution(double targetCellWidth, double targetCellHeight) {
        long newCols = package$.MODULE$.round((this.extent().xmax() - this.extent().xmin()) / targetCellWidth);
        long newRows = package$.MODULE$.round((this.extent().ymax() - this.extent().ymin()) / targetCellHeight);
        return new GridExtent<Object>(this.extent(), targetCellWidth, targetCellHeight, Integral$.MODULE$.apply(this.evidence$1).fromLong(newCols), Integral$.MODULE$.apply(this.evidence$1).fromLong(newRows), this.evidence$1);
    }

    public GridExtent<N> withResolution(CellSize cellSize) {
        return this.withResolution(cellSize.width(), cellSize.height());
    }

    public GridExtent<N> withDimensions(N targetCols, N targetRows) {
        return new GridExtent<N>(this.extent(), targetCols, targetRows, this.evidence$1);
    }

    public GridBounds<N> gridBoundsFor(Extent subExtent, boolean clamp) {
        double colMaxDouble;
        N colMin = this.mapXToGrid(subExtent.xmin());
        N rowMin = this.mapYToGrid(subExtent.ymax());
        Object colMax = Integral$.MODULE$.apply(this.evidence$1).fromLong(package$.MODULE$.abs((colMaxDouble = this.mapXToGridDouble(subExtent.xmax())) - GridExtent$.MODULE$.floorWithTolerance(colMaxDouble)) < 1.0E-7 ? (long)colMaxDouble - 1L : (long)colMaxDouble);
        double rowMaxDouble = this.mapYToGridDouble(subExtent.ymin());
        Object rowMax = Integral$.MODULE$.apply(this.evidence$1).fromLong(package$.MODULE$.abs(rowMaxDouble - GridExtent$.MODULE$.floorWithTolerance(rowMaxDouble)) < 1.0E-7 ? (long)rowMaxDouble - 1L : (long)rowMaxDouble);
        return clamp ? new GridBounds<Object>(this.evidence$1.min(this.evidence$1.max(colMin, this.evidence$1.fromInt(0)), this.evidence$1.minus(this.cols(), this.evidence$1.fromInt(1))), this.evidence$1.min(this.evidence$1.max(rowMin, this.evidence$1.fromInt(0)), this.evidence$1.minus(this.rows(), this.evidence$1.fromInt(1))), this.evidence$1.min(this.evidence$1.max(colMax, this.evidence$1.fromInt(0)), this.evidence$1.minus(this.cols(), this.evidence$1.fromInt(1))), this.evidence$1.min(this.evidence$1.max(rowMax, this.evidence$1.fromInt(0)), this.evidence$1.minus(this.rows(), this.evidence$1.fromInt(1))), this.evidence$1) : new GridBounds<Object>(colMin, rowMin, colMax, rowMax, this.evidence$1);
    }

    public boolean gridBoundsFor$default$2() {
        return true;
    }

    public RasterExtent toRasterExtent() {
        if (this.evidence$1.gt(this.cols(), this.evidence$1.fromInt(Integer.MAX_VALUE))) {
            throw new GeoAttrsError(new StringBuilder(100).append("Cannot convert GridExtent into a RasterExtent: number of columns exceeds maximum integer value (").append(this.cols()).append(" > ").append(Integer.MAX_VALUE).append(")").toString());
        }
        if (this.evidence$1.gt(this.rows(), this.evidence$1.fromInt(Integer.MAX_VALUE))) {
            throw new GeoAttrsError(new StringBuilder(97).append("Cannot convert GridExtent into a RasterExtent: number of rows exceeds maximum integer value (").append(this.rows()).append(" > ").append(Integer.MAX_VALUE).append(")").toString());
        }
        return new RasterExtent(this.extent(), this.cellwidth(), this.cellheight(), this.evidence$1.toInt(this.cols()), this.evidence$1.toInt(this.rows()));
    }

    public GridExtent<N> createAlignedGridExtent(Extent targetExtent) {
        return this.createAlignedGridExtent(targetExtent, this.extent().northWest());
    }

    public GridExtent<N> createAlignedGridExtent(Extent targetExtent, Point alignmentPoint) {
        double xmin = GridExtent.left$1(geotrellis.vector.package$.MODULE$.withExtraPointMethods(alignmentPoint).x(), targetExtent.xmin(), this.cellwidth());
        double xmax = GridExtent.right$1(geotrellis.vector.package$.MODULE$.withExtraPointMethods(alignmentPoint).x(), targetExtent.xmax(), this.cellwidth());
        double ymin = GridExtent.left$1(geotrellis.vector.package$.MODULE$.withExtraPointMethods(alignmentPoint).y(), targetExtent.ymin(), this.cellheight());
        double ymax = GridExtent.right$1(geotrellis.vector.package$.MODULE$.withExtraPointMethods(alignmentPoint).y(), targetExtent.ymax(), this.cellheight());
        Extent alignedExtent = new Extent(xmin, ymin, xmax, ymax);
        long cols = package$.MODULE$.round(alignedExtent.width() / this.cellwidth());
        long rows = package$.MODULE$.round(alignedExtent.height() / this.cellheight());
        Object ncols = Integral$.MODULE$.apply(this.evidence$1).fromDouble((double)cols);
        Object nrows = Integral$.MODULE$.apply(this.evidence$1).fromDouble((double)rows);
        return new GridExtent<Object>(alignedExtent, this.cellwidth(), this.cellheight(), ncols, nrows, this.evidence$1);
    }

    public boolean isGridExtentAligned() {
        return GridExtent.isWhole$1((this.extent().xmax() - this.extent().xmin()) / this.cellwidth()) && GridExtent.isWhole$1((this.extent().ymax() - this.extent().ymin()) / this.cellheight());
    }

    public RasterExtent createAlignedRasterExtent(Extent targetExtent) {
        return this.createAlignedGridExtent(targetExtent).toRasterExtent();
    }

    public GridExtent<N> alignTargetPixels() {
        Extent extent = this.extent();
        CellSize cellSize = this.cellSize();
        if (cellSize == null) {
            throw new MatchError((Object)cellSize);
        }
        double width = cellSize.width();
        double height = cellSize.height();
        Tuple3 tuple32 = new Tuple3((Object)cellSize, (Object)BoxesRunTime.boxToDouble((double)width), (Object)BoxesRunTime.boxToDouble((double)height));
        Tuple3 tuple33 = tuple32;
        CellSize cellSize2 = (CellSize)tuple33._1();
        double width2 = BoxesRunTime.unboxToDouble((Object)tuple33._2());
        double height2 = BoxesRunTime.unboxToDouble((Object)tuple33._3());
        return GridExtent$.MODULE$.apply(new Extent(package$.MODULE$.floor(extent.xmin() / width2) * width2, package$.MODULE$.floor(extent.ymin() / height2) * height2, package$.MODULE$.ceil(extent.xmax() / width2) * width2, package$.MODULE$.ceil(extent.ymax() / height2) * height2), cellSize2, this.evidence$1);
    }

    public Extent extentFor(GridBounds<N> cellBounds, boolean clamp) {
        double xmin = (double)this.evidence$1.toLong(cellBounds.colMin()) * this.cellwidth() + this.extent().xmin();
        double ymax = this.extent().ymax() - (double)this.evidence$1.toLong(cellBounds.rowMin()) * this.cellheight();
        double xmax = xmin + (double)this.evidence$1.toLong(cellBounds.width()) * this.cellwidth();
        double ymin = ymax - (double)this.evidence$1.toLong(cellBounds.height()) * this.cellheight();
        return clamp ? new Extent(package$.MODULE$.max(package$.MODULE$.min(xmin, this.extent().xmax()), this.extent().xmin()), package$.MODULE$.max(package$.MODULE$.min(ymin, this.extent().ymax()), this.extent().ymin()), package$.MODULE$.max(package$.MODULE$.min(xmax, this.extent().xmax()), this.extent().xmin()), package$.MODULE$.max(package$.MODULE$.min(ymax, this.extent().ymax()), this.extent().ymin())) : new Extent(xmin, ymin, xmax, ymax);
    }

    public boolean extentFor$default$2() {
        return true;
    }

    public GridExtent<N> adjustTo(TileLayout tileLayout) {
        long totalCols = (long)tileLayout.tileCols() * (long)tileLayout.layoutCols();
        long totalRows = (long)tileLayout.tileRows() * (long)tileLayout.layoutRows();
        Extent resampledExtent = new Extent(this.extent().xmin(), this.extent().ymax() - this.cellheight() * (double)totalRows, this.extent().xmin() + this.cellwidth() * (double)totalCols, this.extent().ymax());
        return new GridExtent<Object>(resampledExtent, this.cellwidth(), this.cellheight(), Integral$.MODULE$.apply(this.evidence$1).fromLong(totalCols), Integral$.MODULE$.apply(this.evidence$1).fromLong(totalRows), this.evidence$1);
    }

    public boolean canEqual(Object a) {
        return a instanceof GridExtent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof GridExtent)) return false;
        GridExtent gridExtent = (GridExtent)object;
        if (!gridExtent.canEqual(this)) return false;
        Extent extent = gridExtent.extent();
        Extent extent2 = this.extent();
        if (extent == null) {
            if (extent2 != null) {
                return false;
            }
        } else if (!((Object)extent).equals(extent2)) return false;
        CellSize cellSize = gridExtent.cellSize();
        CellSize cellSize2 = this.cellSize();
        if (cellSize == null) {
            if (cellSize2 != null) {
                return false;
            }
        } else if (!((Object)cellSize).equals(cellSize2)) return false;
        if (!BoxesRunTime.equals(gridExtent.cols(), this.cols())) return false;
        if (!BoxesRunTime.equals(gridExtent.rows(), this.rows())) return false;
        return true;
    }

    public int hashCode() {
        return ((31 + (this.extent() == null ? 0 : this.extent().hashCode())) * 31 + (int)this.cellheight()) * 31 + (int)this.cellwidth();
    }

    public <M> GridExtent<M> toGridType(Integral<M> evidence$4) {
        return new GridExtent<Object>(this.extent(), this.cellwidth(), this.cellheight(), Integral$.MODULE$.apply(this.evidence$1).toType(this.cols(), evidence$4), Integral$.MODULE$.apply(this.evidence$1).toType(this.rows(), evidence$4), evidence$4);
    }

    public String toString() {
        return new StringBuilder(17).append("GridExtent(").append(this.extent()).append(", ").append(this.cellSize()).append(", ").append(this.cols()).append("x").append(this.rows()).append(")").toString();
    }

    @Override
    public int cols$mcI$sp() {
        return BoxesRunTime.unboxToInt(this.cols());
    }

    @Override
    public long cols$mcJ$sp() {
        return BoxesRunTime.unboxToLong(this.cols());
    }

    @Override
    public int rows$mcI$sp() {
        return BoxesRunTime.unboxToInt(this.rows());
    }

    @Override
    public long rows$mcJ$sp() {
        return BoxesRunTime.unboxToLong(this.rows());
    }

    public GridExtent<Object> combine$mcI$sp(GridExtent<Object> that) {
        return this.combine(that);
    }

    public GridExtent<Object> combine$mcJ$sp(GridExtent<Object> that) {
        return this.combine(that);
    }

    public int mapXToGrid$mcI$sp(double x) {
        return BoxesRunTime.unboxToInt(this.mapXToGrid(x));
    }

    public long mapXToGrid$mcJ$sp(double x) {
        return BoxesRunTime.unboxToLong(this.mapXToGrid(x));
    }

    public int mapYToGrid$mcI$sp(double y) {
        return BoxesRunTime.unboxToInt(this.mapYToGrid(y));
    }

    public long mapYToGrid$mcJ$sp(double y) {
        return BoxesRunTime.unboxToLong(this.mapYToGrid(y));
    }

    public Tuple2<Object, Object> mapToGrid$mcI$sp(double x, double y) {
        return this.mapToGrid(x, y);
    }

    public Tuple2<Object, Object> mapToGrid$mcJ$sp(double x, double y) {
        return this.mapToGrid(x, y);
    }

    public Tuple2<Object, Object> mapToGrid$mcI$sp(Tuple2<Object, Object> mapCoord) {
        return this.mapToGrid(mapCoord);
    }

    public Tuple2<Object, Object> mapToGrid$mcJ$sp(Tuple2<Object, Object> mapCoord) {
        return this.mapToGrid(mapCoord);
    }

    public Tuple2<Object, Object> mapToGrid$mcI$sp(Point p) {
        return this.mapToGrid(p);
    }

    public Tuple2<Object, Object> mapToGrid$mcJ$sp(Point p) {
        return this.mapToGrid(p);
    }

    public Tuple2<Object, Object> gridToMap$mcI$sp(int col, int row) {
        return this.gridToMap(BoxesRunTime.boxToInteger((int)col), BoxesRunTime.boxToInteger((int)row));
    }

    public Tuple2<Object, Object> gridToMap$mcJ$sp(long col, long row) {
        return this.gridToMap(BoxesRunTime.boxToLong((long)col), BoxesRunTime.boxToLong((long)row));
    }

    public double gridColToMap$mcI$sp(int col) {
        return this.gridColToMap(BoxesRunTime.boxToInteger((int)col));
    }

    public double gridColToMap$mcJ$sp(long col) {
        return this.gridColToMap(BoxesRunTime.boxToLong((long)col));
    }

    public double gridRowToMap$mcI$sp(int row) {
        return this.gridRowToMap(BoxesRunTime.boxToInteger((int)row));
    }

    public double gridRowToMap$mcJ$sp(long row) {
        return this.gridRowToMap(BoxesRunTime.boxToLong((long)row));
    }

    public GridExtent<Object> withResolution$mcI$sp(double targetCellWidth, double targetCellHeight) {
        return this.withResolution(targetCellWidth, targetCellHeight);
    }

    public GridExtent<Object> withResolution$mcJ$sp(double targetCellWidth, double targetCellHeight) {
        return this.withResolution(targetCellWidth, targetCellHeight);
    }

    public GridExtent<Object> withResolution$mcI$sp(CellSize cellSize) {
        return this.withResolution(cellSize);
    }

    public GridExtent<Object> withResolution$mcJ$sp(CellSize cellSize) {
        return this.withResolution(cellSize);
    }

    public GridExtent<Object> withDimensions$mcI$sp(int targetCols, int targetRows) {
        return this.withDimensions(BoxesRunTime.boxToInteger((int)targetCols), BoxesRunTime.boxToInteger((int)targetRows));
    }

    public GridExtent<Object> withDimensions$mcJ$sp(long targetCols, long targetRows) {
        return this.withDimensions(BoxesRunTime.boxToLong((long)targetCols), BoxesRunTime.boxToLong((long)targetRows));
    }

    public GridBounds<Object> gridBoundsFor$mcI$sp(Extent subExtent, boolean clamp) {
        return this.gridBoundsFor(subExtent, clamp);
    }

    public GridBounds<Object> gridBoundsFor$mcJ$sp(Extent subExtent, boolean clamp) {
        return this.gridBoundsFor(subExtent, clamp);
    }

    public GridExtent<Object> createAlignedGridExtent$mcI$sp(Extent targetExtent) {
        return this.createAlignedGridExtent(targetExtent);
    }

    public GridExtent<Object> createAlignedGridExtent$mcJ$sp(Extent targetExtent) {
        return this.createAlignedGridExtent(targetExtent);
    }

    public GridExtent<Object> createAlignedGridExtent$mcI$sp(Extent targetExtent, Point alignmentPoint) {
        return this.createAlignedGridExtent(targetExtent, alignmentPoint);
    }

    public GridExtent<Object> createAlignedGridExtent$mcJ$sp(Extent targetExtent, Point alignmentPoint) {
        return this.createAlignedGridExtent(targetExtent, alignmentPoint);
    }

    public GridExtent<Object> alignTargetPixels$mcI$sp() {
        return this.alignTargetPixels();
    }

    public GridExtent<Object> alignTargetPixels$mcJ$sp() {
        return this.alignTargetPixels();
    }

    public Extent extentFor$mcI$sp(GridBounds<Object> cellBounds, boolean clamp) {
        return this.extentFor(cellBounds, clamp);
    }

    public Extent extentFor$mcJ$sp(GridBounds<Object> cellBounds, boolean clamp) {
        return this.extentFor(cellBounds, clamp);
    }

    public GridExtent<Object> adjustTo$mcI$sp(TileLayout tileLayout) {
        return this.adjustTo(tileLayout);
    }

    public GridExtent<Object> adjustTo$mcJ$sp(TileLayout tileLayout) {
        return this.adjustTo(tileLayout);
    }

    public boolean specInstance$() {
        return false;
    }

    private static final double left$1(double reference, double actual, double unit) {
        return reference + package$.MODULE$.floor((actual - reference) / unit) * unit;
    }

    private static final double right$1(double reference, double actual, double unit) {
        return reference + package$.MODULE$.ceil((actual - reference) / unit) * unit;
    }

    private static final boolean isWhole$1(double x) {
        return package$.MODULE$.abs((double)package$.MODULE$.round(x) - x) < Constants$.MODULE$.FLOAT_EPSILON();
    }

    public GridExtent(Extent extent, double cellwidth, double cellheight, N cols, N rows, Integral<N> evidence$1) {
        this.extent = extent;
        this.cellwidth = cellwidth;
        this.cellheight = cellheight;
        this.cols = cols;
        this.rows = rows;
        this.evidence$1 = evidence$1;
        super(evidence$1);
        if (!this.specInstance$()) {
            if (this.evidence$1.lteqv(this.cols(), this.evidence$1.fromInt(0))) {
                throw new GeoAttrsError(new StringBuilder(14).append("invalid cols: ").append(this.cols()).toString());
            }
            if (this.evidence$1.lteqv(this.rows(), this.evidence$1.fromInt(0))) {
                throw new GeoAttrsError(new StringBuilder(14).append("invalid rows: ").append(this.rows()).toString());
            }
            Predef$.MODULE$.require(BoxesRunTime.equals(this.cols(), (Object)Integral$.MODULE$.apply(this.evidence$1).fromDouble((double)package$.MODULE$.round(extent.width() / cellwidth))) && BoxesRunTime.equals(this.rows(), (Object)Integral$.MODULE$.apply(this.evidence$1).fromDouble((double)package$.MODULE$.round(extent.height() / cellheight))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append(this.extent()).append(" at ").append(this.cellSize()).append(" does not match ").append(this.dimensions()).toString());
        }
    }

    public GridExtent(Extent extent, N cols, N rows, Integral<N> evidence$2) {
        this(extent, extent.width() / evidence$2.toDouble(cols), extent.height() / evidence$2.toDouble(rows), cols, rows, evidence$2);
    }

    public GridExtent(Extent extent, CellSize cellSize, Integral<N> evidence$3) {
        this(extent, cellSize.width(), cellSize.height(), Integral$.MODULE$.apply(evidence$3).fromDouble((double)package$.MODULE$.round(extent.width() / cellSize.width())), Integral$.MODULE$.apply(evidence$3).fromDouble((double)package$.MODULE$.round(extent.height() / cellSize.height())), evidence$3);
    }

    public static class gridExtentMethods<N> {
        private final GridExtent<N> self;
        private final Integral<N> evidence$8;

        public GridExtent<N> reproject(CRS src, CRS dest, Reproject.Options options) {
            GridExtent gridExtent;
            CRS cRS = src;
            CRS cRS2 = dest;
            if (!(cRS != null ? !((Object)cRS).equals(cRS2) : cRS2 != null)) {
                gridExtent = this.self;
            } else {
                Function2<Object, Object, Tuple2<Object, Object>> transform = Transform$.MODULE$.apply(src, dest);
                gridExtent = (GridExtent)options.targetRasterExtent().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toGridType($this.evidence$8)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ReprojectRasterExtent$.MODULE$.apply($this.self, transform, options, $this.evidence$8));
            }
            return gridExtent;
        }

        public GridExtent<N> reproject(CRS src, CRS dest) {
            return this.reproject(src, dest, Reproject$Options$.MODULE$.DEFAULT());
        }

        public gridExtentMethods(GridExtent<N> self, Integral<N> evidence$8) {
            this.self = self;
            this.evidence$8 = evidence$8;
        }
    }
}

