/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.compression;

import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.compression.FloatingPointPredictor$;
import geotrellis.raster.io.geotiff.compression.Predictor;
import geotrellis.raster.io.geotiff.compression.Predictor$;
import geotrellis.raster.io.geotiff.tags.TiffTags;
import scala.Array$;
import scala.Function1;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y;Qa\u0004\t\t\u0002m1Q!\b\t\t\u0002yAQ!J\u0001\u0005\u0002\u0019BQaJ\u0001\u0005\u0002!2A!H\u0001\u0005i!AQ\u0007\u0002B\u0001B\u0003%a\u0007\u0003\u0005:\t\t\u0005\t\u0015!\u0003;\u0011!iDA!A!\u0002\u0013q\u0004\u0002\u0003\"\u0005\u0005\u0003\u0005\u000b\u0011\u0002\u001c\t\u000b\u0015\"A\u0011A\"\t\u000f)#!\u0019!C\u0001\u0017\"1A\n\u0002Q\u0001\nYBq!\u0014\u0003C\u0002\u0013\u0005a\n\u0003\u0004S\t\u0001\u0006Ia\u0014\u0005\u0006O\u0011!\taU\u0001\u0017\r2|\u0017\r^5oOB{\u0017N\u001c;Qe\u0016$\u0017n\u0019;pe*\u0011\u0011CE\u0001\fG>l\u0007O]3tg&|gN\u0003\u0002\u0014)\u00059q-Z8uS\u001a4'BA\u000b\u0017\u0003\tIwN\u0003\u0002\u00181\u00051!/Y:uKJT\u0011!G\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001\u0001\t\u00039\u0005i\u0011\u0001\u0005\u0002\u0017\r2|\u0017\r^5oOB{\u0017N\u001c;Qe\u0016$\u0017n\u0019;peN\u0011\u0011a\b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Y\u0012!B1qa2LHCA\u0015-!\ta\"&\u0003\u0002,!\tI\u0001K]3eS\u000e$xN\u001d\u0005\u0006[\r\u0001\rAL\u0001\ti&4g\rV1hgB\u0011qFM\u0007\u0002a)\u0011\u0011GE\u0001\u0005i\u0006<7/\u0003\u00024a\tAA+\u001b4g)\u0006<7oE\u0002\u0005?%\n!bY8mgB+'OU8x!\t\u0001s'\u0003\u00029C\t\u0019\u0011J\u001c;\u0002\u001bI|wo]%o'\u0016<W.\u001a8u!\u0011\u00013H\u000e\u001c\n\u0005q\n#!\u0003$v]\u000e$\u0018n\u001c82\u0003!\u0011\u0017M\u001c3UsB,\u0007CA A\u001b\u0005\u0011\u0012BA!\u0013\u0005!\u0011\u0015M\u001c3UsB,\u0017!\u00032b]\u0012\u001cu.\u001e8u)\u0015!ei\u0012%J!\t)E!D\u0001\u0002\u0011\u0015)\u0014\u00021\u00017\u0011\u0015I\u0014\u00021\u0001;\u0011\u0015i\u0014\u00021\u0001?\u0011\u0015\u0011\u0015\u00021\u00017\u0003\u0011\u0019w\u000eZ3\u0016\u0003Y\nQaY8eK\u0002\n1b\u00195fG.,e\u000eZ5b]V\tq\n\u0005\u0002!!&\u0011\u0011+\t\u0002\b\u0005>|G.Z1o\u00031\u0019\u0007.Z2l\u000b:$\u0017.\u00198!)\r!&\f\u0018\t\u0004AU;\u0016B\u0001,\"\u0005\u0015\t%O]1z!\t\u0001\u0003,\u0003\u0002ZC\t!!)\u001f;f\u0011\u0015Yf\u00021\u0001U\u0003\u0015\u0011\u0017\u0010^3t\u0011\u0015if\u00021\u00017\u00031\u0019XmZ7f]RLe\u000eZ3y\u0001")
public final class FloatingPointPredictor {
    public static Predictor apply(TiffTags tiffTags) {
        return FloatingPointPredictor$.MODULE$.apply(tiffTags);
    }

    private static class FloatingPointPredictor
    implements Predictor {
        private final int colsPerRow;
        private final Function1<Object, Object> rowsInSegment;
        private final BandType bandType;
        private final int bandCount;
        private final int code;
        private final boolean checkEndian;

        @Override
        public int code() {
            return this.code;
        }

        @Override
        public boolean checkEndian() {
            return this.checkEndian;
        }

        @Override
        public byte[] apply(byte[] bytes, int segmentIndex) {
            int rows = this.rowsInSegment.apply$mcII$sp(segmentIndex);
            int stride = this.bandCount;
            int bytesPerSample = this.bandType.bytesPerSample();
            int colValuesPerRow = this.colsPerRow * this.bandCount;
            int bytesPerRow = colValuesPerRow * bytesPerSample;
            for (int index$macro$4 = 0; index$macro$4 < rows; ++index$macro$4) {
                int rowByteIndex = index$macro$4 * bytesPerRow;
                int limit = (index$macro$4 + 1) * bytesPerRow;
                for (int index$macro$1 = rowByteIndex + this.bandCount; index$macro$1 < limit; ++index$macro$1) {
                    bytes[index$macro$1] = (byte)(bytes[index$macro$1] + bytes[index$macro$1 - this.bandCount]);
                }
                byte[] tmp = (byte[])Array$.MODULE$.ofDim(bytesPerRow, ClassTag$.MODULE$.Byte());
                System.arraycopy(bytes, rowByteIndex, tmp, 0, bytesPerRow);
                for (int index$macro$3 = 0; index$macro$3 < this.colsPerRow * this.bandCount; ++index$macro$3) {
                    for (int index$macro$2 = 0; index$macro$2 < bytesPerSample; ++index$macro$2) {
                        bytes[rowByteIndex + (bytesPerSample * index$macro$3 + index$macro$2)] = tmp[index$macro$2 * this.colsPerRow + index$macro$3];
                    }
                }
            }
            return bytes;
        }

        public FloatingPointPredictor(int colsPerRow, Function1<Object, Object> rowsInSegment, BandType bandType, int bandCount) {
            this.colsPerRow = colsPerRow;
            this.rowsInSegment = rowsInSegment;
            this.bandType = bandType;
            this.bandCount = bandCount;
            this.code = Predictor$.MODULE$.PREDICTOR_FLOATINGPOINT();
            this.checkEndian = false;
        }
    }
}

