/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.vector.interpolation;

import geotrellis.vector.Feature;
import geotrellis.vector.Feature$;
import geotrellis.vector.interpolation.Semivariogram;
import geotrellis.vector.package$;
import java.io.Serializable;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.locationtech.jts.geom.Point;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.mutable.PriorityQueue;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-aaB\u0006\r!\u0003\r\ta\u0005\u0005\u0006M\u0001!\ta\n\u0005\u0006W\u0001!I\u0001\f\u0005\u0006\u007f\u0001!\t\u0002\u0011\u0005\u0006;\u0002!\tB\u0018\u0005\u0006W\u0002!\t\u0002\u001c\u0005\u0006a\u0002!I!\u001d\u0005\u0006i\u00021\t\"\u001e\u0005\to\u0002A)\u0019!C\u0005q\")\u0011\u0010\u0001C\u0001u\"1q\u0010\u0001C\u0001\u0003\u0003\u0011qa\u0013:jO&twM\u0003\u0002\u000e\u001d\u0005i\u0011N\u001c;feB|G.\u0019;j_:T!a\u0004\t\u0002\rY,7\r^8s\u0015\u0005\t\u0012AC4f_R\u0014X\r\u001c7jg\u000e\u00011\u0003\u0002\u0001\u00155\r\u0002\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007#B\u000b\u001c;u\u0001\u0013B\u0001\u000f\u0017\u0005%1UO\\2uS>t'\u0007\u0005\u0002\u0016=%\u0011qD\u0006\u0002\u0007\t>,(\r\\3\u0011\tU\tS$H\u0005\u0003EY\u0011a\u0001V;qY\u0016\u0014\u0004CA\u000b%\u0013\t)cC\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004%S:LG\u000f\n\u000b\u0002QA\u0011Q#K\u0005\u0003UY\u0011A!\u00168ji\u0006AA-[:uC:\u001cW\rF\u0002\u001e[uBQA\f\u0002A\u0002=\n!\u0001]\u0019\u0011\u0005ARdBA\u00199\u001d\t\u0011tG\u0004\u00024m5\tAG\u0003\u00026%\u00051AH]8pizJ\u0011!E\u0005\u0003\u001fAI!!\u000f\b\u0002\u000fA\f7m[1hK&\u00111\b\u0010\u0002\u0006!>Lg\u000e\u001e\u0006\u0003s9AQA\u0010\u0002A\u0002=\n!\u0001\u001d\u001a\u0002#Y\f'/[1oG\u0016l\u0015\r\u001e:jq\u001e+g\u000eF\u0002B\u001fV\u0003\"AQ'\u000e\u0003\rS!\u0001R#\u0002\r1Lg.Z1s\u0015\t1u)A\u0003nCRD7G\u0003\u0002I\u0013\u000691m\\7n_:\u001c(B\u0001&L\u0003\u0019\t\u0007/Y2iK*\tA*A\u0002pe\u001eL!AT\"\u0003\u0015I+\u0017\r\\'biJL\u0007\u0010C\u0003Q\u0007\u0001\u0007\u0011+\u0001\u0002tmB\u0011!kU\u0007\u0002\u0019%\u0011A\u000b\u0004\u0002\u000e'\u0016l\u0017N^1sS><'/Y7\t\u000bY\u001b\u0001\u0019A,\u0002\rA|\u0017N\u001c;t!\r)\u0002LW\u0005\u00033Z\u0011Q!\u0011:sCf\u00042\u0001M.\u001e\u0013\taFH\u0001\u0007Q_&tGOR3biV\u0014X-A\fhKR\u0004v.\u001b8u\t&\u001cH/\u00198dKN\u001cvN\u001d;fIR)q\fZ3hSB\u0019Q\u0003\u00171\u0011\tU\t\u0013-\b\t\u0003+\tL!a\u0019\f\u0003\u0007%sG\u000fC\u0003W\t\u0001\u0007q\u000bC\u0003g\t\u0001\u0007\u0011-A\u0005nS:\u0004v.\u001b8ug\")\u0001\u000e\u0002a\u0001;\u0005I!-\u00198eo&$G\u000f\u001b\u0005\u0006U\u0012\u0001\raL\u0001\u0006a>Lg\u000e^\u0001\tC\n\u001c\u0018I\u001d:bsR\u0011QN\u001c\t\u0004+ak\u0002\"B8\u0006\u0001\u0004i\u0017aA1se\u0006y1M]3bi\u0016\u0004&/\u001a3jGR|'\u000f\u0006\u0002\u001be\")1O\u0002a\u0001C\u0006qa.^7cKJ|e\rU8j]R\u001c\u0018aE2sK\u0006$X\r\u0015:fI&\u001cGo\u001c:J]&$HC\u0001\u000ew\u0011\u0015\u0019x\u00011\u0001b\u0003\u0019y\u0016\r\u001d9msV\t!$A\u0003baBd\u0017\u0010F\u0002!wvDQ\u0001`\u0005A\u0002u\t\u0011\u0001\u001f\u0005\u0006}&\u0001\r!H\u0001\u0002s\u00069\u0001O]3eS\u000e$H\u0003BA\u0002\u0003\u000b\u00012!\u0006-!\u0011\u001d\t9A\u0003a\u0001\u0003\u0013\t1\u0002]8j]Rl\u0015\r\u001e:jqB\u0019Q\u0003W\u0018")
public interface Kriging
extends Function2<Object, Object, Tuple2<Object, Object>>,
scala.Serializable {
    private double distance(Point p1, Point p2) {
        return scala.math.package$.MODULE$.abs(scala.math.package$.MODULE$.sqrt(scala.math.package$.MODULE$.pow(package$.MODULE$.withExtraPointMethods(p1).x() - package$.MODULE$.withExtraPointMethods(p2).x(), 2.0) + scala.math.package$.MODULE$.pow(package$.MODULE$.withExtraPointMethods(p1).y() - package$.MODULE$.withExtraPointMethods(p2).y(), 2.0)));
    }

    public static /* synthetic */ RealMatrix varianceMatrixGen$(Kriging $this, Semivariogram sv, Feature[] points) {
        return $this.varianceMatrixGen(sv, points);
    }

    default public RealMatrix varianceMatrixGen(Semivariogram sv, Feature<Point, Object>[] points) {
        int n = points.length;
        RealMatrix varianceMatrix = MatrixUtils.createRealMatrix((int)n, (int)n);
        for (int index$macro$2 = 0; index$macro$2 < n; ++index$macro$2) {
            varianceMatrix.setEntry(index$macro$2, index$macro$2, sv.nugget());
            for (int index$macro$1 = index$macro$2 + 1; index$macro$1 < n; ++index$macro$1) {
                double dx = package$.MODULE$.withExtraPointMethods(points[index$macro$2].geom()).x() - package$.MODULE$.withExtraPointMethods(points[index$macro$1].geom()).x();
                double dy = package$.MODULE$.withExtraPointMethods(points[index$macro$2].geom()).y() - package$.MODULE$.withExtraPointMethods(points[index$macro$1].geom()).y();
                double varVal = sv.apply(scala.math.package$.MODULE$.min(scala.math.package$.MODULE$.sqrt(dx * dx + dy * dy), sv.range()));
                varianceMatrix.setEntry(index$macro$2, index$macro$1, varVal);
                varianceMatrix.setEntry(index$macro$1, index$macro$2, varVal);
            }
        }
        return varianceMatrix;
    }

    public static /* synthetic */ Tuple2[] getPointDistancesSorted$(Kriging $this, Feature[] points, int minPoints, double bandwidth, Point point) {
        return $this.getPointDistancesSorted(points, minPoints, bandwidth, point);
    }

    default public Tuple2<Object, Object>[] getPointDistancesSorted(Feature<Point, Object>[] points, int minPoints, double bandwidth, Point point) {
        PriorityQueue distances = new PriorityQueue(scala.package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)Kriging.$anonfun$getPointDistancesSorted$1(x$5)), (Ordering)Ordering.Double$.MODULE$));
        for (int index$macro$1 = 0; index$macro$1 < points.length; ++index$macro$1) {
            double dVal = this.distance(Feature$.MODULE$.featureToGeometry(points[index$macro$1]), point);
            distances.$plus$eq((Object)new Tuple2.mcID.sp(index$macro$1, dVal));
        }
        IndexedSeq q = (IndexedSeq)distances.dequeueAll(Predef$.MODULE$.fallbackStringCanBuildFrom());
        Tuple2[] result = (Tuple2[])((TraversableOnce)q.takeWhile((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)Kriging.$anonfun$getPointDistancesSorted$2(bandwidth, x$8)))).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        return result.length < minPoints ? (Tuple2[])((TraversableOnce)q.take(minPoints)).toArray(ClassTag$.MODULE$.apply(Tuple2.class)) : result;
    }

    public static /* synthetic */ double[] absArray$(Kriging $this, double[] arr) {
        return $this.absArray(arr);
    }

    default public double[] absArray(double[] arr) {
        for (int index$macro$1 = 0; index$macro$1 < arr.length; ++index$macro$1) {
            arr[index$macro$1] = scala.math.package$.MODULE$.abs(arr[index$macro$1]);
        }
        return arr;
    }

    private Function2<Object, Object, Tuple2<Object, Object>> createPredictor(int numberOfPoints) {
        return this.createPredictorInit(numberOfPoints);
    }

    public Function2<Object, Object, Tuple2<Object, Object>> createPredictorInit(int var1);

    public static /* synthetic */ Function2 geotrellis$vector$interpolation$Kriging$$_apply$(Kriging $this) {
        return $this.geotrellis$vector$interpolation$Kriging$$_apply();
    }

    default public Function2<Object, Object, Tuple2<Object, Object>> geotrellis$vector$interpolation$Kriging$$_apply() {
        return this.createPredictor(1);
    }

    public static /* synthetic */ Tuple2 apply$(Kriging $this, double x, double y) {
        return $this.apply(x, y);
    }

    default public Tuple2<Object, Object> apply(double x, double y) {
        return (Tuple2)this.geotrellis$vector$interpolation$Kriging$$_apply().apply((Object)BoxesRunTime.boxToDouble((double)x), (Object)BoxesRunTime.boxToDouble((double)y));
    }

    public static /* synthetic */ Tuple2[] predict$(Kriging $this, Point[] pointMatrix) {
        return $this.predict(pointMatrix);
    }

    /*
     * WARNING - void declaration
     */
    default public Tuple2<Object, Object>[] predict(Point[] pointMatrix) {
        void var2_2;
        Tuple2[] krigingPrediction = (Tuple2[])Array$.MODULE$.ofDim(pointMatrix.length, ClassTag$.MODULE$.apply(Tuple2.class));
        Function2<Object, Object, Tuple2<Object, Object>> predictor = this.createPredictor(pointMatrix.length);
        for (int index$macro$1 = 0; index$macro$1 < pointMatrix.length; ++index$macro$1) {
            Point pointPredict = pointMatrix[index$macro$1];
            krigingPrediction[index$macro$1] = (Tuple2)predictor.apply((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.withExtraPointMethods(pointPredict).x()), (Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.withExtraPointMethods(pointPredict).y()));
        }
        return var2_2;
    }

    public static /* synthetic */ double $anonfun$getPointDistancesSorted$1(Tuple2 x$5) {
        return (double)-1 * x$5._2$mcD$sp();
    }

    public static /* synthetic */ boolean $anonfun$getPointDistancesSorted$2(double bandwidth$1, Tuple2 x$8) {
        return x$8._2$mcD$sp() <= bandwidth$1;
    }

    public static void $init$(Kriging $this) {
    }
}

