/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.set;

import java.util.Comparator;
import java.util.SortedSet;
import org.apache.commons.collections.collection.SynchronizedCollection;

public class SynchronizedSortedSet
extends SynchronizedCollection
implements SortedSet {
    private static final long serialVersionUID = 2775582861954500111L;

    public static SortedSet decorate(SortedSet set2) {
        return new SynchronizedSortedSet(set2);
    }

    protected SynchronizedSortedSet(SortedSet set2) {
        super(set2);
    }

    protected SynchronizedSortedSet(SortedSet set2, Object lock) {
        super(set2, lock);
    }

    protected SortedSet getSortedSet() {
        return (SortedSet)this.collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet subSet(Object fromElement, Object toElement) {
        Object object = this.lock;
        synchronized (object) {
            SortedSet<Object> set2 = this.getSortedSet().subSet(fromElement, toElement);
            return new SynchronizedSortedSet(set2, this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet headSet(Object toElement) {
        Object object = this.lock;
        synchronized (object) {
            SortedSet<Object> set2 = this.getSortedSet().headSet(toElement);
            return new SynchronizedSortedSet(set2, this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet tailSet(Object fromElement) {
        Object object = this.lock;
        synchronized (object) {
            SortedSet<Object> set2 = this.getSortedSet().tailSet(fromElement);
            return new SynchronizedSortedSet(set2, this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object first() {
        Object object = this.lock;
        synchronized (object) {
            return this.getSortedSet().first();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object last() {
        Object object = this.lock;
        synchronized (object) {
            return this.getSortedSet().last();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Comparator comparator() {
        Object object = this.lock;
        synchronized (object) {
            return this.getSortedSet().comparator();
        }
    }
}

