/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import squants.Dimension;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.electro.Amperes$;
import squants.electro.AmperesPerMeter$;
import squants.electro.AmperesPerSquareMeter$;
import squants.electro.Coulombs$;
import squants.electro.ElectricCharge;
import squants.electro.ElectricCurrent$;
import squants.electro.ElectricCurrentDensity;
import squants.electro.ElectricCurrentUnit;
import squants.electro.ElectricPotential;
import squants.electro.ElectricalConductance;
import squants.electro.ElectricalResistance;
import squants.electro.Inductance;
import squants.electro.MagneticFieldStrength;
import squants.electro.MagneticFlux;
import squants.electro.Milliamperes$;
import squants.electro.Siemens$;
import squants.electro.Volts$;
import squants.electro.Webers$;
import squants.energy.Power;
import squants.energy.Watts$;
import squants.space.Area;
import squants.space.Length;
import squants.time.Frequency;
import squants.time.Seconds$;
import squants.time.Time;
import squants.time.TimeDerivative;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001\u0002\u000f\u001e\u0005\tB\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\tu\u0001\u0011\t\u0011)A\u0005i!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003>\u0011\u0015\t\u0005\u0001\"\u0003C\u0011\u0015)\u0005\u0001\"\u0001G\u0011!\t9\u0005\u0001C\t?\u0005%\u0003b\u0002\u0017\u0001\t#y\u00121\n\u0005\b\u0003'\u0002A\u0011AA+\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003OBq!a\u0015\u0001\t\u0003\tY\bC\u0004\u0002\f\u0002!\t!!$\t\u000f\u0005-\u0005\u0001\"\u0001\u0002\u0018\"9\u00111\u0012\u0001\u0005\u0002\u0005\u001d\u0006BBA\\\u0001\u0011\u00051\u0007\u0003\u0004\u0002:\u0002!\taM\u0004\u0006\u0011vA\t!\u0013\u0004\u00069uA\tA\u0013\u0005\u0006\u0003J!\ta\u0016\u0005\u00071J!\t!H-\t\u000ba\u0013B\u0011\u0001=\t\u000f\u0005\u0005!\u0003\"\u0001\u0002\u0004!9\u0011Q\u0003\n\u0005\u0002\u0005]\u0001bBA\u0010%\u0011\u0005\u0011q\u0003\u0005\b\u0003C\u0011B\u0011AA\u0012\u0011\u001d\tYD\u0005C\u0001\u0003\u0007A\u0011\"!\u0010\u0013\u0003\u0003%I!a\u0010\u0003\u001f\u0015cWm\u0019;sS\u000e\u001cUO\u001d:f]RT!AH\u0010\u0002\u000f\u0015dWm\u0019;s_*\t\u0001%A\u0004tcV\fg\u000e^:\u0004\u0001M\u0019\u0001aI\u0015\u0011\u0007\u0011*s%D\u0001 \u0013\t1sD\u0001\u0005Rk\u0006tG/\u001b;z!\tA\u0003!D\u0001\u001e!\rQSfL\u0007\u0002W)\u0011AfH\u0001\u0005i&lW-\u0003\u0002/W\tqA+[7f\t\u0016\u0014\u0018N^1uSZ,\u0007C\u0001\u00151\u0013\t\tTD\u0001\bFY\u0016\u001cGO]5d\u0007\"\f'oZ3\u0002\u000bY\fG.^3\u0016\u0003Q\u0002\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012a\u0001R8vE2,\u0017A\u0002<bYV,\u0007%\u0001\u0003v]&$X#A\u001f\u0011\u0005!r\u0014BA \u001e\u0005M)E.Z2ue&\u001c7)\u001e:sK:$XK\\5u\u0003\u0015)h.\u001b;!\u0003\u0019a\u0014N\\5u}Q\u0019qe\u0011#\t\u000bI*\u0001\u0019\u0001\u001b\t\u000bm*\u0001\u0019A\u001f\u0002\u0013\u0011LW.\u001a8tS>tW#A$\u000f\u0005!\n\u0012aD#mK\u000e$(/[2DkJ\u0014XM\u001c;\u0011\u0005!\u00122#\u0002\nL\u001dF#\u0006CA\u001bM\u0013\tieG\u0001\u0004B]f\u0014VM\u001a\t\u0004I=;\u0013B\u0001) \u0005%!\u0015.\\3og&|g\u000e\u0005\u0002%%&\u00111k\b\u0002\u000e\u0005\u0006\u001cX\rR5nK:\u001c\u0018n\u001c8\u0011\u0005U*\u0016B\u0001,7\u00051\u0019VM]5bY&T\u0018M\u00197f)\u0005I\u0015!B1qa2LXC\u0001.m)\rYVo\u001e\u000b\u0003OqCQ!\u0018\u000bA\u0004y\u000b1A\\;n!\ryvM\u001b\b\u0003A\u0016t!!\u00193\u000e\u0003\tT!aY\u0011\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0014B\u000147\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001[5\u0003\u000f9+X.\u001a:jG*\u0011aM\u000e\t\u0003W2d\u0001\u0001B\u0003n)\t\u0007aNA\u0001B#\ty'\u000f\u0005\u00026a&\u0011\u0011O\u000e\u0002\b\u001d>$\b.\u001b8h!\t)4/\u0003\u0002um\t\u0019\u0011I\\=\t\u000bY$\u0002\u0019\u00016\u0002\u00039DQa\u000f\u000bA\u0002u\"\"!_@\u0011\u0007ilx%D\u0001|\u0015\tah'\u0001\u0003vi&d\u0017B\u0001@|\u0005\r!&/\u001f\u0005\u0006eU\u0001\rA]\u0001\u0005]\u0006lW-\u0006\u0002\u0002\u0006A!\u0011qAA\t\u001b\t\tIA\u0003\u0003\u0002\f\u00055\u0011\u0001\u00027b]\u001eT!!a\u0004\u0002\t)\fg/Y\u0005\u0005\u0003'\tIA\u0001\u0004TiJLgnZ\u0001\faJLW.\u0019:z+:LG/\u0006\u0002\u0002\u001a9\u0019\u0001&a\u0007\n\u0007\u0005uQ$A\u0004B[B,'/Z:\u0002\rMLWK\\5u\u0003\u0015)h.\u001b;t+\t\t)\u0003\u0005\u0004\u0002(\u0005E\u0012QG\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003_1\u0014AC2pY2,7\r^5p]&!\u00111GA\u0015\u0005\r\u0019V\r\u001e\t\u0005I\u0005]r%C\u0002\u0002:}\u0011Q\"\u00168ji>3W*Z1tkJ,\u0017a\u00043j[\u0016t7/[8o'fl'm\u001c7\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u0003\u0002B!a\u0002\u0002D%!\u0011QIA\u0005\u0005\u0019y%M[3di\u0006qA/[7f\u0013:$Xm\u001a:bi\u0016$W#A\u0018\u0016\u0005\u00055\u0003c\u0001\u0016\u0002P%\u0019\u0011\u0011K\u0016\u0003\tQKW.Z\u0001\u0007IQLW.Z:\u0015\t\u0005]\u0013Q\f\t\u0004Q\u0005e\u0013bAA.;\t\tR\t\\3diJL7\rU8uK:$\u0018.\u00197\t\u000f\u0005}\u0013\u00021\u0001\u0002b\u0005!A\u000f[1u!\rA\u00131M\u0005\u0004\u0003Kj\"\u0001F#mK\u000e$(/[2bYJ+7/[:uC:\u001cW\r\u0006\u0003\u0002j\u0005e\u0004\u0003BA6\u0003grA!!\u001c\u0002r9\u0019\u0011-a\u001c\n\u0003\u0001J!AZ\u0010\n\t\u0005U\u0014q\u000f\u0002\u0006!><XM\u001d\u0006\u0003M~Aq!a\u0018\u000b\u0001\u0004\t9\u0006\u0006\u0003\u0002~\u0005\r\u0005c\u0001\u0015\u0002\u0000%\u0019\u0011\u0011Q\u000f\u0003\u00195\u000bwM\\3uS\u000e4E.\u001e=\t\u000f\u0005}3\u00021\u0001\u0002\u0006B\u0019\u0001&a\"\n\u0007\u0005%UD\u0001\u0006J]\u0012,8\r^1oG\u0016\fA\u0001\n3jmR!\u0011qRAK!\rA\u0013\u0011S\u0005\u0004\u0003'k\"!F#mK\u000e$(/[2bY\u000e{g\u000eZ;di\u0006t7-\u001a\u0005\b\u0003?b\u0001\u0019AA,)\u0011\tI*a(\u0011\u0007!\nY*C\u0002\u0002\u001ev\u0011Q#T1h]\u0016$\u0018n\u0019$jK2$7\u000b\u001e:f]\u001e$\b\u000eC\u0004\u0002`5\u0001\r!!)\u0011\t\u0005-\u00141U\u0005\u0005\u0003K\u000b9H\u0001\u0004MK:<G\u000f\u001b\u000b\u0005\u0003S\u000by\u000bE\u0002)\u0003WK1!!,\u001e\u0005Y)E.Z2ue&\u001c7)\u001e:sK:$H)\u001a8tSRL\bbBA0\u001d\u0001\u0007\u0011\u0011\u0017\t\u0005\u0003W\n\u0019,\u0003\u0003\u00026\u0006]$\u0001B!sK\u0006\f\u0011\u0002^8B[B,'/Z:\u0002\u001dQ|W*\u001b7mS\u0006l\u0007/\u001a:fg\u0002")
public final class ElectricCurrent
extends Quantity<ElectricCurrent>
implements TimeDerivative<ElectricCharge> {
    private final double value;
    private final ElectricCurrentUnit unit;

    public static String dimensionSymbol() {
        return ElectricCurrent$.MODULE$.dimensionSymbol();
    }

    public static Set<UnitOfMeasure<ElectricCurrent>> units() {
        return ElectricCurrent$.MODULE$.units();
    }

    public static Amperes$ siUnit() {
        return ElectricCurrent$.MODULE$.siUnit();
    }

    public static Amperes$ primaryUnit() {
        return ElectricCurrent$.MODULE$.primaryUnit();
    }

    public static String name() {
        return ElectricCurrent$.MODULE$.name();
    }

    public static Try<ElectricCurrent> apply(Object object) {
        return ElectricCurrent$.MODULE$.apply(object);
    }

    public static Dimension<ElectricCurrent> dimensionImplicit() {
        return ElectricCurrent$.MODULE$.dimensionImplicit();
    }

    public static <N> Try<ElectricCurrent> parseTuple(Tuple2<N, String> tuple22, Numeric<N> numeric) {
        return ElectricCurrent$.MODULE$.parseTuple(tuple22, numeric);
    }

    public static Try<ElectricCurrent> parseString(String string2) {
        return ElectricCurrent$.MODULE$.parseString(string2);
    }

    public static Option<UnitOfMeasure<ElectricCurrent>> symbolToUnit(String string2) {
        return ElectricCurrent$.MODULE$.symbolToUnit(string2);
    }

    @Override
    public Quantity $times(Time that) {
        return TimeDerivative.$times$(this, that);
    }

    @Override
    public Frequency $div(Quantity that) {
        return TimeDerivative.$div$(this, that);
    }

    @Override
    public double value() {
        return this.value;
    }

    public ElectricCurrentUnit unit() {
        return this.unit;
    }

    public ElectricCurrent$ dimension() {
        return ElectricCurrent$.MODULE$;
    }

    @Override
    public ElectricCharge timeIntegrated() {
        return Coulombs$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toAmperes()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Seconds$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public ElectricPotential $times(ElectricalResistance that) {
        return Volts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() * that.toOhms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Power $times(ElectricPotential that) {
        return Watts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() * that.toVolts())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public MagneticFlux $times(Inductance that) {
        return Webers$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() * that.toHenry())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricalConductance $div(ElectricPotential that) {
        return Siemens$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() / that.toVolts())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public MagneticFieldStrength $div(Length that) {
        return AmperesPerMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricCurrentDensity $div(Area that) {
        return AmperesPerSquareMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() / that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toAmperes() {
        return this.to(Amperes$.MODULE$);
    }

    public double toMilliamperes() {
        return this.to(Milliamperes$.MODULE$);
    }

    public ElectricCurrent(double value, ElectricCurrentUnit unit) {
        this.value = value;
        this.unit = unit;
        TimeDerivative.$init$(this);
    }
}

