/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.proj4.CRS;
import geotrellis.raster.CellGrid;
import geotrellis.raster.DataType;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridIntegral;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.PaddedTile;
import geotrellis.raster.ProjectedRasterLike;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterRegion$;
import geotrellis.raster.RasterSource;
import geotrellis.raster.Tile;
import geotrellis.vector.Extent;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import spire.math.Integral$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g!\u0002\u0014(\u0003\u0003a\u0003\"B\u001f\u0001\t\u0003q\u0004\"\u0002\u0015\u0001\r\u0003\u0001u!\u0002&(\u0011\u0003Ye!\u0002\u0014(\u0011\u0003a\u0005\"B\u001f\u0005\t\u0003\u0001\u0006\"B)\u0005\t\u0003\u0011f\u0001\u00021\u0005\u0001\u0006D\u0001\u0002V\u0004\u0003\u0016\u0004%\t!\u001a\u0005\tM\u001e\u0011\t\u0012)A\u0005+\"A\u0011l\u0002BK\u0002\u0013\u0005q\r\u0003\u0005i\u000f\tE\t\u0015!\u0003[\u0011\u0015it\u0001\"\u0001j\u0011\u0015qw\u0001\"\u0011p\u0011\u0015\u0001x\u0001\"\u0011p\u0011\u0015\tx\u0001\"\u0011s\u0011\u0015Ix\u0001\"\u0011{\u0011\u001d\t\u0019a\u0002C!\u0003\u000bA\u0011\"!\u0006\b\u0003\u0003%\t!a\u0006\t\u0013\u0005uq!%A\u0005\u0002\u0005}\u0001\"CA\u001b\u000fE\u0005I\u0011AA\u001c\u0011!As\u0001#b\u0001\n\u0003\u0001\u0005\"CA\"\u000f\u0005\u0005I\u0011IA#\u0011!\t9fBA\u0001\n\u0003y\u0007\"CA-\u000f\u0005\u0005I\u0011AA.\u0011%\t9gBA\u0001\n\u0003\nI\u0007C\u0005\u0002x\u001d\t\t\u0011\"\u0001\u0002z!I\u00111Q\u0004\u0002\u0002\u0013\u0005\u0013Q\u0011\u0005\n\u0003\u000f;\u0011\u0011!C!\u0003\u0013C\u0011\"a#\b\u0003\u0003%\t%!$\b\u0013\u0005EE!!A\t\u0002\u0005Me\u0001\u00031\u0005\u0003\u0003E\t!!&\t\ruzB\u0011AAR\u0011%\t9iHA\u0001\n\u000b\nI\t\u0003\u0005R?\u0005\u0005I\u0011QAS\u0011%\tYkHA\u0001\n\u0003\u000bi\u000bC\u0005\u0002<~\t\t\u0011\"\u0003\u0002>\"I\u00111\u0018\u0003\u0002\u0002\u0013%\u0011Q\u0018\u0002\r%\u0006\u001cH/\u001a:SK\u001eLwN\u001c\u0006\u0003Q%\naA]1ti\u0016\u0014(\"\u0001\u0016\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0014\t\u0001isG\u000f\t\u0004]=\nT\"A\u0014\n\u0005A:#\u0001C\"fY2<%/\u001b3\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\u0007%sG\u000f\u0005\u0002/q%\u0011\u0011h\n\u0002\u0014!J|'.Z2uK\u0012\u0014\u0016m\u001d;fe2K7.\u001a\t\u0003emJ!\u0001P\u001a\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005y\u0004C\u0001\u0018\u0001+\u0005\t\u0005c\u0001\u001aC\t&\u00111i\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00079*u)\u0003\u0002GO\t1!+Y:uKJ\u0004\"A\f%\n\u0005%;#!D'vYRL'-\u00198e)&dW-\u0001\u0007SCN$XM\u001d*fO&|g\u000e\u0005\u0002/\tM\u0019A!\u0014\u001e\u0011\u0005Ir\u0015BA(4\u0005\u0019\te.\u001f*fMR\t1*A\u0003baBd\u0017\u0010F\u0002@'bCQ\u0001\u0016\u0004A\u0002U\u000baa]8ve\u000e,\u0007C\u0001\u0018W\u0013\t9vE\u0001\u0007SCN$XM]*pkJ\u001cW\rC\u0003Z\r\u0001\u0007!,\u0001\u0004c_VtGm\u001d\t\u0004]mk\u0016B\u0001/(\u0005)9%/\u001b3C_VtGm\u001d\t\u0003eyK!aX\u001a\u0003\t1{gn\u001a\u0002\u0017\u000fJLGMQ8v]\u0012\u001c(+Y:uKJ\u0014VmZ5p]N!qa\u00102;!\t\u00114-\u0003\u0002eg\t9\u0001K]8ek\u000e$X#A+\u0002\u000fM|WO]2fAU\t!,A\u0004c_VtGm\u001d\u0011\u0015\u0007)dW\u000e\u0005\u0002l\u000f5\tA\u0001C\u0003U\u0019\u0001\u0007Q\u000bC\u0003Z\u0019\u0001\u0007!,\u0001\u0003d_2\u001cX#A\u0019\u0002\tI|wo]\u0001\u0007Kb$XM\u001c;\u0016\u0003M\u0004\"\u0001^<\u000e\u0003UT!A^\u0015\u0002\rY,7\r^8s\u0013\tAXO\u0001\u0004FqR,g\u000e^\u0001\u0004GJ\u001cX#A>\u0011\u0005q|X\"A?\u000b\u0005yL\u0013!\u00029s_*$\u0014bAA\u0001{\n\u00191IU*\u0002\u0011\r,G\u000e\u001c+za\u0016,\"!a\u0002\u0011\t\u0005%\u0011q\u0002\b\u0004]\u0005-\u0011bAA\u0007O\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\t\u0003'\u0011\u0001bQ3mYRK\b/\u001a\u0006\u0004\u0003\u001b9\u0013\u0001B2paf$RA[A\r\u00037Aq\u0001\u0016\n\u0011\u0002\u0003\u0007Q\u000bC\u0004Z%A\u0005\t\u0019\u0001.\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0005\u0016\u0004+\u0006\r2FAA\u0013!\u0011\t9#!\r\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=2'\u0001\u0006b]:|G/\u0019;j_:LA!a\r\u0002*\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\b\u0016\u00045\u0006\r\u0002fA\u000b\u0002>A\u0019!'a\u0010\n\u0007\u0005\u00053GA\u0005ue\u0006t7/[3oi\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0012\u0011\t\u0005%\u00131K\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u0005!A.\u00198h\u0015\t\t\t&\u0001\u0003kCZ\f\u0017\u0002BA+\u0003\u0017\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003;\n\u0019\u0007E\u00023\u0003?J1!!\u00194\u0005\r\te.\u001f\u0005\t\u0003KB\u0012\u0011!a\u0001c\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u001b\u0011\r\u00055\u00141OA/\u001b\t\tyGC\u0002\u0002rM\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)(a\u001c\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003w\n\t\tE\u00023\u0003{J1!a 4\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u001a\u001b\u0003\u0003\u0005\r!!\u0018\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012!M\u0001\ti>\u001cFO]5oOR\u0011\u0011qI\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005m\u0014q\u0012\u0005\n\u0003Kj\u0012\u0011!a\u0001\u0003;\nac\u0012:jI\n{WO\u001c3t%\u0006\u001cH/\u001a:SK\u001eLwN\u001c\t\u0003W~\u0019BaHALuA9\u0011\u0011TAP+jSWBAAN\u0015\r\tijM\u0001\beVtG/[7f\u0013\u0011\t\t+a'\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002\u0014R)!.a*\u0002*\")AK\ta\u0001+\")\u0011L\ta\u00015\u00069QO\\1qa2LH\u0003BAX\u0003o\u0003BA\r\"\u00022B)!'a-V5&\u0019\u0011QW\u001a\u0003\rQ+\b\u000f\\33\u0011!\tIlIA\u0001\u0002\u0004Q\u0017a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\f\u0005\u0003\u0002J\u0005\u0005\u0017\u0002BAb\u0003\u0017\u0012aa\u00142kK\u000e$\b")
public abstract class RasterRegion
extends CellGrid<Object>
implements ProjectedRasterLike {
    public static RasterRegion apply(RasterSource rasterSource, GridBounds<Object> gridBounds) {
        return RasterRegion$.MODULE$.apply(rasterSource, gridBounds);
    }

    public abstract Option<Raster<MultibandTile>> raster();

    public RasterRegion() {
        super(Integral$.MODULE$.IntIsIntegral());
    }

    public static class GridBoundsRasterRegion
    extends RasterRegion
    implements Product {
        private transient Option<Raster<MultibandTile>> raster;
        private final RasterSource source;
        private final GridBounds<Object> bounds;
        private volatile transient boolean bitmap$trans$0;

        public RasterSource source() {
            return this.source;
        }

        public GridBounds<Object> bounds() {
            return this.bounds;
        }

        private Option<Raster<MultibandTile>> raster$lzycompute() {
            GridBoundsRasterRegion gridBoundsRasterRegion = this;
            synchronized (gridBoundsRasterRegion) {
                if (!this.bitmap$trans$0) {
                    this.raster = this.bounds().intersection$mcJ$sp(this.source().dimensions()).flatMap((Function1 & Serializable & scala.Serializable)intersection -> this.source().read((GridBounds<Object>)intersection).map((Function1 & Serializable & scala.Serializable)raster -> {
                        Raster raster2;
                        if (((GridIntegral)raster.tile()).cols$mcI$sp() == this.cols$mcI$sp() && ((GridIntegral)raster.tile()).rows$mcI$sp() == this.rows$mcI$sp()) {
                            raster2 = raster;
                        } else {
                            long colOffset = package$.MODULE$.abs(this.bounds().colMin$mcJ$sp() - intersection.colMin$mcJ$sp());
                            long rowOffset = package$.MODULE$.abs(this.bounds().rowMin$mcJ$sp() - intersection.rowMin$mcJ$sp());
                            Predef$.MODULE$.require(colOffset <= Integer.MAX_VALUE && rowOffset <= Integer.MAX_VALUE, (Function0 & Serializable & scala.Serializable)() -> "Computed offsets are outside of RasterBounds");
                            raster2 = raster.mapTile((Function1 & Serializable & scala.Serializable)x$1 -> x$1.mapBands((Function2<Object, Tile, Tile>)(Function2 & Serializable & scala.Serializable)(x$2, band) -> GridBoundsRasterRegion.$anonfun$raster$5(this, colOffset, rowOffset, BoxesRunTime.unboxToInt((Object)x$2), band)));
                        }
                        return raster2;
                    }));
                    this.bitmap$trans$0 = true;
                }
            }
            return this.raster;
        }

        @Override
        public Option<Raster<MultibandTile>> raster() {
            return !this.bitmap$trans$0 ? this.raster$lzycompute() : this.raster;
        }

        @Override
        public int cols() {
            return this.cols$mcI$sp();
        }

        @Override
        public int rows() {
            return this.rows$mcI$sp();
        }

        @Override
        public Extent extent() {
            return this.source().gridExtent().extentFor$mcJ$sp(this.bounds(), false);
        }

        @Override
        public CRS crs() {
            return this.source().crs();
        }

        @Override
        public DataType cellType() {
            return this.source().cellType();
        }

        public GridBoundsRasterRegion copy(RasterSource source, GridBounds<Object> bounds) {
            return new GridBoundsRasterRegion(source, bounds);
        }

        public RasterSource copy$default$1() {
            return this.source();
        }

        public GridBounds<Object> copy$default$2() {
            return this.bounds();
        }

        public String productPrefix() {
            return "GridBoundsRasterRegion";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            scala.Serializable serializable;
            int n = x$1;
            switch (n) {
                case 0: {
                    serializable = this.source();
                    break;
                }
                case 1: {
                    serializable = this.bounds();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return serializable;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof GridBoundsRasterRegion;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof GridBoundsRasterRegion)) return false;
            boolean bl = true;
            if (!bl) return false;
            GridBoundsRasterRegion gridBoundsRasterRegion = (GridBoundsRasterRegion)x$1;
            RasterSource rasterSource = this.source();
            RasterSource rasterSource2 = gridBoundsRasterRegion.source();
            if (rasterSource == null) {
                if (rasterSource2 != null) {
                    return false;
                }
            } else if (!rasterSource.equals(rasterSource2)) return false;
            GridBounds<Object> gridBounds = this.bounds();
            GridBounds<Object> gridBounds2 = gridBoundsRasterRegion.bounds();
            if (gridBounds == null) {
                if (gridBounds2 != null) {
                    return false;
                }
            } else if (!((Object)gridBounds).equals(gridBounds2)) return false;
            if (!gridBoundsRasterRegion.canEqual(this)) return false;
            return true;
        }

        @Override
        public int cols$mcI$sp() {
            return (int)this.bounds().width$mcJ$sp();
        }

        @Override
        public int rows$mcI$sp() {
            return (int)this.bounds().height$mcJ$sp();
        }

        public static final /* synthetic */ PaddedTile $anonfun$raster$5(GridBoundsRasterRegion $this, long colOffset$1, long rowOffset$1, int x$2, Tile band) {
            return new PaddedTile(band, (int)colOffset$1, (int)rowOffset$1, $this.cols$mcI$sp(), $this.rows$mcI$sp());
        }

        public GridBoundsRasterRegion(RasterSource source, GridBounds<Object> bounds) {
            this.source = source;
            this.bounds = bounds;
            Product.$init$((Product)this);
            Predef$.MODULE$.require(bounds.intersects$mcJ$sp(source.dimensions()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("The given bounds: ").append(this.bounds()).append(" must intersect the given source: ").append(this.source()).toString());
        }
    }
}

