/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.gdal;

import geotrellis.raster.BitCellType$;
import geotrellis.raster.ByteCellType$;
import geotrellis.raster.ByteConstantNoDataCellType$;
import geotrellis.raster.ByteUserDefinedNoDataCellType;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCellType$;
import geotrellis.raster.DoubleConstantNoDataCellType$;
import geotrellis.raster.DoubleUserDefinedNoDataCellType;
import geotrellis.raster.FloatCellType$;
import geotrellis.raster.FloatConstantNoDataCellType$;
import geotrellis.raster.FloatUserDefinedNoDataCellType;
import geotrellis.raster.IntCellType$;
import geotrellis.raster.IntConstantNoDataCellType$;
import geotrellis.raster.IntUserDefinedNoDataCellType;
import geotrellis.raster.ShortCellType$;
import geotrellis.raster.ShortConstantNoDataCellType$;
import geotrellis.raster.ShortUserDefinedNoDataCellType;
import geotrellis.raster.UByteCellType$;
import geotrellis.raster.UByteConstantNoDataCellType$;
import geotrellis.raster.UByteUserDefinedNoDataCellType;
import geotrellis.raster.UShortCellType$;
import geotrellis.raster.UShortConstantNoDataCellType$;
import geotrellis.raster.UShortUserDefinedNoDataCellType;
import geotrellis.raster.gdal.GDALDataType;
import geotrellis.raster.gdal.TypeByte$;
import geotrellis.raster.gdal.TypeCFloat32$;
import geotrellis.raster.gdal.TypeCFloat64$;
import geotrellis.raster.gdal.TypeCInt16$;
import geotrellis.raster.gdal.TypeCInt32$;
import geotrellis.raster.gdal.TypeFloat32$;
import geotrellis.raster.gdal.TypeFloat64$;
import geotrellis.raster.gdal.TypeInt16$;
import geotrellis.raster.gdal.TypeInt32$;
import geotrellis.raster.gdal.TypeUInt16$;
import geotrellis.raster.gdal.TypeUInt32$;
import geotrellis.raster.gdal.UnknownType$;
import geotrellis.raster.io.geotiff.Auto;
import geotrellis.raster.io.geotiff.Base$;
import geotrellis.raster.io.geotiff.Level;
import geotrellis.raster.io.geotiff.OverviewStrategy;
import geotrellis.raster.resample.Average$;
import geotrellis.raster.resample.Bilinear$;
import geotrellis.raster.resample.CubicConvolution$;
import geotrellis.raster.resample.CubicSpline$;
import geotrellis.raster.resample.Lanczos$;
import geotrellis.raster.resample.Max$;
import geotrellis.raster.resample.Median$;
import geotrellis.raster.resample.Min$;
import geotrellis.raster.resample.Mode$;
import geotrellis.raster.resample.NearestNeighbor$;
import geotrellis.raster.resample.ResampleMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Float$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxesRunTime;

public final class GDALUtils$ {
    public static GDALUtils$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new GDALUtils$();
    }

    private Logger logger$lzycompute() {
        GDALUtils$ gDALUtils$ = this;
        synchronized (gDALUtils$) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger((String)"geotrellis.raster.gdal.GDALUtils");
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    private Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public String deriveResampleMethodString(ResampleMethod method) {
        String string2;
        ResampleMethod resampleMethod = method;
        if (NearestNeighbor$.MODULE$.equals(resampleMethod)) {
            string2 = "near";
        } else if (Bilinear$.MODULE$.equals(resampleMethod)) {
            string2 = "bilinear";
        } else if (CubicConvolution$.MODULE$.equals(resampleMethod)) {
            string2 = "cubic";
        } else if (CubicSpline$.MODULE$.equals(resampleMethod)) {
            string2 = "cubicspline";
        } else if (Lanczos$.MODULE$.equals(resampleMethod)) {
            string2 = "lanczos";
        } else if (Average$.MODULE$.equals(resampleMethod)) {
            string2 = "average";
        } else if (Mode$.MODULE$.equals(resampleMethod)) {
            string2 = "mode";
        } else if (Max$.MODULE$.equals(resampleMethod)) {
            string2 = "max";
        } else if (Min$.MODULE$.equals(resampleMethod)) {
            string2 = "min";
        } else if (Median$.MODULE$.equals(resampleMethod)) {
            string2 = "med";
        } else {
            throw new Exception(new StringBuilder(50).append("Could not find equivalent GDALResampleMethod for: ").append(method).toString());
        }
        return string2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public DataType dataTypeToCellType(GDALDataType datatype, Option<Object> noDataValue, Function0<Option<Object>> typeSizeInBits, Function0<Object> signedByte) {
        block23: {
            block29: {
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block18: {
                                        block20: {
                                            block22: {
                                                block21: {
                                                    block19: {
                                                        var16_5 = datatype;
                                                        if (!TypeByte$.MODULE$.equals(var16_5)) break block18;
                                                        var17_6 = (Option)typeSizeInBits.apply();
                                                        if (!(var17_6 instanceof Some) || (bits = BoxesRunTime.unboxToInt((Object)(var18_7 = (Some)var17_6).value())) != 1) break block19;
                                                        var13_9 /* !! */  = BitCellType$.MODULE$;
                                                        break block20;
                                                    }
                                                    if (signedByte.apply$mcZ$sp()) break block21;
                                                    var20_10 = false;
                                                    var21_11 = null;
                                                    var22_12 = noDataValue;
                                                    if (!(var22_12 instanceof Some)) ** GOTO lbl-1000
                                                    var20_10 = true;
                                                    var21_11 = (Some)var22_12;
                                                    nd = BoxesRunTime.unboxToDouble((Object)var21_11.value());
                                                    if ((int)nd > 0 && nd <= (double)255) {
                                                        var15_14 /* !! */  = new UByteUserDefinedNoDataCellType((byte)nd);
                                                    } else lbl-1000:
                                                    // 2 sources

                                                    {
                                                        var15_14 /* !! */  = var20_10 != false && (int)(nd = BoxesRunTime.unboxToDouble((Object)var21_11.value())) == 0 ? UByteConstantNoDataCellType$.MODULE$ : UByteCellType$.MODULE$;
                                                    }
                                                    v0 /* !! */  = var15_14 /* !! */ ;
                                                    break block22;
                                                }
                                                var27_16 = false;
                                                var28_17 = null;
                                                var29_18 = noDataValue;
                                                if (!(var29_18 instanceof Some)) ** GOTO lbl-1000
                                                var27_16 = true;
                                                var28_17 = (Some)var29_18;
                                                nd = BoxesRunTime.unboxToDouble((Object)var28_17.value());
                                                if ((int)nd > -128 && nd <= (double)127) {
                                                    var14_20 /* !! */  = new ByteUserDefinedNoDataCellType((byte)nd);
                                                } else lbl-1000:
                                                // 2 sources

                                                {
                                                    var14_20 /* !! */  = var27_16 != false && (int)(nd = BoxesRunTime.unboxToDouble((Object)var28_17.value())) == -128 ? ByteConstantNoDataCellType$.MODULE$ : ByteCellType$.MODULE$;
                                                }
                                                v0 /* !! */  = var14_20 /* !! */ ;
                                            }
                                            var13_9 /* !! */  = v0 /* !! */ ;
                                        }
                                        var5_22 /* !! */  = var13_9 /* !! */ ;
                                        break block23;
                                    }
                                    if (!TypeUInt16$.MODULE$.equals(var16_5)) break block24;
                                    var34_23 = false;
                                    var35_24 = null;
                                    var36_25 = noDataValue;
                                    if (!(var36_25 instanceof Some)) ** GOTO lbl-1000
                                    var34_23 = true;
                                    var35_24 = (Some)var36_25;
                                    nd = BoxesRunTime.unboxToDouble((Object)var35_24.value());
                                    if ((int)nd > 0 && nd <= (double)65535) {
                                        var12_27 /* !! */  = new UShortUserDefinedNoDataCellType((short)nd);
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        var12_27 /* !! */  = var34_23 != false && (int)(nd = BoxesRunTime.unboxToDouble((Object)var35_24.value())) == 0 ? UShortConstantNoDataCellType$.MODULE$ : UShortCellType$.MODULE$;
                                    }
                                    var5_22 /* !! */  = var12_27 /* !! */ ;
                                    break block23;
                                }
                                if (!TypeInt16$.MODULE$.equals(var16_5)) break block25;
                                var41_29 = false;
                                var42_30 = null;
                                var43_31 = noDataValue;
                                if (!(var43_31 instanceof Some)) ** GOTO lbl-1000
                                var41_29 = true;
                                var42_30 = (Some)var43_31;
                                nd = BoxesRunTime.unboxToDouble((Object)var42_30.value());
                                if (nd > (double)-32768 && nd <= (double)32767) {
                                    var11_33 /* !! */  = new ShortUserDefinedNoDataCellType((short)nd);
                                } else lbl-1000:
                                // 2 sources

                                {
                                    var11_33 /* !! */  = var41_29 != false && (nd = BoxesRunTime.unboxToDouble((Object)var42_30.value())) == (double)-32768 ? ShortConstantNoDataCellType$.MODULE$ : ShortCellType$.MODULE$;
                                }
                                var5_22 /* !! */  = var11_33 /* !! */ ;
                                break block23;
                            }
                            if (!TypeUInt32$.MODULE$.equals(var16_5)) break block26;
                            var48_35 = false;
                            var49_36 = null;
                            var50_37 = noDataValue;
                            if (!(var50_37 instanceof Some)) ** GOTO lbl-1000
                            var48_35 = true;
                            var49_36 = (Some)var50_37;
                            nd = BoxesRunTime.unboxToDouble((Object)var49_36.value());
                            if ((long)nd > 0L && (long)nd <= 0xFFFFFFFFL) {
                                var10_39 /* !! */  = new FloatUserDefinedNoDataCellType((float)nd);
                            } else lbl-1000:
                            // 2 sources

                            {
                                var10_39 /* !! */  = var48_35 != false && (long)(nd = BoxesRunTime.unboxToDouble((Object)var49_36.value())) == 0L ? FloatConstantNoDataCellType$.MODULE$ : FloatCellType$.MODULE$;
                            }
                            var5_22 /* !! */  = var10_39 /* !! */ ;
                            break block23;
                        }
                        if (!TypeInt32$.MODULE$.equals(var16_5)) break block27;
                        var55_41 = false;
                        var56_42 = null;
                        var57_43 = noDataValue;
                        if (!(var57_43 instanceof Some)) ** GOTO lbl-1000
                        var55_41 = true;
                        var56_42 = (Some)var57_43;
                        nd = BoxesRunTime.unboxToDouble((Object)var56_42.value());
                        if ((int)nd > -2147483648 && (int)nd <= 0x7FFFFFFF) {
                            var9_45 /* !! */  = new IntUserDefinedNoDataCellType((int)nd);
                        } else lbl-1000:
                        // 2 sources

                        {
                            var9_45 /* !! */  = var55_41 != false && (int)(nd = BoxesRunTime.unboxToDouble((Object)var56_42.value())) == -2147483648 ? IntConstantNoDataCellType$.MODULE$ : IntCellType$.MODULE$;
                        }
                        var5_22 /* !! */  = var9_45 /* !! */ ;
                        break block23;
                    }
                    if (!TypeFloat32$.MODULE$.equals(var16_5)) break block28;
                    var62_47 = false;
                    var63_48 = null;
                    var64_49 = noDataValue;
                    if (!(var64_49 instanceof Some)) ** GOTO lbl-1000
                    var62_47 = true;
                    var63_48 = (Some)var64_49;
                    nd = BoxesRunTime.unboxToDouble((Object)var63_48.value());
                    if (!Double.isNaN(nd) && (double)Float$.MODULE$.MinValue() <= nd && (double)3.4028235E38f >= nd) {
                        var8_51 /* !! */  = new FloatUserDefinedNoDataCellType((float)nd);
                    } else lbl-1000:
                    // 2 sources

                    {
                        var8_51 /* !! */  = var62_47 != false ? FloatConstantNoDataCellType$.MODULE$ : FloatCellType$.MODULE$;
                    }
                    var5_22 /* !! */  = var8_51 /* !! */ ;
                    break block23;
                }
                if (!TypeFloat64$.MODULE$.equals(var16_5)) break block29;
                var67_52 = false;
                var68_53 = null;
                var69_54 = noDataValue;
                if (!(var69_54 instanceof Some)) ** GOTO lbl-1000
                var67_52 = true;
                var68_53 = (Some)var69_54;
                nd = BoxesRunTime.unboxToDouble((Object)var68_53.value());
                if (!Double.isNaN(nd)) {
                    var7_56 /* !! */  = new DoubleUserDefinedNoDataCellType(nd);
                } else lbl-1000:
                // 2 sources

                {
                    var7_56 /* !! */  = var67_52 != false ? DoubleConstantNoDataCellType$.MODULE$ : DoubleCellType$.MODULE$;
                }
                var5_22 /* !! */  = var7_56 /* !! */ ;
                break block23;
            }
            if (UnknownType$.MODULE$.equals(var16_5)) {
                throw new UnsupportedOperationException(new StringBuilder(27).append("Datatype ").append(datatype).append(" is not supported.").toString());
            }
            var6_57 = TypeCInt16$.MODULE$.equals(var16_5) != false ? true : (TypeCInt32$.MODULE$.equals(var16_5) != false ? true : (TypeCFloat32$.MODULE$.equals(var16_5) != false ? true : TypeCFloat64$.MODULE$.equals(var16_5) != false));
            if (var6_57) {
                throw new UnsupportedOperationException("Complex datatypes are not supported.");
            }
            throw new MatchError((Object)var16_5);
        }
        return var5_22 /* !! */ ;
    }

    public Option<Object> dataTypeToCellType$default$2() {
        return None$.MODULE$;
    }

    public Option<Object> dataTypeToCellType$default$3() {
        return None$.MODULE$;
    }

    public boolean dataTypeToCellType$default$4() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String deriveOverviewStrategyString(OverviewStrategy strategy) {
        boolean bl = false;
        Auto auto2 = null;
        OverviewStrategy overviewStrategy = strategy;
        if (overviewStrategy instanceof Auto) {
            bl = true;
            auto2 = (Auto)overviewStrategy;
            int n = auto2.n();
            if (n == 0) {
                return "AUTO";
            }
        }
        if (bl) {
            int n = auto2.n();
            return new StringBuilder(5).append("AUTO-").append(n).toString();
        }
        if (overviewStrategy instanceof Level) {
            Level level = (Level)overviewStrategy;
            int level2 = level.overviewLevel();
            return String.valueOf(BoxesRunTime.boxToInteger((int)level2));
        }
        if (Base$.MODULE$.equals(overviewStrategy)) {
            return "NONE";
        }
        if (!this.logger().isDebugEnabled()) return "AUTO";
        this.logger().debug(new StringBuilder(60).append(overviewStrategy).append(" is not a valid GDALWarp -ovr argument; falling back to AUTO").toString());
        return "AUTO";
    }

    private GDALUtils$() {
        MODULE$ = this;
    }
}

