/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.Dimensions;
import geotrellis.raster.Dimensions$;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridBounds$;
import geotrellis.raster.TileLayout;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayoutTransform$;
import geotrellis.raster.io.geotiff.InterleaveMethod;
import geotrellis.raster.io.geotiff.SegmentTransform;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.StripedSegmentTransform;
import geotrellis.raster.io.geotiff.TiledSegmentTransform;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015ca\u0002\r\u001a!\u0003\r\tA\t\u0005\u0006S\u0001!\tA\u000b\u0005\u0007]\u00011\taH\u0018\t\u0015Q\u0002\u0001\u0013!EDB\u0013%Q\u0007\u0003\u0005G\u0001!\u0015\r\u0011\"\u0003H\u0011!A\u0005\u0001#b\u0001\n\u00139\u0005\u0002C%\u0001\u0011\u000b\u0007I\u0011\u0002&\t\u0011-\u0003\u0001R1A\u0005\n1C\u0001\"\u0014\u0001\t\u0006\u0004%IA\u0014\u0005\u0006\u001f\u00021\ta\u0012\u0005\u0006!\u0002!Ia\u0012\u0005\u0006#\u0002!\tA\u0015\u0005\u00061\u0002!\t!\u0017\u0005\u00077\u0002!\t!\u0007/\t\r\u0005\u0004A\u0011A\rc\u0011\u00159\u0007\u0001\"\u0001i\u0011\u0019i\u0007\u0001\"\u0001 ]\"11\u000f\u0001C\u0001?QDQA\u001f\u0001\u0005\u0002mDqa\u001d\u0001\u0005\u0002e\t\u0019cB\u0004\u0002.eA\t!a\f\u0007\raI\u0002\u0012AA\u0019\u0011\u001d\t\u0019$\u0006C\u0001\u0003kAq!a\u000e\u0016\t\u0003\tIDA\u000fHK>$\u0016N\u001a4TK\u001elWM\u001c;MCf|W\u000f\u001e+sC:\u001chm\u001c:n\u0015\tQ2$A\u0004hK>$\u0018N\u001a4\u000b\u0005qi\u0012AA5p\u0015\tqr$\u0001\u0004sCN$XM\u001d\u0006\u0002A\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0011\u0001a\t\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%)\u0005Y\u0003C\u0001\u0013-\u0013\tiSE\u0001\u0003V]&$\u0018!D:fO6,g\u000e\u001e'bs>,H/F\u00011!\t\t$'D\u0001\u001a\u0013\t\u0019\u0014D\u0001\u000bHK>$\u0016N\u001a4TK\u001elWM\u001c;MCf|W\u000f^\u0001\u0005q\u0012\n\u0004'F\u00017!\u001d!s'O\u001d=\u0001\u000eK!\u0001O\u0013\u0003\rQ+\b\u000f\\36!\t!#(\u0003\u0002<K\t\u0019\u0011J\u001c;\u0011\u0005urT\"A\u000f\n\u0005}j\"A\u0003+jY\u0016d\u0015-_8viB\u0011\u0011'Q\u0005\u0003\u0005f\u0011Qb\u0015;pe\u0006<W-T3uQ>$\u0007CA\u0019E\u0013\t)\u0015D\u0001\tJ]R,'\u000f\\3bm\u0016lU\r\u001e5pI\u0006IAo\u001c;bY\u000e{Gn]\u000b\u0002s\u0005IAo\u001c;bYJ{wo]\u0001\u000bi&dW\rT1z_V$X#\u0001\u001f\u0002\u000f%\u001cH+\u001b7fIV\t\u0001)\u0001\tj]R,'\u000f\\3bm\u0016lU\r\u001e5pIV\t1)A\u0005cC:$7i\\;oi\u0006\u0001\"-\u00198e'\u0016<W.\u001a8u\u0007>,h\u000e^\u0001\u0015O\u0016$8+Z4nK:$H)[7f]NLwN\\:\u0015\u0005M3\u0006cA\u001fUs%\u0011Q+\b\u0002\u000b\t&lWM\\:j_:\u001c\b\"B,\f\u0001\u0004I\u0014\u0001D:fO6,g\u000e^%oI\u0016D\u0018AD4fiN+w-\\3oiNK'0\u001a\u000b\u0003siCQa\u0016\u0007A\u0002e\nqbZ3u'\u0016<W.\u001a8u\u0013:$W\r\u001f\u000b\u0004su{\u0006\"\u00020\u000e\u0001\u0004I\u0014aA2pY\")\u0001-\u0004a\u0001s\u0005\u0019!o\\<\u0002'\u001d,GoU3h[\u0016tG\u000f\u0016:b]N4wN]7\u0015\u0005\r4\u0007CA\u0019e\u0013\t)\u0017D\u0001\tTK\u001elWM\u001c;Ue\u0006t7OZ8s[\")qK\u0004a\u0001s\u0005!r-\u001a;TK\u001elWM\u001c;D_>\u0014H-\u001b8bi\u0016$\"!\u001b7\u0011\t\u0011R\u0017(O\u0005\u0003W\u0016\u0012a\u0001V;qY\u0016\u0014\u0004\"B,\u0010\u0001\u0004I\u0014!D4fi\u001e\u0013\u0018\u000e\u001a\"pk:$7\u000f\u0006\u0002peB\u0019Q\b]\u001d\n\u0005El\"AC$sS\u0012\u0014u.\u001e8eg\")q\u000b\u0005a\u0001s\u00059r-\u001a;J]R,'o]3di&twmU3h[\u0016tGo\u001d\u000b\u0003kb\u00042\u0001\n<:\u0013\t9XEA\u0003BeJ\f\u0017\u0010C\u0003z#\u0001\u0007q.\u0001\u0004c_VtGm]\u0001\u001ba\u0006\u0014H/\u001b;j_:<\u0016N\u001c3poN\u0014\u0015pU3h[\u0016tGo\u001d\u000b\u0005yz\fI\u0002E\u0002%mv\u00042\u0001\n<p\u0011\u0019y(\u00031\u0001\u0002\u0002\u00059q/\u001b8e_^\u001c\b#BA\u0002\u0003'yg\u0002BA\u0003\u0003\u001fqA!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017\t\u0013A\u0002\u001fs_>$h(C\u0001'\u0013\r\t\t\"J\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)\"a\u0006\u0003\u0007M+\u0017OC\u0002\u0002\u0012\u0015Bq!a\u0007\u0013\u0001\u0004\ti\"\u0001\tnCb\u0004\u0016M\u001d;ji&|gnU5{KB\u0019A%a\b\n\u0007\u0005\u0005RE\u0001\u0003M_:<GCBA\u0013\u0003O\tI\u0003E\u0002%m&DQ!_\nA\u0002=Da!a\u000b\u0014\u0001\u0004)\u0018!\u00022b]\u0012\u001c\u0018!H$f_RKgMZ*fO6,g\u000e\u001e'bs>,H\u000f\u0016:b]N4wN]7\u0011\u0005E*2CA\u000b$\u0003\u0019a\u0014N\\5u}Q\u0011\u0011qF\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003w\ti$!\u0011\u0011\u0005E\u0002\u0001BBA /\u0001\u0007\u0001'\u0001\b`g\u0016<W.\u001a8u\u0019\u0006Lx.\u001e;\t\r\u0005\rs\u00031\u0001:\u0003)y&-\u00198e\u0007>,h\u000e\u001e")
public interface GeoTiffSegmentLayoutTransform {
    public static GeoTiffSegmentLayoutTransform apply(GeoTiffSegmentLayout geoTiffSegmentLayout, int n) {
        return GeoTiffSegmentLayoutTransform$.MODULE$.apply(geoTiffSegmentLayout, n);
    }

    public GeoTiffSegmentLayout segmentLayout();

    public static /* synthetic */ Tuple5 geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10$(GeoTiffSegmentLayoutTransform $this) {
        return $this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10();
    }

    default public /* synthetic */ Tuple5 geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10() {
        GeoTiffSegmentLayout geoTiffSegmentLayout = this.segmentLayout();
        if (geoTiffSegmentLayout == null) {
            throw new MatchError((Object)geoTiffSegmentLayout);
        }
        int totalCols = geoTiffSegmentLayout.totalCols();
        int totalRows = geoTiffSegmentLayout.totalRows();
        TileLayout tileLayout = geoTiffSegmentLayout.tileLayout();
        StorageMethod isTiled = geoTiffSegmentLayout.storageMethod();
        InterleaveMethod interleaveMethod = geoTiffSegmentLayout.interleaveMethod();
        Tuple5 tuple52 = new Tuple5((Object)BoxesRunTime.boxToInteger((int)totalCols), (Object)BoxesRunTime.boxToInteger((int)totalRows), (Object)tileLayout, (Object)isTiled, (Object)interleaveMethod);
        return tuple52;
    }

    public static /* synthetic */ int geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols$(GeoTiffSegmentLayoutTransform $this) {
        return $this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols();
    }

    default public int geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols() {
        return BoxesRunTime.unboxToInt((Object)this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10()._1());
    }

    public static /* synthetic */ int geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows$(GeoTiffSegmentLayoutTransform $this) {
        return $this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows();
    }

    default public int geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows() {
        return BoxesRunTime.unboxToInt((Object)this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10()._2());
    }

    public static /* synthetic */ TileLayout geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout$(GeoTiffSegmentLayoutTransform $this) {
        return $this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout();
    }

    default public TileLayout geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout() {
        return (TileLayout)this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10()._3();
    }

    public static /* synthetic */ StorageMethod geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$isTiled$(GeoTiffSegmentLayoutTransform $this) {
        return $this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$isTiled();
    }

    default public StorageMethod geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$isTiled() {
        return (StorageMethod)this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10()._4();
    }

    public static /* synthetic */ InterleaveMethod geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$interleaveMethod$(GeoTiffSegmentLayoutTransform $this) {
        return $this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$interleaveMethod();
    }

    default public InterleaveMethod geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$interleaveMethod() {
        return (InterleaveMethod)this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10()._5();
    }

    public int bandCount();

    private int bandSegmentCount() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutCols() * this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutRows();
    }

    public static /* synthetic */ Dimensions getSegmentDimensions$(GeoTiffSegmentLayoutTransform $this, int segmentIndex) {
        return $this.getSegmentDimensions(segmentIndex);
    }

    default public Dimensions<Object> getSegmentDimensions(int segmentIndex) {
        int normalizedSegmentIndex = segmentIndex % this.bandSegmentCount();
        int layoutCol = normalizedSegmentIndex % this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutCols();
        int layoutRow = normalizedSegmentIndex / this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutCols();
        int cols = layoutCol == this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutCols() - 1 ? this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols() - (this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutCols() - 1) * this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().tileCols() : this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().tileCols();
        int rows = layoutRow == this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutRows() - 1 ? this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows() - (this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutRows() - 1) * this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().tileRows() : this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().tileRows();
        return Dimensions$.MODULE$.apply(cols, rows);
    }

    public static /* synthetic */ int getSegmentSize$(GeoTiffSegmentLayoutTransform $this, int segmentIndex) {
        return $this.getSegmentSize(segmentIndex);
    }

    default public int getSegmentSize(int segmentIndex) {
        Dimensions<Object> dimensions = this.getSegmentDimensions(segmentIndex);
        if (dimensions == null) {
            throw new MatchError(dimensions);
        }
        int cols = dimensions.cols$mcI$sp();
        int rows = dimensions.rows$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(cols, rows);
        Tuple2.mcII.sp sp3 = sp2;
        int cols2 = sp3._1$mcI$sp();
        int rows2 = sp3._2$mcI$sp();
        return cols2 * rows2;
    }

    public static /* synthetic */ int getSegmentIndex$(GeoTiffSegmentLayoutTransform $this, int col, int row) {
        return $this.getSegmentIndex(col, row);
    }

    default public int getSegmentIndex(int col, int row) {
        return this.segmentLayout().getSegmentIndex(col, row);
    }

    public static /* synthetic */ SegmentTransform getSegmentTransform$(GeoTiffSegmentLayoutTransform $this, int segmentIndex) {
        return $this.getSegmentTransform(segmentIndex);
    }

    default public SegmentTransform getSegmentTransform(int segmentIndex) {
        int id = segmentIndex % this.bandSegmentCount();
        return this.segmentLayout().isStriped() ? new StripedSegmentTransform(id, GeoTiffSegmentLayoutTransform$.MODULE$.apply(this.segmentLayout(), this.bandCount())) : new TiledSegmentTransform(id, GeoTiffSegmentLayoutTransform$.MODULE$.apply(this.segmentLayout(), this.bandCount()));
    }

    public static /* synthetic */ Tuple2 getSegmentCoordinate$(GeoTiffSegmentLayoutTransform $this, int segmentIndex) {
        return $this.getSegmentCoordinate(segmentIndex);
    }

    default public Tuple2<Object, Object> getSegmentCoordinate(int segmentIndex) {
        return new Tuple2.mcII.sp(segmentIndex % this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutCols(), segmentIndex / this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutCols());
    }

    public static /* synthetic */ GridBounds getGridBounds$(GeoTiffSegmentLayoutTransform $this, int segmentIndex) {
        return $this.getGridBounds(segmentIndex);
    }

    default public GridBounds<Object> getGridBounds(int segmentIndex) {
        int normalizedSegmentIndex = segmentIndex % this.bandSegmentCount();
        Dimensions<Object> dimensions = this.getSegmentDimensions(segmentIndex);
        if (dimensions == null) {
            throw new MatchError(dimensions);
        }
        int segmentCols = dimensions.cols$mcI$sp();
        int segmentRows = dimensions.rows$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(segmentCols, segmentRows);
        Tuple2.mcII.sp sp3 = sp2;
        int segmentCols2 = sp3._1$mcI$sp();
        int segmentRows2 = sp3._2$mcI$sp();
        Tuple2<Object, Object> tuple22 = this.getSegmentCoordinate(normalizedSegmentIndex);
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        int layoutCol = tuple22._1$mcI$sp();
        int layoutRow = tuple22._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(layoutCol, layoutRow);
        Tuple2.mcII.sp sp5 = sp4;
        int layoutCol2 = sp5._1$mcI$sp();
        int layoutRow2 = sp5._2$mcI$sp();
        Tuple2.mcII.sp sp6 = new Tuple2.mcII.sp(layoutCol2 * this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().tileCols(), layoutRow2 * this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().tileRows());
        if (sp6 == null) {
            throw new MatchError((Object)sp6);
        }
        int startCol = sp6._1$mcI$sp();
        int startRow = sp6._2$mcI$sp();
        Tuple2.mcII.sp sp7 = new Tuple2.mcII.sp(startCol, startRow);
        Tuple2.mcII.sp sp8 = sp7;
        int startCol2 = sp8._1$mcI$sp();
        int startRow2 = sp8._2$mcI$sp();
        int endCol = startCol2 + segmentCols2 - 1;
        int endRow = startRow2 + segmentRows2 - 1;
        return GridBounds$.MODULE$.apply(startCol2, startRow2, endCol, endRow);
    }

    public static /* synthetic */ int[] getIntersectingSegments$(GeoTiffSegmentLayoutTransform $this, GridBounds bounds) {
        return $this.getIntersectingSegments(bounds);
    }

    default public int[] getIntersectingSegments(GridBounds<Object> bounds) {
        int[] nArray;
        boolean intersects;
        int colMax = this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols() - 1;
        int rowMax = this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows() - 1;
        boolean bl = intersects = colMax >= bounds.colMin$mcI$sp() && bounds.colMax$mcI$sp() >= 0 && rowMax >= bounds.rowMin$mcI$sp() && bounds.rowMax$mcI$sp() >= 0;
        if (intersects) {
            int tc = this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().tileCols();
            int tr = this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().tileRows();
            int colMin = package$.MODULE$.max(0, bounds.colMin$mcI$sp());
            int rowMin = package$.MODULE$.max(0, bounds.rowMin$mcI$sp());
            int colMax2 = package$.MODULE$.min(this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols() - 1, bounds.colMax$mcI$sp());
            int rowMax2 = package$.MODULE$.min(this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows() - 1, bounds.rowMax$mcI$sp());
            ArrayBuilder ab = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
            for (int index$macro$2 = colMin / tc; index$macro$2 <= colMax2 / tc; ++index$macro$2) {
                for (int index$macro$1 = rowMin / tr; index$macro$1 <= rowMax2 / tr; ++index$macro$1) {
                    ab.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(index$macro$1 * this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutCols() + index$macro$2)));
                }
            }
            nArray = (int[])ab.result();
        } else {
            nArray = (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int());
        }
        return nArray;
    }

    public static /* synthetic */ GridBounds[][] partitionWindowsBySegments$(GeoTiffSegmentLayoutTransform $this, Seq windows, long maxPartitionSize) {
        return $this.partitionWindowsBySegments((Seq<GridBounds<Object>>)windows, maxPartitionSize);
    }

    default public GridBounds<Object>[][] partitionWindowsBySegments(Seq<GridBounds<Object>> windows, long maxPartitionSize) {
        return this.segmentLayout().partitionWindowsBySegments(windows, maxPartitionSize);
    }

    public static /* synthetic */ Tuple2[] getIntersectingSegments$(GeoTiffSegmentLayoutTransform $this, GridBounds bounds, int[] bands) {
        return $this.getIntersectingSegments(bounds, bands);
    }

    default public Tuple2<Object, Object>[] getIntersectingSegments(GridBounds<Object> bounds, int[] bands) {
        int[] firstBandSegments = this.getIntersectingSegments(bounds);
        return (Tuple2[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(bands)).flatMap((Function1 & Serializable & scala.Serializable)band -> new ArrayOps.ofRef(GeoTiffSegmentLayoutTransform.$anonfun$getIntersectingSegments$1(this, firstBandSegments, BoxesRunTime.unboxToInt((Object)band))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public static /* synthetic */ Tuple2 $anonfun$getIntersectingSegments$2(int band$1, int segmentOffset$1, int i) {
        return new Tuple2.mcII.sp(band$1, i + segmentOffset$1);
    }

    public static /* synthetic */ Object[] $anonfun$getIntersectingSegments$1(GeoTiffSegmentLayoutTransform $this, int[] firstBandSegments$1, int band) {
        int segmentOffset = $this.bandSegmentCount() * band;
        return Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(firstBandSegments$1)).map((Function1 & Serializable & scala.Serializable)i -> GeoTiffSegmentLayoutTransform.$anonfun$getIntersectingSegments$2(band, segmentOffset, BoxesRunTime.unboxToInt((Object)i)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))));
    }

    public static void $init$(GeoTiffSegmentLayoutTransform $this) {
    }
}

