/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.vector.triangulation;

import geotrellis.util.Constants$;
import geotrellis.vector.RobustPredicates$;
import geotrellis.vector.ShewchuksDeterminant;
import geotrellis.vector.mesh.HalfEdgeTable;
import geotrellis.vector.mesh.IndexedPointSet;
import org.locationtech.jts.geom.Coordinate;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001\u0002\t\u0012\u0005aA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!)Q\u0006\u0001C\u0001]!)1\u0007\u0001C\u0001i!)1\u0007\u0001C\u0001\u0003\")a\t\u0001C\u0001\u000f\")!\n\u0001C\u0001\u0017\")a\n\u0001C\u0001\u001f\")1\u000b\u0001C\u0001)\")\u0001\f\u0001C\u00013\")A\f\u0001C\u0001;\")\u0001\r\u0001C\u0001C\")!\u000e\u0001C\u0001W\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\u0005\u0001\u0011\u0005\u00111\u0002\u0002\u0018)JL\u0017M\\4vY\u0006$\u0018n\u001c8Qe\u0016$\u0017nY1uKNT!AE\n\u0002\u001bQ\u0014\u0018.\u00198hk2\fG/[8o\u0015\t!R#\u0001\u0004wK\u000e$xN\u001d\u0006\u0002-\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0019\u0001!G\u0010\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g!\tQ\u0002%\u0003\u0002\"7\ta1+\u001a:jC2L'0\u00192mK\u0006A\u0001o\\5oiN+G\u000f\u0005\u0002%O5\tQE\u0003\u0002''\u0005!Q.Z:i\u0013\tASEA\bJ]\u0012,\u00070\u001a3Q_&tGoU3u\u00035A\u0017\r\u001c4FI\u001e,G+\u00192mKB\u0011AeK\u0005\u0003Y\u0015\u0012Q\u0002S1mM\u0016#w-\u001a+bE2,\u0017A\u0002\u001fj]&$h\bF\u00020cI\u0002\"\u0001\r\u0001\u000e\u0003EAQAI\u0002A\u0002\rBQ!K\u0002A\u0002)\n1\"[:D_2d\u0017N\\3beR!Q\u0007O\u001f@!\tQb'\u0003\u000287\t9!i\\8mK\u0006t\u0007\"B\u001d\u0005\u0001\u0004Q\u0014!A1\u0011\u0005iY\u0014B\u0001\u001f\u001c\u0005\rIe\u000e\u001e\u0005\u0006}\u0011\u0001\rAO\u0001\u0002E\")\u0001\t\u0002a\u0001u\u0005\t1\rF\u00026\u0005\u0012CQaQ\u0003A\u0002i\n\u0011!\u001a\u0005\u0006\u000b\u0016\u0001\rAO\u0001\u0002m\u0006QAm\\3t\u000bb$XM\u001c3\u0015\u0007UB\u0015\nC\u0003D\r\u0001\u0007!\bC\u0003F\r\u0001\u0007!(\u0001\u0005jg\u000e{'O\\3s)\t)D\nC\u0003N\u000f\u0001\u0007!(\u0001\u0003fI\u001e,\u0017A\u0003:fY\u0006$\u0018N^3U_R\u0019!\bU)\t\u000b\rC\u0001\u0019\u0001\u001e\t\u000bIC\u0001\u0019\u0001\u001e\u0002\u0003A\fQ![:D\u0007^#B!N+W/\")\u0011(\u0003a\u0001u!)a(\u0003a\u0001u!)\u0001)\u0003a\u0001u\u0005I\u0011n\u001d*jO\"$xJ\u001a\u000b\u0004ki[\u0006\"B\"\u000b\u0001\u0004Q\u0004\"\u0002*\u000b\u0001\u0004Q\u0014\u0001C5t\u0019\u00164Go\u00144\u0015\u0007Urv\fC\u0003D\u0017\u0001\u0007!\bC\u0003S\u0017\u0001\u0007!(\u0001\u0005j]\u000eK'o\u00197f)\u0015)$\r\u001a4i\u0011\u0015\u0019G\u00021\u0001;\u0003\t\t\u0017\u000eC\u0003f\u0019\u0001\u0007!(\u0001\u0002cS\")q\r\u0004a\u0001u\u0005\u00111-\u001b\u0005\u0006S2\u0001\rAO\u0001\u0003I&\fAbY5sG2,7)\u001a8uKJ$R\u0001\u001c@\u0000\u0003\u0003\u0001RAG7peVJ!A\\\u000e\u0003\rQ+\b\u000f\\34!\tQ\u0002/\u0003\u0002r7\t1Ai\\;cY\u0016\u0004\"a\u001d?\u000e\u0003QT!!\u001e<\u0002\t\u001d,w.\u001c\u0006\u0003ob\f1A\u001b;t\u0015\tI(0\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001|\u0003\ry'oZ\u0005\u0003{R\u0014!bQ8pe\u0012Lg.\u0019;f\u0011\u0015\u0019W\u00021\u0001;\u0011\u0015)W\u00021\u0001;\u0011\u00159W\u00021\u0001;\u00039I7\u000fR3mCVt\u0017-_#eO\u0016$2!NA\u0004\u0011\u0015\u0019e\u00021\u0001;\u0003AI7oQ8om\u0016D(i\\;oI\u0006\u0014\u0018\u0010F\u00026\u0003\u001bAa!a\u0004\u0010\u0001\u0004Q\u0014AA31\u0001")
public final class TriangulationPredicates
implements Serializable {
    private final IndexedPointSet pointSet;
    private final HalfEdgeTable halfEdgeTable;

    public boolean isCollinear(int a, int b, int c) {
        return package$.MODULE$.abs(ShewchuksDeterminant.orient2d(this.pointSet.getX(a), this.pointSet.getY(a), this.pointSet.getX(b), this.pointSet.getY(b), this.pointSet.getX(c), this.pointSet.getY(c))) < Constants$.MODULE$.DOUBLE_EPSILON();
    }

    public boolean isCollinear(int e, int v) {
        return this.isCollinear(this.halfEdgeTable.getSrc(e), this.halfEdgeTable.getDest(e), v);
    }

    public boolean doesExtend(int e, int v) {
        double d2;
        int a = this.halfEdgeTable.getSrc(e);
        double ax = this.pointSet.getX(a);
        double ay = this.pointSet.getY(a);
        int b = this.halfEdgeTable.getDest(e);
        double bx = this.pointSet.getX(b);
        double by = this.pointSet.getY(b);
        double cx = this.pointSet.getX(v);
        double cy = this.pointSet.getY(v);
        double d1 = package$.MODULE$.pow(ax - bx, 2.0) + package$.MODULE$.pow(ay - by, 2.0);
        return d1 < (d2 = package$.MODULE$.pow(ax - cx, 2.0) + package$.MODULE$.pow(ay - cy, 2.0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCorner(int edge) {
        if (!this.isCollinear(edge, this.halfEdgeTable.getSrc(this.halfEdgeTable.getPrev(edge)))) return true;
        int c = this.halfEdgeTable.getSrc(edge);
        double cx = this.pointSet.getX(c);
        double cy = this.pointSet.getY(c);
        int n = this.halfEdgeTable.getDest(edge);
        double nx = this.pointSet.getX(n);
        double ny = this.pointSet.getY(n);
        int p = this.halfEdgeTable.getSrc(this.halfEdgeTable.getPrev(edge));
        double px = this.pointSet.getX(p);
        double py = this.pointSet.getY(p);
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(nx - cx, ny - cy);
        if (sp2 == null) throw new MatchError((Object)sp2);
        double xn = sp2._1$mcD$sp();
        double yn = sp2._2$mcD$sp();
        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(xn, yn);
        Tuple2.mcDD.sp sp4 = sp3;
        double xn2 = sp4._1$mcD$sp();
        double yn2 = sp4._2$mcD$sp();
        Tuple2.mcDD.sp sp5 = new Tuple2.mcDD.sp(px - cx, py - cy);
        if (sp5 == null) throw new MatchError((Object)sp5);
        double xp = sp5._1$mcD$sp();
        double yp = sp5._2$mcD$sp();
        Tuple2.mcDD.sp sp6 = new Tuple2.mcDD.sp(xp, yp);
        Tuple2.mcDD.sp sp7 = sp6;
        double xp2 = sp7._1$mcD$sp();
        double yp2 = sp7._2$mcD$sp();
        if (!(xn2 * xp2 + yn2 * yp2 > 0.0)) return false;
        return true;
    }

    public int relativeTo(int e, int p) {
        int e0 = this.halfEdgeTable.getSrc(e);
        double e0x = this.pointSet.getX(e0);
        double e0y = this.pointSet.getY(e0);
        int e1 = this.halfEdgeTable.getDest(e);
        double e1x = this.pointSet.getX(e1);
        double e1y = this.pointSet.getY(e1);
        double ptx = this.pointSet.getX(p);
        double pty = this.pointSet.getY(p);
        return RobustPredicates$.MODULE$.relativeTo(e0x, e0y, e1x, e1y, ptx, pty);
    }

    public boolean isCCW(int a, int b, int c) {
        double ax = this.pointSet.getX(a);
        double ay = this.pointSet.getY(a);
        double bx = this.pointSet.getX(b);
        double by = this.pointSet.getY(b);
        double cx = this.pointSet.getX(c);
        double cy = this.pointSet.getY(c);
        return RobustPredicates$.MODULE$.isCCW(ax, ay, bx, by, cx, cy);
    }

    public boolean isRightOf(int e, int p) {
        double px = this.pointSet.getX(p);
        double py = this.pointSet.getY(p);
        int b = this.halfEdgeTable.getDest(e);
        double bx = this.pointSet.getX(b);
        double by = this.pointSet.getY(b);
        int c = this.halfEdgeTable.getSrc(e);
        double cx = this.pointSet.getX(c);
        double cy = this.pointSet.getY(c);
        return RobustPredicates$.MODULE$.isCCW(px, py, bx, by, cx, cy);
    }

    public boolean isLeftOf(int e, int p) {
        double px = this.pointSet.getX(p);
        double py = this.pointSet.getY(p);
        int b = this.halfEdgeTable.getSrc(e);
        double bx = this.pointSet.getX(b);
        double by = this.pointSet.getY(b);
        int c = this.halfEdgeTable.getDest(e);
        double cx = this.pointSet.getX(c);
        double cy = this.pointSet.getY(c);
        return RobustPredicates$.MODULE$.isCCW(px, py, bx, by, cx, cy);
    }

    public boolean inCircle(int ai, int bi, int ci, int di) {
        double ax = this.pointSet.getX(ai);
        double ay = this.pointSet.getY(ai);
        double bx = this.pointSet.getX(bi);
        double by = this.pointSet.getY(bi);
        double cx = this.pointSet.getX(ci);
        double cy = this.pointSet.getY(ci);
        double dx = this.pointSet.getX(di);
        double dy = this.pointSet.getY(di);
        return RobustPredicates$.MODULE$.inCircle(ax, ay, bx, by, cx, cy, dx, dy);
    }

    public Tuple3<Object, Coordinate, Object> circleCenter(int ai, int bi, int ci) {
        double ax = this.pointSet.getX(ai);
        double ay = this.pointSet.getY(ai);
        double bx = this.pointSet.getX(bi);
        double by = this.pointSet.getY(bi);
        double cx = this.pointSet.getX(ci);
        double cy = this.pointSet.getY(ci);
        return RobustPredicates$.MODULE$.circleCenter(ax, ay, bx, by, cx, cy);
    }

    public boolean isDelaunayEdge(int e) {
        int y;
        int a = this.halfEdgeTable.getDest(this.halfEdgeTable.getNext(e));
        int b = this.halfEdgeTable.getDest(this.halfEdgeTable.getNext(this.halfEdgeTable.getFlip(e)));
        int x = this.halfEdgeTable.getDest(this.halfEdgeTable.getFlip(e));
        return !this.inCircle(a, x, y = this.halfEdgeTable.getDest(e), b);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isConvexBoundary(int e0) {
        void var3_3;
        int e = e0;
        boolean valid = true;
        do {
            valid = valid && !this.isLeftOf(e, this.halfEdgeTable.getDest(this.halfEdgeTable.getNext(e)));
            e = this.halfEdgeTable.getNext(e);
        } while (valid && e != e0);
        return (boolean)var3_3;
    }

    public TriangulationPredicates(IndexedPointSet pointSet, HalfEdgeTable halfEdgeTable) {
        this.pointSet = pointSet;
        this.halfEdgeTable = halfEdgeTable;
    }
}

