/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal.hillshade;

import geotrellis.raster.CellSize;
import geotrellis.raster.GridBounds;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.FocalCalculation;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import geotrellis.raster.mapalgebra.focal.TargetCell;
import geotrellis.raster.mapalgebra.focal.TargetCell$All$;
import geotrellis.raster.mapalgebra.focal.TargetCell$Data$;
import geotrellis.raster.mapalgebra.focal.TargetCell$NoData$;
import geotrellis.raster.mapalgebra.focal.hillshade.SurfacePoint;
import geotrellis.raster.mapalgebra.focal.hillshade.SurfacePointCalculation$;
import scala.MatchError;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005}e!\u0002\u0015*\u0003\u0003!\u0004\"\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B%N\u0011!q\u0005A!A!\u0002\u0013y\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u0011q\u0003!Q1A\u0005\u0002uC\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\nE\u0002\u0011\t\u0011)A\u0005G\u001aDQa\u001a\u0001\u0005\u0002!4q\u0001\u001d\u0001\u0011\u0002G%\u0011\u000fC\u0003v\u0011\u0019\u0005a\u000fC\u0005\u0002\b\u0001\u0001\r\u0011\"\u0001\u0002\n!I\u00111\u0002\u0001A\u0002\u0013\u0005\u0011Q\u0002\u0005\b\u0003'\u0001\u0001\u0015)\u0003Z\u0011%\t)\u0002\u0001a\u0001\n\u0003\t9\u0002C\u0005\u0002\u001a\u0001\u0001\r\u0011\"\u0001\u0002\u001c!9\u0011q\u0004\u0001!B\u0013a\b\"CA\u0011\u0001\u0001\u0007I\u0011AA\f\u0011%\t\u0019\u0003\u0001a\u0001\n\u0003\t)\u0003C\u0004\u0002*\u0001\u0001\u000b\u0015\u0002?\t\u0013\u0005-\u0002\u00011A\u0005\u0002\u00055\u0002\"CA\u001b\u0001\u0001\u0007I\u0011AA\u001c\u0011!\tY\u0004\u0001Q!\n\u0005=\u0002\"CA\u001f\u0001\u0001\u0007I\u0011AA\u0017\u0011%\ty\u0004\u0001a\u0001\n\u0003\t\t\u0005\u0003\u0005\u0002F\u0001\u0001\u000b\u0015BA\u0018\u0011%\t9\u0005\u0001a\u0001\n\u0003\ti\u0003C\u0005\u0002J\u0001\u0001\r\u0011\"\u0001\u0002L!A\u0011q\n\u0001!B\u0013\ty\u0003C\u0005\u0002R\u0001\u0011\r\u0011\"\u0001\u0002T!A\u00111\f\u0001!\u0002\u0013\t)\u0006C\u0004\u0002^\u00011\t!a\u0018\t\u0013\u0005\u001d\u0004A1A\u0005\n\u0005%\u0004\u0002CA8\u0001\u0001\u0006I!a\u001b\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t!9\u0011Q\u000f\u0001\u0005\u0012\u0005M\u0004bBA<\u0001\u0011\u0005\u0011\u0011P\u0004\n\u0003wJ\u0013\u0011!E\u0001\u0003{2\u0001\u0002K\u0015\u0002\u0002#\u0005\u0011q\u0010\u0005\u0007O\u0016\"\t!!!\t\u0013\u0005\rU%%A\u0005\u0002\u0005\u0015%aF*ve\u001a\f7-\u001a)pS:$8)\u00197dk2\fG/[8o\u0015\tQ3&A\u0005iS2d7\u000f[1eK*\u0011A&L\u0001\u0006M>\u001c\u0017\r\u001c\u0006\u0003]=\n!\"\\1qC2<WM\u0019:b\u0015\t\u0001\u0014'\u0001\u0004sCN$XM\u001d\u0006\u0002e\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001U\u0011Q\u0007P\n\u0003\u0001Y\u00022a\u000e\u001d;\u001b\u0005Y\u0013BA\u001d,\u0005A1unY1m\u0007\u0006d7-\u001e7bi&|g\u000e\u0005\u0002<y1\u0001A!B\u001f\u0001\u0005\u0004q$!\u0001+\u0012\u0005}*\u0005C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%a\u0002(pi\"Lgn\u001a\t\u0003\u0001\u001aK!aR!\u0003\u0007\u0005s\u00170A\u0001s!\tQ5*D\u00010\u0013\tauF\u0001\u0003US2,\u0017B\u0001%9\u0003\u0005q\u0007CA\u001cQ\u0013\t\t6F\u0001\u0007OK&<\u0007NY8sQ>|G-\u0001\u0007b]\u0006d\u0017p]5t\u0003J,\u0017\rE\u0002A)ZK!!V!\u0003\r=\u0003H/[8o!\rQu+W\u0005\u00031>\u0012!b\u0012:jI\n{WO\u001c3t!\t\u0001%,\u0003\u0002\\\u0003\n\u0019\u0011J\u001c;\u0002\u0011\r,G\u000e\\*ju\u0016,\u0012A\u0018\t\u0003\u0015~K!\u0001Y\u0018\u0003\u0011\r+G\u000e\\*ju\u0016\f\u0011bY3mYNK'0\u001a\u0011\u0002\rQ\f'oZ3u!\t9D-\u0003\u0002fW\tQA+\u0019:hKR\u001cU\r\u001c7\n\u0005\tD\u0014A\u0002\u001fj]&$h\b\u0006\u0004jW2lgn\u001c\t\u0004U\u0002QT\"A\u0015\t\u000b!;\u0001\u0019A%\t\u000b9;\u0001\u0019A(\t\u000bI;\u0001\u0019A*\t\u000bq;\u0001\u0019\u00010\t\u000f\t<\u0001\u0013!a\u0001G\nA1+\u001a;WC2,Xm\u0005\u0002\teB\u0011\u0001i]\u0005\u0003i\u0006\u0013a!\u00118z%\u00164\u0017!B1qa2LH#B<{\u007f\u0006\r\u0001C\u0001!y\u0013\tI\u0018I\u0001\u0003V]&$\b\"B>\n\u0001\u0004a\u0018!\u0001>\u0011\u0005\u0001k\u0018B\u0001@B\u0005\u0019!u.\u001e2mK\"1\u0011\u0011A\u0005A\u0002e\u000b\u0011\u0001\u001f\u0005\u0007\u0003\u000bI\u0001\u0019A-\u0002\u0003e\fQ\u0001\\1tif+\u0012!W\u0001\nY\u0006\u001cH/W0%KF$2a^A\b\u0011!\t\tbCA\u0001\u0002\u0004I\u0016a\u0001=%c\u00051A.Y:u3\u0002\n\u0011bY3mY^KG\r\u001e5\u0016\u0003q\fQbY3mY^KG\r\u001e5`I\u0015\fHcA<\u0002\u001e!A\u0011\u0011\u0003\b\u0002\u0002\u0003\u0007A0\u0001\u0006dK2dw+\u001b3uQ\u0002\n!bY3mY\"+\u0017n\u001a5u\u00039\u0019W\r\u001c7IK&<\u0007\u000e^0%KF$2a^A\u0014\u0011!\t\t\"EA\u0001\u0002\u0004a\u0018aC2fY2DU-[4ii\u0002\nAa^3tiV\u0011\u0011q\u0006\t\u0005\u0001\u0006EB0C\u0002\u00024\u0005\u0013Q!\u0011:sCf\f\u0001b^3ti~#S-\u001d\u000b\u0004o\u0006e\u0002\"CA\t)\u0005\u0005\t\u0019AA\u0018\u0003\u00159Xm\u001d;!\u0003\u0011\u0011\u0017m]3\u0002\u0011\t\f7/Z0%KF$2a^A\"\u0011%\t\tbFA\u0001\u0002\u0004\ty#A\u0003cCN,\u0007%\u0001\u0003fCN$\u0018\u0001C3bgR|F%Z9\u0015\u0007]\fi\u0005C\u0005\u0002\u0012i\t\t\u00111\u0001\u00020\u0005)Q-Y:uA\u0005\t1/\u0006\u0002\u0002VA\u0019!.a\u0016\n\u0007\u0005e\u0013F\u0001\u0007TkJ4\u0017mY3Q_&tG/\u0001\u0002tA\u0005A1/\u001a;WC2,X\rF\u0004x\u0003C\n\u0019'!\u001a\t\r\u0005\u0005a\u00041\u0001Z\u0011\u0019\t)A\ba\u00013\"9\u0011\u0011\u000b\u0010A\u0002\u0005U\u0013!C0tKR4\u0016\r\\;f+\t\tY\u0007E\u0002\u0002n!i\u0011\u0001A\u0001\u000b?N,GOV1mk\u0016\u0004\u0013!C7pm\u0016\u0014\u0016n\u001a5u)\u00059\u0018aC2bY\u000e\u001cVO\u001d4bG\u0016\fq!\u001a=fGV$X\rF\u0001;\u0003]\u0019VO\u001d4bG\u0016\u0004v.\u001b8u\u0007\u0006d7-\u001e7bi&|g\u000e\u0005\u0002kKM\u0011QE\u001d\u000b\u0003\u0003{\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*T\u0003BAD\u0003;+\"!!#+\u0007\r\fYi\u000b\u0002\u0002\u000eB!\u0011qRAM\u001b\t\t\tJ\u0003\u0003\u0002\u0014\u0006U\u0015!C;oG\",7m[3e\u0015\r\t9*Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAN\u0003#\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0015itE1\u0001?\u0001")
public abstract class SurfacePointCalculation<T>
extends FocalCalculation<T> {
    private final CellSize cellSize;
    private int lastY;
    private double cellWidth;
    private double cellHeight;
    private double[] west;
    private double[] base;
    private double[] east;
    private final SurfacePoint s;
    private final SetValue _setValue;

    public static <T> TargetCell $lessinit$greater$default$5() {
        return SurfacePointCalculation$.MODULE$.$lessinit$greater$default$5();
    }

    public CellSize cellSize() {
        return this.cellSize;
    }

    public int lastY() {
        return this.lastY;
    }

    public void lastY_$eq(int x$1) {
        this.lastY = x$1;
    }

    public double cellWidth() {
        return this.cellWidth;
    }

    public void cellWidth_$eq(double x$1) {
        this.cellWidth = x$1;
    }

    public double cellHeight() {
        return this.cellHeight;
    }

    public void cellHeight_$eq(double x$1) {
        this.cellHeight = x$1;
    }

    public double[] west() {
        return this.west;
    }

    public void west_$eq(double[] x$1) {
        this.west = x$1;
    }

    public double[] base() {
        return this.base;
    }

    public void base_$eq(double[] x$1) {
        this.base = x$1;
    }

    public double[] east() {
        return this.east;
    }

    public void east_$eq(double[] x$1) {
        this.east = x$1;
    }

    public SurfacePoint s() {
        return this.s;
    }

    public abstract void setValue(int var1, int var2, SurfacePoint var3);

    private SetValue _setValue() {
        return this._setValue;
    }

    public void moveRight() {
        double[] tmp = this.west();
        this.west_$eq(this.base());
        this.base_$eq(this.east());
        this.east_$eq(tmp);
    }

    public void calcSurface() {
        if (Double.isNaN(this.base()[1])) {
            this.s().dz$divdx_$eq(Double.NaN);
            this.s().dz$divdy_$eq(Double.NaN);
        } else {
            double neValue = !Double.isNaN(this.east()[0]) ? this.east()[0] : this.base()[1];
            double eValue = !Double.isNaN(this.east()[1]) ? this.east()[1] : this.base()[1];
            double seValue = !Double.isNaN(this.east()[2]) ? this.east()[2] : this.base()[1];
            double nValue = !Double.isNaN(this.base()[0]) ? this.base()[0] : this.base()[1];
            double sValue = !Double.isNaN(this.base()[2]) ? this.base()[2] : this.base()[1];
            double nwValue = !Double.isNaN(this.west()[0]) ? this.west()[0] : this.base()[1];
            double wValue = !Double.isNaN(this.west()[1]) ? this.west()[1] : this.base()[1];
            double swValue = !Double.isNaN(this.west()[2]) ? this.west()[2] : this.base()[1];
            this.s().dz$divdx_$eq((neValue + (double)2 * eValue + seValue - nwValue - (double)2 * wValue - swValue) / ((double)8 * this.cellWidth()));
            this.s().dz$divdy_$eq((swValue + (double)2 * sValue + seValue - nwValue - (double)2 * nValue - neValue) / ((double)8 * this.cellHeight()));
        }
    }

    @Override
    public T execute() {
        int row;
        int col;
        int colMin = this.bounds().colMin$mcI$sp();
        int colMax = this.bounds().colMax$mcI$sp();
        int rowMin = this.bounds().rowMin$mcI$sp();
        int rowMax = this.bounds().rowMax$mcI$sp();
        int colBorderMax = super.r().cols$mcI$sp() - 1;
        int rowBorderMax = super.r().rows$mcI$sp() - 1;
        this.cellWidth_$eq(this.cellSize().width());
        this.cellHeight_$eq(this.cellSize().height());
        if (colBorderMax < 2 || rowBorderMax < 2) {
            throw package$.MODULE$.error(new StringBuilder(45).append("Tile is too small to get surface values. (").append(colBorderMax).append(", ").append(rowBorderMax).append(")").toString());
        }
        double focalValue = super.r().getDouble(colMin, rowMin);
        this.west()[0] = this.getValSafe$1(colMin - 1, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
        this.west()[1] = this.getValSafe$1(colMin - 1, rowMin, focalValue, colBorderMax, rowBorderMax);
        this.west()[2] = this.getValSafe$1(colMin - 1, rowMin + 1, focalValue, colBorderMax, rowBorderMax);
        this.base()[0] = this.getValSafe$1(colMin, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
        this.base()[1] = focalValue;
        this.base()[2] = super.r().getDouble(colMin, rowMin + 1);
        this.east()[0] = this.getValSafe$1(colMin + 1, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
        this.east()[1] = super.r().getDouble(colMin + 1, rowMin);
        this.east()[2] = super.r().getDouble(colMin + 1, rowMin + 1);
        this._setValue().apply(focalValue, 0, 0);
        for (col = colMin + 1; col < colMax; ++col) {
            this.moveRight();
            focalValue = super.r().getDouble(col, rowMin);
            this.west()[0] = this.getValSafe$1(col - 1, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
            this.base()[0] = this.getValSafe$1(col, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
            this.east()[0] = this.getValSafe$1(col + 1, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
            this.east()[1] = super.r().getDouble(col + 1, rowMin);
            this.east()[2] = super.r().getDouble(col + 1, rowMin + 1);
            this._setValue().apply(focalValue, col - colMin, 0);
        }
        this.moveRight();
        focalValue = super.r().getDouble(col, rowMin);
        this.west()[0] = this.getValSafe$1(col - 1, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
        this.base()[0] = this.getValSafe$1(col, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
        this.east()[0] = this.getValSafe$1(col + 1, rowMin - 1, focalValue, colBorderMax, rowBorderMax);
        this.east()[1] = this.getValSafe$1(col + 1, rowMin, focalValue, colBorderMax, rowBorderMax);
        this.east()[2] = this.getValSafe$1(col + 1, rowMin + 1, focalValue, colBorderMax, rowBorderMax);
        this._setValue().apply(focalValue, col - colMin, 0);
        for (row = rowMin + 1; row < rowMax; ++row) {
            focalValue = super.r().getDouble(colMin, row);
            this.west()[0] = this.getValSafe$1(colMin - 1, row - 1, focalValue, colBorderMax, rowBorderMax);
            this.west()[1] = this.getValSafe$1(colMin - 1, row, focalValue, colBorderMax, rowBorderMax);
            this.west()[2] = this.getValSafe$1(colMin - 1, row + 1, focalValue, colBorderMax, rowBorderMax);
            this.base()[0] = super.r().getDouble(colMin, row - 1);
            this.base()[1] = focalValue;
            this.base()[2] = super.r().getDouble(colMin, row + 1);
            this.east()[0] = super.r().getDouble(colMin + 1, row - 1);
            this.east()[1] = super.r().getDouble(colMin + 1, row);
            this.east()[2] = super.r().getDouble(colMin + 1, row + 1);
            this._setValue().apply(focalValue, 0, row - rowMin);
            for (col = colMin + 1; col < colMax; ++col) {
                this.moveRight();
                focalValue = super.r().getDouble(col, row);
                this.east()[0] = super.r().getDouble(col + 1, row - 1);
                this.east()[1] = super.r().getDouble(col + 1, row);
                this.east()[2] = super.r().getDouble(col + 1, row + 1);
                this._setValue().apply(focalValue, col - colMin, row - rowMin);
            }
            this.moveRight();
            focalValue = super.r().getDouble(col, row);
            this.east()[0] = this.getValSafe$1(col + 1, row - 1, focalValue, colBorderMax, rowBorderMax);
            this.east()[1] = this.getValSafe$1(col + 1, row, focalValue, colBorderMax, rowBorderMax);
            this.east()[2] = this.getValSafe$1(col + 1, row + 1, focalValue, colBorderMax, rowBorderMax);
            this._setValue().apply(focalValue, col - colMin, row - rowMin);
        }
        focalValue = super.r().getDouble(colMin, row);
        this.west()[0] = this.getValSafe$1(colMin - 1, row - 1, focalValue, colBorderMax, rowBorderMax);
        this.west()[1] = this.getValSafe$1(colMin - 1, row, focalValue, colBorderMax, rowBorderMax);
        this.west()[2] = this.getValSafe$1(colMin - 1, row + 1, focalValue, colBorderMax, rowBorderMax);
        this.base()[0] = super.r().getDouble(colMin, row - 1);
        this.base()[1] = focalValue;
        this.base()[2] = this.getValSafe$1(colMin, row + 1, focalValue, colBorderMax, rowBorderMax);
        this.east()[0] = super.r().getDouble(colMin + 1, row - 1);
        this.east()[1] = super.r().getDouble(colMin + 1, row);
        this.east()[2] = this.getValSafe$1(colMin + 1, row + 1, focalValue, colBorderMax, rowBorderMax);
        this._setValue().apply(focalValue, 0, row - rowMin);
        for (col = colMin + 1; col < colMax; ++col) {
            this.moveRight();
            focalValue = super.r().getDouble(col, row);
            this.west()[2] = this.getValSafe$1(col - 1, row + 1, focalValue, colBorderMax, rowBorderMax);
            this.base()[2] = this.getValSafe$1(col, row + 1, focalValue, colBorderMax, rowBorderMax);
            this.east()[0] = super.r().getDouble(col + 1, row - 1);
            this.east()[1] = super.r().getDouble(col + 1, row);
            this.east()[2] = this.getValSafe$1(col + 1, row + 1, focalValue, colBorderMax, rowBorderMax);
            this._setValue().apply(focalValue, col - colMin, row - rowMin);
        }
        this.moveRight();
        focalValue = super.r().getDouble(col, row);
        this.west()[2] = this.getValSafe$1(col - 1, row + 1, focalValue, colBorderMax, rowBorderMax);
        this.base()[2] = this.getValSafe$1(col, row + 1, focalValue, colBorderMax, rowBorderMax);
        this.east()[0] = this.getValSafe$1(col + 1, row - 1, focalValue, colBorderMax, rowBorderMax);
        this.east()[1] = this.getValSafe$1(col + 1, row, focalValue, colBorderMax, rowBorderMax);
        this.east()[2] = this.getValSafe$1(col + 1, row + 1, focalValue, colBorderMax, rowBorderMax);
        this._setValue().apply(focalValue, col - colMin, row - rowMin);
        return this.result();
    }

    private final double getValSafe$1(int col, int row, double focalVal, int colBorderMax$1, int rowBorderMax$1) {
        return col < 0 || colBorderMax$1 < col || row < 0 || rowBorderMax$1 < row ? focalVal : super.r().getDouble(col, row);
    }

    public SurfacePointCalculation(Tile r, Neighborhood n, Option<GridBounds<Object>> analysisArea, CellSize cellSize, TargetCell target) {
        SetValue setValue;
        this.cellSize = cellSize;
        super(r, n, analysisArea, target);
        this.lastY = -1;
        this.cellWidth = 0.0;
        this.cellHeight = 0.0;
        this.west = new double[3];
        this.base = new double[3];
        this.east = new double[3];
        this.s = new SurfacePoint();
        TargetCell targetCell = super.target();
        if (TargetCell$All$.MODULE$.equals(targetCell)) {
            setValue = new SetValue(this){
                private final /* synthetic */ SurfacePointCalculation $outer;

                public void apply(double z, int x, int y) {
                    this.$outer.calcSurface();
                    this.$outer.setValue(x, y, this.$outer.s());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        } else if (TargetCell$Data$.MODULE$.equals(targetCell)) {
            setValue = new SetValue(this){
                private final /* synthetic */ SurfacePointCalculation $outer;

                public void apply(double z, int x, int y) {
                    block0: {
                        if (Double.isNaN(z)) break block0;
                        this.$outer.calcSurface();
                        this.$outer.setValue(x, y, this.$outer.s());
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        } else if (TargetCell$NoData$.MODULE$.equals(targetCell)) {
            setValue = new SetValue(this){
                private final /* synthetic */ SurfacePointCalculation $outer;

                public void apply(double z, int x, int y) {
                    block0: {
                        if (!Double.isNaN(z)) break block0;
                        this.$outer.calcSurface();
                        this.$outer.setValue(x, y, this.$outer.s());
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        } else {
            throw new MatchError((Object)targetCell);
        }
        this._setValue = setValue;
    }

    private interface SetValue {
        public void apply(double var1, int var3, int var4);
    }
}

