/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.resample;

import geotrellis.raster.RasterExtent;
import geotrellis.raster.resample.ArrayResampleAssign;
import geotrellis.raster.resample.ArrayResampleAssign$mcB$sp;
import geotrellis.raster.resample.ArrayResampleAssign$mcD$sp;
import geotrellis.raster.resample.ArrayResampleAssign$mcF$sp;
import geotrellis.raster.resample.ArrayResampleAssign$mcI$sp;
import geotrellis.raster.resample.ArrayResampleAssign$mcS$sp;
import geotrellis.raster.resample.ResampleAssign;

public final class ResampleAssign$ {
    public static ResampleAssign$ MODULE$;

    static {
        new ResampleAssign$();
    }

    public <T> void apply(RasterExtent current, RasterExtent target, Object source, Object result) {
        this.apply(current, target, new ArrayResampleAssign(source, result));
    }

    public void apply(RasterExtent current, RasterExtent target, ResampleAssign assign) {
        int n;
        if (!current.extent().intersects(target.extent())) {
            return;
        }
        double src_cellwidth = current.cellwidth();
        double src_cellheight = current.cellheight();
        int src_cols = current.cols();
        int src_rows = current.rows();
        double src_xmin = current.extent().xmin();
        double src_ymin = current.extent().ymin();
        double src_xmax = current.extent().xmax();
        double src_ymax = current.extent().ymax();
        int dst_cols = target.cols();
        int dst_rows = target.rows();
        double dst_cellwidth = target.cellwidth();
        double dst_cellheight = target.cellheight();
        double xbase = target.extent().xmin() - src_xmin + dst_cellwidth / (double)2;
        double ybase = target.extent().ymax() - src_ymin - dst_cellheight / (double)2;
        double src_map_width = src_xmax - src_xmin;
        double src_map_height = src_ymax - src_ymin;
        int src_size = src_rows * src_cols;
        int dst_size = dst_cols * dst_rows;
        int min_col = (int)(xbase / src_cellwidth);
        int max_col = (int)((xbase + (double)dst_cols * dst_cellwidth) / src_cellwidth);
        if (target.extent().xmin() < src_xmin) {
            double delta = src_xmin - target.extent().xmin();
            int startCol = (int)(delta / dst_cellwidth);
            if ((xbase += dst_cellwidth * (double)startCol) < 0.0) {
                xbase += dst_cellwidth;
                n = startCol + 1;
            } else {
                n = startCol;
            }
        } else {
            n = 0;
        }
        int startCol = n;
        double y = ybase;
        for (int index$macro$2 = 0; index$macro$2 < dst_rows; ++index$macro$2) {
            int src_row = src_rows - (int)(y / src_cellheight) - 1;
            int src_span = src_row * src_cols;
            int dst_span = index$macro$2 * dst_cols;
            if (src_span + min_col < src_size && src_span + max_col >= 0) {
                double x = xbase;
                for (int index$macro$1 = startCol; index$macro$1 < dst_cols; ++index$macro$1) {
                    int src_col = (int)(x / src_cellwidth);
                    int src_i = src_span + src_col;
                    if (src_col >= 0 && src_col < src_cols && src_i < src_size && src_i >= 0) {
                        int dst_i = dst_span + index$macro$1;
                        assign.apply(src_i, dst_i);
                    }
                    x += dst_cellwidth;
                }
            }
            y -= dst_cellheight;
        }
    }

    public void apply$mBc$sp(RasterExtent current, RasterExtent target, byte[] source, byte[] result) {
        this.apply(current, target, new ArrayResampleAssign$mcB$sp(source, result));
    }

    public void apply$mDc$sp(RasterExtent current, RasterExtent target, double[] source, double[] result) {
        this.apply(current, target, new ArrayResampleAssign$mcD$sp(source, result));
    }

    public void apply$mFc$sp(RasterExtent current, RasterExtent target, float[] source, float[] result) {
        this.apply(current, target, new ArrayResampleAssign$mcF$sp(source, result));
    }

    public void apply$mIc$sp(RasterExtent current, RasterExtent target, int[] source, int[] result) {
        this.apply(current, target, new ArrayResampleAssign$mcI$sp(source, result));
    }

    public void apply$mSc$sp(RasterExtent current, RasterExtent target, short[] source, short[] result) {
        this.apply(current, target, new ArrayResampleAssign$mcS$sp(source, result));
    }

    private ResampleAssign$() {
        MODULE$ = this;
    }
}

