/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import squants.Dimension;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.electro.Amperes$;
import squants.electro.Capacitance;
import squants.electro.Coulombs$;
import squants.electro.ElectricCharge;
import squants.electro.ElectricCurrent;
import squants.electro.ElectricFieldStrength;
import squants.electro.ElectricPotential$;
import squants.electro.ElectricPotentialUnit;
import squants.electro.ElectricalResistance;
import squants.electro.Kilovolts$;
import squants.electro.MagneticFlux;
import squants.electro.Megavolts$;
import squants.electro.Microvolts$;
import squants.electro.Millivolts$;
import squants.electro.Ohms$;
import squants.electro.Volts$;
import squants.electro.VoltsPerMeter$;
import squants.electro.Webers$;
import squants.energy.Energy;
import squants.energy.Joules$;
import squants.energy.Power;
import squants.energy.Watts$;
import squants.space.Length;
import squants.time.Frequency;
import squants.time.Seconds$;
import squants.time.Time;
import squants.time.TimeDerivative;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001\u0002\u0010 \u0005\u0011B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005m!AQ\b\u0001BC\u0002\u0013\u0005a\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003@\u0011\u0015\u0019\u0005\u0001\"\u0003E\u0011\u00159\u0005\u0001\"\u0001I\u0011!\t\u0019\u0005\u0001C\tC\u0005\u0015\u0003b\u0002\u0018\u0001\t#\t\u0013q\t\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\ty\u0005\u0001C\u0001\u0003[Bq!a\u0014\u0001\t\u0003\ti\bC\u0004\u0002\b\u0002!\t!!#\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\u0014\"9\u0011q\u0011\u0001\u0005\u0002\u0005]\u0005BBAT\u0001\u0011\u0005Q\u0007\u0003\u0004\u0002*\u0002!\t!\u000e\u0005\u0007\u0003W\u0003A\u0011A\u001b\t\r\u00055\u0006\u0001\"\u00016\u0011\u0019\ty\u000b\u0001C\u0001k\u001d)!j\bE\u0001\u0017\u001a)ad\bE\u0001\u0019\")1)\u0006C\u0001-\"1q+\u0006C\u0001?aCQaV\u000b\u0005\u0002]Daa`\u000b\u0005\u0002\u0005\u0005\u0001bBA\n+\u0011\u0005\u0011Q\u0003\u0005\b\u0003;)B\u0011AA\u000b\u0011\u001d\ty\"\u0006C\u0001\u0003CA\u0011\"!\u000f\u0016\u0003\u0003%I!a\u000f\u0003#\u0015cWm\u0019;sS\u000e\u0004v\u000e^3oi&\fGN\u0003\u0002!C\u00059Q\r\\3diJ|'\"\u0001\u0012\u0002\u000fM\fX/\u00198ug\u000e\u00011c\u0001\u0001&WA\u0019aeJ\u0015\u000e\u0003\u0005J!\u0001K\u0011\u0003\u0011E+\u0018M\u001c;jif\u0004\"A\u000b\u0001\u000e\u0003}\u00012\u0001L\u00182\u001b\u0005i#B\u0001\u0018\"\u0003\u0011!\u0018.\\3\n\u0005Aj#A\u0004+j[\u0016$UM]5wCRLg/\u001a\t\u0003UIJ!aM\u0010\u0003\u00195\u000bwM\\3uS\u000e4E.\u001e=\u0002\u000bY\fG.^3\u0016\u0003Y\u0002\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012a\u0001R8vE2,\u0017A\u0002<bYV,\u0007%\u0001\u0003v]&$X#A \u0011\u0005)\u0002\u0015BA! \u0005U)E.Z2ue&\u001c\u0007k\u001c;f]RL\u0017\r\\+oSR\fQ!\u001e8ji\u0002\na\u0001P5oSRtDcA\u0015F\r\")A'\u0002a\u0001m!)Q(\u0002a\u0001\u007f\u0005IA-[7f]NLwN\\\u000b\u0002\u0013:\u0011!\u0006F\u0001\u0012\u000b2,7\r\u001e:jGB{G/\u001a8uS\u0006d\u0007C\u0001\u0016\u0016'\u0011)R\nU*\u0011\u0005]r\u0015BA(9\u0005\u0019\te.\u001f*fMB\u0019a%U\u0015\n\u0005I\u000b#!\u0003#j[\u0016t7/[8o!\t9D+\u0003\u0002Vq\ta1+\u001a:jC2L'0\u00192mKR\t1*A\u0003baBd\u00170\u0006\u0002ZWR\u0019!\f\u001e<\u0015\u0005%Z\u0006\"\u0002/\u0018\u0001\bi\u0016a\u00018v[B\u0019aLZ5\u000f\u0005}#gB\u00011d\u001b\u0005\t'B\u00012$\u0003\u0019a$o\\8u}%\t\u0011(\u0003\u0002fq\u00059\u0001/Y2lC\u001e,\u0017BA4i\u0005\u001dqU/\\3sS\u000eT!!\u001a\u001d\u0011\u0005)\\G\u0002\u0001\u0003\u0006Y^\u0011\r!\u001c\u0002\u0002\u0003F\u0011a.\u001d\t\u0003o=L!\u0001\u001d\u001d\u0003\u000f9{G\u000f[5oOB\u0011qG]\u0005\u0003gb\u00121!\u00118z\u0011\u0015)x\u00031\u0001j\u0003\u0005q\u0007\"B\u001f\u0018\u0001\u0004yDC\u0001=\u007f!\rIH0K\u0007\u0002u*\u00111\u0010O\u0001\u0005kRLG.\u0003\u0002~u\n\u0019AK]=\t\u000bQB\u0002\u0019A9\u0002\t9\fW.Z\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0003mC:<'BAA\u0007\u0003\u0011Q\u0017M^1\n\t\u0005E\u0011q\u0001\u0002\u0007'R\u0014\u0018N\\4\u0002\u0017A\u0014\u0018.\\1ssVs\u0017\u000e^\u000b\u0003\u0003/q1AKA\r\u0013\r\tYbH\u0001\u0006->dGo]\u0001\u0007g&,f.\u001b;\u0002\u000bUt\u0017\u000e^:\u0016\u0005\u0005\r\u0002CBA\u0013\u0003_\t\u0019$\u0004\u0002\u0002()!\u0011\u0011FA\u0016\u0003%IW.\\;uC\ndWMC\u0002\u0002.a\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t$a\n\u0003\u0007M+G\u000f\u0005\u0003'\u0003kI\u0013bAA\u001cC\tiQK\\5u\u001f\u001alU-Y:ve\u0016\f1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\b\t\u0005\u0003\u000b\ty$\u0003\u0003\u0002B\u0005\u001d!AB(cU\u0016\u001cG/\u0001\buS6,\u0017J\u001c;fOJ\fG/\u001a3\u0016\u0003E*\"!!\u0013\u0011\u00071\nY%C\u0002\u0002N5\u0012A\u0001V5nK\u00061A\u0005^5nKN$B!a\u0015\u0002dA!\u0011QKA/\u001d\u0011\t9&a\u0017\u000f\u0007\u0001\fI&C\u0001#\u0013\t)\u0017%\u0003\u0003\u0002`\u0005\u0005$!\u0002)po\u0016\u0014(BA3\"\u0011\u001d\t)'\u0003a\u0001\u0003O\nA\u0001\u001e5biB\u0019!&!\u001b\n\u0007\u0005-tDA\bFY\u0016\u001cGO]5d\u0007V\u0014(/\u001a8u)\u0011\ty'!\u001e\u0011\u0007)\n\t(C\u0002\u0002t}\u0011a\"\u00127fGR\u0014\u0018nY\"iCJ<W\rC\u0004\u0002f)\u0001\r!a\u001e\u0011\u0007)\nI(C\u0002\u0002|}\u00111bQ1qC\u000eLG/\u00198dKR!\u0011qPAC!\u0011\t)&!!\n\t\u0005\r\u0015\u0011\r\u0002\u0007\u000b:,'oZ=\t\u000f\u0005\u00154\u00021\u0001\u0002p\u0005!A\u0005Z5w)\u0011\tY)!%\u0011\u0007)\ni)C\u0002\u0002\u0010~\u0011A#\u00127fGR\u0014\u0018nY1m%\u0016\u001c\u0018n\u001d;b]\u000e,\u0007bBA3\u0019\u0001\u0007\u0011q\r\u000b\u0005\u0003O\n)\nC\u0004\u0002f5\u0001\r!a#\u0015\t\u0005e\u0015q\u0014\t\u0004U\u0005m\u0015bAAO?\t)R\t\\3diJL7MR5fY\u0012\u001cFO]3oORD\u0007bBA3\u001d\u0001\u0007\u0011\u0011\u0015\t\u0005\u0003+\n\u0019+\u0003\u0003\u0002&\u0006\u0005$A\u0002'f]\u001e$\b.A\u0004u_Z{G\u000e^:\u0002\u0019Q|W*[2s_Z|G\u000e^:\u0002\u0019Q|W*\u001b7mSZ|G\u000e^:\u0002\u0017Q|7*\u001b7pm>dGo]\u0001\fi>lUmZ1w_2$8\u000f")
public final class ElectricPotential
extends Quantity<ElectricPotential>
implements TimeDerivative<MagneticFlux> {
    private final double value;
    private final ElectricPotentialUnit unit;

    public static Set<UnitOfMeasure<ElectricPotential>> units() {
        return ElectricPotential$.MODULE$.units();
    }

    public static Volts$ siUnit() {
        return ElectricPotential$.MODULE$.siUnit();
    }

    public static Volts$ primaryUnit() {
        return ElectricPotential$.MODULE$.primaryUnit();
    }

    public static String name() {
        return ElectricPotential$.MODULE$.name();
    }

    public static Try<ElectricPotential> apply(Object object) {
        return ElectricPotential$.MODULE$.apply(object);
    }

    public static Dimension<ElectricPotential> dimensionImplicit() {
        return ElectricPotential$.MODULE$.dimensionImplicit();
    }

    public static <N> Try<ElectricPotential> parseTuple(Tuple2<N, String> tuple22, Numeric<N> numeric) {
        return ElectricPotential$.MODULE$.parseTuple(tuple22, numeric);
    }

    public static Try<ElectricPotential> parseString(String string2) {
        return ElectricPotential$.MODULE$.parseString(string2);
    }

    public static Option<UnitOfMeasure<ElectricPotential>> symbolToUnit(String string2) {
        return ElectricPotential$.MODULE$.symbolToUnit(string2);
    }

    @Override
    public Quantity $times(Time that) {
        return TimeDerivative.$times$(this, that);
    }

    @Override
    public Frequency $div(Quantity that) {
        return TimeDerivative.$div$(this, that);
    }

    @Override
    public double value() {
        return this.value;
    }

    public ElectricPotentialUnit unit() {
        return this.unit;
    }

    public ElectricPotential$ dimension() {
        return ElectricPotential$.MODULE$;
    }

    @Override
    public MagneticFlux timeIntegrated() {
        return Webers$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toVolts()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Seconds$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Power $times(ElectricCurrent that) {
        return Watts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toVolts() * that.toAmperes())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricCharge $times(Capacitance that) {
        return Coulombs$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toVolts() * that.toFarads())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Energy $times(ElectricCharge that) {
        return Joules$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toVolts() * that.toCoulombs())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricalResistance $div(ElectricCurrent that) {
        return Ohms$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toVolts() / that.toAmperes())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricCurrent $div(ElectricalResistance that) {
        return Amperes$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toVolts() / that.toOhms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricFieldStrength $div(Length that) {
        return VoltsPerMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toVolts() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toVolts() {
        return this.to(Volts$.MODULE$);
    }

    public double toMicrovolts() {
        return this.to(Microvolts$.MODULE$);
    }

    public double toMillivolts() {
        return this.to(Millivolts$.MODULE$);
    }

    public double toKilovolts() {
        return this.to(Kilovolts$.MODULE$);
    }

    public double toMegavolts() {
        return this.to(Megavolts$.MODULE$);
    }

    public ElectricPotential(double value, ElectricPotentialUnit unit) {
        this.value = value;
        this.unit = unit;
        TimeDerivative.$init$(this);
    }
}

