/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.raster.GridBounds;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.CellwiseStrategyCalculation;
import geotrellis.raster.mapalgebra.focal.Square;
import scala.math.package$;

public final class CellwiseStrategy$ {
    public static CellwiseStrategy$ MODULE$;

    static {
        new CellwiseStrategy$();
    }

    public void execute(Tile r, Square n, CellwiseStrategyCalculation calc, GridBounds<Object> analysisArea) {
        this.handleScanLine(r, n.extent(), calc, analysisArea);
    }

    private void handleScanLine(Tile r, int n, CellwiseStrategyCalculation calc, GridBounds<Object> analysisArea) {
        int rowMin = analysisArea.rowMin$mcI$sp();
        int colMin = analysisArea.colMin$mcI$sp();
        int rowMax = analysisArea.rowMax$mcI$sp();
        int rowBorderMax = r.rows$mcI$sp() - 1;
        int colMax = analysisArea.colMax$mcI$sp();
        int colBorderMax = r.cols$mcI$sp() - 1;
        int analysisOffsetCols = analysisArea.colMin$mcI$sp();
        int analysisOffsetRows = analysisArea.rowMin$mcI$sp();
        for (int focusRow = rowMin; focusRow <= rowMax; ++focusRow) {
            int curRowMin = package$.MODULE$.max(0, focusRow - n);
            int curRowMax = package$.MODULE$.min(rowBorderMax, focusRow + n);
            calc.reset();
            int curColMax = package$.MODULE$.min(colBorderMax, colMin + n);
            int curColMin = package$.MODULE$.max(0, colMin - n);
            for (int curRow = curRowMin; curRow <= curRowMax; ++curRow) {
                for (int curCol = curColMin; curCol <= curColMax; ++curCol) {
                    calc.add(r, curCol, curRow);
                }
            }
            calc.setValue(colMin, focusRow, 0, focusRow - rowMin);
            for (int focusCol = colMin + 1; focusCol <= colMax; ++focusCol) {
                int newEastCol;
                int oldWestCol = focusCol - n - 1;
                if (oldWestCol >= 0) {
                    for (int yy = curRowMin; yy <= curRowMax; ++yy) {
                        calc.remove(r, oldWestCol, yy);
                    }
                }
                if ((newEastCol = focusCol + n) <= colBorderMax) {
                    for (int yy = curRowMin; yy <= curRowMax; ++yy) {
                        calc.add(r, newEastCol, yy);
                    }
                }
                calc.setValue(focusCol, focusRow, focusCol - colMin, focusRow - rowMin);
            }
        }
    }

    private CellwiseStrategy$() {
        MODULE$ = this;
    }
}

