/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.raster.DataType;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.ArrayTileResult;
import geotrellis.raster.mapalgebra.focal.Cursor;
import geotrellis.raster.mapalgebra.focal.CursorCalculation;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import geotrellis.raster.mapalgebra.focal.TargetCell;
import scala.Function2;
import scala.Function4;
import scala.Option;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0004\b\u0001/!I1\u0005\u0001B\u0001B\u0003%A\u0004\n\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!I1\u0006\u0001B\u0001B\u0003%A\u0006\u000f\u0005\nu\u0001\u0011\t\u0011)A\u0005wyBQa\u0010\u0001\u0005\u0002\u0001CqA\u0012\u0001A\u0002\u0013\u0005q\tC\u0004I\u0001\u0001\u0007I\u0011A%\t\r=\u0003\u0001\u0015)\u00036\u0011\u001d\u0001\u0006\u00011A\u0005\u0002ECq!\u0016\u0001A\u0002\u0013\u0005a\u000b\u0003\u0004Y\u0001\u0001\u0006KA\u0015\u0005\u00063\u0002!\tA\u0017\u0002\u0014\u0007V\u00148o\u001c:E_V\u0014G.Z*v[\u000e\u000bGn\u0019\u0006\u0003\u001fA\tQAZ8dC2T!!\u0005\n\u0002\u00155\f\u0007/\u00197hK\n\u0014\u0018M\u0003\u0002\u0014)\u00051!/Y:uKJT\u0011!F\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001A\n\u0004\u0001a\u0001\u0003cA\r\u001b95\ta\"\u0003\u0002\u001c\u001d\t\t2)\u001e:t_J\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8\u0011\u0005uqR\"\u0001\n\n\u0005}\u0011\"\u0001\u0002+jY\u0016\u0004\"!G\u0011\n\u0005\tr!aD!se\u0006LH+\u001b7f%\u0016\u001cX\u000f\u001c;\u0002\u0003IL!aI\u0013\n\u0005\u0019r!\u0001\u0005$pG\u0006d7)\u00197dk2\fG/[8o\u0003\u0005q\u0007CA\r*\u0013\tQcB\u0001\u0007OK&<\u0007NY8sQ>|G-\u0001\u0004c_VtGm\u001d\t\u0004[A\u0012T\"\u0001\u0018\u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0003\r=\u0003H/[8o!\ri2'N\u0005\u0003iI\u0011!b\u0012:jI\n{WO\u001c3t!\tic'\u0003\u00028]\t\u0019\u0011J\u001c;\n\u0005eR\u0012\u0001D1oC2L8/[:Be\u0016\f\u0017A\u0002;be\u001e,G\u000f\u0005\u0002\u001ay%\u0011QH\u0004\u0002\u000b)\u0006\u0014x-\u001a;DK2d\u0017B\u0001\u001e&\u0003\u0019a\u0014N\\5u}Q)\u0011IQ\"E\u000bB\u0011\u0011\u0004\u0001\u0005\u0006G\u0015\u0001\r\u0001\b\u0005\u0006O\u0015\u0001\r\u0001\u000b\u0005\u0006W\u0015\u0001\r\u0001\f\u0005\u0006u\u0015\u0001\raO\u0001\u0006G>,h\u000e^\u000b\u0002k\u0005I1m\\;oi~#S-\u001d\u000b\u0003\u00156\u0003\"!L&\n\u00051s#\u0001B+oSRDqAT\u0004\u0002\u0002\u0003\u0007Q'A\u0002yIE\naaY8v]R\u0004\u0013!\u0002;pi\u0006dW#\u0001*\u0011\u00055\u001a\u0016B\u0001+/\u0005\u0019!u.\u001e2mK\u0006IAo\u001c;bY~#S-\u001d\u000b\u0003\u0015^CqA\u0014\u0006\u0002\u0002\u0003\u0007!+\u0001\u0004u_R\fG\u000eI\u0001\u0005G\u0006d7\rF\u0002K7rCQa\t\u0007A\u0002qAQ!\u0018\u0007A\u0002y\u000baaY;sg>\u0014\bCA\r`\u0013\t\u0001gB\u0001\u0004DkJ\u001cxN\u001d")
public class CursorDoubleSumCalc
extends CursorCalculation<Tile>
implements ArrayTileResult {
    private int count;
    private double total;
    private final int cols;
    private final int rows;
    private final MutableArrayTile resultTile;
    private final Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue;

    @Override
    public DataType resultCellType() {
        return ArrayTileResult.resultCellType$(this);
    }

    @Override
    public MutableArrayTile result() {
        return ArrayTileResult.result$(this);
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public MutableArrayTile resultTile() {
        return this.resultTile;
    }

    @Override
    public Function4<Object, Object, Object, Object, BoxedUnit> copyOriginalValue() {
        return this.copyOriginalValue;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$cols_$eq(int x$1) {
        this.cols = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$rows_$eq(int x$1) {
        this.rows = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$resultTile_$eq(MutableArrayTile x$1) {
        this.resultTile = x$1;
    }

    @Override
    public void geotrellis$raster$mapalgebra$focal$ArrayTileResult$_setter_$copyOriginalValue_$eq(Function4<Object, Object, Object, Object, BoxedUnit> x$1) {
        this.copyOriginalValue = x$1;
    }

    public int count() {
        return this.count;
    }

    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    public double total() {
        return this.total;
    }

    public void total_$eq(double x$1) {
        this.total = x$1;
    }

    @Override
    public void calc(Tile r, Cursor cursor) {
        cursor.addedCells().foreach((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & java.io.Serializable & Serializable)(x, y) -> {
            block2: {
                double v = r.getDouble(x, y);
                if (Double.isNaN(v)) break block2;
                if (!Double.isNaN(this.total())) {
                    this.total_$eq(this.total() + v);
                    this.count_$eq(this.count() + 1);
                } else {
                    this.total_$eq(v);
                    this.count_$eq(1);
                }
            }
        });
        cursor.removedCells().foreach((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & java.io.Serializable & Serializable)(x, y) -> {
            block2: {
                double v = r.getDouble(x, y);
                if (Double.isNaN(v)) break block2;
                this.count_$eq(this.count() - 1);
                if (this.count() == 0) {
                    this.total_$eq(Double.NaN);
                } else {
                    this.total_$eq(this.total() - v);
                }
            }
        });
        this.resultTile().setDouble(cursor.col(), cursor.row(), this.total());
    }

    public CursorDoubleSumCalc(Tile r, Neighborhood n, Option<GridBounds<Object>> bounds, TargetCell target) {
        super(r, n, bounds, target);
        ArrayTileResult.$init$(this);
        this.count = 0;
        this.total = Double.NaN;
    }
}

