/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.reproject;

import geotrellis.proj4.CRS;
import geotrellis.proj4.Transform$;
import geotrellis.raster.CellSize;
import geotrellis.raster.GridExtent;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.reproject.Reproject;
import geotrellis.raster.reproject.Reproject$Options$;
import geotrellis.vector.Extent;
import org.locationtech.jts.geom.Geometry;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.math.package$;
import spire.math.Integral;
import spire.math.Integral$;

public final class ReprojectRasterExtent$ {
    public static ReprojectRasterExtent$ MODULE$;

    static {
        new ReprojectRasterExtent$();
    }

    public <N> GridExtent<N> apply(GridExtent<N> ge, Function2<Object, Object, Tuple2<Object, Object>> transform, Reproject.Options options, Integral<N> evidence$1) {
        GridExtent<N> gridExtent;
        Extent extent = ge.extent();
        Extent newExtent = geotrellis.vector.package$.MODULE$.withExtraGeometryMethods((Geometry)geotrellis.vector.package$.MODULE$.ReprojectExtent(extent).reprojectAsPolygon(transform, 0.001)).extent();
        Option<GridExtent<Object>> option2 = options.parentGridExtent();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            GridExtent parentGridExtent = (GridExtent)some.value();
            gridExtent = parentGridExtent.createAlignedGridExtent$mcJ$sp(newExtent).toGridType(evidence$1);
        } else if (None$.MODULE$.equals(option2)) {
            Tuple2.mcDD.sp sp2;
            Option<CellSize> option3 = options.targetCellSize();
            if (option3 instanceof Some) {
                Some some = (Some)option3;
                CellSize cellSize = (CellSize)some.value();
                sp2 = new Tuple2.mcDD.sp(cellSize.width(), cellSize.height());
            } else if (None$.MODULE$.equals(option3)) {
                double distance = newExtent.northWest().distance((Geometry)newExtent.southEast());
                double cols = ge.extent().width() / ge.cellwidth();
                double rows = ge.extent().height() / ge.cellheight();
                double pixelSize = distance / package$.MODULE$.sqrt(cols * cols + rows * rows);
                sp2 = new Tuple2.mcDD.sp(pixelSize, pixelSize);
            } else {
                throw new MatchError(option3);
            }
            Tuple2.mcDD.sp sp3 = sp2;
            if (sp3 == null) {
                throw new MatchError((Object)sp3);
            }
            double pixelSizeX = sp3._1$mcD$sp();
            double pixelSizeY = sp3._2$mcD$sp();
            Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(pixelSizeX, pixelSizeY);
            Tuple2.mcDD.sp sp5 = sp4;
            double pixelSizeX2 = sp5._1$mcD$sp();
            double pixelSizeY2 = sp5._2$mcD$sp();
            long newCols = (long)(newExtent.width() / pixelSizeX2 + 0.5);
            long newRows = (long)(newExtent.height() / pixelSizeY2 + 0.5);
            Extent adjustedExtent = new Extent(newExtent.xmin(), newExtent.ymax() - pixelSizeY2 * (double)newRows, newExtent.xmin() + pixelSizeX2 * (double)newCols, newExtent.ymax());
            gridExtent = new GridExtent<N>(adjustedExtent, new CellSize(pixelSizeX2, pixelSizeY2), evidence$1);
        } else {
            throw new MatchError(option2);
        }
        return gridExtent;
    }

    public <N> GridExtent<N> apply(GridExtent<N> ge, Function2<Object, Object, Tuple2<Object, Object>> transform, Integral<N> evidence$2) {
        return this.apply(ge, transform, Reproject$Options$.MODULE$.DEFAULT(), evidence$2);
    }

    public <N> GridExtent<N> apply(GridExtent<N> ge, CRS src, CRS dest, Reproject.Options options, Integral<N> evidence$3) {
        CRS cRS = src;
        CRS cRS2 = dest;
        return !(cRS != null ? !((Object)cRS).equals(cRS2) : cRS2 != null) ? ge : this.apply(ge, Transform$.MODULE$.apply(src, dest), options, evidence$3);
    }

    public <N> GridExtent<N> apply(GridExtent<N> ge, CRS src, CRS dest, Integral<N> evidence$4) {
        return this.apply(ge, src, dest, Reproject$Options$.MODULE$.DEFAULT(), evidence$4);
    }

    public RasterExtent apply(RasterExtent re, Function2<Object, Object, Tuple2<Object, Object>> transform, Reproject.Options options) {
        return this.apply((GridExtent)re, transform, options, (Integral)Integral$.MODULE$.IntIsIntegral()).toRasterExtent();
    }

    public RasterExtent apply(RasterExtent re, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return this.apply(re, transform, Reproject$Options$.MODULE$.DEFAULT());
    }

    public RasterExtent apply(RasterExtent re, CRS src, CRS dest, Reproject.Options options) {
        CRS cRS = src;
        CRS cRS2 = dest;
        return !(cRS != null ? !((Object)cRS).equals(cRS2) : cRS2 != null) ? re : this.apply(re, Transform$.MODULE$.apply(src, dest), options);
    }

    public RasterExtent apply(RasterExtent re, CRS src, CRS dest) {
        return this.apply(re, src, dest, Reproject$Options$.MODULE$.DEFAULT());
    }

    private ReprojectRasterExtent$() {
        MODULE$ = this;
    }
}

