/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.vector.reproject;

import geotrellis.proj4.CRS;
import geotrellis.proj4.Transform$;
import geotrellis.vector.Extent;
import geotrellis.vector.Feature;
import geotrellis.vector.Feature$;
import geotrellis.vector.GeometryCollection$;
import geotrellis.vector.GeometryCollectionFeature$;
import geotrellis.vector.LineString$;
import geotrellis.vector.LineStringFeature$;
import geotrellis.vector.MultiLineString$;
import geotrellis.vector.MultiLineStringFeature$;
import geotrellis.vector.MultiPoint$;
import geotrellis.vector.MultiPointFeature$;
import geotrellis.vector.MultiPolygon$;
import geotrellis.vector.MultiPolygonFeature$;
import geotrellis.vector.Point$;
import geotrellis.vector.PointFeature$;
import geotrellis.vector.Polygon$;
import geotrellis.vector.PolygonFeature$;
import geotrellis.vector.package$;
import java.io.Serializable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Reproject$ {
    public static Reproject$ MODULE$;

    static {
        new Reproject$();
    }

    public Tuple2<Object, Object> apply(Tuple2<Object, Object> t, CRS src, CRS dest) {
        return this.apply(t, Transform$.MODULE$.apply(src, dest));
    }

    public Tuple2<Object, Object> apply(Tuple2<Object, Object> t, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return (Tuple2)transform.apply((Object)BoxesRunTime.boxToDouble((double)t._1$mcD$sp()), (Object)BoxesRunTime.boxToDouble((double)t._2$mcD$sp()));
    }

    public Point apply(Point p, CRS src, CRS dest) {
        return this.apply(p, Transform$.MODULE$.apply(src, dest));
    }

    public Point apply(Point p, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return Point$.MODULE$.apply((Tuple2<Object, Object>)((Tuple2)transform.apply((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.withExtraPointMethods(p).x()), (Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.withExtraPointMethods(p).y()))));
    }

    public <D> Feature<Point, D> pointFeature(Feature<Point, D> pf, CRS src, CRS dest) {
        return PointFeature$.MODULE$.apply(this.apply(pf.geom(), src, dest), pf.data());
    }

    public <D> Feature<Point, D> pointFeature(Feature<Point, D> pf, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return PointFeature$.MODULE$.apply(this.apply(pf.geom(), transform), pf.data());
    }

    public LineString apply(LineString l, CRS src, CRS dest) {
        return this.apply(l, Transform$.MODULE$.apply(src, dest));
    }

    public LineString apply(LineString l, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return LineString$.MODULE$.apply((Traversable<Tuple2<Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.withExtraLineStringMethods(l).points())).map((Function1 & Serializable & scala.Serializable)p -> (Tuple2)transform.apply((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.withExtraPointMethods((Point)p).x()), (Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.withExtraPointMethods((Point)p).y())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))), Predef.DummyImplicit$.MODULE$.dummyImplicit());
    }

    public <D> Feature<LineString, D> lineStringFeature(Feature<LineString, D> lf, CRS src, CRS dest) {
        return LineStringFeature$.MODULE$.apply(this.apply(lf.geom(), src, dest), lf.data());
    }

    public <D> Feature<LineString, D> lineStringFeature(Feature<LineString, D> lf, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return LineStringFeature$.MODULE$.apply(this.apply(lf.geom(), transform), lf.data());
    }

    public Polygon apply(Polygon p, CRS src, CRS dest) {
        return this.apply(p, Transform$.MODULE$.apply(src, dest));
    }

    public Polygon apply(Polygon p, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return Polygon$.MODULE$.apply(this.apply(package$.MODULE$.withExtraPolygonMethods(p).exterior(), transform), (GenTraversable<LineString>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.withExtraPolygonMethods(p).holes())).map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.apply((LineString)x$1, transform), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LineString.class)))));
    }

    public Extent apply(Extent extent, CRS src, CRS dest) {
        return package$.MODULE$.withExtraGeometryMethods((Geometry)this.apply(extent.toPolygon(), src, dest)).extent();
    }

    public Extent apply(Extent extent, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return package$.MODULE$.withExtraGeometryMethods((Geometry)this.apply(extent.toPolygon(), transform)).extent();
    }

    public Polygon reprojectExtentAsPolygon(Extent extent, Function2<Object, Object, Tuple2<Object, Object>> transform, double relError) {
        Tuple2[] pts = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Point[]{extent.southWest(), extent.southEast(), extent.northEast(), extent.northWest()})).map((Function1 & Serializable & scala.Serializable)p -> new Tuple2(p, transform.apply((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.withExtraPointMethods((Point)p).x()), (Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.withExtraPointMethods((Point)p).y()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2 tuple22 = pts[0];
        Tuple2 tuple23 = pts[1];
        Tuple2 tuple24 = pts[2];
        Tuple2 tuple25 = pts[3];
        return Polygon$.MODULE$.apply((Seq<Point>)((Seq)((List)((List)((List)((List)Reproject$.refine$1(pts[0], pts[1], transform, extent, relError).$colon$colon((Object)tuple22).$plus$plus((GenTraversableOnce)Reproject$.refine$1(pts[1], pts[2], transform, extent, relError).$colon$colon((Object)tuple23), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Reproject$.refine$1(pts[2], pts[3], transform, extent, relError).$colon$colon((Object)tuple24), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Reproject$.refine$1(pts[3], pts[0], transform, extent, relError).$colon$colon((Object)tuple25), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)pts[0], (List)Nil$.MODULE$), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple22;
            Tuple2 tuple23 = x0$1;
            if (tuple23 == null || (tuple22 = (Tuple2)tuple23._2()) == null) {
                throw new MatchError((Object)tuple23);
            }
            double x = tuple22._1$mcD$sp();
            double y = tuple22._2$mcD$sp();
            Point point = Point$.MODULE$.apply(x, y);
            return point;
        }, List$.MODULE$.canBuildFrom())));
    }

    public <D> Feature<Polygon, D> polygonFeature(Feature<Polygon, D> pf, CRS src, CRS dest) {
        return PolygonFeature$.MODULE$.apply(this.apply(pf.geom(), src, dest), pf.data());
    }

    public <D> Feature<Polygon, D> polygonFeature(Feature<Polygon, D> pf, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return PolygonFeature$.MODULE$.apply(this.apply(pf.geom(), transform), pf.data());
    }

    public MultiPoint apply(MultiPoint mp, CRS src, CRS dest) {
        return this.apply(mp, Transform$.MODULE$.apply(src, dest));
    }

    public MultiPoint apply(MultiPoint mp, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return MultiPoint$.MODULE$.apply((Traversable<Tuple2<Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.withExtraMultiPointMethods(mp).points())).map((Function1 & Serializable & scala.Serializable)p -> (Tuple2)transform.apply((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.withExtraPointMethods((Point)p).x()), (Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.withExtraPointMethods((Point)p).y())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))), Predef.DummyImplicit$.MODULE$.dummyImplicit());
    }

    public <D> Feature<MultiPoint, D> multiPointFeature(Feature<MultiPoint, D> mpf, CRS src, CRS dest) {
        return MultiPointFeature$.MODULE$.apply(this.apply(mpf.geom(), src, dest), mpf.data());
    }

    public <D> Feature<MultiPoint, D> multiPointFeature(Feature<MultiPoint, D> mpf, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return MultiPointFeature$.MODULE$.apply(this.apply(mpf.geom(), transform), mpf.data());
    }

    public MultiLineString apply(MultiLineString ml, CRS src, CRS dest) {
        return this.apply(ml, Transform$.MODULE$.apply(src, dest));
    }

    public MultiLineString apply(MultiLineString ml, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return MultiLineString$.MODULE$.apply((LineString[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.withExtraMultiLineStringMethods(ml).lines())).map((Function1 & Serializable & scala.Serializable)x$9 -> MODULE$.apply((LineString)x$9, transform), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LineString.class))));
    }

    public <D> Feature<MultiLineString, D> multiLineStringFeature(Feature<MultiLineString, D> mlf, CRS src, CRS dest) {
        return MultiLineStringFeature$.MODULE$.apply(this.apply(Feature$.MODULE$.featureToGeometry(mlf), src, dest), mlf.data());
    }

    public <D> Feature<MultiLineString, D> multiLineStringFeature(Feature<MultiLineString, D> mlf, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return MultiLineStringFeature$.MODULE$.apply(this.apply(Feature$.MODULE$.featureToGeometry(mlf), transform), mlf.data());
    }

    public MultiPolygon apply(MultiPolygon mp, CRS src, CRS dest) {
        return this.apply(mp, Transform$.MODULE$.apply(src, dest));
    }

    public MultiPolygon apply(MultiPolygon mp, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return MultiPolygon$.MODULE$.apply((Polygon[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.withExtraMultiPolygonMethods(mp).polygons())).map((Function1 & Serializable & scala.Serializable)x$10 -> MODULE$.apply((Polygon)x$10, transform), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Polygon.class))));
    }

    public <D> Feature<MultiPolygon, D> multiPolygonFeature(Feature<MultiPolygon, D> mpf, CRS src, CRS dest) {
        return MultiPolygonFeature$.MODULE$.apply(this.apply(mpf.geom(), src, dest), mpf.data());
    }

    public <D> Feature<MultiPolygon, D> multiPolygonFeature(Feature<MultiPolygon, D> mpf, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return MultiPolygonFeature$.MODULE$.apply(this.apply(mpf.geom(), transform), mpf.data());
    }

    public GeometryCollection apply(GeometryCollection gc, CRS src, CRS dest) {
        return GeometryCollection$.MODULE$.apply((Seq<Point>)((Seq)package$.MODULE$.withExtraGeometryCollectionMethods(gc).getAll(ClassTag$.MODULE$.apply(Point.class)).map((Function1 & Serializable & scala.Serializable)x$11 -> MODULE$.apply((Point)x$11, src, dest), Seq$.MODULE$.canBuildFrom())), (Seq<LineString>)((Seq)package$.MODULE$.withExtraGeometryCollectionMethods(gc).getAll(ClassTag$.MODULE$.apply(LineString.class)).map((Function1 & Serializable & scala.Serializable)x$12 -> MODULE$.apply((LineString)x$12, src, dest), Seq$.MODULE$.canBuildFrom())), (Seq<Polygon>)((Seq)package$.MODULE$.withExtraGeometryCollectionMethods(gc).getAll(ClassTag$.MODULE$.apply(Polygon.class)).map((Function1 & Serializable & scala.Serializable)x$13 -> MODULE$.apply((Polygon)x$13, src, dest), Seq$.MODULE$.canBuildFrom())), (Seq<MultiPoint>)((Seq)package$.MODULE$.withExtraGeometryCollectionMethods(gc).getAll(ClassTag$.MODULE$.apply(MultiPoint.class)).map((Function1 & Serializable & scala.Serializable)x$14 -> MODULE$.apply((MultiPoint)x$14, src, dest), Seq$.MODULE$.canBuildFrom())), (Seq<MultiLineString>)((Seq)package$.MODULE$.withExtraGeometryCollectionMethods(gc).getAll(ClassTag$.MODULE$.apply(MultiLineString.class)).map((Function1 & Serializable & scala.Serializable)x$15 -> MODULE$.apply((MultiLineString)x$15, src, dest), Seq$.MODULE$.canBuildFrom())), (Seq<MultiPolygon>)((Seq)package$.MODULE$.withExtraGeometryCollectionMethods(gc).getAll(ClassTag$.MODULE$.apply(MultiPolygon.class)).map((Function1 & Serializable & scala.Serializable)x$16 -> MODULE$.apply((MultiPolygon)x$16, src, dest), Seq$.MODULE$.canBuildFrom())), (Seq<GeometryCollection>)((Seq)package$.MODULE$.withExtraGeometryCollectionMethods(gc).getAll(ClassTag$.MODULE$.apply(GeometryCollection.class)).map((Function1 & Serializable & scala.Serializable)x$17 -> MODULE$.apply((GeometryCollection)x$17, src, dest), Seq$.MODULE$.canBuildFrom())));
    }

    public GeometryCollection apply(GeometryCollection gc, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return GeometryCollection$.MODULE$.apply((Seq<Point>)((Seq)package$.MODULE$.withExtraGeometryCollectionMethods(gc).getAll(ClassTag$.MODULE$.apply(Point.class)).map((Function1 & Serializable & scala.Serializable)x$18 -> MODULE$.apply((Point)x$18, transform), Seq$.MODULE$.canBuildFrom())), (Seq<LineString>)((Seq)package$.MODULE$.withExtraGeometryCollectionMethods(gc).getAll(ClassTag$.MODULE$.apply(LineString.class)).map((Function1 & Serializable & scala.Serializable)x$19 -> MODULE$.apply((LineString)x$19, transform), Seq$.MODULE$.canBuildFrom())), (Seq<Polygon>)((Seq)package$.MODULE$.withExtraGeometryCollectionMethods(gc).getAll(ClassTag$.MODULE$.apply(Polygon.class)).map((Function1 & Serializable & scala.Serializable)x$20 -> MODULE$.apply((Polygon)x$20, transform), Seq$.MODULE$.canBuildFrom())), (Seq<MultiPoint>)((Seq)package$.MODULE$.withExtraGeometryCollectionMethods(gc).getAll(ClassTag$.MODULE$.apply(MultiPoint.class)).map((Function1 & Serializable & scala.Serializable)x$21 -> MODULE$.apply((MultiPoint)x$21, transform), Seq$.MODULE$.canBuildFrom())), (Seq<MultiLineString>)((Seq)package$.MODULE$.withExtraGeometryCollectionMethods(gc).getAll(ClassTag$.MODULE$.apply(MultiLineString.class)).map((Function1 & Serializable & scala.Serializable)x$22 -> MODULE$.apply((MultiLineString)x$22, transform), Seq$.MODULE$.canBuildFrom())), (Seq<MultiPolygon>)((Seq)package$.MODULE$.withExtraGeometryCollectionMethods(gc).getAll(ClassTag$.MODULE$.apply(MultiPolygon.class)).map((Function1 & Serializable & scala.Serializable)x$23 -> MODULE$.apply((MultiPolygon)x$23, transform), Seq$.MODULE$.canBuildFrom())), (Seq<GeometryCollection>)((Seq)package$.MODULE$.withExtraGeometryCollectionMethods(gc).getAll(ClassTag$.MODULE$.apply(GeometryCollection.class)).map((Function1 & Serializable & scala.Serializable)x$24 -> MODULE$.apply((GeometryCollection)x$24, transform), Seq$.MODULE$.canBuildFrom())));
    }

    public <D> Feature<GeometryCollection, D> geometryCollectionFeature(Feature<GeometryCollection, D> gcf, CRS src, CRS dest) {
        return GeometryCollectionFeature$.MODULE$.apply(this.apply(gcf.geom(), src, dest), gcf.data());
    }

    public <D> Feature<GeometryCollection, D> geometryCollectionFeature(Feature<GeometryCollection, D> gcf, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        return GeometryCollectionFeature$.MODULE$.apply(this.apply(gcf.geom(), transform), gcf.data());
    }

    public Geometry apply(Geometry g, CRS src, CRS dest) {
        return this.apply(g, Transform$.MODULE$.apply(src, dest));
    }

    public Geometry apply(Geometry g, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        Point point;
        Geometry geometry = g;
        if (geometry instanceof Point) {
            Point point2 = (Point)geometry;
            point = this.apply(point2, transform);
        } else if (geometry instanceof LineString) {
            LineString lineString = (LineString)geometry;
            point = this.apply(lineString, transform);
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            point = this.apply(polygon, transform);
        } else if (geometry instanceof MultiPoint) {
            MultiPoint multiPoint = (MultiPoint)geometry;
            point = this.apply(multiPoint, transform);
        } else if (geometry instanceof MultiLineString) {
            MultiLineString multiLineString = (MultiLineString)geometry;
            point = this.apply(multiLineString, transform);
        } else if (geometry instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)geometry;
            point = this.apply(multiPolygon, transform);
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            point = this.apply(geometryCollection, transform);
        } else {
            throw new MatchError((Object)geometry);
        }
        return point;
    }

    public <D> Feature<Geometry, D> geometryFeature(Feature<Geometry, D> f, CRS src, CRS dest) {
        return this.geometryFeature(f, Transform$.MODULE$.apply(src, dest));
    }

    public <D> Feature<Geometry, D> geometryFeature(Feature<Geometry, D> f, Function2<Object, Object, Tuple2<Object, Object>> transform) {
        Feature<Point, D> feature;
        Geometry geometry = f.geom();
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            feature = this.pointFeature(new Feature<Point, D>(point, f.data()), transform);
        } else if (geometry instanceof LineString) {
            LineString lineString = (LineString)geometry;
            feature = this.lineStringFeature(new Feature<LineString, D>(lineString, f.data()), transform);
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            feature = this.polygonFeature(new Feature<Polygon, D>(polygon, f.data()), transform);
        } else if (geometry instanceof MultiPoint) {
            MultiPoint multiPoint = (MultiPoint)geometry;
            feature = this.multiPointFeature(new Feature<MultiPoint, D>(multiPoint, f.data()), transform);
        } else if (geometry instanceof MultiLineString) {
            MultiLineString multiLineString = (MultiLineString)geometry;
            feature = this.multiLineStringFeature(new Feature<MultiLineString, D>(multiLineString, f.data()), transform);
        } else if (geometry instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)geometry;
            feature = this.multiPolygonFeature(new Feature<MultiPolygon, D>(multiPolygon, f.data()), transform);
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            feature = this.geometryCollectionFeature(new Feature<GeometryCollection, D>(geometryCollection, f.data()), transform);
        } else {
            throw new MatchError((Object)geometry);
        }
        return feature;
    }

    private static final List refine$1(Tuple2 p0, Tuple2 p1, Function2 transform$3, Extent extent$1, double relError$1) {
        .colon.colon colon2;
        Tuple2 tuple22;
        Point b;
        double y0;
        double x0;
        Point a;
        block8: {
            Tuple2 tuple23;
            block7: {
                tuple23 = new Tuple2((Object)p0, (Object)p1);
                if (tuple23 == null) break block7;
                Tuple2 tuple24 = (Tuple2)tuple23._1();
                Tuple2 tuple25 = (Tuple2)tuple23._2();
                if (tuple24 == null) break block7;
                a = (Point)tuple24._1();
                Tuple2 tuple26 = (Tuple2)tuple24._2();
                if (tuple26 == null) break block7;
                x0 = tuple26._1$mcD$sp();
                y0 = tuple26._2$mcD$sp();
                if (tuple25 == null) break block7;
                b = (Point)tuple25._1();
                tuple22 = (Tuple2)tuple25._2();
                if (tuple22 != null) break block8;
            }
            throw new MatchError((Object)tuple23);
        }
        double x1 = tuple22._1$mcD$sp();
        double y1 = tuple22._2$mcD$sp();
        Tuple6 tuple62 = new Tuple6((Object)a, (Object)BoxesRunTime.boxToDouble((double)x0), (Object)BoxesRunTime.boxToDouble((double)y0), (Object)b, (Object)BoxesRunTime.boxToDouble((double)x1), (Object)BoxesRunTime.boxToDouble((double)y1));
        Tuple6 tuple63 = tuple62;
        Point a2 = (Point)tuple63._1();
        double x02 = BoxesRunTime.unboxToDouble((Object)tuple63._2());
        double y02 = BoxesRunTime.unboxToDouble((Object)tuple63._3());
        Point b2 = (Point)tuple63._4();
        double x12 = BoxesRunTime.unboxToDouble((Object)tuple63._5());
        double y12 = BoxesRunTime.unboxToDouble((Object)tuple63._6());
        Point m = Point$.MODULE$.apply(0.5 * (package$.MODULE$.withExtraPointMethods(a2).x() + package$.MODULE$.withExtraPointMethods(b2).x()), 0.5 * (package$.MODULE$.withExtraPointMethods(a2).y() + package$.MODULE$.withExtraPointMethods(b2).y()));
        Tuple2 tuple27 = (Tuple2)transform$3.apply((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.withExtraPointMethods(m).x()), (Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.withExtraPointMethods(m).y()));
        if (tuple27 == null) {
            throw new MatchError((Object)tuple27);
        }
        double x2 = tuple27._1$mcD$sp();
        double y2 = tuple27._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x2, y2);
        Tuple2.mcDD.sp sp3 = sp2;
        double x22 = sp3._1$mcD$sp();
        double y22 = sp3._2$mcD$sp();
        double deflect = scala.math.package$.MODULE$.abs((y22 - y12) * x02 - (x22 - x12) * y02 + x22 * y12 - y22 * x12) / scala.math.package$.MODULE$.sqrt(scala.math.package$.MODULE$.pow(y22 - y12, 2.0) + scala.math.package$.MODULE$.pow(x22 - x12, 2.0));
        double length = scala.math.package$.MODULE$.sqrt(scala.math.package$.MODULE$.pow(x02 - x12, 2.0) + scala.math.package$.MODULE$.pow(y02 - y12, 2.0));
        Tuple2 p2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)m), (Object)new Tuple2.mcDD.sp(x22, y22));
        if (Double.isNaN(deflect)) {
            throw new IllegalArgumentException(new StringBuilder(91).append("Encountered NaN during a refinement step: (").append(deflect).append(" / ").append(length).append("). Input ").append(extent$1).append(" is likely not in source projection.").toString());
        }
        if (deflect / length < relError$1) {
            colon2 = new .colon.colon((Object)p2, (List)Nil$.MODULE$);
        } else {
            Tuple2 tuple28 = p2;
            colon2 = (List)Reproject$.refine$1(p0, p2, transform$3, extent$1, relError$1).$plus$plus((GenTraversableOnce)Reproject$.refine$1(p2, p1, transform$3, extent$1, relError$1).$colon$colon((Object)tuple28), List$.MODULE$.canBuildFrom());
        }
        return colon2;
    }

    private Reproject$() {
        MODULE$ = this;
    }
}

