/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j;

import java.io.IOException;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.InvalidValueException;
import org.locationtech.proj4j.Registry;
import org.locationtech.proj4j.UnknownAuthorityCodeException;
import org.locationtech.proj4j.UnsupportedParameterException;
import org.locationtech.proj4j.io.Proj4FileReader;
import org.locationtech.proj4j.parser.Proj4Parser;

public class CRSFactory {
    private static Proj4FileReader csReader = new Proj4FileReader();
    private static Registry registry = new Registry();

    public Registry getRegistry() {
        return registry;
    }

    public CoordinateReferenceSystem createFromName(String name) throws UnsupportedParameterException, InvalidValueException, UnknownAuthorityCodeException {
        String[] params2 = csReader.getParameters(name);
        if (params2 == null) {
            throw new UnknownAuthorityCodeException(name);
        }
        return this.createFromParameters(name, params2);
    }

    public CoordinateReferenceSystem createFromParameters(String name, String paramStr) throws UnsupportedParameterException, InvalidValueException {
        return this.createFromParameters(name, CRSFactory.splitParameters(paramStr));
    }

    public CoordinateReferenceSystem createFromParameters(String name, String[] params2) throws UnsupportedParameterException, InvalidValueException {
        if (params2 == null) {
            return null;
        }
        Proj4Parser parser = new Proj4Parser(registry);
        return parser.parse(name, params2);
    }

    public String readEpsgFromParameters(String paramStr) throws IOException {
        return this.readEpsgFromParameters(CRSFactory.splitParameters(paramStr));
    }

    public String readEpsgFromParameters(String[] params2) throws IOException {
        return csReader.readEpsgCodeFromFile(params2);
    }

    private static String[] splitParameters(String paramStr) {
        String[] params2 = paramStr.split("\\s+");
        return params2;
    }
}

