/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import squants.Dimension;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.electro.ElectricCurrent;
import squants.electro.ElectricPotential;
import squants.electro.ElectricalConductance;
import squants.electro.ElectricalResistance$;
import squants.electro.ElectricalResistanceUnit;
import squants.electro.Gigohms$;
import squants.electro.Kilohms$;
import squants.electro.Megohms$;
import squants.electro.Microohms$;
import squants.electro.Milliohms$;
import squants.electro.Nanohms$;
import squants.electro.OhmMeters$;
import squants.electro.Ohms$;
import squants.electro.Resistivity;
import squants.electro.Siemens$;
import squants.electro.Volts$;
import squants.space.Length;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u000e\u001d\u0005\u0005B\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005U!A\u0011\u0007\u0001BC\u0002\u0013\u0005!\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00034\u0011\u00159\u0004\u0001\"\u00039\u0011\u0015Y\u0004\u0001\"\u0001=\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!a\u000b\u0001\t\u0003\ty\u0004\u0003\u0004\u0002Z\u0001!\t!\u000b\u0005\u0007\u00037\u0002A\u0011A\u0015\t\r\u0005u\u0003\u0001\"\u0001*\u0011\u0019\ty\u0006\u0001C\u0001S!1\u0011\u0011\r\u0001\u0005\u0002%Ba!a\u0019\u0001\t\u0003I\u0003BBA3\u0001\u0011\u0005\u0011\u0006C\u0004\u0002h\u0001!\t!!\u001b\b\u000byb\u0002\u0012A \u0007\u000bma\u0002\u0012\u0001!\t\u000b]\u0012B\u0011\u0001&\t\r-\u0013B\u0011\u0001\u000fM\u0011\u0015Y%\u0003\"\u0001l\u0011\u0015\u0019(\u0003\"\u0001u\u0011\u0015i(\u0003\"\u0001\u007f\u0011\u0019\t)A\u0005C\u0001}\"9\u0011q\u0001\n\u0005\u0002\u0005%\u0001\"CA\u0011%\u0005\u0005I\u0011BA\u0012\u0005Q)E.Z2ue&\u001c\u0017\r\u001c*fg&\u001cH/\u00198dK*\u0011QDH\u0001\bK2,7\r\u001e:p\u0015\u0005y\u0012aB:rk\u0006tGo]\u0002\u0001'\t\u0001!\u0005E\u0002$I\u0019j\u0011AH\u0005\u0003Ky\u0011\u0001\"U;b]RLG/\u001f\t\u0003O\u0001i\u0011\u0001H\u0001\u0006m\u0006dW/Z\u000b\u0002UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t1Ai\\;cY\u0016\faA^1mk\u0016\u0004\u0013\u0001B;oSR,\u0012a\r\t\u0003OQJ!!\u000e\u000f\u00031\u0015cWm\u0019;sS\u000e\fGNU3tSN$\u0018M\\2f+:LG/A\u0003v]&$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004MeR\u0004\"\u0002\u0015\u0006\u0001\u0004Q\u0003\"B\u0019\u0006\u0001\u0004\u0019\u0014!\u00033j[\u0016t7/[8o+\u0005idBA\u0014\u0012\u0003Q)E.Z2ue&\u001c\u0017\r\u001c*fg&\u001cH/\u00198dKB\u0011qEE\n\u0005%\u0005#u\t\u0005\u0002,\u0005&\u00111\t\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0007\r*e%\u0003\u0002G=\tIA)[7f]NLwN\u001c\t\u0003W!K!!\u0013\u0017\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0003}\nQ!\u00199qYf,\"!T0\u0015\u00079C'\u000e\u0006\u0002'\u001f\")\u0001\u000b\u0006a\u0002#\u0006\u0019a.^7\u0011\u0007ISVL\u0004\u0002T1:\u0011AkV\u0007\u0002+*\u0011a\u000bI\u0001\u0007yI|w\u000e\u001e \n\u00035J!!\u0017\u0017\u0002\u000fA\f7m[1hK&\u00111\f\u0018\u0002\b\u001dVlWM]5d\u0015\tIF\u0006\u0005\u0002_?2\u0001A!\u00021\u0015\u0005\u0004\t'!A!\u0012\u0005\t,\u0007CA\u0016d\u0013\t!GFA\u0004O_RD\u0017N\\4\u0011\u0005-2\u0017BA4-\u0005\r\te.\u001f\u0005\u0006SR\u0001\r!X\u0001\u0002]\")\u0011\u0007\u0006a\u0001gQ\u0011AN\u001d\t\u0004[B4S\"\u00018\u000b\u0005=d\u0013\u0001B;uS2L!!\u001d8\u0003\u0007Q\u0013\u0018\u0010C\u0003)+\u0001\u0007Q-\u0001\u0003oC6,W#A;\u0011\u0005Y\\X\"A<\u000b\u0005aL\u0018\u0001\u00027b]\u001eT\u0011A_\u0001\u0005U\u00064\u0018-\u0003\u0002}o\n11\u000b\u001e:j]\u001e\f1\u0002\u001d:j[\u0006\u0014\u00180\u00168jiV\tqPD\u0002(\u0003\u0003I1!a\u0001\u001d\u0003\u0011y\u0005.\\:\u0002\rMLWK\\5u\u0003\u0015)h.\u001b;t+\t\tY\u0001\u0005\u0004\u0002\u000e\u0005]\u00111D\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003+a\u0013AC2pY2,7\r^5p]&!\u0011\u0011DA\b\u0005\r\u0019V\r\u001e\t\u0005G\u0005ua%C\u0002\u0002 y\u0011Q\"\u00168ji>3W*Z1tkJ,\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\n\u0011\u0007Y\f9#C\u0002\u0002*]\u0014aa\u00142kK\u000e$\u0018A\u0002\u0013uS6,7\u000f\u0006\u0003\u00020\u0005U\u0002cA\u0014\u00022%\u0019\u00111\u0007\u000f\u0003#\u0015cWm\u0019;sS\u000e\u0004v\u000e^3oi&\fG\u000eC\u0004\u00028\u001d\u0001\r!!\u000f\u0002\tQD\u0017\r\u001e\t\u0004O\u0005m\u0012bAA\u001f9\tyQ\t\\3diJL7mQ;se\u0016tG\u000f\u0006\u0003\u0002B\u0005\u001d\u0003cA\u0014\u0002D%\u0019\u0011Q\t\u000f\u0003\u0017I+7/[:uSZLG/\u001f\u0005\b\u0003oA\u0001\u0019AA%!\u0011\tY%a\u0015\u000f\t\u00055\u0013\u0011\u000b\b\u0004)\u0006=\u0013\"A\u0010\n\u0005es\u0012\u0002BA+\u0003/\u0012a\u0001T3oORD'BA-\u001f\u0003\u0019!xn\u00145ng\u0006IAo\u001c(b]>DWn]\u0001\u000bi>l\u0015n\u0019:pQ6\u001c\u0018A\u0003;p\u001b&dGn\u001c5ng\u0006IAo\\&jY>DWn]\u0001\ni>lUmZ8i[N\f\u0011\u0002^8HS\u001e|\u0007.\\:\u0002\u0013%t7+[3nK:\u001cXCAA6!\r9\u0013QN\u0005\u0004\u0003_b\"!F#mK\u000e$(/[2bY\u000e{g\u000eZ;di\u0006t7-\u001a")
public final class ElectricalResistance
extends Quantity<ElectricalResistance> {
    private final double value;
    private final ElectricalResistanceUnit unit;

    public static Set<UnitOfMeasure<ElectricalResistance>> units() {
        return ElectricalResistance$.MODULE$.units();
    }

    public static Ohms$ siUnit() {
        return ElectricalResistance$.MODULE$.siUnit();
    }

    public static Ohms$ primaryUnit() {
        return ElectricalResistance$.MODULE$.primaryUnit();
    }

    public static String name() {
        return ElectricalResistance$.MODULE$.name();
    }

    public static Try<ElectricalResistance> apply(Object object) {
        return ElectricalResistance$.MODULE$.apply(object);
    }

    public static Dimension<ElectricalResistance> dimensionImplicit() {
        return ElectricalResistance$.MODULE$.dimensionImplicit();
    }

    public static <N> Try<ElectricalResistance> parseTuple(Tuple2<N, String> tuple22, Numeric<N> numeric) {
        return ElectricalResistance$.MODULE$.parseTuple(tuple22, numeric);
    }

    public static Try<ElectricalResistance> parseString(String string2) {
        return ElectricalResistance$.MODULE$.parseString(string2);
    }

    public static Option<UnitOfMeasure<ElectricalResistance>> symbolToUnit(String string2) {
        return ElectricalResistance$.MODULE$.symbolToUnit(string2);
    }

    @Override
    public double value() {
        return this.value;
    }

    public ElectricalResistanceUnit unit() {
        return this.unit;
    }

    public ElectricalResistance$ dimension() {
        return ElectricalResistance$.MODULE$;
    }

    public ElectricPotential $times(ElectricCurrent that) {
        return Volts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toOhms() * that.toAmperes())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Resistivity $times(Length that) {
        return OhmMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toOhms() * that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toOhms() {
        return this.to(Ohms$.MODULE$);
    }

    public double toNanohms() {
        return this.to(Nanohms$.MODULE$);
    }

    public double toMicrohms() {
        return this.to(Microohms$.MODULE$);
    }

    public double toMillohms() {
        return this.to(Milliohms$.MODULE$);
    }

    public double toKilohms() {
        return this.to(Kilohms$.MODULE$);
    }

    public double toMegohms() {
        return this.to(Megohms$.MODULE$);
    }

    public double toGigohms() {
        return this.to(Gigohms$.MODULE$);
    }

    public ElectricalConductance inSiemens() {
        return Siemens$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(1.0 / this.to(Ohms$.MODULE$))), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricalResistance(double value, ElectricalResistanceUnit unit) {
        this.value = value;
        this.unit = unit;
    }
}

