/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.raster.ShortCellType$;
import geotrellis.raster.UShortArrayTile;
import geotrellis.raster.UShortCellType$;
import geotrellis.raster.UShortCells;
import geotrellis.raster.UShortCells$;
import geotrellis.raster.UShortConstantNoDataArrayTile;
import geotrellis.raster.UShortConstantNoDataCellType$;
import geotrellis.raster.UShortRawArrayTile;
import geotrellis.raster.UShortUserDefinedNoDataArrayTile;
import geotrellis.raster.UShortUserDefinedNoDataCellType;
import geotrellis.raster.package$;
import geotrellis.raster.package$ShortArrayFiller$;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class UShortArrayTile$
implements Serializable {
    public static UShortArrayTile$ MODULE$;

    static {
        new UShortArrayTile$();
    }

    public UShortArrayTile apply(short[] arr, int cols, int rows) {
        return this.apply(arr, cols, rows, UShortConstantNoDataCellType$.MODULE$);
    }

    public UShortArrayTile apply(short[] arr, int cols, int rows, UShortCells cellType) {
        UShortArrayTile uShortArrayTile;
        UShortCells uShortCells = cellType;
        if (UShortCellType$.MODULE$.equals(uShortCells)) {
            uShortArrayTile = new UShortRawArrayTile(arr, cols, rows);
        } else if (UShortConstantNoDataCellType$.MODULE$.equals(uShortCells)) {
            uShortArrayTile = new UShortConstantNoDataArrayTile(arr, cols, rows);
        } else if (uShortCells instanceof UShortUserDefinedNoDataCellType) {
            UShortUserDefinedNoDataCellType uShortUserDefinedNoDataCellType = (UShortUserDefinedNoDataCellType)uShortCells;
            uShortArrayTile = new UShortUserDefinedNoDataArrayTile(arr, cols, rows, uShortUserDefinedNoDataCellType);
        } else {
            throw new MatchError((Object)uShortCells);
        }
        return uShortArrayTile;
    }

    public UShortArrayTile apply(short[] arr, int cols, int rows, Option<Object> noDataValue) {
        return this.apply(arr, cols, rows, UShortCells$.MODULE$.withNoData(noDataValue));
    }

    public UShortArrayTile apply(short[] arr, int cols, int rows, short noDataValue) {
        return this.apply(arr, cols, rows, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)noDataValue)));
    }

    public UShortArrayTile ofDim(int cols, int rows) {
        return new UShortConstantNoDataArrayTile((short[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Short()), cols, rows);
    }

    public UShortArrayTile ofDim(int cols, int rows, UShortCells cellType) {
        UShortArrayTile uShortArrayTile;
        UShortCells uShortCells = cellType;
        if (UShortCellType$.MODULE$.equals(uShortCells)) {
            uShortArrayTile = new UShortRawArrayTile((short[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Short()), cols, rows);
        } else if (UShortConstantNoDataCellType$.MODULE$.equals(uShortCells)) {
            uShortArrayTile = new UShortConstantNoDataArrayTile((short[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Short()), cols, rows);
        } else if (uShortCells instanceof UShortUserDefinedNoDataCellType) {
            UShortUserDefinedNoDataCellType uShortUserDefinedNoDataCellType = (UShortUserDefinedNoDataCellType)uShortCells;
            uShortArrayTile = new UShortUserDefinedNoDataArrayTile((short[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Short()), cols, rows, uShortUserDefinedNoDataCellType);
        } else {
            throw new MatchError((Object)uShortCells);
        }
        return uShortArrayTile;
    }

    public UShortArrayTile empty(int cols, int rows) {
        return this.empty(cols, rows, UShortConstantNoDataCellType$.MODULE$);
    }

    public UShortArrayTile empty(int cols, int rows, UShortCells cellType) {
        UShortArrayTile uShortArrayTile;
        UShortCells uShortCells = cellType;
        if (UShortCellType$.MODULE$.equals(uShortCells)) {
            uShortArrayTile = this.ofDim(cols, rows, cellType);
        } else if (UShortConstantNoDataCellType$.MODULE$.equals(uShortCells)) {
            uShortArrayTile = this.fill(package$.MODULE$.ushortNODATA(), cols, rows, cellType);
        } else if (uShortCells instanceof UShortUserDefinedNoDataCellType) {
            UShortUserDefinedNoDataCellType uShortUserDefinedNoDataCellType = (UShortUserDefinedNoDataCellType)uShortCells;
            short nd = uShortUserDefinedNoDataCellType.noDataValue();
            uShortArrayTile = this.fill(nd, cols, rows, cellType);
        } else {
            throw new MatchError((Object)uShortCells);
        }
        return uShortArrayTile;
    }

    public UShortArrayTile fill(short v, int cols, int rows) {
        return this.fill(v, cols, rows, UShortConstantNoDataCellType$.MODULE$);
    }

    public UShortArrayTile fill(short v, int cols, int rows, UShortCells cellType) {
        UShortArrayTile uShortArrayTile;
        UShortCells uShortCells = cellType;
        if (UShortCellType$.MODULE$.equals(uShortCells)) {
            uShortArrayTile = new UShortRawArrayTile(package$ShortArrayFiller$.MODULE$.fill$extension(package$.MODULE$.ShortArrayFiller((short[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Short())), v), cols, rows);
        } else if (UShortConstantNoDataCellType$.MODULE$.equals(uShortCells)) {
            uShortArrayTile = new UShortConstantNoDataArrayTile(package$ShortArrayFiller$.MODULE$.fill$extension(package$.MODULE$.ShortArrayFiller((short[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Short())), v), cols, rows);
        } else if (uShortCells instanceof UShortUserDefinedNoDataCellType) {
            UShortUserDefinedNoDataCellType uShortUserDefinedNoDataCellType = (UShortUserDefinedNoDataCellType)uShortCells;
            uShortArrayTile = new UShortUserDefinedNoDataArrayTile(package$ShortArrayFiller$.MODULE$.fill$extension(package$.MODULE$.ShortArrayFiller((short[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Short())), v), cols, rows, uShortUserDefinedNoDataCellType);
        } else {
            throw new MatchError((Object)uShortCells);
        }
        return uShortArrayTile;
    }

    private short[] constructShortArray(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, 0, bytes.length);
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        short[] shortArray = new short[bytes.length / ShortCellType$.MODULE$.bytes()];
        shortBuffer.get(shortArray);
        return shortArray;
    }

    public UShortArrayTile fromBytes(byte[] bytes, int cols, int rows) {
        return this.fromBytes(bytes, cols, rows, UShortConstantNoDataCellType$.MODULE$);
    }

    public UShortArrayTile fromBytes(byte[] bytes, int cols, int rows, UShortCells cellType) {
        UShortArrayTile uShortArrayTile;
        UShortCells uShortCells = cellType;
        if (UShortCellType$.MODULE$.equals(uShortCells)) {
            uShortArrayTile = new UShortRawArrayTile(this.constructShortArray((byte[])bytes.clone()), cols, rows);
        } else if (UShortConstantNoDataCellType$.MODULE$.equals(uShortCells)) {
            uShortArrayTile = new UShortConstantNoDataArrayTile(this.constructShortArray((byte[])bytes.clone()), cols, rows);
        } else if (uShortCells instanceof UShortUserDefinedNoDataCellType) {
            UShortUserDefinedNoDataCellType uShortUserDefinedNoDataCellType = (UShortUserDefinedNoDataCellType)uShortCells;
            uShortArrayTile = new UShortUserDefinedNoDataArrayTile(this.constructShortArray((byte[])bytes.clone()), cols, rows, uShortUserDefinedNoDataCellType);
        } else {
            throw new MatchError((Object)uShortCells);
        }
        return uShortArrayTile;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private UShortArrayTile$() {
        MODULE$ = this;
    }
}

