/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.proj4.CRS;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.CellSize;
import geotrellis.raster.DataType;
import geotrellis.raster.GeoAttrsError;
import geotrellis.raster.GridBounds;
import geotrellis.raster.PixelSampleType;
import geotrellis.raster.ProjectedRaster;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.crop.Crop;
import geotrellis.raster.crop.Crop$Options$;
import geotrellis.raster.io.geotiff.BandType$;
import geotrellis.raster.io.geotiff.GeoTiff;
import geotrellis.raster.io.geotiff.GeoTiff$;
import geotrellis.raster.io.geotiff.GeoTiffBuilder$;
import geotrellis.raster.io.geotiff.GeoTiffData;
import geotrellis.raster.io.geotiff.GeoTiffImageData;
import geotrellis.raster.io.geotiff.GeoTiffOptions;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout$;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.InterleaveMethod;
import geotrellis.raster.io.geotiff.NewSubfileType;
import geotrellis.raster.io.geotiff.OverviewStrategy;
import geotrellis.raster.io.geotiff.PixelInterleave$;
import geotrellis.raster.io.geotiff.ReducedImage$;
import geotrellis.raster.io.geotiff.SinglebandGeoTiff$;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.Tags;
import geotrellis.raster.io.geotiff.Tags$;
import geotrellis.raster.io.geotiff.TiffType;
import geotrellis.raster.io.geotiff.Tiled;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.package$;
import geotrellis.raster.render.IndexedColorMap;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.util.ByteReader;
import geotrellis.vector.Extent;
import geotrellis.vector.ProjectedExtent;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Product2;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r}d\u0001\u0002\"D\u00012C\u0001\"\u0019\u0001\u0003\u0016\u0004%\tA\u0019\u0005\tG\u0002\u0011\t\u0012)A\u0005/\"AA\r\u0001BK\u0002\u0013\u0005Q\r\u0003\u0005m\u0001\tE\t\u0015!\u0003g\u0011!i\u0007A!f\u0001\n\u0003q\u0007\u0002C;\u0001\u0005#\u0005\u000b\u0011B8\t\u0011Y\u0004!Q3A\u0005\u0002]D\u0001b\u001f\u0001\u0003\u0012\u0003\u0006I\u0001\u001f\u0005\ty\u0002\u0011)\u001a!C\u0001{\"I\u00111\u0001\u0001\u0003\u0012\u0003\u0006IA \u0005\u000b\u0003\u000b\u0001!Q3A\u0005\u0002\u0005\u001d\u0001BCA\u0011\u0001\tE\t\u0015!\u0003\u0002\n!9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0002\"CA\u001b\u0001\t\u0007I\u0011AA\u001c\u0011!\t)\u0005\u0001Q\u0001\n\u0005e\u0002bBA$\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003+\u0002A\u0011AA,\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003KBq!!\u001c\u0001\t\u0003\ty\u0007C\u0004\u0002n\u0001!\t!!#\t\u000f\u00055\u0004\u0001\"\u0001\u0002\u001a\"9\u0011Q\u000e\u0001\u0005\u0002\u0005\u001d\u0006bBA7\u0001\u0011\u0005\u00111\u0017\u0005\b\u0003[\u0002A\u0011AA\\\u0011\u001d\ti\u0007\u0001C\u0001\u0003_Dq!a8\u0001\t\u0003\u00119\u0001C\u0004\u0003\u0018\u0001!\tA!\u0007\t\u000f\t\u0015\u0002\u0001\"\u0001\u0003(!I!1\u0007\u0001\u0012\u0002\u0013\u0005!Q\u0007\u0005\n\u0005\u0017\u0002\u0011\u0013!C\u0001\u0005\u001bBqA!\u0015\u0001\t\u0003\u0011\u0019\u0006C\u0005\u0003b\u0001\t\n\u0011\"\u0001\u0003d!I!q\r\u0001\u0012\u0002\u0013\u0005!\u0011\u000e\u0005\n\u0005[\u0002\u0011\u0013!C\u0001\u0005_B\u0011Ba\u001d\u0001#\u0003%\tA!\u001e\t\u0013\te\u0004!%A\u0005\u0002\tm\u0004\"\u0003B@\u0001E\u0005I\u0011\u0001BA\u0011%\u0011)\tAA\u0001\n\u0003\u00129\tC\u0005\u0003\u001a\u0002\t\t\u0011\"\u0001\u0003\u001c\"I!Q\u0014\u0001\u0002\u0002\u0013\u0005!q\u0014\u0005\n\u0005W\u0003\u0011\u0011!C!\u0005[C\u0011B!/\u0001\u0003\u0003%\tAa/\t\u0013\t\u0015\u0007!!A\u0005B\t\u001d\u0007\"\u0003Be\u0001\u0005\u0005I\u0011\tBf\u0011%\u0011i\rAA\u0001\n\u0003\u0012ymB\u0004\u0003T\u000eC\tA!6\u0007\r\t\u001b\u0005\u0012\u0001Bl\u0011\u001d\t\u0019c\fC\u0001\u00053DqAa70\t\u0003\u0011i\u000eC\u0004\u0003\\>\"\tA!:\t\u000f\tmw\u0006\"\u0001\u0003x\"9!1\\\u0018\u0005\u0002\t}\bb\u0002Bn_\u0011\u000511\u0003\u0005\b\u00057|C\u0011AB\u000e\u0011\u001d\u0011Yn\fC\u0001\u0007OAqAa70\t\u0003\u0019i\u0003C\u0004\u0003\\>\"\taa\u0010\t\u000f\tmw\u0006\"\u0001\u0004F!9!Q`\u0018\u0005\u0002\r-\u0003b\u0002B\u007f_\u0011\u00051q\n\u0005\n\u00057|\u0013\u0011!CA\u0007'B\u0011b!\u00190#\u0003%\tA!!\t\u0013\r\rt&!A\u0005\u0002\u000e\u0015\u0004\"CB:_E\u0005I\u0011\u0001BA\u0011%\u0019)hLA\u0001\n\u0013\u00199HA\tTS:<G.\u001a2b]\u0012<Um\u001c+jM\u001aT!\u0001R#\u0002\u000f\u001d,w\u000e^5gM*\u0011aiR\u0001\u0003S>T!\u0001S%\u0002\rI\f7\u000f^3s\u0015\u0005Q\u0015AC4f_R\u0014X\r\u001c7jg\u000e\u00011#\u0002\u0001N'ns\u0006C\u0001(R\u001b\u0005y%\"\u0001)\u0002\u000bM\u001c\u0017\r\\1\n\u0005I{%AB!osJ+g\rE\u0002U+^k\u0011aQ\u0005\u0003-\u000e\u0013qaR3p)&4g\r\u0005\u0002Y36\tq)\u0003\u0002[\u000f\n!A+\u001b7f!\tqE,\u0003\u0002^\u001f\n9\u0001K]8ek\u000e$\bC\u0001(`\u0013\t\u0001wJ\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003uS2,W#A,\u0002\u000bQLG.\u001a\u0011\u0002\r\u0015DH/\u001a8u+\u00051\u0007CA4k\u001b\u0005A'BA5J\u0003\u00191Xm\u0019;pe&\u00111\u000e\u001b\u0002\u0007\u000bb$XM\u001c;\u0002\u000f\u0015DH/\u001a8uA\u0005\u00191M]:\u0016\u0003=\u0004\"\u0001]:\u000e\u0003ET!A]%\u0002\u000bA\u0014xN\u001b\u001b\n\u0005Q\f(aA\"S'\u0006!1M]:!\u0003\u0011!\u0018mZ:\u0016\u0003a\u0004\"\u0001V=\n\u0005i\u001c%\u0001\u0002+bON\fQ\u0001^1hg\u0002\nqa\u001c9uS>t7/F\u0001\u007f!\t!v0C\u0002\u0002\u0002\r\u0013abR3p)&4gm\u00149uS>t7/\u0001\u0005paRLwN\\:!\u0003%yg/\u001a:wS\u0016<8/\u0006\u0002\u0002\nA)\u00111BA\u000e':!\u0011QBA\f\u001d\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\n\u0017\u00061AH]8pizJ\u0011\u0001U\u0005\u0004\u00033y\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003;\tyB\u0001\u0003MSN$(bAA\r\u001f\u0006QqN^3sm&,wo\u001d\u0011\u0002\rqJg.\u001b;?)9\t9#!\u000b\u0002,\u00055\u0012qFA\u0019\u0003g\u0001\"\u0001\u0016\u0001\t\u000b\u0005l\u0001\u0019A,\t\u000b\u0011l\u0001\u0019\u00014\t\u000b5l\u0001\u0019A8\t\u000bYl\u0001\u0019\u0001=\t\u000bql\u0001\u0019\u0001@\t\u0013\u0005\u0015Q\u0002%AA\u0002\u0005%\u0011\u0001C2fY2$\u0016\u0010]3\u0016\u0005\u0005e\u0002\u0003BA\u001e\u0003\u007fq1\u0001WA\u001f\u0013\r\tIbR\u0005\u0005\u0003\u0003\n\u0019E\u0001\u0005DK2dG+\u001f9f\u0015\r\tIbR\u0001\nG\u0016dG\u000eV=qK\u0002\nq!\\1q)&dW\r\u0006\u0003\u0002(\u0005-\u0003bBA'!\u0001\u0007\u0011qJ\u0001\u0002MB)a*!\u0015X/&\u0019\u00111K(\u0003\u0013\u0019+hn\u0019;j_:\f\u0014!E<ji\"\u001cFo\u001c:bO\u0016lU\r\u001e5pIR!\u0011qEA-\u0011\u001d\tY&\u0005a\u0001\u0003;\nQb\u001d;pe\u0006<W-T3uQ>$\u0007c\u0001+\u0002`%\u0019\u0011\u0011M\"\u0003\u001bM#xN]1hK6+G\u000f[8e\u0003%IW.Y4f\t\u0006$\u0018-\u0006\u0002\u0002hA\u0019A+!\u001b\n\u0007\u0005-4I\u0001\tHK>$\u0016N\u001a4J[\u0006<W\rR1uC\u0006!1M]8q)\u0019\t9#!\u001d\u0002v!1\u00111O\nA\u0002\u0019\f\u0011b];c\u000bb$XM\u001c;\t\rq\u001c\u0002\u0019AA<!\u0011\tI(a!\u000f\t\u0005m\u0014qP\u0007\u0003\u0003{R1!!\u001cH\u0013\u0011\t\t)! \u0002\t\r\u0013x\u000e]\u0005\u0005\u0003\u000b\u000b9IA\u0004PaRLwN\\:\u000b\t\u0005\u0005\u0015Q\u0010\u000b\u0007\u0003O\tY)!&\t\u000f\u00055E\u00031\u0001\u0002\u0010\u000611m\u001c7NCb\u00042ATAI\u0013\r\t\u0019j\u0014\u0002\u0004\u0013:$\bbBAL)\u0001\u0007\u0011qR\u0001\u0007e><X*\u0019=\u0015\u0015\u0005\u001d\u00121TAP\u0003G\u000b)\u000bC\u0004\u0002\u001eV\u0001\r!a$\u0002\r\r|G.T5o\u0011\u001d\t\t+\u0006a\u0001\u0003\u001f\u000baA]8x\u001b&t\u0007bBAG+\u0001\u0007\u0011q\u0012\u0005\b\u0003/+\u0002\u0019AAH)\u0011\t9#!+\t\u000f\u0005-f\u00031\u0001\u0002.\u0006QqM]5e\u0005>,h\u000eZ:\u0011\u000ba\u000by+a$\n\u0007\u0005EvI\u0001\u0006He&$'i\\;oIN$B!a\n\u00026\"1\u00111O\fA\u0002\u0019$\"\"!/\u0002J\u0006-\u0017Q[As!\u0011\tY,!2\u000f\t\u0005u\u0016Q\b\b\u0005\u0003\u007f\u000b\u0019M\u0004\u0003\u0002\u0010\u0005\u0005\u0017\"\u0001&\n\u0005!K\u0015\u0002BAd\u0003\u0007\u0012\u0001cU5oO2,'-\u00198e%\u0006\u001cH/\u001a:\t\r\u0005M\u0004\u00041\u0001g\u0011\u001d\ti\r\u0007a\u0001\u0003\u001f\f\u0001bY3mYNK'0\u001a\t\u00041\u0006E\u0017bAAj\u000f\nA1)\u001a7m'&TX\rC\u0004\u0002Xb\u0001\r!!7\u0002\u001dI,7/Y7qY\u0016lU\r\u001e5pIB!\u00111\\Aq\u001b\t\tiNC\u0002\u0002`\u001e\u000b\u0001B]3tC6\u0004H.Z\u0005\u0005\u0003G\fiN\u0001\bSKN\fW\u000e\u001d7f\u001b\u0016$\bn\u001c3\t\u000f\u0005\u001d\b\u00041\u0001\u0002j\u0006A1\u000f\u001e:bi\u0016<\u0017\u0010E\u0002U\u0003WL1!!<D\u0005Aye/\u001a:wS\u0016<8\u000b\u001e:bi\u0016<\u0017\u0010\u0006\u0003\u0002r\u0006u\bCBA\u0006\u0003g\f90\u0003\u0003\u0002v\u0006}!\u0001C%uKJ\fGo\u001c:\u0011\r9\u000bI0!,X\u0013\r\tYp\u0014\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005}\u0018\u00041\u0001\u0003\u0002\u00059q/\u001b8e_^\u001c\bCBA\u0006\u0005\u0007\ti+\u0003\u0003\u0003\u0006\u0005}!aA*fcRA\u0011\u0011\u0018B\u0005\u0005'\u0011)\u0002C\u0004\u0003\fi\u0001\rA!\u0004\u0002\u0019I\f7\u000f^3s\u000bb$XM\u001c;\u0011\u0007a\u0013y!C\u0002\u0003\u0012\u001d\u0013ABU1ti\u0016\u0014X\t\u001f;f]RDq!a6\u001b\u0001\u0004\tI\u000eC\u0004\u0002hj\u0001\r!!;\u0002\u001b\t,\u0018\u000e\u001c3Pm\u0016\u0014h/[3x)!\t9Ca\u0007\u0003\u001e\t\u0005\u0002bBAl7\u0001\u0007\u0011\u0011\u001c\u0005\b\u0005?Y\u0002\u0019AAH\u0003A!WmY5nCRLwN\u001c$bGR|'\u000fC\u0005\u0003$m\u0001\n\u00111\u0001\u0002\u0010\u0006I!\r\\8dWNK'0Z\u0001\u000eo&$\bn\u0014<feZLWm^:\u0015\u0011\u0005\u001d\"\u0011\u0006B\u0016\u0005cAq!a6\u001d\u0001\u0004\tI\u000eC\u0005\u0003.q\u0001\n\u00111\u0001\u00030\u0005YA-Z2j[\u0006$\u0018n\u001c8t!\u0019\tY!a\u0007\u0002\u0010\"I!1\u0005\u000f\u0011\u0002\u0003\u0007\u0011qR\u0001\u0018o&$\bn\u0014<feZLWm^:%I\u00164\u0017-\u001e7uII*\"Aa\u000e+\t\t=\"\u0011H\u0016\u0003\u0005w\u0001BA!\u0010\u0003H5\u0011!q\b\u0006\u0005\u0005\u0003\u0012\u0019%A\u0005v]\u000eDWmY6fI*\u0019!QI(\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003J\t}\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00069r/\u001b;i\u001fZ,'O^5foN$C-\u001a4bk2$HeM\u000b\u0003\u0005\u001fRC!a$\u0003:\u0005!1m\u001c9z)9\t9C!\u0016\u0003X\te#1\fB/\u0005?Bq!Y\u0010\u0011\u0002\u0003\u0007q\u000bC\u0004e?A\u0005\t\u0019\u00014\t\u000f5|\u0002\u0013!a\u0001_\"9ao\bI\u0001\u0002\u0004A\bb\u0002? !\u0003\u0005\rA \u0005\n\u0003\u000by\u0002\u0013!a\u0001\u0003\u0013\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003f)\u001aqK!\u000f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u000e\u0016\u0004M\ne\u0012AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005cR3a\u001cB\u001d\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"Aa\u001e+\u0007a\u0014I$\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\tu$f\u0001@\u0003:\u0005q1m\u001c9zI\u0011,g-Y;mi\u00122TC\u0001BBU\u0011\tIA!\u000f\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011I\t\u0005\u0003\u0003\f\nUUB\u0001BG\u0015\u0011\u0011yI!%\u0002\t1\fgn\u001a\u0006\u0003\u0005'\u000bAA[1wC&!!q\u0013BG\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011qR\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011\tKa*\u0011\u00079\u0013\u0019+C\u0002\u0003&>\u00131!\u00118z\u0011%\u0011I\u000bKA\u0001\u0002\u0004\ty)A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005_\u0003bA!-\u00038\n\u0005VB\u0001BZ\u0015\r\u0011)lT\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA{\u0005g\u000b\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005{\u0013\u0019\rE\u0002O\u0005\u007fK1A!1P\u0005\u001d\u0011un\u001c7fC:D\u0011B!++\u0003\u0003\u0005\rA!)\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a$\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!#\u0002\r\u0015\fX/\u00197t)\u0011\u0011iL!5\t\u0013\t%V&!AA\u0002\t\u0005\u0016!E*j]\u001edWMY1oI\u001e+w\u000eV5gMB\u0011AkL\n\u0004_5sFC\u0001Bk\u0003\u0015\t\u0007\u000f\u001d7z)!\t9Ca8\u0003b\n\r\b\"B12\u0001\u00049\u0006\"\u000232\u0001\u00041\u0007\"B72\u0001\u0004yG\u0003BA\u0014\u0005ODqA!;3\u0001\u0004\u0011Y/A\u0003csR,7\u000fE\u0003O\u0005[\u0014\t0C\u0002\u0003p>\u0013Q!\u0011:sCf\u00042A\u0014Bz\u0013\r\u0011)p\u0014\u0002\u0005\u0005f$X\r\u0006\u0004\u0002(\te(1 \u0005\b\u0005S\u001c\u0004\u0019\u0001Bv\u0011\u001d\u0011ip\ra\u0001\u0005{\u000b\u0011b\u001d;sK\u0006l\u0017N\\4\u0015\t\u0005\u001d2\u0011\u0001\u0005\b\u0007\u0007!\u0004\u0019AB\u0003\u0003\u0011\u0001\u0018\r\u001e5\u0011\t\r\u001d1q\u0002\b\u0005\u0007\u0013\u0019Y\u0001E\u0002\u0002\u0010=K1a!\u0004P\u0003\u0019\u0001&/\u001a3fM&!!qSB\t\u0015\r\u0019ia\u0014\u000b\u0007\u0003O\u0019)ba\u0006\t\u000f\r\rQ\u00071\u0001\u0004\u0006!11\u0011D\u001bA\u0002\u0019\f\u0011!\u001a\u000b\u0007\u0003O\u0019iba\b\t\u000f\r\ra\u00071\u0001\u0004\u0006!91\u0011\u0004\u001cA\u0002\r\u0005\u0002\u0003\u0002(\u0004$\u0019L1a!\nP\u0005\u0019y\u0005\u000f^5p]R1\u0011qEB\u0015\u0007WAqaa\u00018\u0001\u0004\u0019)\u0001C\u0004\u0003~^\u0002\rA!0\u0015\t\u0005\u001d2q\u0006\u0005\b\u0007cA\u0004\u0019AB\u001a\u0003)\u0011\u0017\u0010^3SK\u0006$WM\u001d\t\u0005\u0007k\u0019Y$\u0004\u0002\u00048)\u00191\u0011H%\u0002\tU$\u0018\u000e\\\u0005\u0005\u0007{\u00199D\u0001\u0006CsR,'+Z1eKJ$b!a\n\u0004B\r\r\u0003bBB\u0019s\u0001\u000711\u0007\u0005\u0007\u00073I\u0004\u0019\u00014\u0015\r\u0005\u001d2qIB%\u0011\u001d\u0019\tD\u000fa\u0001\u0007gAqa!\u0007;\u0001\u0004\u0019\t\u0003\u0006\u0003\u0002(\r5\u0003bBB\u0002w\u0001\u00071Q\u0001\u000b\u0005\u0003O\u0019\t\u0006C\u0004\u00042q\u0002\raa\r\u0015\u001d\u0005\u001d2QKB,\u00073\u001aYf!\u0018\u0004`!)\u0011-\u0010a\u0001/\")A-\u0010a\u0001M\")Q.\u0010a\u0001_\")a/\u0010a\u0001q\")A0\u0010a\u0001}\"I\u0011QA\u001f\u0011\u0002\u0003\u0007\u0011\u0011B\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%m\u00059QO\\1qa2LH\u0003BB4\u0007_\u0002RATB\u0012\u0007S\u0002\"BTB6/\u001a|\u0007P`A\u0005\u0013\r\u0019ig\u0014\u0002\u0007)V\u0004H.\u001a\u001c\t\u0013\rEt(!AA\u0002\u0005\u001d\u0012a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY\n1B]3bIJ+7o\u001c7wKR\u00111\u0011\u0010\t\u0005\u0005\u0017\u001bY(\u0003\u0003\u0004~\t5%AB(cU\u0016\u001cG\u000f")
public class SinglebandGeoTiff
implements GeoTiff<Tile>,
Product,
scala.Serializable {
    private final Tile tile;
    private final Extent extent;
    private final CRS crs;
    private final Tags tags;
    private final GeoTiffOptions options;
    private final List<GeoTiff<Tile>> overviews;
    private final DataType cellType;

    public static List<GeoTiff<Tile>> $lessinit$greater$default$6() {
        return SinglebandGeoTiff$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<Tuple6<Tile, Extent, CRS, Tags, GeoTiffOptions, List<GeoTiff<Tile>>>> unapply(SinglebandGeoTiff singlebandGeoTiff) {
        return SinglebandGeoTiff$.MODULE$.unapply(singlebandGeoTiff);
    }

    public static List<GeoTiff<Tile>> apply$default$6() {
        return SinglebandGeoTiff$.MODULE$.apply$default$6();
    }

    public static SinglebandGeoTiff apply(Tile tile, Extent extent, CRS cRS, Tags tags, GeoTiffOptions geoTiffOptions, List<GeoTiff<Tile>> list2) {
        return SinglebandGeoTiff$.MODULE$.apply(tile, extent, cRS, tags, geoTiffOptions, list2);
    }

    public static SinglebandGeoTiff streaming(ByteReader byteReader) {
        return SinglebandGeoTiff$.MODULE$.streaming(byteReader);
    }

    public static SinglebandGeoTiff streaming(String string2) {
        return SinglebandGeoTiff$.MODULE$.streaming(string2);
    }

    public static SinglebandGeoTiff apply(ByteReader byteReader, Option<Extent> option2) {
        return SinglebandGeoTiff$.MODULE$.apply(byteReader, option2);
    }

    public static SinglebandGeoTiff apply(ByteReader byteReader, Extent extent) {
        return SinglebandGeoTiff$.MODULE$.apply(byteReader, extent);
    }

    public static SinglebandGeoTiff apply(ByteReader byteReader) {
        return SinglebandGeoTiff$.MODULE$.apply(byteReader);
    }

    public static SinglebandGeoTiff apply(String string2, boolean bl) {
        return SinglebandGeoTiff$.MODULE$.apply(string2, bl);
    }

    public static SinglebandGeoTiff apply(String string2, Option<Extent> option2) {
        return SinglebandGeoTiff$.MODULE$.apply(string2, option2);
    }

    public static SinglebandGeoTiff apply(String string2, Extent extent) {
        return SinglebandGeoTiff$.MODULE$.apply(string2, extent);
    }

    public static SinglebandGeoTiff apply(String string2) {
        return SinglebandGeoTiff$.MODULE$.apply(string2);
    }

    public static SinglebandGeoTiff apply(byte[] byArray, boolean bl) {
        return SinglebandGeoTiff$.MODULE$.apply(byArray, bl);
    }

    public static SinglebandGeoTiff apply(byte[] byArray) {
        return SinglebandGeoTiff$.MODULE$.apply(byArray);
    }

    public static SinglebandGeoTiff apply(Tile tile, Extent extent, CRS cRS) {
        return SinglebandGeoTiff$.MODULE$.apply(tile, extent, cRS);
    }

    @Override
    public int cols() {
        return GeoTiff.cols$(this);
    }

    @Override
    public int rows() {
        return GeoTiff.rows$(this);
    }

    @Override
    public ProjectedExtent projectedExtent() {
        return GeoTiff.projectedExtent$(this);
    }

    @Override
    public ProjectedRaster<Tile> projectedRaster() {
        return GeoTiff.projectedRaster$(this);
    }

    @Override
    public Raster<Tile> raster() {
        return GeoTiff.raster$(this);
    }

    @Override
    public RasterExtent rasterExtent() {
        return GeoTiff.rasterExtent$(this);
    }

    @Override
    public CellSize cellSize() {
        return GeoTiff.cellSize$(this);
    }

    @Override
    public int bandCount() {
        return GeoTiff.bandCount$(this);
    }

    @Override
    public void write(String path, boolean optimizedOrder) {
        GeoTiff.write$(this, path, optimizedOrder);
    }

    @Override
    public boolean write$default$2() {
        return GeoTiff.write$default$2$(this);
    }

    @Override
    public byte[] toByteArray() {
        return GeoTiff.toByteArray$(this);
    }

    @Override
    public byte[] toCloudOptimizedByteArray() {
        return GeoTiff.toCloudOptimizedByteArray$(this);
    }

    @Override
    public int getOverviewsCount() {
        return GeoTiff.getOverviewsCount$(this);
    }

    @Override
    public GeoTiff<Tile> getOverview(int idx) {
        return GeoTiff.getOverview$(this, idx);
    }

    @Override
    public int buildOverview$default$3() {
        return GeoTiff.buildOverview$default$3$(this);
    }

    @Override
    public GeoTiff<Tile> withOverviews(Seq<GeoTiff<Tile>> overviews) {
        return GeoTiff.withOverviews$(this, overviews);
    }

    @Override
    public Raster<Tile> crop(Extent subExtent, CellSize cellSize) {
        return GeoTiff.crop$(this, subExtent, cellSize);
    }

    @Override
    public Raster<Tile> crop(RasterExtent rasterExtent) {
        return GeoTiff.crop$(this, rasterExtent);
    }

    @Override
    public GeoTiff<Tile> getClosestOverview(CellSize cellSize, OverviewStrategy strategy) {
        return GeoTiff.getClosestOverview$(this, cellSize, strategy);
    }

    @Override
    public OverviewStrategy getClosestOverview$default$2() {
        return GeoTiff.getClosestOverview$default$2$(this);
    }

    @Override
    public Option<PixelSampleType> pixelSampleType() {
        return GeoTiffData.pixelSampleType$(this);
    }

    @Override
    public Tile tile() {
        return this.tile;
    }

    @Override
    public Extent extent() {
        return this.extent;
    }

    @Override
    public CRS crs() {
        return this.crs;
    }

    @Override
    public Tags tags() {
        return this.tags;
    }

    @Override
    public GeoTiffOptions options() {
        return this.options;
    }

    @Override
    public List<GeoTiff<Tile>> overviews() {
        return this.overviews;
    }

    @Override
    public DataType cellType() {
        return this.cellType;
    }

    public SinglebandGeoTiff mapTile(Function1<Tile, Tile> f) {
        return new SinglebandGeoTiff((Tile)f.apply((Object)this.tile()), this.extent(), this.crs(), this.tags(), this.options(), this.overviews());
    }

    public SinglebandGeoTiff withStorageMethod(StorageMethod storageMethod) {
        return new SinglebandGeoTiff(this.tile().toArrayTile(), this.extent(), this.crs(), this.tags(), this.options().copy(storageMethod, this.options().copy$default$2(), this.options().copy$default$3(), this.options().copy$default$4(), this.options().copy$default$5(), this.options().copy$default$6(), this.options().copy$default$7()), this.overviews());
    }

    @Override
    public GeoTiffImageData imageData() {
        GeoTiffTile geoTiffTile;
        Tile tile = this.tile();
        GeoTiffTile geoTiffTile2 = tile instanceof GeoTiffTile ? (geoTiffTile = (GeoTiffTile)tile) : geotrellis.raster.io.geotiff.package$.MODULE$.GeoTiffTileMethods(this.tile()).toGeoTiffTile(this.options());
        return geoTiffTile2;
    }

    public SinglebandGeoTiff crop(Extent subExtent, Crop.Options options) {
        Option<Extent> option2 = this.extent().intersection(subExtent);
        if (!(option2 instanceof Some)) {
            throw new GeoAttrsError(new StringBuilder(60).append("Extent to crop by (").append(subExtent).append(") should intersect the imagery extent (").append(this.extent()).append(").").toString());
        }
        Some some = (Some)option2;
        Extent ext = (Extent)some.value();
        Raster raster = package$.MODULE$.withSinglebandTileRasterCropMethods(this.raster()).crop(ext, options);
        SinglebandGeoTiff singlebandGeoTiff = new SinglebandGeoTiff((Tile)raster.tile(), raster.extent(), this.crs(), this.tags(), this.options(), this.overviews());
        return singlebandGeoTiff;
    }

    public SinglebandGeoTiff crop(int colMax, int rowMax) {
        return this.crop(0, 0, colMax, rowMax);
    }

    public SinglebandGeoTiff crop(int colMin, int rowMin, int colMax, int rowMax) {
        Raster raster = (Raster)package$.MODULE$.withSinglebandTileRasterCropMethods(this.raster()).crop(colMin, rowMin, colMax, rowMax);
        return new SinglebandGeoTiff((Tile)raster.tile(), raster.extent(), this.crs(), this.tags(), this.options(), this.overviews());
    }

    public SinglebandGeoTiff crop(GridBounds<Object> gridBounds) {
        return this.crop(gridBounds.colMin$mcI$sp(), gridBounds.rowMin$mcI$sp(), gridBounds.colMax$mcI$sp(), gridBounds.rowMax$mcI$sp());
    }

    public SinglebandGeoTiff crop(Extent subExtent) {
        return this.crop(subExtent, Crop$Options$.MODULE$.DEFAULT());
    }

    @Override
    public Raster<Tile> crop(Extent subExtent, CellSize cellSize, ResampleMethod resampleMethod, OverviewStrategy strategy) {
        return this.getClosestOverview(cellSize, strategy).crop(subExtent, new Crop.Options(false, Crop$Options$.MODULE$.apply$default$2())).resample(RasterExtent$.MODULE$.apply(subExtent, cellSize), resampleMethod, strategy);
    }

    @Override
    public Iterator<Tuple2<GridBounds<Object>, Tile>> crop(Seq<GridBounds<Object>> windows) {
        Object object;
        Tile tile = this.tile();
        if (tile instanceof GeoTiffTile) {
            GeoTiffTile geoTiffTile = (GeoTiffTile)tile;
            object = geoTiffTile.crop(windows);
        } else if (tile != null) {
            Tile tile2 = tile;
            object = package$.MODULE$.withSinglebandTileCropMethods(tile2).crop(windows);
        } else {
            throw new MatchError((Object)tile);
        }
        return object;
    }

    @Override
    public Raster<Tile> resample(RasterExtent rasterExtent, ResampleMethod resampleMethod, OverviewStrategy strategy) {
        return package$.MODULE$.withSinglebandRasterResampleMethods(this.getClosestOverview(this.cellSize(), strategy).raster()).resample(rasterExtent, resampleMethod);
    }

    public SinglebandGeoTiff buildOverview(ResampleMethod resampleMethod, int decimationFactor, int blockSize) {
        RasterExtent overviewRasterExtent = RasterExtent$.MODULE$.apply(this.extent(), (int)scala.math.package$.MODULE$.ceil((double)this.tile().cols$mcI$sp() / (double)decimationFactor), (int)scala.math.package$.MODULE$.ceil((double)this.tile().rows$mcI$sp() / (double)decimationFactor));
        GeoTiffSegmentLayout segmentLayout = GeoTiffSegmentLayout$.MODULE$.apply(overviewRasterExtent.cols(), overviewRasterExtent.rows(), new Tiled(blockSize, blockSize), PixelInterleave$.MODULE$, BandType$.MODULE$.forCellType(this.tile().cellType()));
        Seq segments = (Seq)((TraversableLike)package$.MODULE$.withSinglebandTileSplitMethods(package$.MODULE$.withSinglebandRasterResampleMethods(new Raster<Tile>(this.tile().toArrayTile(), this.extent())).resample(overviewRasterExtent, resampleMethod).tile()).split(segmentLayout.tileLayout()).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple22 = x0$1;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Tile tile = (Tile)tuple22._1();
            int index = tuple22._2$mcI$sp();
            int col = index % segmentLayout.tileLayout().layoutCols();
            int row = index / segmentLayout.tileLayout().layoutCols();
            Tuple2 tuple23 = new Tuple2((Object)new Tuple2.mcII.sp(col, row), (Object)tile);
            return tuple23;
        }, Seq$.MODULE$.canBuildFrom());
        Tiled storageMethod = new Tiled(blockSize, blockSize);
        Some x$1 = new Some((Object)ReducedImage$.MODULE$);
        Tiled x$2 = storageMethod;
        Compression x$3 = this.options().copy$default$2();
        int x$4 = this.options().copy$default$3();
        Option<IndexedColorMap> x$5 = this.options().copy$default$4();
        InterleaveMethod x$6 = this.options().copy$default$5();
        TiffType x$7 = this.options().copy$default$7();
        GeoTiffOptions overviewOptions = this.options().copy(x$2, x$3, x$4, x$5, x$6, (Option<NewSubfileType>)x$1, x$7);
        Tile overviewTile = GeoTiffBuilder$.MODULE$.apply(GeoTiffBuilder$.MODULE$.singlebandGeoTiffBuilder()).makeTile((Iterator<Tuple2<Product2<Object, Object>, Tile>>)segments.iterator(), segmentLayout, this.cellType(), this.options().compression());
        return new SinglebandGeoTiff(overviewTile, this.extent(), this.crs(), Tags$.MODULE$.empty(), overviewOptions, SinglebandGeoTiff$.MODULE$.apply$default$6());
    }

    public SinglebandGeoTiff withOverviews(ResampleMethod resampleMethod, List<Object> decimations, int blockSize) {
        SinglebandGeoTiff singlebandGeoTiff;
        List<Object> overviewDecimations;
        List<Object> list2 = overviewDecimations = decimations.isEmpty() ? GeoTiff$.MODULE$.defaultOverviewDecimations(this.tile().cols$mcI$sp(), this.tile().rows$mcI$sp(), blockSize) : decimations;
        if (overviewDecimations.isEmpty()) {
            singlebandGeoTiff = this;
        } else {
            ArrayTile arrayTile = this.tile().toArrayTile();
            SinglebandGeoTiff staged = new SinglebandGeoTiff(arrayTile, this.extent(), this.crs(), this.tags(), this.options(), (List<GeoTiff<Tile>>)Nil$.MODULE$);
            List overviews = (List)overviewDecimations.map((Function1 & Serializable & scala.Serializable)decimationFactor -> staged.buildOverview(resampleMethod, BoxesRunTime.unboxToInt((Object)decimationFactor), blockSize), List$.MODULE$.canBuildFrom());
            singlebandGeoTiff = new SinglebandGeoTiff(this.tile(), this.extent(), this.crs(), this.tags(), this.options(), (List<GeoTiff<Tile>>)overviews);
        }
        return singlebandGeoTiff;
    }

    @Override
    public List<Object> withOverviews$default$2() {
        return Nil$.MODULE$;
    }

    @Override
    public int withOverviews$default$3() {
        return GeoTiff$.MODULE$.DefaultBlockSize();
    }

    public SinglebandGeoTiff copy(Tile tile, Extent extent, CRS crs, Tags tags, GeoTiffOptions options, List<GeoTiff<Tile>> overviews) {
        return new SinglebandGeoTiff(tile, extent, crs, tags, options, overviews);
    }

    @Override
    public Tile copy$default$1() {
        return this.tile();
    }

    @Override
    public Extent copy$default$2() {
        return this.extent();
    }

    @Override
    public CRS copy$default$3() {
        return this.crs();
    }

    @Override
    public Tags copy$default$4() {
        return this.tags();
    }

    @Override
    public GeoTiffOptions copy$default$5() {
        return this.options();
    }

    @Override
    public List<GeoTiff<Tile>> copy$default$6() {
        return this.overviews();
    }

    public String productPrefix() {
        return "SinglebandGeoTiff";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        scala.Serializable serializable;
        int n = x$1;
        switch (n) {
            case 0: {
                serializable = this.tile();
                break;
            }
            case 1: {
                serializable = this.extent();
                break;
            }
            case 2: {
                serializable = this.crs();
                break;
            }
            case 3: {
                serializable = this.tags();
                break;
            }
            case 4: {
                serializable = this.options();
                break;
            }
            case 5: {
                serializable = this.overviews();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return serializable;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SinglebandGeoTiff;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SinglebandGeoTiff)) return false;
        boolean bl = true;
        if (!bl) return false;
        SinglebandGeoTiff singlebandGeoTiff = (SinglebandGeoTiff)x$1;
        Tile tile = this.tile();
        Tile tile2 = singlebandGeoTiff.tile();
        if (tile == null) {
            if (tile2 != null) {
                return false;
            }
        } else if (!tile.equals(tile2)) return false;
        Extent extent = this.extent();
        Extent extent2 = singlebandGeoTiff.extent();
        if (extent == null) {
            if (extent2 != null) {
                return false;
            }
        } else if (!((Object)extent).equals(extent2)) return false;
        CRS cRS = this.crs();
        CRS cRS2 = singlebandGeoTiff.crs();
        if (cRS == null) {
            if (cRS2 != null) {
                return false;
            }
        } else if (!((Object)cRS).equals(cRS2)) return false;
        Tags tags = this.tags();
        Tags tags2 = singlebandGeoTiff.tags();
        if (tags == null) {
            if (tags2 != null) {
                return false;
            }
        } else if (!((Object)tags).equals(tags2)) return false;
        GeoTiffOptions geoTiffOptions = this.options();
        GeoTiffOptions geoTiffOptions2 = singlebandGeoTiff.options();
        if (geoTiffOptions == null) {
            if (geoTiffOptions2 != null) {
                return false;
            }
        } else if (!((Object)geoTiffOptions).equals(geoTiffOptions2)) return false;
        List<GeoTiff<Tile>> list2 = this.overviews();
        List<GeoTiff<Tile>> list3 = singlebandGeoTiff.overviews();
        if (list2 == null) {
            if (list3 != null) {
                return false;
            }
        } else if (!list2.equals(list3)) return false;
        if (!singlebandGeoTiff.canEqual(this)) return false;
        return true;
    }

    public SinglebandGeoTiff(Tile tile, Extent extent, CRS crs, Tags tags, GeoTiffOptions options, List<GeoTiff<Tile>> overviews) {
        this.tile = tile;
        this.extent = extent;
        this.crs = crs;
        this.tags = tags;
        this.options = options;
        this.overviews = overviews;
        GeoTiffData.$init$(this);
        GeoTiff.$init$(this);
        Product.$init$((Product)this);
        this.cellType = tile.cellType();
    }
}

