/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.regiongroup;

import geotrellis.raster.Connectivity;
import geotrellis.raster.FourNeighbors$;
import geotrellis.raster.IntArrayTile;
import geotrellis.raster.IntArrayTile$;
import geotrellis.raster.Tile;
import geotrellis.raster.regiongroup.RegionGroupOptions;
import geotrellis.raster.regiongroup.RegionGroupOptions$;
import geotrellis.raster.regiongroup.RegionGroupResult;
import geotrellis.raster.regiongroup.RegionPartition;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class RegionGroup$ {
    public static RegionGroup$ MODULE$;

    static {
        new RegionGroup$();
    }

    public RegionGroupResult apply(Tile r, RegionGroupOptions options) {
        int regionId = -1;
        RegionPartition regions = new RegionPartition();
        Map regionMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        int cols = r.cols$mcI$sp();
        int rows = r.rows$mcI$sp();
        IntArrayTile tile = IntArrayTile$.MODULE$.empty(cols, rows);
        boolean ignoreNoData = options.ignoreNoData();
        Connectivity connectivity = options.connectivity();
        FourNeighbors$ fourNeighbors$ = FourNeighbors$.MODULE$;
        if (!(connectivity != null ? !connectivity.equals(fourNeighbors$) : fourNeighbors$ != null)) {
            for (int index$macro$2 = 0; index$macro$2 < rows; ++index$macro$2) {
                int valueToLeft = Integer.MIN_VALUE;
                for (int index$macro$1 = 0; index$macro$1 < cols; ++index$macro$1) {
                    int v = r.get(index$macro$1, index$macro$2);
                    if (v != Integer.MIN_VALUE || !ignoreNoData) {
                        int top;
                        int n = top = index$macro$2 > 0 ? r.get(index$macro$1, index$macro$2 - 1) : v + 1;
                        if (v == top) {
                            int leftRegion;
                            int topRegion = tile.get(index$macro$1, index$macro$2 - 1);
                            tile.set(index$macro$1, index$macro$2, topRegion);
                            if (v == valueToLeft && index$macro$1 > 0 && (leftRegion = tile.get(index$macro$1 - 1, index$macro$2)) != topRegion) {
                                regions.add(topRegion, tile.get(index$macro$1 - 1, index$macro$2));
                            }
                        } else if (v == valueToLeft && index$macro$1 > 0) {
                            tile.set(index$macro$1, index$macro$2, tile.get(index$macro$1 - 1, index$macro$2));
                        } else {
                            regions.add(++regionId);
                            tile.set(index$macro$1, index$macro$2, regionId);
                            regionMap.update((Object)BoxesRunTime.boxToInteger((int)regionId), (Object)BoxesRunTime.boxToInteger((int)v));
                        }
                    }
                    valueToLeft = v;
                }
            }
        } else {
            for (int index$macro$4 = 0; index$macro$4 < rows; ++index$macro$4) {
                int valueToLeft = Integer.MIN_VALUE;
                int valueToTopLeft = Integer.MIN_VALUE;
                int valueToTop = Integer.MIN_VALUE;
                for (int index$macro$3 = 0; index$macro$3 < cols; ++index$macro$3) {
                    int topRight;
                    int v = r.get(index$macro$3, index$macro$4);
                    int n = topRight = index$macro$4 > 0 && index$macro$3 < cols - 1 ? r.get(index$macro$3 + 1, index$macro$4 - 1) : v + 1;
                    if (index$macro$3 == 0) {
                        valueToTop = index$macro$4 > 0 ? r.get(index$macro$3, index$macro$4 - 1) : v + 1;
                    }
                    if (v != Integer.MIN_VALUE || !ignoreNoData) {
                        if (v == topRight) {
                            int topRegion;
                            int topLeftRegion;
                            int leftRegion;
                            int topRightRegion = tile.get(index$macro$3 + 1, index$macro$4 - 1);
                            tile.set(index$macro$3, index$macro$4, topRightRegion);
                            if (v == valueToLeft && index$macro$3 > 0 && (leftRegion = tile.get(index$macro$3 - 1, index$macro$4)) != topRightRegion) {
                                regions.add(topRightRegion, tile.get(index$macro$3 - 1, index$macro$4));
                            }
                            if (v == valueToTopLeft && index$macro$3 > 0 && index$macro$4 > 0 && (topLeftRegion = tile.get(index$macro$3 - 1, index$macro$4 - 1)) != topRightRegion) {
                                regions.add(topRightRegion, tile.get(index$macro$3 - 1, index$macro$4 - 1));
                            }
                            if (v == valueToTop && index$macro$4 > 0 && (topRegion = tile.get(index$macro$3, index$macro$4 - 1)) != topRightRegion) {
                                regions.add(topRightRegion, tile.get(index$macro$3, index$macro$4 - 1));
                            }
                        } else if (v == valueToTop) {
                            int topLeftRegion;
                            int leftRegion;
                            int topRegion = tile.get(index$macro$3, index$macro$4 - 1);
                            tile.set(index$macro$3, index$macro$4, topRegion);
                            if (v == valueToLeft && index$macro$3 > 0 && (leftRegion = tile.get(index$macro$3 - 1, index$macro$4)) != topRegion) {
                                regions.add(topRegion, tile.get(index$macro$3 - 1, index$macro$4));
                            }
                            if (v == valueToTopLeft && index$macro$3 > 0 && index$macro$4 > 0 && (topLeftRegion = tile.get(index$macro$3 - 1, index$macro$4 - 1)) != topRegion) {
                                regions.add(topRegion, tile.get(index$macro$3 - 1, index$macro$4 - 1));
                            }
                        } else if (v == valueToLeft && index$macro$3 > 0) {
                            int topLeftRegion;
                            int westRegion = tile.get(index$macro$3 - 1, index$macro$4);
                            tile.set(index$macro$3, index$macro$4, westRegion);
                            if (v == valueToTopLeft && index$macro$3 > 0 && index$macro$4 > 0 && (topLeftRegion = tile.get(index$macro$3 - 1, index$macro$4 - 1)) != westRegion) {
                                regions.add(westRegion, tile.get(index$macro$3 - 1, index$macro$4 - 1));
                            }
                        } else if (v == valueToTopLeft && index$macro$3 > 0 && index$macro$4 > 0) {
                            tile.set(index$macro$3, index$macro$4, tile.get(index$macro$3 - 1, index$macro$4 - 1));
                        } else {
                            regions.add(++regionId);
                            tile.set(index$macro$3, index$macro$4, regionId);
                            regionMap.update((Object)BoxesRunTime.boxToInteger((int)regionId), (Object)BoxesRunTime.boxToInteger((int)v));
                        }
                    }
                    valueToLeft = v;
                    valueToTopLeft = valueToTop;
                    valueToTop = topRight;
                }
            }
        }
        for (int index$macro$6 = 0; index$macro$6 < rows; ++index$macro$6) {
            for (int index$macro$5 = 0; index$macro$5 < cols; ++index$macro$5) {
                BoxedUnit boxedUnit;
                int v = tile.get(index$macro$5, index$macro$6);
                if (v == Integer.MIN_VALUE && ignoreNoData) continue;
                int cls = regions.getClass(v);
                if (cls != v && regionMap.contains((Object)BoxesRunTime.boxToInteger((int)v))) {
                    if (!regionMap.contains((Object)BoxesRunTime.boxToInteger((int)cls))) {
                        throw package$.MODULE$.error(new StringBuilder(43).append("Region map should contain class identifier ").append(cls).toString());
                    }
                    boxedUnit = regionMap.remove((Object)BoxesRunTime.boxToInteger((int)v));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                tile.set(index$macro$5, index$macro$6, regions.getClass(v));
            }
        }
        return new RegionGroupResult(tile, (scala.collection.immutable.Map<Object, Object>)regionMap.toMap(Predef$.MODULE$.$conforms()));
    }

    public RegionGroupOptions apply$default$2() {
        return RegionGroupOptions$.MODULE$.default();
    }

    private RegionGroup$() {
        MODULE$ = this;
    }
}

