/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.vector.interpolation;

import geotrellis.vector.Feature;
import geotrellis.vector.interpolation.EmpiricalVariogram;
import geotrellis.vector.package$;
import java.io.Serializable;
import org.locationtech.jts.geom.Point;
import scala.Array$;
import scala.Double$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.PriorityQueue;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class NonLinearEmpiricalVariogram$ {
    public static NonLinearEmpiricalVariogram$ MODULE$;

    static {
        new NonLinearEmpiricalVariogram$();
    }

    public EmpiricalVariogram apply(Feature<Point, Object>[] pts, double maxDistanceBandwidth, int binMaxCount) {
        Tuple2.mcII.sp sp2;
        int n;
        Feature[] points = (Feature[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pts)).toArray(ClassTag$.MODULE$.apply(Feature.class));
        int n2 = points.length;
        PriorityQueue distances = new PriorityQueue(scala.package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)NonLinearEmpiricalVariogram$.$anonfun$apply$1(x$1)), (Ordering)Ordering.Double$.MODULE$));
        double dMax = Double$.MODULE$.MinValue();
        for (int index$macro$2 = 0; index$macro$2 < n2; ++index$macro$2) {
            for (int index$macro$1 = index$macro$2 + 1; index$macro$1 < n2; ++index$macro$1) {
                double dx = package$.MODULE$.withExtraPointMethods(pts[index$macro$2].geom()).x() - package$.MODULE$.withExtraPointMethods(pts[index$macro$1].geom()).x();
                double dy = package$.MODULE$.withExtraPointMethods(pts[index$macro$2].geom()).y() - package$.MODULE$.withExtraPointMethods(pts[index$macro$1].geom()).y();
                double d = scala.math.package$.MODULE$.sqrt(dx * dx + dy * dy);
                if (maxDistanceBandwidth == 0.0) {
                    if (d > dMax) {
                        dMax = d;
                    }
                    distances.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)index$macro$2), (Object)BoxesRunTime.boxToInteger((int)index$macro$1), (Object)BoxesRunTime.boxToDouble((double)d)));
                    continue;
                }
                if (!(d <= maxDistanceBandwidth)) continue;
                distances.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)index$macro$2), (Object)BoxesRunTime.boxToInteger((int)index$macro$1), (Object)BoxesRunTime.boxToDouble((double)d)));
            }
        }
        IndexedSeq q = (IndexedSeq)distances.dequeueAll(Predef$.MODULE$.fallbackStringCanBuildFrom());
        Tuple3[] sortedDistances = (Tuple3[])q.toArray(ClassTag$.MODULE$.apply(Tuple3.class));
        int n_S = q.length();
        if (maxDistanceBandwidth == 0.0) {
            double md = dMax / 2.0;
            Tuple3[] result = (Tuple3[])((TraversableOnce)q.takeWhile((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)NonLinearEmpiricalVariogram$.$anonfun$apply$2(md, x$6)))).toArray(ClassTag$.MODULE$.apply(Tuple3.class));
            n = result.length == 0 ? ((Tuple3[])q.toArray(ClassTag$.MODULE$.apply(Tuple3.class))).length : result.length;
        } else {
            int ret = ((Tuple3[])q.toArray(ClassTag$.MODULE$.apply(Tuple3.class))).length;
            if (ret == 0) {
                throw new IllegalArgumentException("No points in the dataset with a distance below $maxDistance");
            }
            n = ret;
        }
        int n0_S = n;
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)n_S), (Object)sortedDistances, (Object)BoxesRunTime.boxToInteger((int)n0_S));
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        int n_S2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
        Tuple3[] sortedDistances2 = (Tuple3[])tuple32._2();
        int n0_S2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)n_S2), (Object)sortedDistances2, (Object)BoxesRunTime.boxToInteger((int)n0_S2));
        Tuple3 tuple34 = tuple33;
        int n_S3 = BoxesRunTime.unboxToInt((Object)tuple34._1());
        Tuple3[] sortedDistances3 = (Tuple3[])tuple34._2();
        int n0_S3 = BoxesRunTime.unboxToInt((Object)tuple34._3());
        int binMax = binMaxCount == 0 ? 100 : binMaxCount;
        int binSize = (int)scala.math.package$.MODULE$.ceil((double)n0_S3 * 1.0 / (double)binMax);
        Tuple2.mcII.sp sp3 = sp2 = binSize >= 30 ? new Tuple2.mcII.sp(binSize, binMax) : new Tuple2.mcII.sp(30, (int)scala.math.package$.MODULE$.ceil((double)n0_S3 / 30.0));
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int binSize2 = sp2._1$mcI$sp();
        int binNum = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(binSize2, binNum);
        Tuple2.mcII.sp sp5 = sp4;
        int binSize3 = sp5._1$mcI$sp();
        int binNum2 = sp5._2$mcI$sp();
        double[] empiricalDistances = (double[])Array$.MODULE$.ofDim(binNum2, ClassTag$.MODULE$.Double());
        double[] empiricalVariance = (double[])Array$.MODULE$.ofDim(binNum2, ClassTag$.MODULE$.Double());
        double[] data = (double[])Array$.MODULE$.tabulate(n2, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> BoxesRunTime.unboxToDouble(pts[j].data()), ClassTag$.MODULE$.Double());
        for (int index$macro$3 = 0; index$macro$3 < binNum2; ++index$macro$3) {
            int n0 = index$macro$3 * binSize3 + 1 - 1;
            int n1Temp = (index$macro$3 + 1) * binSize3 - 1;
            int n1 = n1Temp > n_S3 ? n_S3 - 1 : n1Temp;
            int binSizeLocal = n1 - n0 + 1;
            int[] s1 = (int[])Array$.MODULE$.tabulate(n1 - n0 + 1, (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)j -> BoxesRunTime.unboxToInt((Object)sortedDistances3[n0 + j]._1()), ClassTag$.MODULE$.Int());
            int[] s2 = (int[])Array$.MODULE$.tabulate(n1 - n0 + 1, (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)j -> BoxesRunTime.unboxToInt((Object)sortedDistances3[n0 + j]._2()), ClassTag$.MODULE$.Int());
            double li = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])Array$.MODULE$.tabulate(n1 - n0 + 1, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> BoxesRunTime.unboxToDouble((Object)sortedDistances3[n0 + j]._3()), ClassTag$.MODULE$.Double()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)binSizeLocal;
            double vi = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])Array$.MODULE$.tabulate(n1 - n0 + 1, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> scala.math.package$.MODULE$.pow(data[s1[j]] - data[s2[j]], 2.0), ClassTag$.MODULE$.Double()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)(2 * binSizeLocal);
            empiricalDistances[index$macro$3] = li;
            empiricalVariance[index$macro$3] = vi;
        }
        return new EmpiricalVariogram(empiricalDistances, empiricalVariance);
    }

    public static final /* synthetic */ double $anonfun$apply$1(Tuple3 x$1) {
        return (double)-1 * BoxesRunTime.unboxToDouble((Object)x$1._3());
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(double md$1, Tuple3 x$6) {
        return BoxesRunTime.unboxToDouble((Object)x$6._3()) <= md$1;
    }

    private NonLinearEmpiricalVariogram$() {
        MODULE$ = this;
    }
}

