/*
 * Decompiled with CFR 0.152.
 */
package pureconfig;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import pureconfig.error.CannotConvert;
import pureconfig.error.ExceptionThrown;
import pureconfig.error.FailureReason;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class DurationUtils$ {
    public static DurationUtils$ MODULE$;
    private final Function1<String, Either<FailureReason, Duration>> fromString;
    private final List<Tuple2<TimeUnit, String>> timeUnitLabels;
    private final Map<String, TimeUnit> timeUnit;
    private final Regex onlyNumberRegex;
    private final Regex fauxMuRegex;
    private final Regex shortMinuteRegex;
    private final Function1<String, String> addDefaultUnit;
    private final Function1<String, String> itsGreekToMe;
    private final Function1<String, String> justAMinute;
    private final Vector<Tuple2<Object, String>> timeUnitsToLabels;

    static {
        new DurationUtils$();
    }

    public Function1<String, Either<FailureReason, Duration>> fromString() {
        return this.fromString;
    }

    private List<String> words(String s) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.trim().split("\\s+"))).toList();
    }

    private List<String> expandLabels(String labels) {
        List<String> list2 = this.words(labels);
        if (!(list2 instanceof .colon.colon)) {
            throw new MatchError(list2);
        }
        .colon.colon colon2 = (.colon.colon)list2;
        String hd = (String)colon2.head();
        List rest = colon2.tl$access$1();
        Tuple2 tuple22 = new Tuple2((Object)hd, (Object)rest);
        Tuple2 tuple23 = tuple22;
        String hd2 = (String)tuple23._1();
        List rest2 = (List)tuple23._2();
        String string2 = hd2;
        return ((List)rest2.flatMap((Function1 & Serializable & scala.Serializable)s -> new .colon.colon(s, (List)new .colon.colon((Object)new StringBuilder(1).append((String)s).append("s").toString(), (List)Nil$.MODULE$)), List$.MODULE$.canBuildFrom())).$colon$colon((Object)string2);
    }

    public Map<String, TimeUnit> timeUnit() {
        return this.timeUnit;
    }

    public Duration parseDuration(String s) {
        Duration.Infinite infinite;
        String s1 = (String)new StringOps(Predef$.MODULE$.augmentString(s)).filterNot((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$4)))));
        String string2 = s1;
        boolean bl = "Inf".equals(string2) ? true : ("PlusInf".equals(string2) ? true : "+Inf".equals(string2));
        if (bl) {
            infinite = Duration$.MODULE$.Inf();
        } else {
            boolean bl2 = "MinusInf".equals(string2) ? true : "-Inf".equals(string2);
            if (bl2) {
                infinite = Duration$.MODULE$.MinusInf();
            } else {
                String unitName = (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(s1)).reverse())).takeWhile((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$5))))))).reverse();
                Option option2 = this.timeUnit().get((Object)unitName);
                if (!(option2 instanceof Some)) {
                    throw new NumberFormatException(new StringBuilder(13).append("format error ").append(s).toString());
                }
                Some some = (Some)option2;
                TimeUnit unit = (TimeUnit)((Object)some.value());
                String valueStr = (String)new StringOps(Predef$.MODULE$.augmentString(s1)).dropRight(unitName.length());
                Duration duration = (Duration)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Duration$.MODULE$.apply(Long.parseLong(valueStr), unit)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Duration$.MODULE$.apply(Double.parseDouble(valueStr), unit));
                infinite = duration;
            }
        }
        return infinite;
    }

    private Regex onlyNumberRegex() {
        return this.onlyNumberRegex;
    }

    private Regex fauxMuRegex() {
        return this.fauxMuRegex;
    }

    private Regex shortMinuteRegex() {
        return this.shortMinuteRegex;
    }

    private Function1<String, String> addDefaultUnit() {
        return this.addDefaultUnit;
    }

    private Function1<String, String> itsGreekToMe() {
        return this.itsGreekToMe;
    }

    private Function1<String, String> justAMinute() {
        return this.justAMinute;
    }

    public String fromDuration(Duration d) {
        String string2;
        Duration duration = d;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)duration;
            string2 = this.fromFiniteDuration(finiteDuration);
        } else {
            Duration.Infinite infinite = Duration$.MODULE$.Inf();
            Duration duration2 = duration;
            if (!(infinite != null ? !infinite.equals(duration2) : duration2 != null)) {
                string2 = "Inf";
            } else {
                Duration.Infinite infinite2 = Duration$.MODULE$.MinusInf();
                Duration duration3 = duration;
                if (!(infinite2 != null ? !infinite2.equals(duration3) : duration3 != null)) {
                    string2 = "MinusInf";
                } else if (duration == Duration$.MODULE$.Undefined()) {
                    string2 = "Undefined";
                } else {
                    throw new MatchError((Object)duration);
                }
            }
        }
        return string2;
    }

    private final String UndefinedDuration() {
        return "Undefined";
    }

    public String fromFiniteDuration(FiniteDuration d) {
        long l = d.toNanos();
        String string2 = 0L == l ? "0" : (String)this.timeUnitsToLabels().collectFirst((PartialFunction)new scala.Serializable(l){
            public static final long serialVersionUID = 0L;
            private final long x1$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    long unitInNanos = A1._1$mcJ$sp();
                    String unitLabel = (String)A1._2();
                    if (this.x1$1 >= unitInNanos && this.x1$1 % unitInNanos == 0L) {
                        object = new StringBuilder(0).append(this.x1$1 / unitInNanos).append(unitLabel).toString();
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, String> x1) {
                long unitInNanos;
                Tuple2<Object, String> tuple22 = x1;
                boolean bl = tuple22 != null && this.x1$1 >= (unitInNanos = tuple22._1$mcJ$sp()) && this.x1$1 % unitInNanos == 0L;
                return bl;
            }
            {
                this.x1$1 = x1$1;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(l).append("ns").toString());
        return string2;
    }

    private final long microsecondInNanos() {
        return 1000L;
    }

    private final long millisecondInNanos() {
        return 1000000L;
    }

    private final long secondInNanos() {
        return 1000000000L;
    }

    private final long minuteInNanos() {
        return 60000000000L;
    }

    private final long hourInNanos() {
        return 3600000000000L;
    }

    private final long dayInNanos() {
        return 86400000000000L;
    }

    private final Vector<Tuple2<Object, String>> timeUnitsToLabels() {
        return this.timeUnitsToLabels;
    }

    private DurationUtils$() {
        MODULE$ = this;
        this.fromString = (Function1 & Serializable & scala.Serializable)string2 -> {
            Right right;
            String string3 = string2;
            String string4 = "Undefined";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                right = package$.MODULE$.Right().apply((Object)Duration$.MODULE$.Undefined());
            } else {
                try {
                    right = package$.MODULE$.Right().apply((Object)MODULE$.parseDuration((String)MODULE$.addDefaultUnit().apply(MODULE$.justAMinute().apply(MODULE$.itsGreekToMe().apply(string2)))));
                }
                catch (Throwable throwable) {
                    Left left;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof NumberFormatException) {
                        NumberFormatException numberFormatException = (NumberFormatException)throwable2;
                        String err = new StringBuilder(58).append(numberFormatException.getMessage()).append(". (try a number followed by any of ns, us, ms, s, m, h, d)").toString();
                        left = package$.MODULE$.Left().apply((Object)new CannotConvert((String)string2, "Duration", err));
                    } else {
                        Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option2.isEmpty()) {
                            Throwable t = (Throwable)option2.get();
                            left = package$.MODULE$.Left().apply((Object)new ExceptionThrown(t));
                        } else {
                            throw throwable;
                        }
                    }
                    right = left;
                }
            }
            return right;
        };
        this.timeUnitLabels = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimeUnit.DAYS), (Object)"d day"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimeUnit.HOURS), (Object)"h hour"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimeUnit.MINUTES), (Object)"min minute"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimeUnit.SECONDS), (Object)"s sec second"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimeUnit.MILLISECONDS), (Object)"ms milli millisecond"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimeUnit.MICROSECONDS), (Object)"\u00b5s micro microsecond"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimeUnit.NANOSECONDS), (Object)"ns nano nanosecond"), (List)Nil$.MODULE$)))))));
        this.timeUnit = ((TraversableOnce)this.timeUnitLabels.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple22 = x0$1;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            TimeUnit unit = (TimeUnit)((Object)((Object)tuple22._1()));
            String names = (String)tuple22._2();
            List list2 = (List)MODULE$.expandLabels(names).map((Function1 & Serializable & scala.Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$3), (Object)unit), List$.MODULE$.canBuildFrom());
            return list2;
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.onlyNumberRegex = new StringOps(Predef$.MODULE$.augmentString("\\s*[+-]?[0-9]+\\s*$")).r();
        this.fauxMuRegex = new StringOps(Predef$.MODULE$.augmentString("([0-9])(\\s*)us(\\s*)$")).r();
        this.shortMinuteRegex = new StringOps(Predef$.MODULE$.augmentString("([0-9])(\\s*)m(\\s*)$")).r();
        this.addDefaultUnit = (Function1 & Serializable & scala.Serializable)s -> MODULE$.onlyNumberRegex().unapplySeq((CharSequence)s).isDefined() ? new StringBuilder(3).append((String)s).append(" ms").toString() : s;
        this.itsGreekToMe = (Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.fauxMuRegex().replaceSomeIn((CharSequence)x$6, (Function1 & Serializable & scala.Serializable)m -> new Some((Object)new StringBuilder(2).append(m.group(1)).append(m.group(2)).append("\u00b5s").append(m.group(3)).toString()));
        this.justAMinute = (Function1 & Serializable & scala.Serializable)x$7 -> MODULE$.shortMinuteRegex().replaceSomeIn((CharSequence)x$7, (Function1 & Serializable & scala.Serializable)m -> new Some((Object)new StringBuilder(7).append(m.group(1)).append(m.group(2)).append("minutes").append(m.group(3)).toString()));
        this.timeUnitsToLabels = (Vector)((SeqLike)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)86400000000000L)), (Object)"d"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3600000000000L)), (Object)"h"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)60000000000L)), (Object)"m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1000000000L)), (Object)"s"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1000000L)), (Object)"ms"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1000L)), (Object)"us")}))).sortBy((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8._1$mcJ$sp()), ((Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Long$.MODULE$)).reverse());
    }
}

