/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.costdistance;

import geotrellis.raster.Dimensions;
import geotrellis.raster.DoubleArrayTile;
import geotrellis.raster.DoubleArrayTile$;
import geotrellis.raster.Tile;
import java.io.Serializable;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SimpleCostDistance$ {
    public static SimpleCostDistance$ MODULE$;

    static {
        new SimpleCostDistance$();
    }

    public void nop(Tuple4<Object, Object, Object, Object> cost) {
    }

    public PriorityQueue<Tuple4<Object, Object, Object, Object>> generateEmptyQueue(int cols, int rows) {
        return new PriorityQueue<Tuple4<Object, Object, Object, Object>>(cols * 16 + rows * 16, new Comparator<Tuple4<Object, Object, Object, Object>>(){

            public Comparator<Tuple4<Object, Object, Object, Object>> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<Tuple4<Object, Object, Object, Object>> thenComparing(Comparator<? super Tuple4<Object, Object, Object, Object>> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<Tuple4<Object, Object, Object, Object>> thenComparing(Function<? super Tuple4<Object, Object, Object, Object>, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<Tuple4<Object, Object, Object, Object>> thenComparing(Function<? super Tuple4<Object, Object, Object, Object>, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<Tuple4<Object, Object, Object, Object>> thenComparingInt(ToIntFunction<? super Tuple4<Object, Object, Object, Object>> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<Tuple4<Object, Object, Object, Object>> thenComparingLong(ToLongFunction<? super Tuple4<Object, Object, Object, Object>> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<Tuple4<Object, Object, Object, Object>> thenComparingDouble(ToDoubleFunction<? super Tuple4<Object, Object, Object, Object>> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public boolean equals(Object a) {
                return a.equals(this);
            }

            public int compare(Tuple4<Object, Object, Object, Object> a, Tuple4<Object, Object, Object, Object> b) {
                return Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)a._4())).compareTo(Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)b._4())));
            }
        });
    }

    public DoubleArrayTile generateEmptyCostTile(int cols, int rows) {
        return DoubleArrayTile$.MODULE$.empty(cols, rows);
    }

    public DoubleArrayTile apply(Tile frictionTile, Seq<Tuple2<Object, Object>> points, double maxCost, double resolution) {
        int cols = frictionTile.cols$mcI$sp();
        int rows = frictionTile.rows$mcI$sp();
        DoubleArrayTile costTile = this.generateEmptyCostTile(cols, rows);
        PriorityQueue<Tuple4<Object, Object, Object, Object>> q = this.generateEmptyQueue(cols, rows);
        for (int i = 0; i < points.length(); ++i) {
            Tuple2 tuple22 = (Tuple2)points.apply(i);
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            int col = tuple22._1$mcI$sp();
            int row = tuple22._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(col, row);
            Tuple2.mcII.sp sp3 = sp2;
            int col2 = sp3._1$mcI$sp();
            int row2 = sp3._2$mcI$sp();
            Tuple4 entry = new Tuple4((Object)BoxesRunTime.boxToInteger((int)col2), (Object)BoxesRunTime.boxToInteger((int)row2), (Object)BoxesRunTime.boxToDouble((double)frictionTile.getDouble(col2, row2)), (Object)BoxesRunTime.boxToDouble((double)0.0));
            q.add((Tuple4<Object, Object, Object, Object>)entry);
        }
        return this.compute(frictionTile, costTile, maxCost, resolution, q, (Function1<Tuple4<Object, Object, Object, Object>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)cost -> {
            SimpleCostDistance$.MODULE$.nop((Tuple4<Object, Object, Object, Object>)cost);
            return BoxedUnit.UNIT;
        });
    }

    public double apply$default$3() {
        return Double.POSITIVE_INFINITY;
    }

    public double apply$default$4() {
        return 1.0;
    }

    public DoubleArrayTile compute(Tile frictionTile, DoubleArrayTile costTile, double maxCost, double resolution, PriorityQueue<Tuple4<Object, Object, Object, Object>> q, Function1<Tuple4<Object, Object, Object, Object>, BoxedUnit> edgeCallback) {
        int cols = frictionTile.cols$mcI$sp();
        int rows = frictionTile.rows$mcI$sp();
        Dimensions dimensions = frictionTile.dimensions();
        Dimensions dimensions2 = costTile.dimensions();
        Predef$.MODULE$.require(!(dimensions != null ? !((Object)dimensions).equals(dimensions2) : dimensions2 != null));
        while (!q.isEmpty()) {
            SimpleCostDistance$.processNext$1(q, costTile, edgeCallback, cols, rows, frictionTile, resolution, maxCost);
        }
        return costTile;
    }

    private static final boolean inTile$1(int col, int row, int cols$1, int rows$1) {
        return 0 <= col && col < cols$1 && 0 <= row && row < rows$1;
    }

    private static final boolean isPassable$1(double f) {
        return !Double.isNaN(f) && 0.0 <= f;
    }

    private static final boolean onEdge$1(int col, int row, int cols$1, int rows$1) {
        return col == 0 || row == 0 || col == cols$1 - 1 || row == rows$1 - 1;
    }

    private static final void enqueueNeighbor$1(int col, int row, double friction1, double neighborCost, double distance, Tile frictionTile$1, DoubleArrayTile costTile$1, double resolution$1, double maxCost$1, PriorityQueue q$1, int cols$1, int rows$1) {
        block1: {
            double step;
            double candidateCost;
            if (!SimpleCostDistance$.inTile$1(col, row, cols$1, rows$1)) break block1;
            double friction2 = frictionTile$1.getDouble(col, row);
            double currentCost = costTile$1.getDouble(col, row);
            if (SimpleCostDistance$.isPassable$1(friction2) && (candidateCost = neighborCost + (step = resolution$1 * distance * (friction1 + friction2) / 2.0)) <= maxCost$1 && (Double.isNaN(currentCost) || candidateCost < currentCost)) {
                Tuple4 entry = new Tuple4((Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToInteger((int)row), (Object)BoxesRunTime.boxToDouble((double)friction2), (Object)BoxesRunTime.boxToDouble((double)candidateCost));
                costTile$1.setDouble(col, row, candidateCost);
                q$1.add(entry);
            }
        }
    }

    private static final double enqueueNeighbor$default$5$1() {
        return 1.0;
    }

    private static final void processNext$1(PriorityQueue q$1, DoubleArrayTile costTile$1, Function1 edgeCallback$1, int cols$1, int rows$1, Tile frictionTile$1, double resolution$1, double maxCost$1) {
        block3: {
            double currentCost;
            Tuple4 entry = (Tuple4)q$1.poll();
            Tuple4 tuple42 = entry;
            if (tuple42 == null) {
                throw new MatchError((Object)tuple42);
            }
            int col = BoxesRunTime.unboxToInt((Object)tuple42._1());
            int row = BoxesRunTime.unboxToInt((Object)tuple42._2());
            double friction1 = BoxesRunTime.unboxToDouble((Object)tuple42._3());
            double candidateCost = BoxesRunTime.unboxToDouble((Object)tuple42._4());
            Tuple4 tuple43 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToInteger((int)row), (Object)BoxesRunTime.boxToDouble((double)friction1), (Object)BoxesRunTime.boxToDouble((double)candidateCost));
            Tuple4 tuple44 = tuple43;
            int col2 = BoxesRunTime.unboxToInt((Object)tuple44._1());
            int row2 = BoxesRunTime.unboxToInt((Object)tuple44._2());
            double friction12 = BoxesRunTime.unboxToDouble((Object)tuple44._3());
            double candidateCost2 = BoxesRunTime.unboxToDouble((Object)tuple44._4());
            double d = currentCost = SimpleCostDistance$.inTile$1(col2, row2, cols$1, rows$1) ? costTile$1.getDouble(col2, row2) : Double.NaN;
            if (!Double.isNaN(currentCost) && !(candidateCost2 <= currentCost)) break block3;
            if (SimpleCostDistance$.inTile$1(col2, row2, cols$1, rows$1)) {
                costTile$1.setDouble(col2, row2, candidateCost2);
            }
            Object object = SimpleCostDistance$.onEdge$1(col2, row2, cols$1, rows$1) ? edgeCallback$1.apply((Object)entry) : BoxedUnit.UNIT;
            if (SimpleCostDistance$.isPassable$1(friction12)) {
                SimpleCostDistance$.enqueueNeighbor$1(col2 - 1, row2 + 0, friction12, candidateCost2, SimpleCostDistance$.enqueueNeighbor$default$5$1(), frictionTile$1, costTile$1, resolution$1, maxCost$1, q$1, cols$1, rows$1);
                SimpleCostDistance$.enqueueNeighbor$1(col2 + 1, row2 + 0, friction12, candidateCost2, SimpleCostDistance$.enqueueNeighbor$default$5$1(), frictionTile$1, costTile$1, resolution$1, maxCost$1, q$1, cols$1, rows$1);
                SimpleCostDistance$.enqueueNeighbor$1(col2 + 0, row2 + 1, friction12, candidateCost2, SimpleCostDistance$.enqueueNeighbor$default$5$1(), frictionTile$1, costTile$1, resolution$1, maxCost$1, q$1, cols$1, rows$1);
                SimpleCostDistance$.enqueueNeighbor$1(col2 + 0, row2 - 1, friction12, candidateCost2, SimpleCostDistance$.enqueueNeighbor$default$5$1(), frictionTile$1, costTile$1, resolution$1, maxCost$1, q$1, cols$1, rows$1);
                SimpleCostDistance$.enqueueNeighbor$1(col2 - 1, row2 - 1, friction12, candidateCost2, package$.MODULE$.sqrt(2.0), frictionTile$1, costTile$1, resolution$1, maxCost$1, q$1, cols$1, rows$1);
                SimpleCostDistance$.enqueueNeighbor$1(col2 - 1, row2 + 1, friction12, candidateCost2, package$.MODULE$.sqrt(2.0), frictionTile$1, costTile$1, resolution$1, maxCost$1, q$1, cols$1, rows$1);
                SimpleCostDistance$.enqueueNeighbor$1(col2 + 1, row2 - 1, friction12, candidateCost2, package$.MODULE$.sqrt(2.0), frictionTile$1, costTile$1, resolution$1, maxCost$1, q$1, cols$1, rows$1);
                SimpleCostDistance$.enqueueNeighbor$1(col2 + 1, row2 + 1, friction12, candidateCost2, package$.MODULE$.sqrt(2.0), frictionTile$1, costTile$1, resolution$1, maxCost$1, q$1, cols$1, rows$1);
            }
        }
    }

    private SimpleCostDistance$() {
        MODULE$ = this;
    }
}

