/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.gdal;

import cats.syntax.OptionIdOps$;
import cats.syntax.package$option$;
import geotrellis.raster.gdal.GDALPath;
import geotrellis.raster.gdal.GDALPath$Schemes$;
import io.lemonlabs.uri.Host;
import io.lemonlabs.uri.QueryString;
import io.lemonlabs.uri.Url;
import io.lemonlabs.uri.Url$;
import io.lemonlabs.uri.UrlPath$;
import io.lemonlabs.uri.UrlWithAuthority;
import io.lemonlabs.uri.UrlWithAuthority$;
import io.lemonlabs.uri.config.UriConfig;
import io.lemonlabs.uri.encoding.PercentEncoder;
import io.lemonlabs.uri.encoding.PercentEncoder$;
import java.io.Serializable;
import java.net.MalformedURLException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class GDALPath$
implements scala.Serializable {
    public static GDALPath$ MODULE$;
    private final String PREFIX;

    static {
        new GDALPath$();
    }

    public String PREFIX() {
        return this.PREFIX;
    }

    public GDALPath toGDALDataPath(String path) {
        return this.parse(path, this.parse$default$2(), this.parse$default$3());
    }

    public Option<GDALPath> parseOption(String path, Option<String> compressedFileDelimiter, PercentEncoder percentEncoder) {
        Option option2;
        String string2 = System.getProperty("os.name").toLowerCase();
        String string3 = "win";
        boolean onLocalWindows = !(string2 != null ? !string2.equals(string3) : string3 != null);
        String upath = percentEncoder.encode(path, "UTF-8");
        if (GDALPath$Schemes$.MODULE$.isVSIFormatted(path)) {
            option2 = OptionIdOps$.MODULE$.some$extension(package$option$.MODULE$.catsSyntaxOptionId(path));
        } else {
            String x$1 = upath;
            UriConfig x$2 = UrlWithAuthority$.MODULE$.parseOption$default$2(x$1);
            option2 = ((Option)UrlWithAuthority$.MODULE$.parseOption(x$1, x$2).fold((Function0 & Serializable & scala.Serializable)() -> {
                String x$3 = Url$.MODULE$.apply$default$1();
                String x$4 = Url$.MODULE$.apply$default$2();
                String x$5 = Url$.MODULE$.apply$default$3();
                String x$6 = Url$.MODULE$.apply$default$4();
                int x$7 = Url$.MODULE$.apply$default$5();
                String x$8 = Url$.MODULE$.apply$default$6();
                QueryString x$9 = Url$.MODULE$.apply$default$7();
                String x$10 = Url$.MODULE$.apply$default$8();
                UriConfig x$11 = Url$.MODULE$.apply$default$9(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
                String x$12 = upath;
                UriConfig x$13 = UrlPath$.MODULE$.fromRaw$default$2(x$12);
                return OptionIdOps$.MODULE$.some$extension(package$option$.MODULE$.catsSyntaxOptionId(Url$.MODULE$.apply(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11).withPath(UrlPath$.MODULE$.fromRaw(x$12, x$13))));
            }, (Function1 & Serializable & scala.Serializable)x$3 -> OptionIdOps$.MODULE$.some$extension(package$option$.MODULE$.catsSyntaxOptionId(x$3)))).flatMap((Function1 & Serializable & scala.Serializable)url -> {
                String string2;
                Url url2 = url;
                if (url2 instanceof UrlWithAuthority) {
                    UrlWithAuthority urlWithAuthority = (UrlWithAuthority)url2;
                    string2 = (String)urlWithAuthority.authority().userInfo().user().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                } else {
                    string2 = "";
                }
                String authority = string2;
                String relativeUrl = url.toRelativeUrl().path().toStringRaw();
                return ((Option)url.schemeOption().fold((Function0 & Serializable & scala.Serializable)() -> OptionIdOps$.MODULE$.some$extension(package$option$.MODULE$.catsSyntaxOptionId("")), (Function1 & Serializable & scala.Serializable)x$4 -> OptionIdOps$.MODULE$.some$extension(package$option$.MODULE$.catsSyntaxOptionId(x$4)))).map((Function1 & Serializable & scala.Serializable)scheme2 -> {
                    String[] schemesArray = scheme2.split("\\+");
                    String schemes = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schemesArray)).map((Function1 & Serializable & scala.Serializable)scheme -> GDALPath$Schemes$.MODULE$.toVSIScheme((String)scheme), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString();
                    String path = (String)(schemes.contains("file") && onLocalWindows ? compressedFileDelimiter.map((Function1 & Serializable & scala.Serializable)x$5 -> relativeUrl.replace((CharSequence)x$5, "\\\\")) : compressedFileDelimiter.map((Function1 & Serializable & scala.Serializable)x$6 -> relativeUrl.replace((CharSequence)x$6, "/"))).getOrElse((Function0 & Serializable & scala.Serializable)() -> relativeUrl);
                    Option<String> extraScheme = GDALPath$Schemes$.MODULE$.extraCompressionScheme(path);
                    boolean extraSchemeExists = extraScheme.exists((Function1 & Serializable & scala.Serializable)es -> BoxesRunTime.boxToBoolean((boolean)GDALPath$.$anonfun$parseOption$12(schemes, es)));
                    String extendedSchemes = (String)extraScheme.fold((Function0 & Serializable & scala.Serializable)() -> schemes, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                        String string2 = x0$1;
                        String string3 = extraSchemeExists ? schemes : new StringBuilder(0).append(string2).append(schemes).toString();
                        return string3;
                    });
                    String webProtocol = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schemesArray)).collectFirst((PartialFunction)new scala.Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])GDALPath$Schemes$.MODULE$.URI_PROTOCOL_INCLUDE())).contains(A1) ? new StringBuilder(3).append(A1).append("://").toString() : function1.apply(x1);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(String x1) {
                            String string2 = x1;
                            boolean bl = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])GDALPath$Schemes$.MODULE$.URI_PROTOCOL_INCLUDE())).contains((Object)string2);
                            return bl;
                        }
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                    return (String)url.hostOption().filterNot((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)GDALPath$.$anonfun$parseOption$16(schemesArray, x$7))).fold((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(0).append(extendedSchemes).append(webProtocol).append(authority).append(path).toString(), (Function1 & Serializable & scala.Serializable)host -> new StringBuilder(0).append(extendedSchemes).append(webProtocol).append(authority).append(host).append(path).toString());
                });
            });
        }
        Option vsiPath = option2;
        return vsiPath.map((Function1 & Serializable & scala.Serializable)x$10 -> new GDALPath((String)x$10));
    }

    public GDALPath parse(String path, Option<String> compressedFileDelimiter, PercentEncoder percentEncoder) {
        return (GDALPath)this.parseOption(path, compressedFileDelimiter, percentEncoder).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new MalformedURLException(new StringBuilder(30).append("Unable to parse GDALDataPath: ").append(path).toString());
        });
    }

    public Option<String> parseOption$default$2() {
        return OptionIdOps$.MODULE$.some$extension(package$option$.MODULE$.catsSyntaxOptionId("!"));
    }

    public PercentEncoder parseOption$default$3() {
        return new PercentEncoder((Set<Object>)((Set)PercentEncoder$.MODULE$.PATH_CHARS_TO_ENCODE().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'%', '?', '#'})))));
    }

    public Option<String> parse$default$2() {
        return OptionIdOps$.MODULE$.some$extension(package$option$.MODULE$.catsSyntaxOptionId("!"));
    }

    public PercentEncoder parse$default$3() {
        return new PercentEncoder((Set<Object>)((Set)PercentEncoder$.MODULE$.PATH_CHARS_TO_ENCODE().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'%', '?', '#'})))));
    }

    public GDALPath apply(String value) {
        return new GDALPath(value);
    }

    public Option<String> unapply(GDALPath x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.value());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$parseOption$12(String schemes$2, String es) {
        return new StringOps(Predef$.MODULE$.augmentString(schemes$2)).nonEmpty() && (schemes$2.contains(es) || GDALPath$Schemes$.MODULE$.isCompressed(schemes$2));
    }

    public static final /* synthetic */ boolean $anonfun$parseOption$17(Object[] eta$0$1$1, Object elem) {
        return new ArrayOps.ofRef(eta$0$1$1).contains(elem);
    }

    public static final /* synthetic */ boolean $anonfun$parseOption$18(boolean x$8, boolean x$9) {
        return x$8 || x$9;
    }

    public static final /* synthetic */ boolean $anonfun$parseOption$16(String[] schemesArray$1, Host x$7) {
        Object[] objectArray = Predef$.MODULE$.refArrayOps((Object[])schemesArray$1);
        return BoxesRunTime.unboxToBoolean((Object)new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps((boolean[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])GDALPath$Schemes$.MODULE$.URI_HOST_EXCLUDE())).map((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)GDALPath$.$anonfun$parseOption$17(objectArray, elem)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean())))).reduce((Function2 & Serializable & scala.Serializable)(x$8, x$9) -> BoxesRunTime.boxToBoolean((boolean)GDALPath$.$anonfun$parseOption$18(BoxesRunTime.unboxToBoolean((Object)x$8), BoxesRunTime.unboxToBoolean((Object)x$9)))));
    }

    private GDALPath$() {
        MODULE$ = this;
        this.PREFIX = "gdal+";
    }
}

