/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.BitArrayTile$;
import geotrellis.raster.Dimensions;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import geotrellis.raster.io.geotiff.util.package$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class GeoTiffSegment$ {
    public static GeoTiffSegment$ MODULE$;

    static {
        new GeoTiffSegment$();
    }

    public byte[][] deinterleave(byte[] bytes, int bandCount, int bytesPerSample) {
        byte[][] bands = new byte[bandCount][];
        int segmentSize = bytes.length / bandCount;
        for (int index$macro$1 = 0; index$macro$1 < bandCount; ++index$macro$1) {
            bands[index$macro$1] = new byte[segmentSize];
        }
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        for (int index$macro$3 = 0; index$macro$3 < segmentSize; index$macro$3 += bytesPerSample) {
            for (int index$macro$2 = 0; index$macro$2 < bandCount; ++index$macro$2) {
                bb.get(bands[index$macro$2], index$macro$3, bytesPerSample);
            }
        }
        return bands;
    }

    public byte[] deinterleave(byte[] bytes, int bandCount, int bytesPerSample, int index) {
        int n = index;
        return (byte[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.deinterleave(bytes, bandCount, bytesPerSample, (Traversable<Object>)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n))))).head();
    }

    public byte[][] deinterleave(byte[] bytes, int bandCount, int bytesPerSample, Traversable<Object> indices) {
        List indicesList = indices.toList();
        Map bandToIndex = ((TraversableOnce)indicesList.zipWithIndex(List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        int actualBandCount = indicesList.length();
        byte[][] bands = new byte[actualBandCount][];
        int segmentSize = bytes.length / bandCount;
        for (int index$macro$1 = 0; index$macro$1 < actualBandCount; ++index$macro$1) {
            bands[index$macro$1] = new byte[segmentSize];
        }
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        for (int index$macro$3 = 0; index$macro$3 < segmentSize; index$macro$3 += bytesPerSample) {
            for (int index$macro$2 = 0; index$macro$2 < bandCount; ++index$macro$2) {
                if (indicesList.contains((Object)BoxesRunTime.boxToInteger((int)index$macro$2))) {
                    bb.get(bands[BoxesRunTime.unboxToInt((Object)bandToIndex.apply((Object)BoxesRunTime.boxToInteger((int)index$macro$2)))], index$macro$3, bytesPerSample);
                    continue;
                }
                bb.position(bb.position() + bytesPerSample);
            }
        }
        return bands;
    }

    public byte[][] deinterleaveBitSegment(GeoTiffSegment segment, Dimensions<Object> dims, int bandCount) {
        int cols = dims.cols$mcI$sp();
        int rows = dims.rows$mcI$sp();
        int bytesWidth = (cols + 7) / 8;
        int paddedCols = bytesWidth * 8;
        int resultByteCount = paddedCols / 8 * rows;
        byte[][] bands = (byte[][])Array$.MODULE$.fill(bandCount, (Function0 & Serializable & scala.Serializable)() -> (byte[])Array$.MODULE$.ofDim(resultByteCount, ClassTag$.MODULE$.Byte()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        for (int index$macro$1 = 0; index$macro$1 < segment.size(); ++index$macro$1) {
            int bandIndex = index$macro$1 % bandCount;
            int j = index$macro$1 / bandCount;
            int col = j % cols;
            int row = j / cols;
            int i2 = row * paddedCols + col;
            BitArrayTile$.MODULE$.update(bands[bandIndex], i2, segment.getInt(index$macro$1));
        }
        for (int index$macro$3 = 0; index$macro$3 < bandCount; ++index$macro$3) {
            byte[] bytes = bands[index$macro$3];
            for (int index$macro$2 = 0; index$macro$2 < bytes.length; ++index$macro$2) {
                bytes[index$macro$2] = package$.MODULE$.invertByte(bytes[index$macro$2]);
            }
        }
        return bands;
    }

    public byte[] deinterleaveBitSegment(GeoTiffSegment segment, Dimensions<Object> dims, int bandCount, int index) {
        int n = index;
        return (byte[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.deinterleaveBitSegment(segment, dims, bandCount, (Traversable<Object>)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n))))).head();
    }

    public byte[][] deinterleaveBitSegment(GeoTiffSegment segment, Dimensions<Object> dims, int bandCount, Traversable<Object> indices) {
        int cols = dims.cols$mcI$sp();
        int rows = dims.rows$mcI$sp();
        int bytesWidth = (cols + 7) / 8;
        int paddedCols = bytesWidth * 8;
        int resultByteCount = paddedCols / 8 * rows;
        List indicesList = indices.toList();
        Map bandToIndex = ((TraversableOnce)indicesList.zipWithIndex(List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        int actualBandCount = indicesList.length();
        byte[][] bands = (byte[][])Array$.MODULE$.fill(actualBandCount, (Function0 & Serializable & scala.Serializable)() -> (byte[])Array$.MODULE$.ofDim(resultByteCount, ClassTag$.MODULE$.Byte()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        for (int index$macro$1 = 0; index$macro$1 < segment.size(); ++index$macro$1) {
            int bandIndex = index$macro$1 % bandCount;
            if (!indicesList.contains((Object)BoxesRunTime.boxToInteger((int)bandIndex))) continue;
            int j = index$macro$1 / bandCount;
            int col = j % cols;
            int row = j / cols;
            int i2 = row * paddedCols + col;
            BitArrayTile$.MODULE$.update(bands[BoxesRunTime.unboxToInt((Object)bandToIndex.apply((Object)BoxesRunTime.boxToInteger((int)bandIndex)))], i2, segment.getInt(index$macro$1));
        }
        for (int index$macro$3 = 0; index$macro$3 < actualBandCount; ++index$macro$3) {
            byte[] bytes = bands[index$macro$3];
            for (int index$macro$2 = 0; index$macro$2 < bytes.length; ++index$macro$2) {
                bytes[index$macro$2] = package$.MODULE$.invertByte(bytes[index$macro$2]);
            }
        }
        return bands;
    }

    public byte[] pixelInterleave(MultibandTile tile) {
        int bandCount = tile.bandCount();
        int byteCount = tile.cellType().bytes();
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(byteCount * bandCount * tile.cols$mcI$sp() * tile.rows$mcI$sp(), ClassTag$.MODULE$.Byte());
        Vector bandBytes = (Vector)tile.bands().map((Function1 & Serializable & scala.Serializable)x$73 -> x$73.toBytes(), Vector$.MODULE$.canBuildFrom());
        int segIndex = 0;
        for (int index$macro$3 = 0; index$macro$3 < tile.cols$mcI$sp() * tile.rows$mcI$sp(); ++index$macro$3) {
            for (int index$macro$2 = 0; index$macro$2 < bandCount; ++index$macro$2) {
                byte[] bandByteArr = (byte[])bandBytes.apply(index$macro$2);
                for (int index$macro$1 = 0; index$macro$1 < byteCount; ++index$macro$1) {
                    int bandByteIndex = index$macro$3 * byteCount + index$macro$1;
                    bytes[segIndex] = bandByteArr[index$macro$3 * byteCount + index$macro$1];
                    ++segIndex;
                }
            }
        }
        return bytes;
    }

    private GeoTiffSegment$() {
        MODULE$ = this;
    }
}

