/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.render;

import geotrellis.raster.histogram.Histogram;
import geotrellis.raster.render.ClassBoundaryType;
import geotrellis.raster.render.ColorMap;
import geotrellis.raster.render.ColorMap$Options$;
import geotrellis.raster.render.ColorRamp;
import geotrellis.raster.render.ColorRamp$;
import geotrellis.raster.render.DoubleColorMap;
import geotrellis.raster.render.Exact$;
import geotrellis.raster.render.GreaterThan$;
import geotrellis.raster.render.GreaterThanOrEqualTo$;
import geotrellis.raster.render.IntColorMap;
import geotrellis.raster.render.LessThan$;
import geotrellis.raster.render.LessThanOrEqualTo$;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

public final class ColorMap$
implements scala.Serializable {
    public static ColorMap$ MODULE$;

    static {
        new ColorMap$();
    }

    public ColorMap apply(Seq<Tuple2<Object, Object>> breaksToColors) {
        return this.apply((Map<Object, Object>)breaksToColors.toMap(Predef$.MODULE$.$conforms()));
    }

    public ColorMap apply(Map<Object, Object> breaksToColors) {
        return this.apply(breaksToColors, ColorMap$Options$.MODULE$.DEFAULT());
    }

    public ColorMap apply(Map<Object, Object> breaksToColors, ColorMap.Options options) {
        return new IntColorMap(breaksToColors, options);
    }

    public ColorMap apply(Seq<Tuple2<Object, Object>> breaksToColors, Predef.DummyImplicit d) {
        return this.apply((Map<Object, Object>)breaksToColors.toMap(Predef$.MODULE$.$conforms()), d);
    }

    public ColorMap apply(Map<Object, Object> breaksToColors, Predef.DummyImplicit d) {
        return this.apply(breaksToColors, ColorMap$Options$.MODULE$.DEFAULT(), d);
    }

    public ColorMap apply(Map<Object, Object> breaksToColors, ColorMap.Options options, Predef.DummyImplicit d) {
        return new DoubleColorMap(breaksToColors, options);
    }

    public ColorMap apply(int[] breaks, ColorRamp colorRamp) {
        return this.apply(breaks, colorRamp, ColorMap$Options$.MODULE$.DEFAULT());
    }

    public ColorMap apply(int[] breaks, ColorRamp colorRamp, ColorMap.Options options) {
        return this.apply((Vector<Object>)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(breaks)).toVector(), colorRamp, options);
    }

    public ColorMap apply(Vector<Object> breaks, ColorRamp colorRamp) {
        return this.apply(breaks, colorRamp, ColorMap$Options$.MODULE$.DEFAULT());
    }

    public ColorMap apply(Vector<Object> breaks, ColorRamp colorRamp, ColorMap.Options options) {
        Map breaksToColors = ((TraversableOnce)breaks.zip(colorRamp.stops(breaks.size()).colors(), Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return this.apply((Map<Object, Object>)breaksToColors, options);
    }

    public ColorMap apply(double[] breaks, ColorRamp colorRamp, Predef.DummyImplicit d) {
        return this.apply(breaks, colorRamp, ColorMap$Options$.MODULE$.DEFAULT(), d);
    }

    public ColorMap apply(double[] breaks, ColorRamp colorRamp, ColorMap.Options options, Predef.DummyImplicit d) {
        return this.apply((Vector<Object>)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(breaks)).toVector(), colorRamp, options, d);
    }

    public ColorMap apply(Vector<Object> breaks, ColorRamp colorRamp, Predef.DummyImplicit d) {
        return this.apply(breaks, colorRamp, ColorMap$Options$.MODULE$.DEFAULT(), d);
    }

    public ColorMap apply(Vector<Object> breaks, ColorRamp colorRamp, ColorMap.Options options, Predef.DummyImplicit d) {
        Map breaksToColors = ((TraversableOnce)breaks.zip(colorRamp.stops(breaks.size()).colors(), Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return this.apply((Map<Object, Object>)breaksToColors, options, d);
    }

    public ColorMap fromQuantileBreaks(Histogram<Object> histogram, ColorRamp colorRamp) {
        return this.fromQuantileBreaks(histogram, colorRamp, ColorMap$Options$.MODULE$.DEFAULT());
    }

    public ColorMap fromQuantileBreaks(Histogram<Object> histogram, ColorRamp colorRamp, ColorMap.Options options) {
        return this.apply((Vector<Object>)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(histogram.quantileBreaks$mcI$sp(colorRamp.numStops()))).toVector(), ColorRamp$.MODULE$.intVectorToColorRamp(colorRamp.colors()), options);
    }

    public ColorMap fromQuantileBreaks(Histogram<Object> histogram, ColorRamp colorRamp, Predef.DummyImplicit d) {
        return this.fromQuantileBreaks(histogram, colorRamp, ColorMap$Options$.MODULE$.DEFAULT(), d);
    }

    public ColorMap fromQuantileBreaks(Histogram<Object> histogram, ColorRamp colorRamp, ColorMap.Options options, Predef.DummyImplicit d) {
        ColorMap colorMap;
        ColorMap cm = this.apply((Vector<Object>)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(histogram.quantileBreaks$mcD$sp(colorRamp.numStops()))).toVector(), ColorRamp$.MODULE$.intVectorToColorRamp(colorRamp.colors()), options, d);
        ClassBoundaryType classBoundaryType = options.classBoundaryType();
        boolean bl = GreaterThan$.MODULE$.equals(classBoundaryType) ? true : GreaterThanOrEqualTo$.MODULE$.equals(classBoundaryType);
        if (bl) {
            colorMap = cm.withFallbackColor(BoxesRunTime.unboxToInt((Object)colorRamp.colors().apply(0)));
        } else {
            boolean bl2 = LessThan$.MODULE$.equals(classBoundaryType) ? true : LessThanOrEqualTo$.MODULE$.equals(classBoundaryType);
            if (bl2) {
                colorMap = cm.withFallbackColor(BoxesRunTime.unboxToInt((Object)colorRamp.colors().apply(colorRamp.colors().length() - 1)));
            } else if (Exact$.MODULE$.equals(classBoundaryType)) {
                colorMap = cm;
            } else {
                throw new MatchError((Object)classBoundaryType);
            }
        }
        return colorMap;
    }

    public Option<ColorMap> fromString(String str) {
        String[][] split2 = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(str)).split(';'))).map((Function1 & Serializable & scala.Serializable)x$1 -> new StringOps(Predef$.MODULE$.augmentString(x$1.trim())).split(':'), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            int[] limits = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])split2)).map((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToInteger((int)ColorMap$.$anonfun$fromString$3(pair)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            int[] colors = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])split2)).map((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToInteger((int)ColorMap$.$anonfun$fromString$4(pair)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            Predef$.MODULE$.require(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(limits)).size() == new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(colors)).size());
            return MODULE$.apply(limits, ColorRamp$.MODULE$.intArrayToColorRamp(colors));
        }).toOption();
    }

    public Option<ColorMap> fromStringDouble(String str) {
        String[][] split2 = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(str)).split(';'))).map((Function1 & Serializable & scala.Serializable)x$2 -> new StringOps(Predef$.MODULE$.augmentString(x$2.trim())).split(':'), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            double[] limits = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])split2)).map((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToDouble((double)ColorMap$.$anonfun$fromStringDouble$3(pair)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            int[] colors = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])split2)).map((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToInteger((int)ColorMap$.$anonfun$fromStringDouble$4(pair)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            Predef$.MODULE$.require(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(limits)).size() == new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(colors)).size());
            return MODULE$.apply(limits, ColorRamp$.MODULE$.intArrayToColorRamp(colors), Predef.DummyImplicit$.MODULE$.dummyImplicit());
        }).toOption();
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ int $anonfun$fromString$3(String[] pair) {
        return new StringOps(Predef$.MODULE$.augmentString(pair[0])).toInt();
    }

    public static final /* synthetic */ int $anonfun$fromString$4(String[] pair) {
        return package$.MODULE$.BigInt().apply(pair[1], 16).toInt();
    }

    public static final /* synthetic */ double $anonfun$fromStringDouble$3(String[] pair) {
        return new StringOps(Predef$.MODULE$.augmentString(pair[0])).toDouble();
    }

    public static final /* synthetic */ int $anonfun$fromStringDouble$4(String[] pair) {
        return package$.MODULE$.BigInt().apply(pair[1], 16).toInt();
    }

    private ColorMap$() {
        MODULE$ = this;
    }
}

