/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.vector;

import geotrellis.util.Constants$;
import geotrellis.vector.ShewchuksDeterminant;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.locationtech.jts.geom.Coordinate;
import scala.Tuple3;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class RobustPredicates$ {
    public static RobustPredicates$ MODULE$;

    static {
        new RobustPredicates$();
    }

    public final int LEFTOF() {
        return -1;
    }

    public final int RIGHTOF() {
        return 1;
    }

    public final int ON() {
        return 0;
    }

    public double det2(double a11, double a12, double a21, double a22) {
        return a11 * a22 - a12 * a21;
    }

    public double det3(double a11, double a12, double a13, double a21, double a22, double a23, double a31, double a32, double a33) {
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])((double[][])((Object[])new double[][]{{a11, a12, a13}, {a21, a22, a23}, {a31, a32, a33}})));
        return new LUDecomposition(m).getDeterminant();
    }

    public boolean isCollinear(double ax, double ay, double bx, double by, double cx, double cy) {
        return package$.MODULE$.abs(ShewchuksDeterminant.orient2d(ax, ay, bx, by, cx, cy)) < Constants$.MODULE$.DOUBLE_EPSILON();
    }

    public boolean isCollinear(Coordinate a, Coordinate b, Coordinate c) {
        return this.isCollinear(a.x, a.y, b.x, b.y, c.x, c.y);
    }

    public boolean isCCW(double ax, double ay, double bx, double by, double cx, double cy) {
        return ShewchuksDeterminant.orient2d(ax, ay, bx, by, cx, cy) > Constants$.MODULE$.DOUBLE_EPSILON();
    }

    public boolean isCCW(Coordinate a, Coordinate b, Coordinate c) {
        return this.isCCW(a.x, a.y, b.x, b.y, c.x, c.y);
    }

    public int relativeTo(double e0x, double e0y, double e1x, double e1y, double px, double py) {
        double det = ShewchuksDeterminant.orient2d(e0x, e0y, e1x, e1y, px, py);
        return det > Constants$.MODULE$.DOUBLE_EPSILON() ? -1 : (det < -Constants$.MODULE$.DOUBLE_EPSILON() ? 1 : 0);
    }

    public int relativeTo(Coordinate e0, Coordinate e1, Coordinate p) {
        return this.relativeTo(e0.x, e0.y, e1.x, e1.y, p.x, p.y);
    }

    public boolean inCircle(double ax, double ay, double bx, double by, double cx, double cy, double dx, double dy) {
        return ShewchuksDeterminant.incircle(ax, ay, bx, by, cx, cy, dx, dy) > Constants$.MODULE$.DOUBLE_EPSILON();
    }

    public boolean inCircle(Coordinate a, Coordinate b, Coordinate c, Coordinate d) {
        return this.inCircle(a.x, a.y, b.x, b.y, c.x, c.y, d.x, d.y);
    }

    public Tuple3<Object, Coordinate, Object> circleCenter(double ax, double ay, double bx, double by, double cx, double cy) {
        double dbx = bx - ax;
        double dby = by - ay;
        double dcx = cx - ax;
        double dcy = cy - ay;
        double len\u0394b2 = dbx * dbx + dby * dby;
        double len\u0394c2 = dcx * dcx + dcy * dcy;
        double d = 2.0 * this.det2(dbx, dby, dcx, dcy);
        double h = ax - this.det2(dby, len\u0394b2, dcy, len\u0394c2) / d;
        double k = ay + this.det2(dbx, len\u0394b2, dcx, len\u0394c2) / d;
        double r = package$.MODULE$.sqrt(len\u0394b2 * len\u0394c2 * ((bx - cx) * (bx - cx) + (by - cy) * (by - cy))) / d;
        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)r), (Object)new Coordinate(h, k), (Object)BoxesRunTime.boxToBoolean((d > 2.0E-8 ? 1 : 0) != 0));
    }

    private RobustPredicates$() {
        MODULE$ = this;
    }
}

