/*
 * Decompiled with CFR 0.152.
 */
package squants.energy;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import squants.Dimension;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.electro.Amperes$;
import squants.electro.ElectricCurrent;
import squants.electro.ElectricPotential;
import squants.electro.Volts$;
import squants.energy.BtusPerHour$;
import squants.energy.Energy;
import squants.energy.ErgsPerSecond$;
import squants.energy.Gigawatts$;
import squants.energy.Kilowatts$;
import squants.energy.Megawatts$;
import squants.energy.Milliwatts$;
import squants.energy.Power$;
import squants.energy.PowerDensity;
import squants.energy.PowerRamp;
import squants.energy.PowerUnit;
import squants.energy.SolarLuminosities$;
import squants.energy.WattHours$;
import squants.energy.Watts$;
import squants.energy.WattsPerCubicMeter$;
import squants.energy.WattsPerHour$;
import squants.package$;
import squants.radio.Irradiance;
import squants.radio.RadiantIntensity;
import squants.radio.SpectralPower;
import squants.radio.WattsPerMeter$;
import squants.radio.WattsPerSquareMeter$;
import squants.radio.WattsPerSteradian$;
import squants.space.Area;
import squants.space.Length;
import squants.space.SolidAngle;
import squants.space.SquareMeters$;
import squants.space.SquaredRadians$;
import squants.space.Volume;
import squants.time.Frequency;
import squants.time.Hours$;
import squants.time.Time;
import squants.time.TimeDerivative;
import squants.time.TimeIntegral;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t%a\u0001\u0002\u0014(\u00051B\u0001B\u0011\u0001\u0003\u0006\u0004%\ta\u0011\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\t\"A1\n\u0001BC\u0002\u0013\u0005A\n\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003N\u0011\u0015\t\u0006\u0001\"\u0003S\u0011\u0015)\u0006\u0001\"\u0001W\u0011!\t)\b\u0001C\tS\u0005]\u0004bBA=\u0001\u0011E\u00111\u0010\u0005\bm\u0001!\t\"KA?\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000bCq!a!\u0001\t\u0003\ti\nC\u0004\u0002\u0004\u0002!\t!!)\t\u000f\u0005\r\u0005\u0001\"\u0001\u00022\"9\u00111\u0011\u0001\u0005\u0002\u0005U\u0006bBAB\u0001\u0011\u0005\u00111\u001a\u0005\b\u0003\u0007\u0003A\u0011AAh\u0011\u001d\t\u0019\t\u0001C\u0001\u0003KDq!a!\u0001\t\u0003\tI\u000f\u0003\u0004\u0002z\u0002!\ta\u0011\u0005\u0007\u0003w\u0004A\u0011A\"\t\r\u0005u\b\u0001\"\u0001D\u0011\u0019\ty\u0010\u0001C\u0001\u0007\"1!\u0011\u0001\u0001\u0005\u0002\rCaAa\u0001\u0001\t\u0003\u0019\u0005B\u0002B\u0003\u0001\u0011\u00051\t\u0003\u0004\u0003\b\u0001!\taQ\u0004\u00061\u001eB\t!\u0017\u0004\u0006M\u001dB\tA\u0017\u0005\u0006#r!\t\u0001\u001a\u0005\u0007Kr!\ta\n4\t\r\u0015dB\u0011AA\u0006\u0011\u0019)G\u0004\"\u0001\u0002\"!9\u0011\u0011\u0007\u000f\u0005\u0002\u0005M\u0002bBA#9\u0011\u0005\u0011q\t\u0005\b\u0003\u001fbB\u0011AA$\u0011\u001d\t\t\u0006\bC\u0001\u0003'B\u0011\"a\u001b\u001d\u0003\u0003%I!!\u001c\u0003\u000bA{w/\u001a:\u000b\u0005!J\u0013AB3oKJ<\u0017PC\u0001+\u0003\u001d\u0019\u0018/^1oiN\u001c\u0001a\u0005\u0003\u0001[Mb\u0004c\u0001\u00180c5\t\u0011&\u0003\u00021S\tA\u0011+^1oi&$\u0018\u0010\u0005\u00023\u00015\tq\u0005E\u00025oej\u0011!\u000e\u0006\u0003m%\nA\u0001^5nK&\u0011\u0001(\u000e\u0002\u000f)&lW\rR3sSZ\fG/\u001b<f!\t\u0011$(\u0003\u0002<O\t1QI\\3sOf\u00042\u0001N\u001f@\u0013\tqTG\u0001\u0007US6,\u0017J\u001c;fOJ\fG\u000e\u0005\u00023\u0001&\u0011\u0011i\n\u0002\n!><XM\u001d*b[B\fQA^1mk\u0016,\u0012\u0001\u0012\t\u0003\u000b\"k\u0011A\u0012\u0006\u0002\u000f\u0006)1oY1mC&\u0011\u0011J\u0012\u0002\u0007\t>,(\r\\3\u0002\rY\fG.^3!\u0003\u0011)h.\u001b;\u0016\u00035\u0003\"A\r(\n\u0005=;#!\u0003)po\u0016\u0014XK\\5u\u0003\u0015)h.\u001b;!\u0003\u0019a\u0014N\\5u}Q\u0019\u0011g\u0015+\t\u000b\t+\u0001\u0019\u0001#\t\u000b-+\u0001\u0019A'\u0002\u0013\u0011LW.\u001a8tS>tW#A,\u000f\u0005IZ\u0012!\u0002)po\u0016\u0014\bC\u0001\u001a\u001d'\u0011a2LX1\u0011\u0005\u0015c\u0016BA/G\u0005\u0019\te.\u001f*fMB\u0019afX\u0019\n\u0005\u0001L#!\u0003#j[\u0016t7/[8o!\t)%-\u0003\u0002d\r\na1+\u001a:jC2L'0\u00192mKR\t\u0011,A\u0003baBd\u00170\u0006\u0002hsR)\u0001.!\u0002\u0002\nQ\u0011\u0011'\u001b\u0005\u0006Uz\u0001\u001da[\u0001\u0004]Vl\u0007c\u00017uo:\u0011QN\u001d\b\u0003]Fl\u0011a\u001c\u0006\u0003a.\na\u0001\u0010:p_Rt\u0014\"A$\n\u0005M4\u0015a\u00029bG.\fw-Z\u0005\u0003kZ\u0014qAT;nKJL7M\u0003\u0002t\rB\u0011\u00010\u001f\u0007\u0001\t\u0015QhD1\u0001|\u0005\u0005\t\u0015C\u0001?\u0000!\t)U0\u0003\u0002\u007f\r\n9aj\u001c;iS:<\u0007cA#\u0002\u0002%\u0019\u00111\u0001$\u0003\u0007\u0005s\u0017\u0010\u0003\u0004\u0002\by\u0001\ra^\u0001\u0002]\")1J\ba\u0001\u001bR)\u0011'!\u0004\u0002\u0010!)\u0001f\ba\u0001s!1ag\ba\u0001\u0003#\u0001B!a\u0005\u0002\u001c9!\u0011QCA\r\u001d\rq\u0017qC\u0005\u0002U%\u00111/K\u0005\u0005\u0003;\tyB\u0001\u0003US6,'BA:*)\u0011\t\u0019#a\f\u0011\u000b\u0005\u0015\u00121F\u0019\u000e\u0005\u0005\u001d\"bAA\u0015\r\u0006!Q\u000f^5m\u0013\u0011\ti#a\n\u0003\u0007Q\u0013\u0018\u0010C\u0003CA\u0001\u0007q0\u0001\u0003oC6,WCAA\u001b!\u0011\t9$!\u0011\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\tA\u0001\\1oO*\u0011\u0011qH\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002D\u0005e\"AB*ue&tw-A\u0006qe&l\u0017M]=V]&$XCAA%\u001d\r\u0011\u00141J\u0005\u0004\u0003\u001b:\u0013!B,biR\u001c\u0018AB:j+:LG/A\u0003v]&$8/\u0006\u0002\u0002VA1\u0011qKA1\u0003Kj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\nS6lW\u000f^1cY\u0016T1!a\u0018G\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003G\nIFA\u0002TKR\u0004BALA4c%\u0019\u0011\u0011N\u0015\u0003\u001bUs\u0017\u000e^(g\u001b\u0016\f7/\u001e:f\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005=\u0004\u0003BA\u001c\u0003cJA!a\u001d\u0002:\t1qJ\u00196fGR\fa\u0002^5nK&sG/Z4sCR,G-F\u0001:\u0003-!\u0018.\\3EKJLg/\u001a3\u0016\u0003}*\"!a \u0011\u0007Q\n\t)C\u0002\u0002\u001eU\nA\u0001\n3jmR!\u0011qQAJ!\u0011\tI)a$\u000e\u0005\u0005-%bAAGS\u0005)!/\u00193j_&!\u0011\u0011SAF\u00055\u0019\u0006/Z2ue\u0006d\u0007k\\<fe\"9\u0011Q\u0013\u0006A\u0002\u0005]\u0015\u0001\u0002;iCR\u0004B!a\u0005\u0002\u001a&!\u00111TA\u0010\u0005\u0019aUM\\4uQR!\u0011qSAP\u0011\u001d\t)j\u0003a\u0001\u0003\u000f#B!a)\u0002*B!\u0011\u0011RAS\u0013\u0011\t9+a#\u0003\u0015%\u0013(/\u00193jC:\u001cW\rC\u0004\u0002\u00162\u0001\r!a+\u0011\t\u0005M\u0011QV\u0005\u0005\u0003_\u000byB\u0001\u0003Be\u0016\fG\u0003BAV\u0003gCq!!&\u000e\u0001\u0004\t\u0019\u000b\u0006\u0003\u00028\u0006\r\u0007\u0003BA]\u0003\u007fk!!a/\u000b\u0007\u0005u\u0016&A\u0003ta\u0006\u001cW-\u0003\u0003\u0002B\u0006m&AC*pY&$\u0017I\\4mK\"9\u0011Q\u0013\bA\u0002\u0005\u0015\u0007\u0003BAE\u0003\u000fLA!!3\u0002\f\n\u0001\"+\u00193jC:$\u0018J\u001c;f]NLG/\u001f\u000b\u0005\u0003\u000b\fi\rC\u0004\u0002\u0016>\u0001\r!a.\u0015\t\u0005E\u0017Q\u001c\t\u0005\u0003'\fI.\u0004\u0002\u0002V*\u0019\u0011q[\u0015\u0002\u000f\u0015dWm\u0019;s_&!\u00111\\Ak\u0005=)E.Z2ue&\u001c7)\u001e:sK:$\bbBAK!\u0001\u0007\u0011q\u001c\t\u0005\u0003'\f\t/\u0003\u0003\u0002d\u0006U'!E#mK\u000e$(/[2Q_R,g\u000e^5bYR!\u0011q\\At\u0011\u001d\t)*\u0005a\u0001\u0003#$B!a;\u0002rB\u0019!'!<\n\u0007\u0005=xE\u0001\u0007Q_^,'\u000fR3og&$\u0018\u0010C\u0004\u0002\u0016J\u0001\r!a=\u0011\t\u0005M\u0011Q_\u0005\u0005\u0003o\fyB\u0001\u0004W_2,X.Z\u0001\ri>l\u0015\u000e\u001c7jo\u0006$Ho]\u0001\bi><\u0016\r\u001e;t\u0003-!xnS5m_^\fG\u000f^:\u0002\u0017Q|W*Z4bo\u0006$Ho]\u0001\fi><\u0015nZ1xCR$8/A\u0007u_\n#Xo\u001d)fe\"{WO]\u0001\u0010i>,%oZ:QKJ\u001cVmY8oI\u0006\u0019Bo\\*pY\u0006\u0014H*^7j]>\u001c\u0018\u000e^5fg\u0002")
public final class Power
extends Quantity<Power>
implements TimeDerivative<Energy>,
TimeIntegral<PowerRamp> {
    private final double value;
    private final PowerUnit unit;

    public static Set<UnitOfMeasure<Power>> units() {
        return Power$.MODULE$.units();
    }

    public static Watts$ siUnit() {
        return Power$.MODULE$.siUnit();
    }

    public static Watts$ primaryUnit() {
        return Power$.MODULE$.primaryUnit();
    }

    public static String name() {
        return Power$.MODULE$.name();
    }

    public static Try<Power> apply(Object object) {
        return Power$.MODULE$.apply(object);
    }

    public static Power apply(Energy energy, Time time) {
        return Power$.MODULE$.apply(energy, time);
    }

    public static Dimension<Power> dimensionImplicit() {
        return Power$.MODULE$.dimensionImplicit();
    }

    public static <N> Try<Power> parseTuple(Tuple2<N, String> tuple22, Numeric<N> numeric) {
        return Power$.MODULE$.parseTuple(tuple22, numeric);
    }

    public static Try<Power> parseString(String string2) {
        return Power$.MODULE$.parseString(string2);
    }

    public static Option<UnitOfMeasure<Power>> symbolToUnit(String string2) {
        return Power$.MODULE$.symbolToUnit(string2);
    }

    @Override
    public Quantity $div(Time that) {
        return TimeIntegral.$div$((TimeIntegral)this, that);
    }

    @Override
    public Quantity per(Time that) {
        return TimeIntegral.per$(this, that);
    }

    @Override
    public Time $div(Quantity that) {
        return TimeIntegral.$div$((TimeIntegral)this, that);
    }

    @Override
    public Quantity $times(Frequency that) {
        return TimeIntegral.$times$(this, that);
    }

    @Override
    public Quantity $times(Time that) {
        return TimeDerivative.$times$(this, that);
    }

    @Override
    public Frequency $div(Quantity that) {
        return TimeDerivative.$div$(this, that);
    }

    @Override
    public double value() {
        return this.value;
    }

    public PowerUnit unit() {
        return this.unit;
    }

    public Power$ dimension() {
        return Power$.MODULE$;
    }

    @Override
    public Energy timeIntegrated() {
        return WattHours$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toWatts()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public PowerRamp timeDerived() {
        return WattsPerHour$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toWatts()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Hours$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public SpectralPower $div(Length that) {
        return WattsPerMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Length $div(SpectralPower that) {
        return package$.MODULE$.Meters().apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toWattsPerMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Irradiance $div(Area that) {
        return WattsPerSquareMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Area $div(Irradiance that) {
        return SquareMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toWattsPerSquareMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public SolidAngle $div(RadiantIntensity that) {
        return SquaredRadians$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toWattsPerSteradian())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public RadiantIntensity $div(SolidAngle that) {
        return WattsPerSteradian$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toSteradians())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricCurrent $div(ElectricPotential that) {
        return Amperes$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toVolts())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricPotential $div(ElectricCurrent that) {
        return Volts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toAmperes())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public PowerDensity $div(Volume that) {
        return WattsPerCubicMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toCubicMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toMilliwatts() {
        return this.to(Milliwatts$.MODULE$);
    }

    public double toWatts() {
        return this.to(Watts$.MODULE$);
    }

    public double toKilowatts() {
        return this.to(Kilowatts$.MODULE$);
    }

    public double toMegawatts() {
        return this.to(Megawatts$.MODULE$);
    }

    public double toGigawatts() {
        return this.to(Gigawatts$.MODULE$);
    }

    public double toBtusPerHour() {
        return this.to(BtusPerHour$.MODULE$);
    }

    public double toErgsPerSecond() {
        return this.to(ErgsPerSecond$.MODULE$);
    }

    public double toSolarLuminosities() {
        return this.to(SolarLuminosities$.MODULE$);
    }

    public Power(double value, PowerUnit unit) {
        this.value = value;
        this.unit = unit;
        TimeDerivative.$init$(this);
        TimeIntegral.$init$(this);
    }
}

