/*
 * Decompiled with CFR 0.152.
 */
package squants.market;

import scala.Function1;
import scala.Option;
import scala.Some;
import scala.math.BigDecimal;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import squants.market.AUD$;
import squants.market.BTC$;
import squants.market.CAD$;
import squants.market.CHF$;
import squants.market.ETH$;
import squants.market.EUR$;
import squants.market.GBP$;
import squants.market.HKD$;
import squants.market.JPY$;
import squants.market.LTC$;
import squants.market.Money;
import squants.market.Money$;
import squants.market.MoneyContext;
import squants.market.MoneyConversions$;
import squants.market.NAD$;
import squants.market.NOK$;
import squants.market.NZD$;
import squants.market.SEK$;
import squants.market.TRY$;
import squants.market.USD$;
import squants.market.XAG$;
import squants.market.XAU$;
import squants.market.ZAR$;

@ScalaSignature(bytes="\u0006\u0001\u0005]x!B\u001d;\u0011\u0003yd!B!;\u0011\u0003\u0011\u0005\"B%\u0002\t\u0003Q\u0005\u0002C&\u0002\u0011\u000b\u0007I\u0011\u0001'\t\u0011A\u000b\u0001R1A\u0005\u00021C\u0001\"U\u0001\t\u0006\u0004%\t\u0001\u0014\u0005\u0006%\u0006!\u0019a\u0015\u0005\b\u0003\u0003\nA1AA\"\r\u0011\t\u0015!\u0001,\t\u0011aC!\u0011!Q\u0001\neC\u0001\u0002\u001a\u0005\u0003\u0002\u0003\u0006Y!\u001a\u0005\u0006\u0013\"!\t!\u001d\u0005\u0006m\"!\ta\u001e\u0005\u0006{\"!\t\u0001\u0014\u0005\u0006}\"!\t\u0001\u0014\u0005\u0006\u007f\"!\t\u0001\u0014\u0005\u0007\u0003\u0003AA\u0011\u0001'\t\r\u0005\r\u0001\u0002\"\u0001M\u0011\u0019\t)\u0001\u0003C\u0001\u0019\"1\u0011q\u0001\u0005\u0005\u00021Ca!!\u0003\t\t\u0003a\u0005\"B)\t\t\u0003a\u0005BBA\u0006\u0011\u0011\u0005A\n\u0003\u0004\u0002\u000e!!\t\u0001\u0014\u0005\u0007\u0003\u001fAA\u0011\u0001'\t\r\u0005E\u0001\u0002\"\u0001M\u0011\u0019\t\u0019\u0002\u0003C\u0001\u0019\"1\u0011Q\u0003\u0005\u0005\u00021Ca!a\u0006\t\t\u0003a\u0005BBA\r\u0011\u0011\u0005A\n\u0003\u0004\u0002\u001c!!\t\u0001\u0014\u0005\u0007\u0003;AA\u0011\u0001'\t\r\u0005}\u0001\u0002\"\u0001M\u0011\u0019\t\t\u0003\u0003C\u0001\u0019\"1\u00111\u0005\u0005\u0005\u00021Ca!!\n\t\t\u0003a\u0005BBA\u0014\u0011\u0011\u0005A\n\u0003\u0004\u0002*!!\t\u0001\u0014\u0005\u0007\u0003WAA\u0011\u0001'\t\r\u00055\u0002\u0002\"\u0001M\u0011\u0019\ty\u0003\u0003C\u0001\u0019\"A\u0011(AA\u0001\n\u0007\tyE\u0002\u0004\u0002b\u0005\u0001\u00111\r\u0005\n\u0003oR#\u0011!Q\u0001\fiDa!\u0013\u0016\u0005\u0002\u0005e\u0004bBAAU\u0011\u0005\u00111\u0011\u0005\b\u0003\u001bSC\u0011AAH\u0011\u001d\t)J\u000bC\u0001\u0003/Cq!!(+\t\u0003\ty\nC\u0004\u0002$*\"\t!!*\t\u000f\u0005=&\u0006\"\u0001\u00022\"9\u0011Q\u0017\u0016\u0005\u0002\u0005]\u0006bBA^U\u0011\u0005\u0011Q\u0018\u0005\b\u0003\u000fTC\u0011AAe\u0011\u001d\tiM\u000bC\u0001\u0003\u001fDq!!6+\t\u0003\t9\u000eC\u0004\u0002t*\"\t%!>\u0002!5{g.Z=D_:4XM]:j_:\u001c(BA\u001e=\u0003\u0019i\u0017M]6fi*\tQ(A\u0004tcV\fg\u000e^:\u0004\u0001A\u0011\u0001)A\u0007\u0002u\t\u0001Rj\u001c8fs\u000e{gN^3sg&|gn]\n\u0003\u0003\r\u0003\"\u0001R$\u000e\u0003\u0015S\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u0016\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001@\u0003\u0019!w\u000e\u001c7beV\tQ\n\u0005\u0002A\u001d&\u0011qJ\u000f\u0002\u0006\u001b>tW-_\u0001\u0005KV\u0014x.A\u0002zK:\f\u0001B\u001a:p[2{gn\u001a\u000b\u0004)\u0006]\u0002\u0003B+\t\u0003ci\u0011!A\u000b\u0003/n\u001b\"\u0001C\"\u0002\u00039\u0004\"AW.\r\u0001\u0011)A\f\u0003b\u0001;\n\t\u0011)\u0005\u0002_CB\u0011AiX\u0005\u0003A\u0016\u0013qAT8uQ&tw\r\u0005\u0002EE&\u00111-\u0012\u0002\u0004\u0003:L\u0018a\u00018v[B\u0019aM\\-\u000f\u0005\u001ddgB\u00015l\u001b\u0005I'B\u00016?\u0003\u0019a$o\\8u}%\ta)\u0003\u0002n\u000b\u00069\u0001/Y2lC\u001e,\u0017BA8q\u0005\u001dqU/\\3sS\u000eT!!\\#\u0015\u0005I,HCA:u!\r)\u0006\"\u0017\u0005\u0006I.\u0001\u001d!\u001a\u0005\u00061.\u0001\r!W\u0001\u0006[>tW-\u001f\u000b\u0003\u001bbDQ!\u001f\u0007A\u0004i\fqaY8oi\u0016DH\u000f\u0005\u0002Aw&\u0011AP\u000f\u0002\r\u001b>tW-_\"p]R,\u0007\u0010^\u0001\u00041\u0006+\u0016a\u0001-B\u000f\u0006\u0019Qk\u0015#\u0002\u000f\u0011|G\u000e\\1sg\u0006)1-\u001a8ug\u0006\u0019Q)\u0016*\u0002\u000b\u0015,(o\\:\u0002\u0007)\u0003\u0016,A\u0002H\u0005B\u000bQ\u0002]8v]\u0012\u001cF/\u001a:mS:<\u0017aA\"I\r\u0006Y1o^5tg\u001a\u0013\u0018M\\2t\u0003\r\tU\u000bR\u0001\u0004\u0007\u0006#\u0015aA*F\u0017\u0006\u0019\u0001j\u0013#\u0002\u00079{5*A\u0002O5\u0012\u000b1A\u0011+D\u0003\u001d\u0011\u0017\u000e^2pS:\f1!\u0012+I\u0003\u0015)G\u000f[3s\u0003\raEkQ\u0001\tY&$XmY8j]\u0006\u0019!,\u0011*\u0002\u00079\u000bE)A\u0002U%f\u00032AZA\u001a\u0013\r\t)\u0004\u001d\u0002\u000b\u0005&<G)Z2j[\u0006d\u0007bBA\u001d\r\u0001\u0007\u00111H\u0001\u0002YB\u0019A)!\u0010\n\u0007\u0005}RI\u0001\u0003M_:<\u0017A\u00034s_6$u.\u001e2mKR\u0019A+!\u0012\t\u000f\u0005\u001ds\u00011\u0001\u0002J\u0005\tA\rE\u0002E\u0003\u0017J1!!\u0014F\u0005\u0019!u.\u001e2mKV!\u0011\u0011KA-)\u0011\t\u0019&a\u0018\u0015\t\u0005U\u00131\f\t\u0005+\"\t9\u0006E\u0002[\u00033\"Q\u0001X\u0015C\u0002uCa\u0001Z\u0015A\u0004\u0005u\u0003\u0003\u00024o\u0003/Ba\u0001W\u0015A\u0002\u0005]#\u0001D'p]\u0016Lh*^7fe&\u001c7#\u0002\u0016\u0002f\u0005U\u0004\u0003BA4\u0003cj!!!\u001b\u000b\t\u0005-\u0014QN\u0001\u0005Y\u0006twM\u0003\u0002\u0002p\u0005!!.\u0019<b\u0013\u0011\t\u0019(!\u001b\u0003\r=\u0013'.Z2u!\r1g.T\u0001\u0003[\u000e$\"!a\u001f\u0015\t\u0005u\u0014q\u0010\t\u0003+*Ba!a\u001e-\u0001\bQ\u0018\u0001\u00029mkN$R!TAC\u0003\u0013Ca!a\".\u0001\u0004i\u0015!\u0001=\t\r\u0005-U\u00061\u0001N\u0003\u0005I\u0018!B7j]V\u001cH#B'\u0002\u0012\u0006M\u0005BBAD]\u0001\u0007Q\n\u0003\u0004\u0002\f:\u0002\r!T\u0001\u0006i&lWm\u001d\u000b\u0006=\u0006e\u00151\u0014\u0005\u0007\u0003\u000f{\u0003\u0019A'\t\r\u0005-u\u00061\u0001N\u0003\u0019qWmZ1uKR\u0019Q*!)\t\r\u0005\u001d\u0005\u00071\u0001N\u0003\u001d1'o\\7J]R$2!TAT\u0011\u001d\t9)\ra\u0001\u0003S\u00032\u0001RAV\u0013\r\ti+\u0012\u0002\u0004\u0013:$\u0018!\u0002;p\u0013:$H\u0003BAU\u0003gCa!a\"3\u0001\u0004i\u0015A\u0002;p\u0019>tw\r\u0006\u0003\u0002<\u0005e\u0006BBADg\u0001\u0007Q*A\u0004u_\u001acw.\u0019;\u0015\t\u0005}\u0016Q\u0019\t\u0004\t\u0006\u0005\u0017bAAb\u000b\n)a\t\\8bi\"1\u0011q\u0011\u001bA\u00025\u000b\u0001\u0002^8E_V\u0014G.\u001a\u000b\u0005\u0003\u0013\nY\r\u0003\u0004\u0002\bV\u0002\r!T\u0001\bG>l\u0007/\u0019:f)\u0019\tI+!5\u0002T\"1\u0011q\u0011\u001cA\u00025Ca!a#7\u0001\u0004i\u0015a\u00039beN,7\u000b\u001e:j]\u001e$B!!7\u0002`B!A)a7N\u0013\r\ti.\u0012\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005\u0005x\u00071\u0001\u0002d\u0006\u00191\u000f\u001e:\u0011\t\u0005\u0015\u0018Q\u001e\b\u0005\u0003O\fI\u000f\u0005\u0002i\u000b&\u0019\u00111^#\u0002\rA\u0013X\rZ3g\u0013\u0011\ty/!=\u0003\rM#(/\u001b8h\u0015\r\tY/R\u0001\ti>\u001cFO]5oOR\u0011\u00111\u001d")
public final class MoneyConversions {
    public static <A> MoneyConversions<A> MoneyConversions(A a, Numeric<A> numeric) {
        return MoneyConversions$.MODULE$.MoneyConversions(a, numeric);
    }

    public static MoneyConversions<BigDecimal> fromDouble(double d) {
        return MoneyConversions$.MODULE$.fromDouble(d);
    }

    public static MoneyConversions<BigDecimal> fromLong(long l) {
        return MoneyConversions$.MODULE$.fromLong(l);
    }

    public static Money yen() {
        return MoneyConversions$.MODULE$.yen();
    }

    public static Money euro() {
        return MoneyConversions$.MODULE$.euro();
    }

    public static Money dollar() {
        return MoneyConversions$.MODULE$.dollar();
    }

    public static class MoneyConversions<A> {
        private final A n;
        private final Numeric<A> num;

        public Money money(MoneyContext context) {
            return Money$.MODULE$.apply(this.n, context.defaultCurrency(), this.num);
        }

        public Money XAU() {
            return Money$.MODULE$.apply(this.n, XAU$.MODULE$, this.num);
        }

        public Money XAG() {
            return Money$.MODULE$.apply(this.n, XAG$.MODULE$, this.num);
        }

        public Money USD() {
            return Money$.MODULE$.apply(this.n, USD$.MODULE$, this.num);
        }

        public Money dollars() {
            return this.USD();
        }

        public Money cents() {
            return Money$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.num.toDouble(this.n) / 100.0)), USD$.MODULE$, Numeric.DoubleIsFractional$.MODULE$);
        }

        public Money EUR() {
            return Money$.MODULE$.apply(this.n, EUR$.MODULE$, this.num);
        }

        public Money euros() {
            return this.EUR();
        }

        public Money JPY() {
            return Money$.MODULE$.apply(this.n, JPY$.MODULE$, this.num);
        }

        public Money yen() {
            return this.JPY();
        }

        public Money GBP() {
            return Money$.MODULE$.apply(this.n, GBP$.MODULE$, this.num);
        }

        public Money poundSterling() {
            return this.GBP();
        }

        public Money CHF() {
            return Money$.MODULE$.apply(this.n, CHF$.MODULE$, this.num);
        }

        public Money swissFrancs() {
            return this.CHF();
        }

        public Money AUD() {
            return Money$.MODULE$.apply(this.n, AUD$.MODULE$, this.num);
        }

        public Money CAD() {
            return Money$.MODULE$.apply(this.n, CAD$.MODULE$, this.num);
        }

        public Money SEK() {
            return Money$.MODULE$.apply(this.n, SEK$.MODULE$, this.num);
        }

        public Money HKD() {
            return Money$.MODULE$.apply(this.n, HKD$.MODULE$, this.num);
        }

        public Money NOK() {
            return Money$.MODULE$.apply(this.n, NOK$.MODULE$, this.num);
        }

        public Money NZD() {
            return Money$.MODULE$.apply(this.n, NZD$.MODULE$, this.num);
        }

        public Money BTC() {
            return Money$.MODULE$.apply(this.n, BTC$.MODULE$, this.num);
        }

        public Money bitcoin() {
            return this.BTC();
        }

        public Money ETH() {
            return Money$.MODULE$.apply(this.n, ETH$.MODULE$, this.num);
        }

        public Money ether() {
            return this.ETH();
        }

        public Money LTC() {
            return Money$.MODULE$.apply(this.n, LTC$.MODULE$, this.num);
        }

        public Money litecoin() {
            return this.LTC();
        }

        public Money ZAR() {
            return Money$.MODULE$.apply(this.n, ZAR$.MODULE$, this.num);
        }

        public Money NAD() {
            return Money$.MODULE$.apply(this.n, NAD$.MODULE$, this.num);
        }

        public Money TRY() {
            return Money$.MODULE$.apply(this.n, TRY$.MODULE$, this.num);
        }

        public MoneyConversions(A n, Numeric<A> num) {
            this.n = n;
            this.num = num;
        }
    }

    public static class MoneyNumeric
    implements Numeric<Money> {
        private final MoneyContext mc;

        public Object zero() {
            return Numeric.zero$((Numeric)this);
        }

        public Object one() {
            return Numeric.one$((Numeric)this);
        }

        public Object abs(Object x) {
            return Numeric.abs$((Numeric)this, (Object)x);
        }

        public int signum(Object x) {
            return Numeric.signum$((Numeric)this, (Object)x);
        }

        public Numeric.Ops mkNumericOps(Object lhs) {
            return Numeric.mkNumericOps$((Numeric)this, (Object)lhs);
        }

        public Some tryCompare(Object x, Object y) {
            return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean lteq(Object x, Object y) {
            return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean gteq(Object x, Object y) {
            return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean lt(Object x, Object y) {
            return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean gt(Object x, Object y) {
            return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean equiv(Object x, Object y) {
            return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
        }

        public Object max(Object x, Object y) {
            return Ordering.max$((Ordering)this, (Object)x, (Object)y);
        }

        public Object min(Object x, Object y) {
            return Ordering.min$((Ordering)this, (Object)x, (Object)y);
        }

        public Ordering<Money> reverse() {
            return Ordering.reverse$((Ordering)this);
        }

        public <U> Ordering<U> on(Function1<U, Money> f) {
            return Ordering.on$((Ordering)this, f);
        }

        public Ordering.Ops mkOrderingOps(Object lhs) {
            return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
        }

        public Money plus(Money x, Money y) {
            return x.$plus(y, this.mc);
        }

        public Money minus(Money x, Money y) {
            return x.$minus(y, this.mc);
        }

        public Nothing$ times(Money x, Money y) {
            throw new UnsupportedOperationException("Numeric.times not supported for Quantities");
        }

        public Money negate(Money x) {
            return (Money)x.unary_$minus();
        }

        public Money fromInt(int x) {
            return this.mc.defaultCurrency().apply(BoxesRunTime.boxToInteger((int)x), (Numeric)Numeric.IntIsIntegral$.MODULE$);
        }

        public int toInt(Money x) {
            return (int)x.value();
        }

        public long toLong(Money x) {
            return (long)x.value();
        }

        public float toFloat(Money x) {
            return (float)x.value();
        }

        public double toDouble(Money x) {
            return x.value();
        }

        public int compare(Money x, Money y) {
            return x.value() > y.value() ? 1 : (x.value() < y.value() ? -1 : 0);
        }

        public Option<Money> parseString(String str) {
            return Money$.MODULE$.apply(str, this.mc).toOption();
        }

        public String toString() {
            return new StringBuilder(14).append("MoneyNumeric(").append(this.mc).append(")").toString();
        }

        public MoneyNumeric(MoneyContext mc) {
            this.mc = mc;
            PartialOrdering.$init$((PartialOrdering)this);
            Ordering.$init$((Ordering)this);
            Numeric.$init$((Numeric)this);
        }
    }
}

