/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CompositeTile;
import geotrellis.raster.ConstantTile;
import geotrellis.raster.CroppedTile;
import geotrellis.raster.DataType;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.package$;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\tEd!B\u0016-\u0003\u0003\t\u0004\"\u0002\u001f\u0001\t\u0003i\u0004\"B \u0001\r\u0003\u0001\u0005\"\u0002#\u0001\r\u0003\u0001\u0005\"B#\u0001\t\u0003i\u0004\"\u0002$\u0001\t\u00039\u0005\"B)\u0001\r\u0003\u0011\u0006\"B.\u0001\r\u0003a\u0006\"B0\u0001\t\u0003\u0001\u0007\"B5\u0001\t\u0003Q\u0007\"B7\u0001\t\u0003q\u0007\"\u0002;\u0001\t\u0003)\b\"\u0002>\u0001\t\u0003Y\b\"\u0002@\u0001\t\u0003y\bbBA\u0003\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003'\u0001A\u0011AA\u000b\u0011\u001d\ty\u0002\u0001C\u0001\u0003CAq!a\b\u0001\t\u0003\t\t\u0004C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005e\u0002\u0001\"\u0001\u0002F!9\u0011Q\n\u0001\u0005B\u0005=\u0003bBA0\u0001\u0019\u0005\u0011\u0011\r\u0005\b\u0003O\u0002a\u0011AA5\u0011\u001d\ti\u0007\u0001C\u0001\u0003_Bq!!\u001f\u0001\t\u0003\tY\bC\u0004\u0002\u0002\u00021\t!a!\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0005bBAN\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0003K\u0003A\u0011AAT\u0011\u001d\tY\u000b\u0001C!\u0003[;q!!2-\u0011\u0003\t9M\u0002\u0004,Y!\u0005\u0011\u0011\u001a\u0005\u0007y\u0001\"\t!!5\t\u000f\u0005M\u0007\u0005\"\u0001\u0002V\"9\u0011Q\u001d\u0011\u0005\u0002\u0005\u001d\bbBAxA\u0011\u0005\u0011\u0011\u001f\u0005\b\u0003?\u0002C\u0011\u0001B\u0003\u0011\u001d\ty\u0006\tC\u0001\u0005+Aq!a\u0018!\t\u0003\u0011Y\u0003C\u0004\u0002`\u0001\"\tA!\u000f\t\u000f\u0005}\u0003\u0005\"\u0001\u0003P!I!Q\f\u0011\u0002\u0002\u0013%!q\f\u0002\n\u0003J\u0014\u0018-\u001f+jY\u0016T!!\f\u0018\u0002\rI\f7\u000f^3s\u0015\u0005y\u0013AC4f_R\u0014X\r\u001c7jg\u000e\u00011c\u0001\u00013mA\u00111\u0007N\u0007\u0002Y%\u0011Q\u0007\f\u0002\u0005)&dW\r\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004H\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGO\u0010\u000b\u0002}A\u00111\u0007A\u0001\u0005G>d7/F\u0001B!\t9$)\u0003\u0002Dq\t\u0019\u0011J\u001c;\u0002\tI|wo]\u0001\fi>\f%O]1z)&dW-A\u0004d_:4XM\u001d;\u0015\u0005yB\u0005\"B%\u0006\u0001\u0004Q\u0015A\u0004;be\u001e,GoQ3mYRK\b/\u001a\t\u0003\u0017:s!a\r'\n\u00055c\u0013a\u00029bG.\fw-Z\u0005\u0003\u001fB\u0013\u0001bQ3mYRK\b/\u001a\u0006\u0003\u001b2\n!b^5uQ:{G)\u0019;b)\t\u00114\u000bC\u0003U\r\u0001\u0007Q+A\u0006o_\u0012\u000bG/\u0019,bYV,\u0007cA\u001cW1&\u0011q\u000b\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005]J\u0016B\u0001.9\u0005\u0019!u.\u001e2mK\u0006Y\u0011N\u001c;feB\u0014X\r^!t)\t\u0011T\fC\u0003_\u000f\u0001\u0007!*A\u0006oK^\u001cU\r\u001c7UsB,\u0017a\u00024pe\u0016\f7\r\u001b\u000b\u0003C\u0012\u0004\"a\u000e2\n\u0005\rD$\u0001B+oSRDQ!\u001a\u0005A\u0002\u0019\f\u0011A\u001a\t\u0005o\u001d\f\u0015-\u0003\u0002iq\tIa)\u001e8di&|g.M\u0001\u000eM>\u0014X-Y2i\t>,(\r\\3\u0015\u0005\u0005\\\u0007\"B3\n\u0001\u0004a\u0007\u0003B\u001ch1\u0006\f\u0011CZ8sK\u0006\u001c\u0007.\u00138u-&\u001c\u0018\u000e^8s)\t\tw\u000eC\u0003q\u0015\u0001\u0007\u0011/A\u0004wSNLGo\u001c:\u0011\u0005-\u0013\u0018BA:Q\u00059Ie\u000e\u001e+jY\u00164\u0016n]5u_J\fACZ8sK\u0006\u001c\u0007\u000eR8vE2,g+[:ji>\u0014HCA1w\u0011\u0015\u00018\u00021\u0001x!\tY\u00050\u0003\u0002z!\n\tBi\\;cY\u0016$\u0016\u000e\\3WSNLGo\u001c:\u0002\u00075\f\u0007\u000f\u0006\u00023y\")Q\r\u0004a\u0001{B!qgZ!B\u0003%i\u0017\r\u001d#pk\ndW\rF\u00023\u0003\u0003Aa!Z\u0007A\u0002\u0005\r\u0001\u0003B\u001ch1b\u000bA\"\\1q\u0013:$X*\u00199qKJ$2AMA\u0005\u0011\u001d\tYA\u0004a\u0001\u0003\u001b\ta!\\1qa\u0016\u0014\bcA&\u0002\u0010%\u0019\u0011\u0011\u0003)\u0003\u001b%sG\u000fV5mK6\u000b\u0007\u000f]3s\u0003=i\u0017\r\u001d#pk\ndW-T1qa\u0016\u0014Hc\u0001\u001a\u0002\u0018!9\u00111B\bA\u0002\u0005e\u0001cA&\u0002\u001c%\u0019\u0011Q\u0004)\u0003!\u0011{WO\u00197f)&dW-T1qa\u0016\u0014\u0018aB2p[\nLg.\u001a\u000b\u0005\u0003G\ti\u0003F\u0002?\u0003KAa!\u001a\tA\u0002\u0005\u001d\u0002CB\u001c\u0002*\u0005\u000b\u0015)C\u0002\u0002,a\u0012\u0011BR;oGRLwN\u001c\u001a\t\r\u0005=\u0002\u00031\u0001?\u0003\u0015yG\u000f[3s)\u0011\t\u0019$a\u000e\u0015\u0007I\n)\u0004\u0003\u0004f#\u0001\u0007\u0011q\u0005\u0005\u0007\u0003_\t\u0002\u0019\u0001\u001a\u0002\u001b\r|WNY5oK\u0012{WO\u00197f)\u0011\ti$a\u0011\u0015\u0007y\ny\u0004\u0003\u0004f%\u0001\u0007\u0011\u0011\t\t\u0007o\u0005%\u0002\f\u0017-\t\r\u0005=\"\u00031\u0001?)\u0011\t9%a\u0013\u0015\u0007I\nI\u0005\u0003\u0004f'\u0001\u0007\u0011\u0011\t\u0005\u0007\u0003_\u0019\u0002\u0019\u0001\u001a\u0002\r\u0015\fX/\u00197t)\u0011\t\t&a\u0016\u0011\u0007]\n\u0019&C\u0002\u0002Va\u0012qAQ8pY\u0016\fg\u000eC\u0004\u00020Q\u0001\r!!\u0017\u0011\u0007]\nY&C\u0002\u0002^a\u00121!\u00118z\u0003\u0015\t\u0007\u000f\u001d7z)\r\t\u00151\r\u0005\u0007\u0003K*\u0002\u0019A!\u0002\u0003%\f1\"\u00199qYf$u.\u001e2mKR\u0019\u0001,a\u001b\t\r\u0005\u0015d\u00031\u0001B\u0003\r9W\r\u001e\u000b\u0006\u0003\u0006E\u0014Q\u000f\u0005\u0007\u0003g:\u0002\u0019A!\u0002\u0007\r|G\u000e\u0003\u0004\u0002x]\u0001\r!Q\u0001\u0004e><\u0018!C4fi\u0012{WO\u00197f)\u0015A\u0016QPA@\u0011\u0019\t\u0019\b\u0007a\u0001\u0003\"1\u0011q\u000f\rA\u0002\u0005\u000bAaY8qsV\ta(\u0001\u0004u_2K7\u000f^\u000b\u0003\u0003\u0013\u0003R!a#\u0002\u0010\u0006s1aNAG\u0013\ti\u0005(\u0003\u0003\u0002\u0012\u0006M%\u0001\u0002'jgRT!!\u0014\u001d\u0002\u0019Q|G*[:u\t>,(\r\\3\u0016\u0005\u0005e\u0005#BAF\u0003\u001fC\u0016a\u0002;p\u0003J\u0014\u0018-\u001f\u000b\u0003\u0003?\u0003BaNAQ\u0003&\u0019\u00111\u0015\u001d\u0003\u000b\u0005\u0013(/Y=\u0002\u001bQ|\u0017I\u001d:bs\u0012{WO\u00197f)\t\tI\u000b\u0005\u00038\u0003CC\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005=\u0006\u0003BAY\u0003\u007fsA!a-\u0002<B\u0019\u0011Q\u0017\u001d\u000e\u0005\u0005]&bAA]a\u00051AH]8pizJ1!!09\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011YAb\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0018\u001d\u0002\u0013\u0005\u0013(/Y=US2,\u0007CA\u001a!'\u0011\u0001\u00131\u001a\u001c\u0011\u0007]\ni-C\u0002\u0002Pb\u0012a!\u00118z%\u00164GCAAd\u0003\u0015\tG\u000e\\8d)!\t9.!8\u0002b\u0006\r\bcA\u001a\u0002Z&\u0019\u00111\u001c\u0017\u0003!5+H/\u00192mK\u0006\u0013(/Y=US2,\u0007BBApE\u0001\u0007!*A\u0001u\u0011\u0015y$\u00051\u0001B\u0011\u0015!%\u00051\u0001B\u0003\u0015)W\u000e\u001d;z)!\t9.!;\u0002l\u00065\bBBApG\u0001\u0007!\nC\u0003@G\u0001\u0007\u0011\tC\u0003EG\u0001\u0007\u0011)A\u0005ge>l')\u001f;fgRQ\u0011q[Az\u0003\u007f\u0014\tAa\u0001\t\u000f\u0005UH\u00051\u0001\u0002x\u0006)!-\u001f;fgB)q'!)\u0002zB\u0019q'a?\n\u0007\u0005u\bH\u0001\u0003CsR,\u0007BBApI\u0001\u0007!\nC\u0003@I\u0001\u0007\u0011\tC\u0003EI\u0001\u0007\u0011\t\u0006\u0005\u0003\b\t5!\u0011\u0003B\n!\r\u0019$\u0011B\u0005\u0004\u0005\u0017a#a\u0007\"zi\u0016\u001cuN\\:uC:$hj\u001c#bi\u0006\f%O]1z)&dW\rC\u0004\u0003\u0010\u0015\u0002\r!a>\u0002\u0007\u0005\u0014(\u000fC\u0003@K\u0001\u0007\u0011\tC\u0003EK\u0001\u0007\u0011\t\u0006\u0005\u0003\u0018\tu!q\u0005B\u0015!\r\u0019$\u0011D\u0005\u0004\u00057a#\u0001H*i_J$8i\u001c8ti\u0006tGOT8ECR\f\u0017I\u001d:bsRKG.\u001a\u0005\b\u0005\u001f1\u0003\u0019\u0001B\u0010!\u00159\u0014\u0011\u0015B\u0011!\r9$1E\u0005\u0004\u0005KA$!B*i_J$\b\"B '\u0001\u0004\t\u0005\"\u0002#'\u0001\u0004\tE\u0003\u0003B\u0017\u0005g\u0011)Da\u000e\u0011\u0007M\u0012y#C\u0002\u000321\u0012!$\u00138u\u0007>t7\u000f^1oi:{G)\u0019;b\u0003J\u0014\u0018-\u001f+jY\u0016DqAa\u0004(\u0001\u0004\ty\nC\u0003@O\u0001\u0007\u0011\tC\u0003EO\u0001\u0007\u0011\t\u0006\u0005\u0003<\t\u0005#1\nB'!\r\u0019$QH\u0005\u0004\u0005\u007fa#\u0001\b$m_\u0006$8i\u001c8ti\u0006tGOT8ECR\f\u0017I\u001d:bsRKG.\u001a\u0005\b\u0005\u001fA\u0003\u0019\u0001B\"!\u00159\u0014\u0011\u0015B#!\r9$qI\u0005\u0004\u0005\u0013B$!\u0002$m_\u0006$\b\"B )\u0001\u0004\t\u0005\"\u0002#)\u0001\u0004\tE\u0003\u0003B)\u0005/\u0012IFa\u0017\u0011\u0007M\u0012\u0019&C\u0002\u0003V1\u0012Q\u0004R8vE2,7i\u001c8ti\u0006tGOT8ECR\f\u0017I\u001d:bsRKG.\u001a\u0005\b\u0005\u001fI\u0003\u0019AAU\u0011\u0015y\u0014\u00061\u0001B\u0011\u0015!\u0015\u00061\u0001B\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u0005\u0004\u0003\u0002B2\u0005[j!A!\u001a\u000b\t\t\u001d$\u0011N\u0001\u0005Y\u0006twM\u0003\u0002\u0003l\u0005!!.\u0019<b\u0013\u0011\u0011yG!\u001a\u0003\r=\u0013'.Z2u\u0001")
public abstract class ArrayTile
extends Tile {
    public static MutableArrayTile fromBytes(byte[] byArray, DataType dataType, int n, int n2) {
        return ArrayTile$.MODULE$.fromBytes(byArray, dataType, n, n2);
    }

    public static MutableArrayTile empty(DataType dataType, int n, int n2) {
        return ArrayTile$.MODULE$.empty(dataType, n, n2);
    }

    public static MutableArrayTile alloc(DataType dataType, int n, int n2) {
        return ArrayTile$.MODULE$.alloc(dataType, n, n2);
    }

    @Override
    public abstract int cols();

    @Override
    public abstract int rows();

    @Override
    public ArrayTile toArrayTile() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ArrayTile convert(DataType targetCellType) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(targetCellType, this.cols$mcI$sp(), this.rows$mcI$sp());
        if (!this.cellType().isFloatingPoint()) {
            for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
                for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                    tile.set(index$macro$1, index$macro$2, this.get(index$macro$1, index$macro$2));
                }
            }
        } else {
            for (int index$macro$4 = 0; index$macro$4 < this.rows$mcI$sp(); ++index$macro$4) {
                for (int index$macro$3 = 0; index$macro$3 < this.cols$mcI$sp(); ++index$macro$3) {
                    tile.setDouble(index$macro$3, index$macro$4, this.getDouble(index$macro$3, index$macro$4));
                }
            }
        }
        return var2_2;
    }

    @Override
    public abstract Tile withNoData(Option<Object> var1);

    @Override
    public abstract Tile interpretAs(DataType var1);

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        int len = BoxesRunTime.unboxToInt(this.size());
        for (int i = 0; i < len; ++i) {
            f.apply$mcVI$sp(this.apply(i));
        }
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        int len = BoxesRunTime.unboxToInt(this.size());
        for (int i = 0; i < len; ++i) {
            f.apply$mcVD$sp(this.applyDouble(i));
        }
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                visitor.apply(index$macro$1, index$macro$2, this.get(index$macro$1, index$macro$2));
            }
        }
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                visitor.apply(index$macro$1, index$macro$2, this.getDouble(index$macro$1, index$macro$2));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile map(Function1<Object, Object> f) {
        void var2_2;
        MutableArrayTile output = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols$mcI$sp(), this.rows$mcI$sp());
        int len = BoxesRunTime.unboxToInt(this.size());
        for (int i = 0; i < len; ++i) {
            output.update(i, f.apply$mcII$sp(this.apply(i)));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        void var3_3;
        int len = BoxesRunTime.unboxToInt(this.size());
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols$mcI$sp(), this.rows$mcI$sp());
        for (int i = 0; i < len; ++i) {
            tile.updateDouble(i, f.apply$mcDD$sp(this.applyDouble(i)));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols$mcI$sp(), this.rows$mcI$sp());
        for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                tile.set(index$macro$1, index$macro$2, mapper.apply(index$macro$1, index$macro$2, this.get(index$macro$1, index$macro$2)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols$mcI$sp(), this.rows$mcI$sp());
        for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                tile.setDouble(index$macro$1, index$macro$2, mapper.apply(index$macro$1, index$macro$2, this.getDouble(index$macro$1, index$macro$2)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayTile combine(ArrayTile other, Function2<Object, Object, Object> f) {
        void var3_3;
        package$.MODULE$.TileTupleExtensions((Tuple2<Tile, Tile>)new Tuple2((Object)this, (Object)other)).assertEqualDimensions();
        MutableArrayTile output = ArrayTile$.MODULE$.alloc(this.cellType().union(other.cellType()), this.cols$mcI$sp(), this.rows$mcI$sp());
        int len = BoxesRunTime.unboxToInt(this.size());
        for (int i = 0; i < len; ++i) {
            output.update(i, f.apply$mcIII$sp(this.apply(i), other.apply(i)));
        }
        return var3_3;
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        Tile tile;
        Tile tile2 = other;
        if (tile2 instanceof ArrayTile) {
            ArrayTile arrayTile = (ArrayTile)tile2;
            tile = this.combine(arrayTile, f);
        } else if (tile2 instanceof ConstantTile) {
            ConstantTile constantTile = (ConstantTile)tile2;
            tile = constantTile.combine(this, (Function2<Object, Object, Object>)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(z1, z2) -> f.apply$mcIII$sp(z2, z1));
        } else if (tile2 instanceof CompositeTile) {
            CompositeTile compositeTile = (CompositeTile)tile2;
            tile = compositeTile.combine(this, (Function2<Object, Object, Object>)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(z1, z2) -> f.apply$mcIII$sp(z2, z1));
        } else if (tile2 instanceof CroppedTile) {
            CroppedTile croppedTile = (CroppedTile)tile2;
            tile = croppedTile.combine(this, (Function2<Object, Object, Object>)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(z1, z2) -> f.apply$mcIII$sp(z2, z1));
        } else {
            tile = this.mapIntMapper(new IntTileMapper(null, f, tile2){
                private final Function2 f$1;
                private final Tile x1$1;

                public int apply(int col, int row, int z) {
                    return this.f$1.apply$mcIII$sp(z, this.x1$1.get(col, row));
                }
                {
                    this.f$1 = f$1;
                    this.x1$1 = x1$1;
                }
            });
        }
        return tile;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayTile combineDouble(ArrayTile other, Function2<Object, Object, Object> f) {
        void var3_3;
        package$.MODULE$.TileTupleExtensions((Tuple2<Tile, Tile>)new Tuple2((Object)this, (Object)other)).assertEqualDimensions();
        MutableArrayTile output = ArrayTile$.MODULE$.alloc(this.cellType().union(other.cellType()), this.cols$mcI$sp(), this.rows$mcI$sp());
        int len = BoxesRunTime.unboxToInt(this.size());
        for (int i = 0; i < len; ++i) {
            output.updateDouble(i, f.apply$mcDDD$sp(this.applyDouble(i), other.applyDouble(i)));
        }
        return var3_3;
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        Tile tile;
        Tile tile2 = other;
        if (tile2 instanceof ArrayTile) {
            ArrayTile arrayTile = (ArrayTile)tile2;
            tile = this.combineDouble(arrayTile, f);
        } else if (tile2 instanceof ConstantTile) {
            ConstantTile constantTile = (ConstantTile)tile2;
            tile = constantTile.combineDouble(this, (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(z1, z2) -> f.apply$mcDDD$sp(z2, z1));
        } else if (tile2 instanceof CompositeTile) {
            CompositeTile compositeTile = (CompositeTile)tile2;
            tile = compositeTile.combineDouble(this, (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(z1, z2) -> f.apply$mcDDD$sp(z2, z1));
        } else {
            tile = this.mapDoubleMapper(new DoubleTileMapper(null, f, tile2){
                private final Function2 f$2;
                private final Tile x1$2;

                public double apply(int col, int row, double z) {
                    return this.f$2.apply$mcDDD$sp(z, this.x1$2.getDouble(col, row));
                }
                {
                    this.f$2 = f$2;
                    this.x1$2 = x1$2;
                }
            });
        }
        return tile;
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof ArrayTile) {
            int i;
            ArrayTile arrayTile = (ArrayTile)object;
            if (arrayTile == null) {
                return false;
            }
            if (arrayTile.cols$mcI$sp() != this.cols$mcI$sp() || arrayTile.rows$mcI$sp() != this.rows$mcI$sp()) {
                return false;
            }
            DataType dataType = arrayTile.cellType();
            DataType dataType2 = this.cellType();
            if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
                return false;
            }
            if (this.cellType().isFloatingPoint()) {
                for (i = 0; i < BoxesRunTime.unboxToInt(this.size()); ++i) {
                    double value = this.applyDouble(i);
                    double otherValue = arrayTile.applyDouble(i);
                    if (!Double.isNaN(value) && !Double.isNaN(otherValue) && value != otherValue) {
                        return false;
                    }
                    if ((Double.isNaN(value) || !Double.isNaN(otherValue)) && (!Double.isNaN(value) || Double.isNaN(otherValue))) continue;
                    return false;
                }
            } else {
                while (i < BoxesRunTime.unboxToInt(this.size())) {
                    if (this.apply(i) != arrayTile.apply(i)) {
                        return false;
                    }
                    ++i;
                }
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public abstract int apply(int var1);

    public abstract double applyDouble(int var1);

    @Override
    public int get(int col, int row) {
        return this.apply(row * this.cols$mcI$sp() + col);
    }

    @Override
    public double getDouble(int col, int row) {
        return this.applyDouble(row * this.cols$mcI$sp() + col);
    }

    public abstract ArrayTile copy();

    public List<Object> toList() {
        return new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.toArray())).toList();
    }

    public List<Object> toListDouble() {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.toArrayDouble())).toList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] toArray() {
        void var2_2;
        int len = BoxesRunTime.unboxToInt(this.size());
        int[] arr = (int[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Int());
        for (int i = 0; i < len; ++i) {
            arr[i] = this.apply(i);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArrayDouble() {
        void var2_2;
        int len = BoxesRunTime.unboxToInt(this.size());
        double[] arr = (double[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Double());
        for (int i = 0; i < len; ++i) {
            arr[i] = this.applyDouble(i);
        }
        return var2_2;
    }

    public String toString() {
        return new StringBuilder(13).append("ArrayTile(").append(this.cols$mcI$sp()).append(",").append(this.rows$mcI$sp()).append(",").append(this.cellType()).append(")").toString();
    }

    @Override
    public int cols$mcI$sp() {
        return this.cols();
    }

    @Override
    public int rows$mcI$sp() {
        return this.rows();
    }
}

