/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.histogram;

import geotrellis.raster.histogram.FastMapHistogram;
import geotrellis.raster.histogram.Histogram$mcI$sp;
import geotrellis.raster.histogram.IntHistogram$;
import geotrellis.raster.summary.Statistics;
import geotrellis.raster.summary.Statistics$mcI$sp;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005<Q!\u0004\b\t\u0002U1Qa\u0006\b\t\u0002aAQAI\u0001\u0005\u0002\rBQ\u0001J\u0001\u0005\u0002\u0015BQ\u0001J\u0001\u0005\u0002%BqaL\u0001\u0002\u0002\u0013%\u0001GB\u0004\u0018\u001dA\u0005\u0019\u0011A\u001d\t\u000bu2A\u0011\u0001 \t\u000b\t3A\u0011A\"\t\u000b13A\u0011A'\t\u000bE3A\u0011A'\t\u000bI3A\u0011A*\t\u000ba3A\u0011A-\u0002\u0019%sG\u000fS5ti><'/Y7\u000b\u0005=\u0001\u0012!\u00035jgR|wM]1n\u0015\t\t\"#\u0001\u0004sCN$XM\u001d\u0006\u0002'\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001A\u0011a#A\u0007\u0002\u001d\ta\u0011J\u001c;ISN$xn\u001a:b[N\u0019\u0011!G\u0010\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g!\tQ\u0002%\u0003\u0002\"7\ta1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012!F\u0001\u0006CB\u0004H.\u001f\u000b\u0002MA\u0011acJ\u0005\u0003Q9\u0011\u0001CR1ti6\u000b\u0007\u000fS5ti><'/Y7\u0015\u0005\u0019R\u0003\"B\u0016\u0005\u0001\u0004a\u0013\u0001B:ju\u0016\u0004\"AG\u0017\n\u00059Z\"aA%oi\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005\t\u0004C\u0001\u001a8\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0011a\u0017M\\4\u000b\u0003Y\nAA[1wC&\u0011\u0001h\r\u0002\u0007\u001f\nTWm\u0019;\u0014\u0007\u0019I\"\bE\u0002\u0017w1J!\u0001\u0010\b\u0003\u0013!K7\u000f^8he\u0006l\u0017A\u0002\u0013j]&$H\u0005F\u0001@!\tQ\u0002)\u0003\u0002B7\t!QK\\5u\u0003\u001d1wN]3bG\"$\"a\u0010#\t\u000b\u0015C\u0001\u0019\u0001$\u0002\u0003\u0019\u0004RAG$-\u0013~J!\u0001S\u000e\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u0001\u000eK\u0013\tY5D\u0001\u0003M_:<\u0017\u0001B7pI\u0016$\u0012A\u0014\t\u00045=c\u0013B\u0001)\u001c\u0005\u0019y\u0005\u000f^5p]\u00061Q.\u001a3jC:\fA!\\3b]R\tA\u000bE\u0002\u001b\u001fV\u0003\"A\u0007,\n\u0005][\"A\u0002#pk\ndW-\u0001\u0006ti\u0006$\u0018n\u001d;jGN$\u0012A\u0017\t\u00045=[\u0006c\u0001/`Y5\tQL\u0003\u0002_!\u000591/^7nCJL\u0018B\u00011^\u0005)\u0019F/\u0019;jgRL7m\u001d")
public interface IntHistogram
extends Histogram$mcI$sp {
    public static FastMapHistogram apply(int n) {
        return IntHistogram$.MODULE$.apply(n);
    }

    public static FastMapHistogram apply() {
        return IntHistogram$.MODULE$.apply();
    }

    public static /* synthetic */ void foreach$(IntHistogram $this, Function2 f) {
        $this.foreach((Function2<Object, Object, BoxedUnit>)f);
    }

    @Override
    default public void foreach(Function2<Object, Object, BoxedUnit> f) {
        this.foreach$mcI$sp(f);
    }

    public static /* synthetic */ Option mode$(IntHistogram $this) {
        return $this.mode();
    }

    @Override
    default public Option<Object> mode() {
        if (this.totalCount() == 0L) {
            return None$.MODULE$;
        }
        int[] localValues = this.values$mcI$sp();
        int mode = localValues[0];
        long count = this.itemCount$mcI$sp(mode);
        int len = localValues.length;
        for (int index$macro$1 = 1; index$macro$1 < len; ++index$macro$1) {
            int z = localValues[index$macro$1];
            long c = this.itemCount$mcI$sp(z);
            if (c <= count) continue;
            count = c;
            mode = z;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)mode));
    }

    public static /* synthetic */ Option median$(IntHistogram $this) {
        return $this.median();
    }

    @Override
    default public Option<Object> median() {
        None$ none$;
        if (this.totalCount() == 0L) {
            none$ = None$.MODULE$;
        } else {
            int[] localValues = this.values$mcI$sp();
            long middle = this.totalCount() / 2L;
            long total = 0L;
            int i = 0;
            while (total <= middle) {
                total += this.itemCount$mcI$sp(localValues[i]);
                ++i;
            }
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)localValues[i - 1]));
        }
        return none$;
    }

    public static /* synthetic */ Option mean$(IntHistogram $this) {
        return $this.mean();
    }

    @Override
    default public Option<Object> mean() {
        if (this.totalCount() == 0L) {
            return None$.MODULE$;
        }
        int[] localValues = this.rawValues$mcI$sp();
        double mean = 0.0;
        double total = 0.0;
        for (int value : localValues) {
            long count = this.itemCount$mcI$sp(value);
            double delta = (double)value - mean;
            mean += (double)count * delta / (total += (double)count);
        }
        return new Some((Object)BoxesRunTime.boxToDouble((double)mean));
    }

    public static /* synthetic */ Option statistics$(IntHistogram $this) {
        return $this.statistics();
    }

    @Override
    default public Option<Statistics<Object>> statistics() {
        None$ none$;
        int[] localValues = this.values$mcI$sp();
        if (localValues.length == 0) {
            none$ = None$.MODULE$;
        } else {
            long dataCount = 0L;
            int mode = 0;
            long modeCount = 0L;
            double mean = 0.0;
            long total = 0L;
            int median = 0;
            boolean needMedian = true;
            long limit = this.totalCount() / 2L;
            int len = localValues.length;
            for (int index$macro$1 = 0; index$macro$1 < len; ++index$macro$1) {
                int value = localValues[index$macro$1];
                long count = this.itemCount$mcI$sp(value);
                dataCount += count;
                if (count == 0L) continue;
                if (count > modeCount) {
                    mode = value;
                    modeCount = count;
                }
                double delta = (double)value - mean;
                mean += (double)count * delta / (double)(total += count);
                if (!needMedian || total <= limit) continue;
                median = localValues[index$macro$1];
                needMedian = false;
            }
            int zmin = localValues[0];
            int zmax = localValues[len - 1];
            total = 0L;
            double mean2 = 0.0;
            for (int index$macro$2 = 0; index$macro$2 < len; ++index$macro$2) {
                int value = localValues[index$macro$2];
                long count = this.itemCount$mcI$sp(value);
                if (count <= 0L) continue;
                double x = (double)value - mean;
                double y = x * x;
                double delta = y - mean2;
                mean2 += (double)count * delta / (double)(total += count);
            }
            double stddev = package$.MODULE$.sqrt(mean2);
            none$ = new Some((Object)new Statistics$mcI$sp(dataCount, mean, median, mode, stddev, zmin, zmax));
        }
        return none$;
    }

    public static /* synthetic */ void foreach$mcI$sp$(IntHistogram $this, Function2 f) {
        $this.foreach$mcI$sp((Function2<Object, Object, BoxedUnit>)f);
    }

    @Override
    default public void foreach$mcI$sp(Function2<Object, Object, BoxedUnit> f) {
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.values$mcI$sp())).foreach((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)z -> f.apply$mcVIJ$sp(z, this.itemCount$mcI$sp(z)));
    }

    public static void $init$(IntHistogram $this) {
    }
}

