/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.DataType;
import geotrellis.raster.DoubleConstantNoDataCellType$;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000154Q!\u0005\n\u0002\u0002mA\u0001B\n\u0001\u0003\u0006\u0004%\ta\n\u0005\t]\u0001\u0011\t\u0011)A\u0005Q!)q\u0006\u0001C\u0001a!91\u0007\u0001b\u0001\n#!\u0004BB\u001f\u0001A\u0003%Q\u0007C\u0004?\u0001\t\u0007I\u0011A \t\r\r\u0003\u0001\u0015!\u0003A\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015Y\u0005A\"\u0001M\u0011\u0015q\u0005A\"\u0001P\u0011\u0015\t\u0006A\"\u0005S\u0011\u0015)\u0006A\"\u0005W\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u0015I\u0007\u0001\"\u0001k\u0005U1En\\1umQ:Um\u001c+jM\u001a\u001cVmZ7f]RT!a\u0005\u000b\u0002\u000f\u001d,w\u000e^5gM*\u0011QCF\u0001\u0003S>T!a\u0006\r\u0002\rI\f7\u000f^3s\u0015\u0005I\u0012AC4f_R\u0014X\r\u001c7jg\u000e\u00011c\u0001\u0001\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004\"a\t\u0013\u000e\u0003II!!\n\n\u0003\u001d\u001d+w\u000eV5gMN+w-\\3oi\u0006)!-\u001f;fgV\t\u0001\u0006E\u0002\u001eS-J!A\u000b\u0010\u0003\u000b\u0005\u0013(/Y=\u0011\u0005ua\u0013BA\u0017\u001f\u0005\u0011\u0011\u0015\u0010^3\u0002\r\tLH/Z:!\u0003\u0019a\u0014N\\5u}Q\u0011\u0011G\r\t\u0003G\u0001AQAJ\u0002A\u0002!\naAY;gM\u0016\u0014X#A\u001b\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014a\u00018j_*\t!(\u0001\u0003kCZ\f\u0017B\u0001\u001f8\u00051!u.\u001e2mK\n+hMZ3s\u0003\u001d\u0011WO\u001a4fe\u0002\nAa]5{KV\t\u0001\t\u0005\u0002\u001e\u0003&\u0011!I\b\u0002\u0004\u0013:$\u0018!B:ju\u0016\u0004\u0013aA4fiR\u0011a)\u0013\t\u0003;\u001dK!\u0001\u0013\u0010\u0003\r\u0011{WO\u00197f\u0011\u0015Q\u0005\u00021\u0001A\u0003\u0005I\u0017AB4fi&sG\u000f\u0006\u0002A\u001b\")!*\u0003a\u0001\u0001\u0006Iq-\u001a;E_V\u0014G.\u001a\u000b\u0003\rBCQA\u0013\u0006A\u0002\u0001\u000ba\"\u001b8u)>$u.\u001e2mK>+H\u000f\u0006\u0002G'\")Ak\u0003a\u0001\u0001\u0006\ta/A\te_V\u0014G.\u001a+p\t>,(\r\\3PkR$\"AR,\t\u000bQc\u0001\u0019\u0001$\u0002\u00075\f\u0007\u000f\u0006\u0002)5\")1,\u0004a\u00019\u0006\ta\r\u0005\u0003\u001e;\u0002\u0003\u0015B\u00010\u001f\u0005%1UO\\2uS>t\u0017'A\u0005nCB$u.\u001e2mKR\u0011\u0001&\u0019\u0005\u00067:\u0001\rA\u0019\t\u0005;u3e)\u0001\u0007nCB<\u0016\u000e\u001e5J]\u0012,\u0007\u0010\u0006\u0002)K\")1l\u0004a\u0001MB)Qd\u001a!A\u0001&\u0011\u0001N\b\u0002\n\rVt7\r^5p]J\n!#\\1q\t>,(\r\\3XSRD\u0017J\u001c3fqR\u0011\u0001f\u001b\u0005\u00067B\u0001\r\u0001\u001c\t\u0006;\u001d\u0004eI\u0012")
public abstract class Float64GeoTiffSegment
implements GeoTiffSegment {
    private final byte[] bytes;
    private final DoubleBuffer buffer;
    private final int size;

    @Override
    public byte[] convert(DataType cellType) {
        return GeoTiffSegment.convert$(this, cellType);
    }

    @Override
    public byte[] bytes() {
        return this.bytes;
    }

    public DoubleBuffer buffer() {
        return this.buffer;
    }

    @Override
    public int size() {
        return this.size;
    }

    public double get(int i) {
        return this.buffer().get(i);
    }

    @Override
    public abstract int getInt(int var1);

    @Override
    public abstract double getDouble(int var1);

    public abstract double intToDoubleOut(int var1);

    public abstract double doubleToDoubleOut(double var1);

    @Override
    public byte[] map(Function1<Object, Object> f) {
        double[] arr = (double[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Double());
        for (int index$macro$1 = 0; index$macro$1 < this.size(); ++index$macro$1) {
            int n = f.apply$mcII$sp(this.getInt(index$macro$1));
            arr[index$macro$1] = n == Integer.MIN_VALUE ? Double.NaN : (double)n;
        }
        byte[] result = new byte[this.size() * DoubleConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asDoubleBuffer().put(arr);
        return result;
    }

    @Override
    public byte[] mapDouble(Function1<Object, Object> f) {
        double[] arr = (double[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Double());
        for (int index$macro$1 = 0; index$macro$1 < this.size(); ++index$macro$1) {
            arr[index$macro$1] = f.apply$mcDD$sp(this.getDouble(index$macro$1));
        }
        byte[] result = new byte[this.size() * DoubleConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asDoubleBuffer().put(arr);
        return result;
    }

    @Override
    public byte[] mapWithIndex(Function2<Object, Object, Object> f) {
        double[] arr = (double[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Double());
        for (int index$macro$1 = 0; index$macro$1 < this.size(); ++index$macro$1) {
            int n = f.apply$mcIII$sp(index$macro$1, this.getInt(index$macro$1));
            arr[index$macro$1] = n == Integer.MIN_VALUE ? Double.NaN : (double)n;
        }
        byte[] result = new byte[this.size() * DoubleConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asDoubleBuffer().put(arr);
        return result;
    }

    @Override
    public byte[] mapDoubleWithIndex(Function2<Object, Object, Object> f) {
        double[] arr = (double[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Double());
        for (int index$macro$1 = 0; index$macro$1 < this.size(); ++index$macro$1) {
            arr[index$macro$1] = f.apply$mcDID$sp(index$macro$1, this.getDouble(index$macro$1));
        }
        byte[] result = new byte[this.size() * DoubleConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asDoubleBuffer().put(arr);
        return result;
    }

    public Float64GeoTiffSegment(byte[] bytes) {
        this.bytes = bytes;
        GeoTiffSegment.$init$(this);
        this.buffer = ByteBuffer.wrap(bytes).asDoubleBuffer();
        this.size = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).size() / 8;
    }
}

