/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.DataType;
import geotrellis.raster.FloatConstantNoDataCellType$;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d4Aa\u0004\t\u00013!AA\u0005\u0001BC\u0002\u0013\u0005Q\u0005\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003'\u0011\u0015i\u0003\u0001\"\u0001/\u0011\u001d\t\u0004A1A\u0005\u0012IBaa\u000f\u0001!\u0002\u0013\u0019\u0004b\u0002\u001f\u0001\u0005\u0004%\t!\u0010\u0005\u0007\u0003\u0002\u0001\u000b\u0011\u0002 \t\u000b\t\u0003A\u0011A\"\t\u000b%\u0003A\u0011\u0001&\t\u000b1\u0003A\u0011A'\t\u000bI\u0003A\u0011A*\t\u000be\u0003A\u0011\u0001.\t\u000bu\u0003A\u0011\u00010\t\u000b\r\u0004A\u0011\u00013\u0003)UKe\u000e^\u001a3\u000f\u0016|G+\u001b4g'\u0016<W.\u001a8u\u0015\t\t\"#A\u0004hK>$\u0018N\u001a4\u000b\u0005M!\u0012AA5p\u0015\t)b#\u0001\u0004sCN$XM\u001d\u0006\u0002/\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0019\u0001A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g!\t\t#%D\u0001\u0011\u0013\t\u0019\u0003C\u0001\bHK>$\u0016N\u001a4TK\u001elWM\u001c;\u0002\u000b\tLH/Z:\u0016\u0003\u0019\u00022aG\u0014*\u0013\tACDA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001cU%\u00111\u0006\b\u0002\u0005\u0005f$X-\u0001\u0004csR,7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005=\u0002\u0004CA\u0011\u0001\u0011\u0015!3\u00011\u0001'\u0003\u0019\u0011WO\u001a4feV\t1\u0007\u0005\u00025s5\tQG\u0003\u00027o\u0005\u0019a.[8\u000b\u0003a\nAA[1wC&\u0011!(\u000e\u0002\n\u0013:$()\u001e4gKJ\fqAY;gM\u0016\u0014\b%\u0001\u0003tSj,W#\u0001 \u0011\u0005my\u0014B\u0001!\u001d\u0005\rIe\u000e^\u0001\u0006g&TX\rI\u0001\u0004O\u0016$HC\u0001#H!\tYR)\u0003\u0002G9\t)a\t\\8bi\")\u0001\n\u0003a\u0001}\u0005\t\u0011.\u0001\u0004hKRLe\u000e\u001e\u000b\u0003}-CQ\u0001S\u0005A\u0002y\n\u0011bZ3u\t>,(\r\\3\u0015\u00059\u000b\u0006CA\u000eP\u0013\t\u0001FD\u0001\u0004E_V\u0014G.\u001a\u0005\u0006\u0011*\u0001\rAP\u0001\u0004[\u0006\u0004HC\u0001\u0014U\u0011\u0015)6\u00021\u0001W\u0003\u00051\u0007\u0003B\u000eX}yJ!\u0001\u0017\u000f\u0003\u0013\u0019+hn\u0019;j_:\f\u0014!C7ba\u0012{WO\u00197f)\t13\fC\u0003V\u0019\u0001\u0007A\f\u0005\u0003\u001c/:s\u0015\u0001D7ba^KG\u000f[%oI\u0016DHC\u0001\u0014`\u0011\u0015)V\u00021\u0001a!\u0015Y\u0012M\u0010 ?\u0013\t\u0011GDA\u0005Gk:\u001cG/[8oe\u0005\u0011R.\u00199E_V\u0014G.Z,ji\"Le\u000eZ3y)\t1S\rC\u0003V\u001d\u0001\u0007a\rE\u0003\u001cCzre\n")
public class UInt32GeoTiffSegment
implements GeoTiffSegment {
    private final byte[] bytes;
    private final IntBuffer buffer;
    private final int size;

    @Override
    public byte[] convert(DataType cellType) {
        return GeoTiffSegment.convert$(this, cellType);
    }

    @Override
    public byte[] bytes() {
        return this.bytes;
    }

    public IntBuffer buffer() {
        return this.buffer;
    }

    @Override
    public int size() {
        return this.size;
    }

    public float get(int i) {
        return (long)this.buffer().get(i) & 0xFFFFFFFFL;
    }

    @Override
    public int getInt(int i) {
        float n = this.get(i);
        return Float.isNaN(n) ? Integer.MIN_VALUE : (int)n;
    }

    @Override
    public double getDouble(int i) {
        return this.get(i);
    }

    @Override
    public byte[] map(Function1<Object, Object> f) {
        float[] arr = (float[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Float());
        for (int index$macro$1 = 0; index$macro$1 < this.size(); ++index$macro$1) {
            int n = f.apply$mcII$sp(this.getInt(index$macro$1));
            arr[index$macro$1] = n == Integer.MIN_VALUE ? Float.NaN : (float)n;
        }
        byte[] result = new byte[this.size() * FloatConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asFloatBuffer().put(arr);
        return result;
    }

    @Override
    public byte[] mapDouble(Function1<Object, Object> f) {
        float[] arr = (float[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Float());
        for (int index$macro$1 = 0; index$macro$1 < this.size(); ++index$macro$1) {
            arr[index$macro$1] = (float)f.apply$mcDD$sp(this.getDouble(index$macro$1));
        }
        byte[] result = new byte[this.size() * FloatConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asFloatBuffer().put(arr);
        return result;
    }

    @Override
    public byte[] mapWithIndex(Function2<Object, Object, Object> f) {
        float[] arr = (float[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Float());
        for (int index$macro$1 = 0; index$macro$1 < this.size(); ++index$macro$1) {
            int n = f.apply$mcIII$sp(index$macro$1, this.getInt(index$macro$1));
            arr[index$macro$1] = n == Integer.MIN_VALUE ? Float.NaN : (float)n;
        }
        byte[] result = new byte[this.size() * FloatConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asFloatBuffer().put(arr);
        return result;
    }

    @Override
    public byte[] mapDoubleWithIndex(Function2<Object, Object, Object> f) {
        float[] arr = (float[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Float());
        for (int index$macro$1 = 0; index$macro$1 < this.size(); ++index$macro$1) {
            arr[index$macro$1] = (float)f.apply$mcDID$sp(index$macro$1, this.getDouble(index$macro$1));
        }
        byte[] result = new byte[this.size() * FloatConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asFloatBuffer().put(arr);
        return result;
    }

    public UInt32GeoTiffSegment(byte[] bytes) {
        this.bytes = bytes;
        GeoTiffSegment.$init$(this);
        this.buffer = ByteBuffer.wrap(bytes).asIntBuffer();
        this.size = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).size() / 4;
    }
}

