/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.render;

import geotrellis.raster.render.ColorRamp;
import geotrellis.raster.render.RGBA$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class ColorRamp$
implements Serializable {
    public static ColorRamp$ MODULE$;

    static {
        new ColorRamp$();
    }

    public ColorRamp intArrayToColorRamp(int[] colors) {
        return this.apply(colors);
    }

    public ColorRamp intVectorToColorRamp(Vector<Object> colors) {
        return this.apply((Traversable<Object>)colors);
    }

    public int[] colorRampToIntArray(ColorRamp colorRamp) {
        return (int[])colorRamp.colors().toArray(ClassTag$.MODULE$.Int());
    }

    public Vector<Object> colorRampToIntVector(ColorRamp colorRamp) {
        return colorRamp.colors();
    }

    public ColorRamp apply(int[] colors) {
        return this.apply((Traversable<Object>)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(colors)).toVector());
    }

    public ColorRamp apply(Traversable<Object> colors) {
        return new ColorRamp((Vector<Object>)colors.toVector());
    }

    public ColorRamp apply(Seq<Object> colors, Predef.DummyImplicit d) {
        return this.apply((Traversable<Object>)colors);
    }

    public Vector<Object> spread(Vector<Object> colors, int n) {
        if (colors.length() == n) {
            return colors;
        }
        if (n < 1) {
            return scala.package$.MODULE$.Vector().empty();
        }
        int[] colors2 = new int[n];
        colors2[0] = BoxesRunTime.unboxToInt((Object)colors.apply(0));
        int b = n - 1;
        int color = colors.length() - 1;
        for (int i = 1; i < n; ++i) {
            colors2[i] = BoxesRunTime.unboxToInt((Object)colors.apply((int)package$.MODULE$.round((double)i * (double)color / (double)b)));
        }
        return new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(colors2)).toVector();
    }

    public Vector<Object> chooseColors(Vector<Object> c, int numColors) {
        Vector<Object> vector2 = c;
        Vector<Object> vector3 = vector2.isEmpty() ? vector2 : this.getColorSequence(numColors, (Function1<Function1<Object, Object>, int[]>)(Function1 & java.io.Serializable & Serializable)masker -> {
            int[] nArray;
            Vector hues = (Vector)c.map(masker, Vector$.MODULE$.canBuildFrom());
            int mult = c.length() - 1;
            int denom = numColors - 1;
            if (numColors < 2) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = BoxesRunTime.unboxToInt((Object)hues.apply(0));
            } else {
                int[] ranges = new int[numColors];
                for (int i = 0; i < numColors; ++i) {
                    int j = i * mult / denom;
                    ranges[i] = j < mult ? MODULE$.blend(BoxesRunTime.unboxToInt((Object)hues.apply(j)), BoxesRunTime.unboxToInt((Object)hues.apply(j + 1)), i * mult % denom, denom) : BoxesRunTime.unboxToInt((Object)hues.apply(j));
                }
                nArray = ranges;
            }
            return nArray;
        });
        return vector3;
    }

    private int blend(int start, int end, int numerator, int denominator) {
        return start + (end - start) * numerator / denominator;
    }

    private Vector<Object> getColorSequence(int n, Function1<Function1<Object, Object>, int[]> getRanges) {
        Vector vector2;
        int n2 = n;
        switch (n2) {
            default: 
        }
        if (n2 < 1) {
            vector2 = scala.package$.MODULE$.Vector().empty();
        } else {
            JFunction1.mcII.sp & java.io.Serializable & Serializable unzipR = (JFunction1.mcII.sp & java.io.Serializable & Serializable)color -> RGBA$.MODULE$.red$extension(RGBA$.MODULE$.apply(color));
            JFunction1.mcII.sp & java.io.Serializable & Serializable unzipG = (JFunction1.mcII.sp & java.io.Serializable & Serializable)color -> RGBA$.MODULE$.green$extension(RGBA$.MODULE$.apply(color));
            JFunction1.mcII.sp & java.io.Serializable & Serializable unzipB = (JFunction1.mcII.sp & java.io.Serializable & Serializable)color -> RGBA$.MODULE$.blue$extension(RGBA$.MODULE$.apply(color));
            JFunction1.mcII.sp & java.io.Serializable & Serializable unzipA = (JFunction1.mcII.sp & java.io.Serializable & Serializable)color -> RGBA$.MODULE$.alpha$extension(RGBA$.MODULE$.apply(color));
            int[] rs = (int[])getRanges.apply((Object)unzipR);
            int[] gs = (int[])getRanges.apply((Object)unzipG);
            int[] bs = (int[])getRanges.apply((Object)unzipB);
            int[] as = (int[])getRanges.apply((Object)unzipA);
            int[] theColors = new int[n];
            for (int i = 0; i < n; ++i) {
                theColors[i] = RGBA$.MODULE$.fromRGBA(rs[i], gs[i], bs[i], as[i]);
            }
            vector2 = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(theColors)).toVector();
        }
        return vector2;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ColorRamp$() {
        MODULE$ = this;
    }
}

