/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.vector.triangulation;

import geotrellis.util.Direction;
import geotrellis.vector.Extent;
import geotrellis.vector.MultiPolygon$;
import geotrellis.vector.Polygon$;
import geotrellis.vector.io.wkt.WKT$;
import geotrellis.vector.mesh.HalfEdgeTable;
import geotrellis.vector.mesh.IndexedPointSet;
import geotrellis.vector.triangulation.BoundaryDelaunay;
import geotrellis.vector.triangulation.DelaunayTriangulation;
import geotrellis.vector.triangulation.StitchedDelaunay$;
import geotrellis.vector.triangulation.TriangleMap;
import java.io.PrintWriter;
import java.io.Serializable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t\rt!B\u0015+\u0011\u0003\td!B\u001a+\u0011\u0003!\u0004\"\u0002 \u0002\t\u0003y\u0004\"\u0002!\u0002\t\u0003\t\u0005\"\u0002!\u0002\t\u0003\u0011\b\"\u0002!\u0002\t\u0003!\b\"\u0002@\u0002\t\u0003y\b\"\u0003B\u0011\u0003E\u0005I\u0011\u0001B\u0012\u0011\u0019q\u0018\u0001\"\u0001\u0003(!1a0\u0001C\u0001\u0005cA\u0001B`\u0001\u0002\u0002\u0013\u0005%\u0011\b\u0005\n\u0005\u000b\n\u0011\u0011!CA\u0005\u000fB\u0011B!\u0017\u0002\u0003\u0003%IAa\u0017\u0007\u000bMR\u0003)a\u0001\t\u0015\u0005-QB!f\u0001\n\u0003\ti\u0001\u0003\u0006\u0002.5\u0011\t\u0012)A\u0005\u0003\u001fA!\"a\f\u000e\u0005+\u0007I\u0011AA\u0019\u0011)\tI$\u0004B\tB\u0003%\u00111\u0007\u0005\u000b\u0003wi!Q3A\u0005\u0002\u0005u\u0002\"CA \u001b\tE\t\u0015!\u0003F\u0011)\t\t%\u0004BK\u0002\u0013\u0005\u00111\t\u0005\n\u0003\u000bj!\u0011#Q\u0001\n!C!\"a\u0012\u000e\u0005+\u0007I\u0011AA%\u0011)\t\t&\u0004B\tB\u0003%\u00111\n\u0005\u0007}5!\t!a\u0015\t\u000f\u0005}S\u0002\"\u0001\u0002b!9\u0011qO\u0007\u0005\u0002\u0005e\u0004\"CAK\u001b\u0005\u0005I\u0011AAL\u0011%\t\u0019+DI\u0001\n\u0003\t)\u000bC\u0005\u0002<6\t\n\u0011\"\u0001\u0002>\"I\u0011\u0011Y\u0007\u0012\u0002\u0013\u0005\u00111\u0019\u0005\n\u0003\u000fl\u0011\u0013!C\u0001\u0003\u0013D\u0011\"!4\u000e#\u0003%\t!a4\t\u0013\u0005MW\"!A\u0005B\u0005U\u0007\"CAq\u001b\u0005\u0005I\u0011AA\u001f\u0011%\t\u0019/DA\u0001\n\u0003\t)\u000fC\u0005\u0002r6\t\t\u0011\"\u0011\u0002t\"I!\u0011A\u0007\u0002\u0002\u0013\u0005!1\u0001\u0005\n\u0005\u001bi\u0011\u0011!C!\u0005\u001fA\u0011B!\u0005\u000e\u0003\u0003%\tEa\u0005\t\u0013\tUQ\"!A\u0005B\t]\u0011\u0001E*uSR\u001c\u0007.\u001a3EK2\fWO\\1z\u0015\tYC&A\u0007ue&\fgnZ;mCRLwN\u001c\u0006\u0003[9\naA^3di>\u0014(\"A\u0018\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0011\u0005I\nQ\"\u0001\u0016\u0003!M#\u0018\u000e^2iK\u0012$U\r\\1v]\u0006L8cA\u00016wA\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t1\u0011I\\=SK\u001a\u0004\"A\u000e\u001f\n\u0005u:$\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$h\bF\u00012\u0003A\u0019w.\u001c2j]\u0016$\u0007k\\5oiN+G\u000fF\u0002CA\u0016\u0004RAN\"F\u0011:K!\u0001R\u001c\u0003\rQ+\b\u000f\\34!\t1d)\u0003\u0002Ho\t\u0019\u0011J\u001c;\u0011\u0005%cU\"\u0001&\u000b\u0005-c\u0013\u0001B7fg\"L!!\u0014&\u0003\u001f%sG-\u001a=fIB{\u0017N\u001c;TKR\u0004Ba\u0014,Z?:\u0011\u0001\u000b\u0016\t\u0003#^j\u0011A\u0015\u0006\u0003'B\na\u0001\u0010:p_Rt\u0014BA+8\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000b\u0017\u0002\u0004\u001b\u0006\u0004(BA+8!\tQV,D\u0001\\\u0015\taf&\u0001\u0003vi&d\u0017B\u00010\\\u0005%!\u0015N]3di&|g\u000e\u0005\u0003P-\u0016+\u0005\"B1\u0004\u0001\u0004\u0011\u0017AB2f]R,'\u000f\u0005\u00023G&\u0011AM\u000b\u0002\u0016\t\u0016d\u0017-\u001e8bsR\u0013\u0018.\u00198hk2\fG/[8o\u0011\u001517\u00011\u0001h\u0003%qW-[4iE>\u00148\u000f\u0005\u0003P-fC\u0007\u0003\u0002\u001cjW:L!A[\u001c\u0003\rQ+\b\u000f\\33!\t\u0011D.\u0003\u0002nU\t\u0001\"i\\;oI\u0006\u0014\u0018\u0010R3mCVt\u0017-\u001f\t\u0003_Bl\u0011\u0001L\u0005\u0003c2\u0012a!\u0012=uK:$HC\u0001\"t\u0011\u00151G\u00011\u0001h)\t)8\u0010\u0006\u0002Cm\")q/\u0002a\u0002q\u0006)A-^7nsB\u0011q*_\u0005\u0003ub\u0013Q\u0002R;n[fLU\u000e\u001d7jG&$\b\"\u00024\u0006\u0001\u0004a\b\u0003B(W3v\u0004BAN5c]\u0006)\u0011\r\u001d9msR1\u0011\u0011\u0001B\u000e\u0005;\u0001\"AM\u0007\u0014\u000b5)4(!\u0002\u0011\u0007Y\n9!C\u0002\u0002\n]\u0012q\u0001\u0015:pIV\u001cG/\u0001\u0007j]\u0012,\u0007\u0010V8D_>\u0014H-\u0006\u0002\u0002\u0010A1a'!\u0005F\u0003+I1!a\u00058\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002\u0018\u0005%RBAA\r\u0015\u0011\tY\"!\b\u0002\t\u001d,w.\u001c\u0006\u0005\u0003?\t\t#A\u0002kiNTA!a\t\u0002&\u0005aAn\\2bi&|g\u000e^3dQ*\u0011\u0011qE\u0001\u0004_J<\u0017\u0002BA\u0016\u00033\u0011!bQ8pe\u0012Lg.\u0019;f\u00035Ig\u000eZ3y)>\u001cun\u001c:eA\u0005i\u0001.\u00197g\u000b\u0012<W\rV1cY\u0016,\"!a\r\u0011\u0007%\u000b)$C\u0002\u00028)\u0013Q\u0002S1mM\u0016#w-\u001a+bE2,\u0017A\u00045bY\u001a,EmZ3UC\ndW\rI\u0001\tE>,h\u000eZ1ssV\tQ)A\u0005c_VtG-\u0019:zA\u0005A\u0001o\\5oiN+G/F\u0001I\u0003%\u0001x.\u001b8u'\u0016$\b%A\u0007gS2dGK]5b]\u001edWm]\u000b\u0003\u0003\u0017\u00022AMA'\u0013\r\tyE\u000b\u0002\f)JL\u0017M\\4mK6\u000b\u0007/\u0001\bgS2dGK]5b]\u001edWm\u001d\u0011\u0015\u0019\u0005\u0005\u0011QKA,\u00033\nY&!\u0018\t\u000f\u0005-\u0001\u00041\u0001\u0002\u0010!9\u0011q\u0006\rA\u0002\u0005M\u0002BBA\u001e1\u0001\u0007Q\t\u0003\u0004\u0002Ba\u0001\r\u0001\u0013\u0005\b\u0003\u000fB\u0002\u0019AA&\u0003%!(/[1oO2,7\u000f\u0006\u0002\u0002dA1\u0011QMA8\u0003krA!a\u001a\u0002l9\u0019\u0011+!\u001b\n\u0003aJ1!!\u001c8\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001d\u0002t\t\u00191+Z9\u000b\u0007\u00055t\u0007E\u00037\u0007\u0016+U)\u0001\u0005xe&$XmV&U)\u0011\tY(a#\u0011\t\u0005u\u0014qQ\u0007\u0003\u0003\u007fRA!!!\u0002\u0004\u0006\u0011\u0011n\u001c\u0006\u0003\u0003\u000b\u000bAA[1wC&!\u0011\u0011RA@\u0005-\u0001&/\u001b8u/JLG/\u001a:\t\u000f\u00055%\u00041\u0001\u0002\u0010\u00069qo\u001b;GS2,\u0007cA(\u0002\u0012&\u0019\u00111\u0013-\u0003\rM#(/\u001b8h\u0003\u0011\u0019w\u000e]=\u0015\u0019\u0005\u0005\u0011\u0011TAN\u0003;\u000by*!)\t\u0013\u0005-1\u0004%AA\u0002\u0005=\u0001\"CA\u00187A\u0005\t\u0019AA\u001a\u0011!\tYd\u0007I\u0001\u0002\u0004)\u0005\u0002CA!7A\u0005\t\u0019\u0001%\t\u0013\u0005\u001d3\u0004%AA\u0002\u0005-\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003OSC!a\u0004\u0002*.\u0012\u00111\u0016\t\u0005\u0003[\u000b9,\u0004\u0002\u00020*!\u0011\u0011WAZ\u0003%)hn\u00195fG.,GMC\u0002\u00026^\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI,a,\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005}&\u0006BA\u001a\u0003S\u000babY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002F*\u001aQ)!+\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u001a\u0016\u0004\u0011\u0006%\u0016AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0003#TC!a\u0013\u0002*\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a6\u0011\t\u0005e\u0017q\\\u0007\u0003\u00037TA!!8\u0002\u0004\u0006!A.\u00198h\u0013\u0011\t\u0019*a7\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011q]Aw!\r1\u0014\u0011^\u0005\u0004\u0003W<$aA!os\"A\u0011q^\u0012\u0002\u0002\u0003\u0007Q)A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003k\u0004b!a>\u0002~\u0006\u001dXBAA}\u0015\r\tYpN\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0000\u0003s\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!Q\u0001B\u0006!\r1$qA\u0005\u0004\u0005\u00139$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003_,\u0013\u0011!a\u0001\u0003O\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002\u000b\u0006AAo\\*ue&tw\r\u0006\u0002\u0002X\u00061Q-];bYN$BA!\u0002\u0003\u001a!I\u0011q\u001e\u0015\u0002\u0002\u0003\u0007\u0011q\u001d\u0005\u0006M\u001a\u0001\ra\u001a\u0005\n\u0005?1\u0001\u0013!a\u0001\u0005\u000b\tQ\u0001Z3ck\u001e\fq\"\u00199qYf$C-\u001a4bk2$HEM\u000b\u0003\u0005KQCA!\u0002\u0002*R1!\u0011\u0006B\u0017\u0005_!B!!\u0001\u0003,!)q\u000f\u0003a\u0002q\")a\r\u0003a\u0001y\"9!q\u0004\u0005A\u0002\t\u0015A\u0003CA\u0001\u0005g\u0011)Da\u000e\t\u000b\u0005L\u0001\u0019\u00012\t\u000b\u0019L\u0001\u0019A4\t\u000f\t}\u0011\u00021\u0001\u0003\u0006Qa\u0011\u0011\u0001B\u001e\u0005{\u0011yD!\u0011\u0003D!9\u00111\u0002\u0006A\u0002\u0005=\u0001bBA\u0018\u0015\u0001\u0007\u00111\u0007\u0005\u0007\u0003wQ\u0001\u0019A#\t\r\u0005\u0005#\u00021\u0001I\u0011\u001d\t9E\u0003a\u0001\u0003\u0017\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003J\tU\u0003#\u0002\u001c\u0003L\t=\u0013b\u0001B'o\t1q\n\u001d;j_:\u00042B\u000eB)\u0003\u001f\t\u0019$\u0012%\u0002L%\u0019!1K\u001c\u0003\rQ+\b\u000f\\36\u0011%\u00119fCA\u0001\u0002\u0004\t\t!A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!Q\f\t\u0005\u00033\u0014y&\u0003\u0003\u0003b\u0005m'AB(cU\u0016\u001cG\u000f")
public class StitchedDelaunay
implements scala.Serializable,
Product {
    private final Function1<Object, Coordinate> indexToCoord;
    private final HalfEdgeTable halfEdgeTable;
    private final int boundary;
    private final IndexedPointSet pointSet;
    private final TriangleMap fillTriangles;

    public static Option<Tuple5<Function1<Object, Coordinate>, HalfEdgeTable, Object, IndexedPointSet, TriangleMap>> unapply(StitchedDelaunay stitchedDelaunay) {
        return StitchedDelaunay$.MODULE$.unapply(stitchedDelaunay);
    }

    public static StitchedDelaunay apply(Function1<Object, Coordinate> function1, HalfEdgeTable halfEdgeTable, int n, IndexedPointSet indexedPointSet, TriangleMap triangleMap) {
        return StitchedDelaunay$.MODULE$.apply(function1, halfEdgeTable, n, indexedPointSet, triangleMap);
    }

    public static StitchedDelaunay apply(DelaunayTriangulation delaunayTriangulation, Map<Direction, Tuple2<BoundaryDelaunay, Extent>> map2, boolean bl) {
        return StitchedDelaunay$.MODULE$.apply(delaunayTriangulation, map2, bl);
    }

    public static StitchedDelaunay apply(Map<Direction, Tuple2<DelaunayTriangulation, Extent>> map2, boolean bl, Predef.DummyImplicit dummyImplicit) {
        return StitchedDelaunay$.MODULE$.apply(map2, bl, dummyImplicit);
    }

    public static boolean apply$default$2() {
        return StitchedDelaunay$.MODULE$.apply$default$2();
    }

    public static StitchedDelaunay apply(Map<Direction, Tuple2<BoundaryDelaunay, Extent>> map2, boolean bl) {
        return StitchedDelaunay$.MODULE$.apply(map2, bl);
    }

    public static Tuple3<Object, IndexedPointSet, Map<Direction, Map<Object, Object>>> combinedPointSet(Map<Direction, Tuple2<DelaunayTriangulation, Extent>> map2, Predef.DummyImplicit dummyImplicit) {
        return StitchedDelaunay$.MODULE$.combinedPointSet(map2, dummyImplicit);
    }

    public static Tuple3<Object, IndexedPointSet, Map<Direction, Map<Object, Object>>> combinedPointSet(Map<Direction, Tuple2<BoundaryDelaunay, Extent>> map2) {
        return StitchedDelaunay$.MODULE$.combinedPointSet(map2);
    }

    public static Tuple3<Object, IndexedPointSet, Map<Direction, Map<Object, Object>>> combinedPointSet(DelaunayTriangulation delaunayTriangulation, Map<Direction, Tuple2<BoundaryDelaunay, Extent>> map2) {
        return StitchedDelaunay$.MODULE$.combinedPointSet(delaunayTriangulation, map2);
    }

    public Function1<Object, Coordinate> indexToCoord() {
        return this.indexToCoord;
    }

    public HalfEdgeTable halfEdgeTable() {
        return this.halfEdgeTable;
    }

    public int boundary() {
        return this.boundary;
    }

    public IndexedPointSet pointSet() {
        return this.pointSet;
    }

    public TriangleMap fillTriangles() {
        return this.fillTriangles;
    }

    public Seq<Tuple3<Object, Object, Object>> triangles() {
        return this.fillTriangles().getTriangles().keys().toSeq();
    }

    public PrintWriter writeWKT(String wktFile) {
        MultiPolygon mp = MultiPolygon$.MODULE$.apply((Traversable<Polygon>)((Traversable)this.triangles().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple32 = x0$1;
            if (tuple32 == null) {
                throw new MatchError((Object)tuple32);
            }
            int i = BoxesRunTime.unboxToInt((Object)tuple32._1());
            int j = BoxesRunTime.unboxToInt((Object)tuple32._2());
            int k = BoxesRunTime.unboxToInt((Object)tuple32._3());
            Polygon polygon = Polygon$.MODULE$.apply((Seq<Coordinate>)Predef$.MODULE$.wrapRefArray((Object[])new Coordinate[]{(Coordinate)this.indexToCoord().apply((Object)BoxesRunTime.boxToInteger((int)i)), (Coordinate)this.indexToCoord().apply((Object)BoxesRunTime.boxToInteger((int)j)), (Coordinate)this.indexToCoord().apply((Object)BoxesRunTime.boxToInteger((int)k)), (Coordinate)this.indexToCoord().apply((Object)BoxesRunTime.boxToInteger((int)i))}), Predef.DummyImplicit$.MODULE$.dummyImplicit(), Predef.DummyImplicit$.MODULE$.dummyImplicit());
            return polygon;
        }, Seq$.MODULE$.canBuildFrom())));
        String wktString = WKT$.MODULE$.write((Geometry)mp);
        return new PrintWriter(null, wktFile, wktString){
            {
                this.write(wktString$1);
                this.close();
            }
        };
    }

    public StitchedDelaunay copy(Function1<Object, Coordinate> indexToCoord, HalfEdgeTable halfEdgeTable, int boundary, IndexedPointSet pointSet, TriangleMap fillTriangles) {
        return new StitchedDelaunay(indexToCoord, halfEdgeTable, boundary, pointSet, fillTriangles);
    }

    public Function1<Object, Coordinate> copy$default$1() {
        return this.indexToCoord();
    }

    public HalfEdgeTable copy$default$2() {
        return this.halfEdgeTable();
    }

    public int copy$default$3() {
        return this.boundary();
    }

    public IndexedPointSet copy$default$4() {
        return this.pointSet();
    }

    public TriangleMap copy$default$5() {
        return this.fillTriangles();
    }

    public String productPrefix() {
        return "StitchedDelaunay";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.indexToCoord();
                break;
            }
            case 1: {
                object = this.halfEdgeTable();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.boundary());
                break;
            }
            case 3: {
                object = this.pointSet();
                break;
            }
            case 4: {
                object = this.fillTriangles();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StitchedDelaunay;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash(this.indexToCoord()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.halfEdgeTable()));
        n = Statics.mix((int)n, (int)this.boundary());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pointSet()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.fillTriangles()));
        return Statics.finalizeHash((int)n, (int)5);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StitchedDelaunay)) return false;
        boolean bl = true;
        if (!bl) return false;
        StitchedDelaunay stitchedDelaunay = (StitchedDelaunay)x$1;
        Function1<Object, Coordinate> function1 = this.indexToCoord();
        Function1<Object, Coordinate> function12 = stitchedDelaunay.indexToCoord();
        if (function1 == null) {
            if (function12 != null) {
                return false;
            }
        } else if (!function1.equals(function12)) return false;
        HalfEdgeTable halfEdgeTable = this.halfEdgeTable();
        HalfEdgeTable halfEdgeTable2 = stitchedDelaunay.halfEdgeTable();
        if (halfEdgeTable == null) {
            if (halfEdgeTable2 != null) {
                return false;
            }
        } else if (!halfEdgeTable.equals(halfEdgeTable2)) return false;
        if (this.boundary() != stitchedDelaunay.boundary()) return false;
        IndexedPointSet indexedPointSet = this.pointSet();
        IndexedPointSet indexedPointSet2 = stitchedDelaunay.pointSet();
        if (indexedPointSet == null) {
            if (indexedPointSet2 != null) {
                return false;
            }
        } else if (!indexedPointSet.equals(indexedPointSet2)) return false;
        TriangleMap triangleMap = this.fillTriangles();
        TriangleMap triangleMap2 = stitchedDelaunay.fillTriangles();
        if (triangleMap == null) {
            if (triangleMap2 != null) {
                return false;
            }
        } else if (!triangleMap.equals(triangleMap2)) return false;
        if (!stitchedDelaunay.canEqual(this)) return false;
        return true;
    }

    public StitchedDelaunay(Function1<Object, Coordinate> indexToCoord, HalfEdgeTable halfEdgeTable, int boundary, IndexedPointSet pointSet, TriangleMap fillTriangles) {
        this.indexToCoord = indexToCoord;
        this.halfEdgeTable = halfEdgeTable;
        this.boundary = boundary;
        this.pointSet = pointSet;
        this.fillTriangles = fillTriangles;
        Product.$init$((Product)this);
    }
}

