/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.storage.filesystem.fs.input;

import com.geoway.atlas.common.error.IoException;
import com.geoway.atlas.common.error.IoException$;
import com.geoway.atlas.common.io.StandardInput;
import com.geoway.atlas.data.storage.filesystem.fs.input.FileStandardInput$;
import java.io.RandomAccessFile;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\n\u0015\u0001\u0015B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\u0006\t\u0002!\t!\u0012\u0005\b\u0013\u0002\u0011\r\u0011\"\u0001K\u0011\u0019\u0001\u0006\u0001)A\u0005\u0017\"9\u0011\u000b\u0001b\u0001\n\u0003\u0011\u0006BB,\u0001A\u0003%1\u000bC\u0003Y\u0001\u0011\u0005#\u000bC\u0003Z\u0001\u0011\u0005#\fC\u0003Z\u0001\u0011\u0005#\u000eC\u0003m\u0001\u0011\u0005S\u000eC\u0003o\u0001\u0011\u0005s\u000eC\u0003s\u0001\u0011\u00053\u000fC\u0003y\u0001\u0011\u0005\u0013\u0010C\u0003{\u0001\u0011\u0005\u0013pB\u0003|)!\u0005APB\u0003\u0014)!\u0005Q\u0010\u0003\u0004E!\u0011\u0005\u00111\u0001\u0005\b\u0003\u000b\u0001B\u0011AA\u0004\u0005E1\u0015\u000e\\3Ti\u0006tG-\u0019:e\u0013:\u0004X\u000f\u001e\u0006\u0003+Y\tQ!\u001b8qkRT!a\u0006\r\u0002\u0005\u0019\u001c(BA\r\u001b\u0003)1\u0017\u000e\\3tsN$X-\u001c\u0006\u00037q\tqa\u001d;pe\u0006<WM\u0003\u0002\u001e=\u0005!A-\u0019;b\u0015\ty\u0002%A\u0003bi2\f7O\u0003\u0002\"E\u00051q-Z8xCfT\u0011aI\u0001\u0004G>l7\u0001A\n\u0004\u0001\u0019r\u0003CA\u0014-\u001b\u0005A#BA\u0015+\u0003\u0011a\u0017M\\4\u000b\u0003-\nAA[1wC&\u0011Q\u0006\u000b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014AA5p\u0015\t\u0019d$\u0001\u0004d_6lwN\\\u0005\u0003kA\u0012Qb\u0015;b]\u0012\f'\u000fZ%oaV$\u0018A\u00024t!\u0006$\b\u000e\u0005\u00029\u0003:\u0011\u0011h\u0010\t\u0003uuj\u0011a\u000f\u0006\u0003y\u0011\na\u0001\u0010:p_Rt$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k\u0014A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001Q\u001f\u0002\rqJg.\u001b;?)\t1\u0005\n\u0005\u0002H\u00015\tA\u0003C\u00037\u0005\u0001\u0007q'\u0001\tsC:$w.\\!dG\u0016\u001c8OR5mKV\t1\n\u0005\u0002M\u001d6\tQJ\u0003\u00022U%\u0011q*\u0014\u0002\u0011%\u0006tGm\\7BG\u000e,7o\u001d$jY\u0016\f\u0011C]1oI>l\u0017iY2fgN4\u0015\u000e\\3!\u0003\u0019aWM\\4uQV\t1\u000b\u0005\u0002U+6\tQ(\u0003\u0002W{\t!Aj\u001c8h\u0003\u001daWM\\4uQ\u0002\n\u0011bZ3u\u0019\u0016tw\r\u001e5\u0002\tI,\u0017\r\u001a\u000b\u00057z3\u0007\u000e\u0005\u0002U9&\u0011Q,\u0010\u0002\u0004\u0013:$\b\"B0\t\u0001\u0004\u0001\u0017!\u0003:fC\u0012\u0014\u0015\u0010^3t!\r!\u0016mY\u0005\u0003Ev\u0012Q!\u0011:sCf\u0004\"\u0001\u00163\n\u0005\u0015l$\u0001\u0002\"zi\u0016DQa\u001a\u0005A\u0002m\u000b!b\u001d;beRLe\u000eZ3y\u0011\u0015I\u0007\u00021\u0001\\\u0003)\u0011X-\u00193MK:<G\u000f\u001b\u000b\u00037.DQaX\u0005A\u0002\u0001\f\u0001\u0002]8tSRLwN\u001c\u000b\u0002'\u0006!1o[5q)\t\u0019\u0006\u000fC\u0003r\u0017\u0001\u00071+A\u0001o\u0003\u0011\u0019X-Z6\u0015\u0005Q<\bC\u0001+v\u0013\t1XH\u0001\u0003V]&$\b\"B9\r\u0001\u0004\u0019\u0016!B2m_N,G#\u0001;\u0002\u0017\rdwn]3TiJ,\u0017-\\\u0001\u0012\r&dWm\u0015;b]\u0012\f'\u000fZ%oaV$\bCA$\u0011'\t\u0001b\u0010\u0005\u0002U\u007f&\u0019\u0011\u0011A\u001f\u0003\r\u0005s\u0017PU3g)\u0005a\u0018!B1qa2LHc\u0001$\u0002\n!)aG\u0005a\u0001o\u0001")
public class FileStandardInput
implements StandardInput {
    private final String fsPath;
    private final RandomAccessFile randomAccessFile;
    private final long length;

    public static FileStandardInput apply(String string) {
        return FileStandardInput$.MODULE$.apply(string);
    }

    public RandomAccessFile randomAccessFile() {
        return this.randomAccessFile;
    }

    public long length() {
        return this.length;
    }

    public long getLength() {
        return this.length();
    }

    public int read(byte[] readBytes, int startIndex, int readLength) {
        if (this.randomAccessFile().getFilePointer() == this.getLength()) {
            return -1;
        }
        if (readLength < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < readLength) {
            int count = this.randomAccessFile().read(readBytes, startIndex + n, readLength - n);
            if (count >= 0) {
                n += count;
                continue;
            }
            if (count >= 0) continue;
            String x$1 = new StringBuilder(9).append(this.fsPath).append(":\u5df2\u8bfb\u53d6\u5230\u6587\u4ef6\u5c3e!").toString();
            Thread x$2 = IoException$.MODULE$.apply$default$2(x$1);
            int x$3 = IoException$.MODULE$.apply$default$3(x$1);
            throw new IoException(x$1, x$2, x$3);
        }
        return n;
    }

    public int read(byte[] readBytes) {
        return this.read(readBytes, 0, readBytes.length);
    }

    public long position() {
        return this.randomAccessFile().getFilePointer();
    }

    public long skip(long n) {
        long pos = this.randomAccessFile().getFilePointer();
        long len = this.randomAccessFile().length();
        if (n <= 0L) {
            return 0L;
        }
        long newpos = pos + n;
        if (newpos > len) {
            newpos = len;
        }
        this.seek(newpos);
        return newpos - pos;
    }

    public void seek(long n) {
        this.randomAccessFile().seek(n);
    }

    public void close() {
        this.randomAccessFile().close();
    }

    public void closeStream() {
        this.randomAccessFile().close();
    }

    public FileStandardInput(String fsPath) {
        this.fsPath = fsPath;
        this.randomAccessFile = new RandomAccessFile(fsPath, "r");
        this.length = this.randomAccessFile().length();
    }
}

