/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.storage.filesystem.hdfs.input;

import com.geoway.atlas.common.io.StandardInput;
import com.geoway.atlas.data.storage.filesystem.hdfs.input.HdfsStandardInput$;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001}4A\u0001E\t\u0001E!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015Q\u0005\u0001\"\u0011L\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015\u0011\u0006\u0001\"\u0011d\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u00159\u0007\u0001\"\u0011i\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015\t\b\u0001\"\u0011s\u0011\u0015\u0019\b\u0001\"\u0011s\u000f\u0015!\u0018\u0003#\u0001v\r\u0015\u0001\u0012\u0003#\u0001w\u0011\u0015!U\u0002\"\u0001{\u0011\u0015YX\u0002\"\u0001}\u0005EAEMZ:Ti\u0006tG-\u0019:e\u0013:\u0004X\u000f\u001e\u0006\u0003%M\tQ!\u001b8qkRT!\u0001F\u000b\u0002\t!$gm\u001d\u0006\u0003-]\t!BZ5mKNL8\u000f^3n\u0015\tA\u0012$A\u0004ti>\u0014\u0018mZ3\u000b\u0005iY\u0012\u0001\u00023bi\u0006T!\u0001H\u000f\u0002\u000b\u0005$H.Y:\u000b\u0005yy\u0012AB4f_^\f\u0017PC\u0001!\u0003\r\u0019w.\\\u0002\u0001'\r\u00011e\u000b\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nA\u0001\\1oO*\t\u0001&\u0001\u0003kCZ\f\u0017B\u0001\u0016&\u0005\u0019y%M[3diB\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0003S>T!\u0001M\u000e\u0002\r\r|W.\\8o\u0013\t\u0011TFA\u0007Ti\u0006tG-\u0019:e\u0013:\u0004X\u000f^\u0001\nQ\u001247/\u00138qkR\u0004\"!\u000e \u000e\u0003YR!a\u000e\u001d\u0002\u0005\u0019\u001c(BA\u001d;\u0003\u0019A\u0017\rZ8pa*\u00111\bP\u0001\u0007CB\f7\r[3\u000b\u0003u\n1a\u001c:h\u0013\tydGA\tG'\u0012\u000bG/Y%oaV$8\u000b\u001e:fC6\f!BZ5mKNK8\u000f^3n!\t)$)\u0003\u0002Dm\tQa)\u001b7f'f\u001cH/Z7\u0002\rqJg.\u001b;?)\r1\u0005*\u0013\t\u0003\u000f\u0002i\u0011!\u0005\u0005\u0006g\r\u0001\r\u0001\u000e\u0005\u0006\u0001\u000e\u0001\r!Q\u0001\nO\u0016$H*\u001a8hi\",\u0012\u0001\u0014\t\u0003\u001bBk\u0011A\u0014\u0006\u0002\u001f\u0006)1oY1mC&\u0011\u0011K\u0014\u0002\u0005\u0019>tw-\u0001\u0003sK\u0006$G\u0003\u0002+X?\u0006\u0004\"!T+\n\u0005Ys%aA%oi\")\u0001,\u0002a\u00013\u0006I!/Z1e\u0005f$Xm\u001d\t\u0004\u001bjc\u0016BA.O\u0005\u0015\t%O]1z!\tiU,\u0003\u0002_\u001d\n!!)\u001f;f\u0011\u0015\u0001W\u00011\u0001U\u0003)\u0019H/\u0019:u\u0013:$W\r\u001f\u0005\u0006E\u0016\u0001\r\u0001V\u0001\u000be\u0016\fG\rT3oORDGC\u0001+e\u0011\u0015Af\u00011\u0001Z\u0003!\u0001xn]5uS>tG#\u0001'\u0002\tM\\\u0017\u000e\u001d\u000b\u0003\u0019&DQA\u001b\u0005A\u00021\u000b\u0011A\\\u0001\u0005g\u0016,7\u000e\u0006\u0002naB\u0011QJ\\\u0005\u0003_:\u0013A!\u00168ji\")!.\u0003a\u0001\u0019\u0006)1\r\\8tKR\tQ.A\u0006dY>\u001cXm\u0015;sK\u0006l\u0017!\u0005%eMN\u001cF/\u00198eCJ$\u0017J\u001c9viB\u0011q)D\n\u0003\u001b]\u0004\"!\u0014=\n\u0005et%AB!osJ+g\rF\u0001v\u0003\u0015\t\u0007\u000f\u001d7z)\r1UP \u0005\u0006g=\u0001\r\u0001\u000e\u0005\u0006\u0001>\u0001\r!\u0011")
public class HdfsStandardInput
implements StandardInput {
    private final FSDataInputStream hdfsInput;
    private final FileSystem fileSystem;

    public static HdfsStandardInput apply(FSDataInputStream fSDataInputStream, FileSystem fileSystem) {
        return HdfsStandardInput$.MODULE$.apply(fSDataInputStream, fileSystem);
    }

    public long getLength() {
        return this.hdfsInput.getPos() + (long)this.hdfsInput.available();
    }

    public int read(byte[] readBytes, int startIndex, int readLength) {
        if (this.hdfsInput.available() == 0) {
            return -1;
        }
        if (readLength < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < readLength) {
            int count = this.hdfsInput.read(readBytes, startIndex + n, readLength - n);
            if (count < 0) continue;
            n += count;
        }
        return n;
    }

    public int read(byte[] readBytes) {
        return this.read(readBytes, 0, readBytes.length);
    }

    public long position() {
        return this.hdfsInput.getPos();
    }

    public long skip(long n) {
        return this.hdfsInput.skip(n);
    }

    public void seek(long n) {
        this.hdfsInput.seek(n);
    }

    public void close() {
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> $this.hdfsInput.close());
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> $this.fileSystem.close());
    }

    public void closeStream() {
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> $this.hdfsInput.close());
    }

    public HdfsStandardInput(FSDataInputStream hdfsInput, FileSystem fileSystem) {
        this.hdfsInput = hdfsInput;
        this.fileSystem = fileSystem;
    }
}

